/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins.treeview;

import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.tools.plugins.treeview.ArrayTreeNode;
import com.lowagie.tools.plugins.treeview.DictionaryTreeNode;
import com.lowagie.tools.plugins.treeview.FileTreeNode;
import com.lowagie.tools.plugins.treeview.ICommonAnalyzer;
import com.lowagie.tools.plugins.treeview.OutlinelistTreeNode;
import com.lowagie.tools.plugins.treeview.PagelistTreeNode;
import com.lowagie.tools.plugins.treeview.Pagetreenode;
import com.lowagie.tools.plugins.treeview.ProgressDialog;
import com.lowagie.tools.plugins.treeview.SimpletextTreeNode;
import com.lowagie.tools.plugins.treeview.TextpaneTreeNode;
import com.lowagie.tools.plugins.treeview.UpdateableTreeNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class AnalyzePDF
extends Thread
implements TreeModel,
ICommonAnalyzer {
    DefaultMutableTreeNode root;
    DefaultMutableTreeNode filenode;
    int pagecount;
    ProgressDialog progressdialog;
    int numberofpages;
    ArrayList pageInh = new ArrayList();
    private transient Vector treeModelListeners;
    PdfReader reader;

    public AnalyzePDF(String infile, ProgressDialog blubb) {
        this.progressdialog = blubb;
        try {
            this.reader = new PdfReader(infile);
            this.root = new SimpletextTreeNode("Dokument");
            this.filenode = new FileTreeNode((Object)infile, this.reader);
            this.root.add(this.filenode);
            this.numberofpages = this.reader.getNumberOfPages();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.pagecount = 0;
    }

    public TableModel getXReftable() {
        AbstractTableModel tm = new AbstractTableModel(){
            private static final long serialVersionUID = 8820950528057757413L;

            public int getColumnCount() {
                return 2;
            }

            public int getRowCount() {
                return AnalyzePDF.this.reader.getXrefSize() - 1;
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return new Integer(rowIndex + 1);
                    }
                    case 1: {
                        PdfObject pdfob = AnalyzePDF.this.reader.getPdfObject(rowIndex + 1);
                        if (pdfob.isStream()) {
                            return "Stream " + pdfob;
                        }
                        return pdfob;
                    }
                }
                return null;
            }

            public String getColumnName(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return "XRefNr";
                    }
                    case 1: {
                        return "Object";
                    }
                }
                return null;
            }
        };
        return tm;
    }

    protected void iteratePages(PdfDictionary page, PdfReader pdfreader, DefaultMutableTreeNode node) {
        PdfArray kidsPR = (PdfArray)PdfReader.getPdfObject(page.get(PdfName.KIDS));
        if (kidsPR == null) {
            node.add(new Pagetreenode(page, this.pagecount, this, pdfreader));
            System.out.println("Page= " + (this.pagecount + 1));
            this.pageInh.add(this.pagecount, page);
            ++this.pagecount;
        } else {
            PagelistTreeNode leaf = new PagelistTreeNode(kidsPR);
            node.add(leaf);
            page.put(PdfName.TYPE, PdfName.PAGES);
            ArrayList kids = kidsPR.getArrayList();
            int k = 0;
            while (k < kids.size()) {
                PdfDictionary kid = (PdfDictionary)PdfReader.getPdfObject((PRIndirectReference)kids.get(k));
                this.iteratePages(kid, pdfreader, leaf);
                ++k;
            }
        }
    }

    protected void iterateOutlines(PdfDictionary outlines, PdfReader pdfreader, DefaultMutableTreeNode node) {
        PdfDictionary kid = outlines;
        do {
            PdfObject a;
            PdfObject dest;
            PdfString title = (PdfString)PdfReader.getPdfObject(kid.get(PdfName.TITLE));
            OutlinelistTreeNode leaf = new OutlinelistTreeNode((Object)title, kid);
            node.add(leaf);
            PdfDictionary first = (PdfDictionary)PdfReader.getPdfObject(kid.get(PdfName.FIRST));
            if (first != null) {
                this.iterateOutlines(first, pdfreader, leaf);
                continue;
            }
            PdfDictionary se = (PdfDictionary)PdfReader.getPdfObject(kid.get(new PdfName("SE")));
            if (se != null) {
                this.iterateObjects(se, pdfreader, leaf);
            }
            if ((dest = PdfReader.getPdfObject(kid.get(PdfName.DEST))) != null) {
                this.iterateObjects(dest, pdfreader, leaf);
            }
            if ((a = PdfReader.getPdfObject(kid.get(PdfName.A))) == null) continue;
            this.iterateObjects(a, pdfreader, leaf);
        } while ((kid = (PdfDictionary)PdfReader.getPdfObject(kid.get(PdfName.NEXT))) != null);
    }

    public void iterateObjects(PdfObject pdfobj, PdfReader pdfreader, DefaultMutableTreeNode node) {
        if (pdfobj.isDictionary()) {
            DictionaryTreeNode leaf = new DictionaryTreeNode((Object)("PdfDictionary " + pdfobj), (PdfDictionary)pdfobj);
            node.add(leaf);
            Set s = ((PdfDictionary)pdfobj).getKeys();
            Iterator it = s.iterator();
            int i = 0;
            while (it.hasNext()) {
                ++i;
                Object obj = it.next();
                PdfObject value = PdfReader.getPdfObject(((PdfDictionary)pdfobj).get((PdfName)obj));
                SimpletextTreeNode sttn = new SimpletextTreeNode(obj + " " + value);
                leaf.add(sttn);
                if (obj.equals(PdfName.PARENT) || value == null) continue;
                this.iterateObjects(value, pdfreader, sttn);
            }
        } else if (pdfobj.isArray()) {
            ArrayTreeNode leaf = new ArrayTreeNode((Object)("PdfArray " + pdfobj), (PdfArray)pdfobj);
            node.add(leaf);
            ArrayList kids = ((PdfArray)pdfobj).getArrayList();
            int k = 0;
            while (k < kids.size()) {
                PdfObject kid;
                PdfObject curkid = (PdfObject)kids.get(k);
                if (curkid.isIndirect()) {
                    kid = PdfReader.getPdfObject((PRIndirectReference)kids.get(k));
                    if (kid != null) {
                        this.iterateObjects(kid, pdfreader, leaf);
                    }
                } else if (!curkid.isNumber()) {
                    kid = (PdfObject)kids.get(k);
                    this.iterateObjects(kid, pdfreader, leaf);
                }
                ++k;
            }
        } else if (pdfobj.isIndirect()) {
            SimpletextTreeNode leaf = new SimpletextTreeNode("PRIndirectReference " + pdfobj);
            node.add(leaf);
            PdfObject target = PdfReader.getPdfObject(pdfobj);
            if (target != null) {
                this.iterateObjects(target, pdfreader, leaf);
            }
        } else if (!(pdfobj.isBoolean() || pdfobj.isName() || pdfobj.isNull() || pdfobj.isNumber() || pdfobj.isString())) {
            if (pdfobj.isStream()) {
                UpdateableTreeNode leaf = new TextpaneTreeNode(pdfobj, "Stream");
                node.add(leaf);
                leaf = new DictionaryTreeNode((Object)("PdfDictionary " + pdfobj), (PdfDictionary)pdfobj);
                node.add(leaf);
                Set s = ((PdfDictionary)pdfobj).getKeys();
                Iterator it = s.iterator();
                int i = 0;
                while (it.hasNext()) {
                    ++i;
                    Object obj = it.next();
                    PdfObject value = PdfReader.getPdfObject(((PdfDictionary)pdfobj).get((PdfName)obj));
                    SimpletextTreeNode sttn = new SimpletextTreeNode(obj + " " + value);
                    leaf.add(sttn);
                    if (obj.equals(PdfName.PARENT) || value == null) continue;
                    this.iterateObjects(value, pdfreader, sttn);
                }
            } else {
                SimpletextTreeNode leaf = new SimpletextTreeNode("Unknown " + pdfobj);
                node.add(leaf);
            }
        }
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object parent, int index) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent;
        return node.getChildAt(index);
    }

    public int getChildCount(Object parent) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent;
        return node.getChildCount();
    }

    public boolean isLeaf(Object node) {
        DefaultMutableTreeNode leaf = (DefaultMutableTreeNode)node;
        return leaf.isLeaf();
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new RuntimeException("Manipulation of objecttree not yet supported!");
    }

    public int getIndexOfChild(Object parent, Object child) {
        DefaultMutableTreeNode parentobj = (DefaultMutableTreeNode)parent;
        DefaultMutableTreeNode childobj = (DefaultMutableTreeNode)child;
        return parentobj.getIndex(childobj);
    }

    public synchronized void removeTreeModelListener(TreeModelListener l) {
        if (this.treeModelListeners != null && this.treeModelListeners.contains(l)) {
            Vector v = (Vector)this.treeModelListeners.clone();
            v.removeElement(l);
            this.treeModelListeners = v;
        }
    }

    public synchronized void addTreeModelListener(TreeModelListener l) {
        Vector v;
        Vector vector = v = this.treeModelListeners == null ? new Vector(2) : (Vector)this.treeModelListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.treeModelListeners = v;
        }
    }

    protected void fireTreeNodesChanged(TreeModelEvent e) {
        if (this.treeModelListeners != null) {
            Vector listeners = this.treeModelListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((TreeModelListener)listeners.elementAt(i)).treeNodesChanged(e);
                ++i;
            }
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent e) {
        if (this.treeModelListeners != null) {
            Vector listeners = this.treeModelListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((TreeModelListener)listeners.elementAt(i)).treeNodesInserted(e);
                ++i;
            }
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent e) {
        if (this.treeModelListeners != null) {
            Vector listeners = this.treeModelListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((TreeModelListener)listeners.elementAt(i)).treeNodesRemoved(e);
                ++i;
            }
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent e) {
        if (this.treeModelListeners != null) {
            Vector listeners = this.treeModelListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((TreeModelListener)listeners.elementAt(i)).treeStructureChanged(e);
                ++i;
            }
        }
    }

    public void run() {
        try {
            PdfDictionary catalog = this.reader.getCatalog();
            PdfDictionary rootPages = (PdfDictionary)PdfReader.getPdfObject(catalog.get(PdfName.PAGES));
            SimpletextTreeNode rootPagesGUI = new SimpletextTreeNode("Pagetree " + rootPages);
            this.filenode.add(rootPagesGUI);
            this.iteratePages(rootPages, this.reader, rootPagesGUI);
            PdfDictionary rootOutlines = (PdfDictionary)PdfReader.getPdfObject(catalog.get(PdfName.OUTLINES));
            if (rootOutlines != null) {
                PdfDictionary first;
                SimpletextTreeNode outlinetree = new SimpletextTreeNode("Outlinetree " + rootOutlines);
                this.filenode.add(outlinetree);
                PdfObject firstindref = rootOutlines.get(PdfName.FIRST);
                if (firstindref != null && (first = (PdfDictionary)PdfReader.getPdfObject(firstindref)) != null) {
                    this.iterateOutlines(first, this.reader, outlinetree);
                }
            }
            System.out.println(" Pagecount= " + this.pagecount);
            this.progressdialog.setVisible(false);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public int getPagecount() {
        return this.pagecount;
    }

    public void updatecount() {
        this.progressdialog.setCurrentPage(this.getPagecount());
    }
}

