/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.CentralLayoutWindow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.LinkedList;
import java.util.Random;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import tree.Cluster;
import tree.GraphicalTree;
import tree.Tree;
import tree.Vertex;
import utils.MyStats;
import utils.SomeUsefullStuff;

public class TopMenu
extends JMenuBar
implements ActionListener {
    private JMenuItem loadTree;
    private JMenuItem newTree;
    private JMenuItem saveLeafCoords;
    private JMenuItem saveFormattedTree;
    private JMenuItem saveNewickFormat;
    private JMenuItem highlightClusters;
    private JMenuItem getClusterData;
    private JMenuItem distancesFromRootsToFile;
    private JMenuItem leafPairDistances;
    private JMenuItem createPDF;
    private JMenuItem generateFileOfXRandomTrees;
    private JMenuItem getIntraClusterData;
    private JMenuItem getLeavesThatAreTooCloseToEachOther;
    private JMenuItem hideLeavesFromFile;
    private JMenuItem showLeavesFromFile;
    private JMenuItem removeRandomStrainsFromTree;
    private JMenuItem randomTreeSDR;
    private JMenuItem generateRandomTree;
    private JMenuItem textTree;
    private JMenuItem basicTreeData;
    private JMenuItem about;
    private JMenuItem disclamer;
    private JMenuItem getInterClusterData;
    private JCheckBoxMenuItem showRootNode;
    private JCheckBoxMenuItem showClusterRoots;
    private JCheckBoxMenuItem showLeafText;
    private JCheckBoxMenuItem showEdgeLengths;
    private JCheckBoxMenuItem showCOT;
    private JCheckBoxMenuItem showInternalNode;
    private JCheckBoxMenuItem showLeafNode;
    private JCheckBoxMenuItem showBootstrapValues;
    private JCheckBoxMenuItem displayclusterRootBootstrap;
    private JCheckBoxMenuItem fontBold;
    private JCheckBoxMenuItem fontItalic;
    private JCheckBoxMenuItem fontPlain;
    private JCheckBoxMenuItem fontSize_16;
    private JCheckBoxMenuItem fontSize_15;
    private JCheckBoxMenuItem fontSize_14;
    private JCheckBoxMenuItem fontSize_13;
    private JCheckBoxMenuItem fontSize_12;
    private JCheckBoxMenuItem fontSize_6;
    private JCheckBoxMenuItem fontSize_7;
    private JCheckBoxMenuItem fontSize_8;
    private JCheckBoxMenuItem fontSize_9;
    private JCheckBoxMenuItem fontSize_10;
    private JCheckBoxMenuItem fontSize_11;
    private JCheckBoxMenuItem highlightClusterCenterLeaves;
    private CentralLayoutWindow centralLayoutWindow;
    private Random randVal = new Random();

    public TopMenu(CentralLayoutWindow centralLayoutWindow) {
        this.centralLayoutWindow = centralLayoutWindow;
        JMenu jMenu = new JMenu("File");
        this.newTree = new JMenuItem("Load Newick Tree(s)");
        this.addJMenuItem(this.newTree, jMenu);
        this.loadTree = new JMenuItem("Load Formatted Tree");
        this.addJMenuItem(this.loadTree, jMenu);
        jMenu.addSeparator();
        this.saveFormattedTree = new JMenuItem("Save Formatted Tree");
        this.addJMenuItem(this.saveFormattedTree, jMenu);
        this.saveNewickFormat = new JMenuItem("Save As Newick Tree");
        this.addJMenuItem(this.saveNewickFormat, jMenu);
        jMenu.addSeparator();
        this.createPDF = new JMenuItem("Export To PDF");
        this.addJMenuItem(this.createPDF, jMenu);
        this.add(jMenu);
        JMenu jMenu2 = new JMenu("Show");
        this.showLeafText = new JCheckBoxMenuItem("Leaf Labels");
        this.addJCheckBoxMenuItem(this.showLeafText, jMenu2);
        this.showLeafText.setSelected(true);
        jMenu2.addSeparator();
        this.showRootNode = new JCheckBoxMenuItem("Current Root");
        this.addJCheckBoxMenuItem(this.showRootNode, jMenu2);
        this.showRootNode.setSelected(true);
        this.showInternalNode = new JCheckBoxMenuItem("Internal Nodes");
        this.addJCheckBoxMenuItem(this.showInternalNode, jMenu2);
        this.showInternalNode.setSelected(true);
        this.showLeafNode = new JCheckBoxMenuItem("Leaf Nodes");
        this.addJCheckBoxMenuItem(this.showLeafNode, jMenu2);
        jMenu2.addSeparator();
        this.showEdgeLengths = new JCheckBoxMenuItem("Edge Lengths");
        this.addJCheckBoxMenuItem(this.showEdgeLengths, jMenu2);
        this.showBootstrapValues = new JCheckBoxMenuItem("Bootstrap Values");
        this.addJCheckBoxMenuItem(this.showBootstrapValues, jMenu2);
        jMenu2.addSeparator();
        this.showClusterRoots = new JCheckBoxMenuItem("Cluster Roots");
        this.addJCheckBoxMenuItem(this.showClusterRoots, jMenu2);
        this.highlightClusterCenterLeaves = new JCheckBoxMenuItem("Cluster Center Leaves");
        this.addJCheckBoxMenuItem(this.highlightClusterCenterLeaves, jMenu2);
        this.displayclusterRootBootstrap = new JCheckBoxMenuItem("Cluster Root Bootstrap Values");
        this.addJCheckBoxMenuItem(this.displayclusterRootBootstrap, jMenu2);
        jMenu2.addSeparator();
        this.showLeavesFromFile = new JMenuItem("Show Leaf Labels From File");
        this.addJMenuItem(this.showLeavesFromFile, jMenu2);
        this.hideLeavesFromFile = new JMenuItem("Hide Leaf Labels From File");
        this.addJMenuItem(this.hideLeavesFromFile, jMenu2);
        this.add(jMenu2);
        JMenu jMenu3 = new JMenu("Font");
        this.fontBold = new JCheckBoxMenuItem("Bold");
        this.addJCheckBoxMenuItem(this.fontBold, jMenu3);
        this.fontItalic = new JCheckBoxMenuItem("Italic");
        this.addJCheckBoxMenuItem(this.fontItalic, jMenu3);
        this.fontPlain = new JCheckBoxMenuItem("Plain");
        this.addJCheckBoxMenuItem(this.fontPlain, jMenu3);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.fontBold);
        buttonGroup.add(this.fontItalic);
        buttonGroup.add(this.fontPlain);
        jMenu3.addSeparator();
        this.fontSize_6 = new JCheckBoxMenuItem("Size 6");
        this.addJCheckBoxMenuItem(this.fontSize_6, jMenu3);
        this.fontSize_7 = new JCheckBoxMenuItem("Size 7");
        this.addJCheckBoxMenuItem(this.fontSize_7, jMenu3);
        this.fontSize_8 = new JCheckBoxMenuItem("Size 8");
        this.addJCheckBoxMenuItem(this.fontSize_8, jMenu3);
        this.fontSize_9 = new JCheckBoxMenuItem("Size 9");
        this.addJCheckBoxMenuItem(this.fontSize_9, jMenu3);
        this.fontSize_10 = new JCheckBoxMenuItem("Size 10");
        this.addJCheckBoxMenuItem(this.fontSize_10, jMenu3);
        this.fontSize_11 = new JCheckBoxMenuItem("Size 11");
        this.addJCheckBoxMenuItem(this.fontSize_11, jMenu3);
        this.fontSize_12 = new JCheckBoxMenuItem("Size 12");
        this.addJCheckBoxMenuItem(this.fontSize_12, jMenu3);
        this.fontSize_13 = new JCheckBoxMenuItem("Size 13");
        this.addJCheckBoxMenuItem(this.fontSize_13, jMenu3);
        this.fontSize_14 = new JCheckBoxMenuItem("Size 14");
        this.addJCheckBoxMenuItem(this.fontSize_14, jMenu3);
        this.fontSize_15 = new JCheckBoxMenuItem("Size 15");
        this.addJCheckBoxMenuItem(this.fontSize_15, jMenu3);
        this.fontSize_16 = new JCheckBoxMenuItem("Size 16");
        this.addJCheckBoxMenuItem(this.fontSize_16, jMenu3);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.fontSize_6);
        buttonGroup2.add(this.fontSize_7);
        buttonGroup2.add(this.fontSize_8);
        buttonGroup2.add(this.fontSize_9);
        buttonGroup2.add(this.fontSize_10);
        buttonGroup2.add(this.fontSize_11);
        buttonGroup2.add(this.fontSize_12);
        buttonGroup2.add(this.fontSize_13);
        buttonGroup2.add(this.fontSize_14);
        buttonGroup2.add(this.fontSize_15);
        buttonGroup2.add(this.fontSize_16);
        this.add(jMenu3);
        JMenu jMenu4 = new JMenu("Tree");
        this.showCOT = new JCheckBoxMenuItem("Find Center Of Tree");
        this.addJCheckBoxMenuItem(this.showCOT, jMenu4);
        jMenu4.addSeparator();
        this.basicTreeData = new JMenuItem("Get Basic Tree Data");
        this.addJMenuItem(this.basicTreeData, jMenu4);
        this.leafPairDistances = new JMenuItem("Get Pairwise Data");
        this.addJMenuItem(this.leafPairDistances, jMenu4);
        this.getLeavesThatAreTooCloseToEachOther = new JMenuItem("Get Strains Within Minimum Distance From  Each Other");
        this.addJMenuItem(this.getLeavesThatAreTooCloseToEachOther, jMenu4);
        this.saveLeafCoords = new JMenuItem("Get X-Y Co-ords");
        this.addJMenuItem(this.saveLeafCoords, jMenu4);
        this.textTree = new JMenuItem("Get Text Tree Construction");
        this.addJMenuItem(this.textTree, jMenu4);
        jMenu4.addSeparator();
        this.removeRandomStrainsFromTree = new JMenuItem("Remove Strains From Tree Randomly");
        this.addJMenuItem(this.removeRandomStrainsFromTree, jMenu4);
        jMenu4.addSeparator();
        this.generateRandomTree = new JMenuItem("Generate Random Tree");
        this.addJMenuItem(this.generateRandomTree, jMenu4);
        this.generateFileOfXRandomTrees = new JMenuItem("Generate File Of 'x' Random Trees");
        this.addJMenuItem(this.generateFileOfXRandomTrees, jMenu4);
        this.add(jMenu4);
        JMenu jMenu5 = new JMenu("Clusters");
        this.highlightClusters = new JMenuItem("Pick Clusters Automatically");
        this.addJMenuItem(this.highlightClusters, jMenu5);
        jMenu5.addSeparator();
        this.getClusterData = new JMenuItem("Calculate Subtype Diversity Ratio And Subtype Diversity Variance");
        this.addJMenuItem(this.getClusterData, jMenu5);
        jMenu5.addSeparator();
        this.getIntraClusterData = new JMenuItem("Get Intra (Within) Cluster Pairwise Data");
        this.addJMenuItem(this.getIntraClusterData, jMenu5);
        this.getInterClusterData = new JMenuItem("Get Inter (Between) Cluster Pairwise Data");
        this.addJMenuItem(this.getInterClusterData, jMenu5);
        jMenu5.addSeparator();
        this.randomTreeSDR = new JMenuItem("Calculate SDR/SDV Distribution From 'x' No. Of Sampled Random Trees");
        this.addJMenuItem(this.randomTreeSDR, jMenu5);
        this.add(jMenu5);
        JMenu jMenu6 = new JMenu("Help");
        this.about = new JMenuItem("About");
        this.addJMenuItem(this.about, jMenu6);
        this.disclamer = new JMenuItem("Disclaimer");
        this.addJMenuItem(this.disclamer, jMenu6);
        this.add(jMenu6);
    }

    private void addJMenuItem(JMenuItem jMenuItem, JMenu jMenu) {
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
    }

    private void addJCheckBoxMenuItem(JCheckBoxMenuItem jCheckBoxMenuItem, JMenu jMenu) {
        jCheckBoxMenuItem.addActionListener(this);
        jMenu.add(jCheckBoxMenuItem);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.saveNewickFormat && this.centralLayoutWindow.getTheTree() != null) {
            String string = this.centralLayoutWindow.getTheTree().getRoot().getTitle();
            FileWriter fileWriter = null;
            PrintWriter printWriter = null;
            String string2 = SomeUsefullStuff.getFile(this, false).getSelectedFile().getPath();
            try {
                fileWriter = new FileWriter(string2);
                printWriter = new PrintWriter((Writer)fileWriter, false);
                printWriter.println(string);
                printWriter.close();
                this.centralLayoutWindow.printConsoleln("Tree saved to: " + string2, SomeUsefullStuff.CONSOLE_TREE);
                this.centralLayoutWindow.openDividerIfClosed();
            }
            catch (Exception exception) {
                this.centralLayoutWindow.printConsoleln("Tree scould not be saved.", SomeUsefullStuff.CONSOLE_TREE);
                this.centralLayoutWindow.openDividerIfClosed();
            }
        } else if (object == this.about) {
            String string = System.getProperty("line.separator") + "Version: 1.00 " + System.getProperty("line.separator") + " Authors: John Archer and David Robertson " + System.getProperty("line.separator") + " Contact:john.archer@postgrad.manchester.ac.uk " + System.getProperty("line.separator") + " Date of Last Update: 04/03/07 " + System.getProperty("line.separator") + " Referance: XXXXX " + System.getProperty("line.separator") + " " + System.getProperty("line.separator");
            this.centralLayoutWindow.printConsoleln(string, SomeUsefullStuff.CONSOLE_TREE);
            this.centralLayoutWindow.openDividerIfClosed();
        } else if (object == this.disclamer) {
            String string = System.getProperty("line.separator") + "There is no charge for using CTree. " + System.getProperty("line.separator") + " Users use CTree at their own risk. " + System.getProperty("line.separator") + " If using this software in a publication please referance the paper under the 'About CTree' menu option. " + System.getProperty("line.separator") + " Report any bugs or sugestions to: john.archer@postgrad.manchester.ac.uk " + System.getProperty("line.separator") + " " + System.getProperty("line.separator");
            this.centralLayoutWindow.printConsoleln(string, SomeUsefullStuff.CONSOLE_TREE);
            this.centralLayoutWindow.openDividerIfClosed();
        } else if (object == this.createPDF && this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.getTreePane().makePDF(SomeUsefullStuff.getFile(this, false).getSelectedFile().getPath());
        } else if (object == this.textTree && this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.printConsoleln(this.centralLayoutWindow.getTheTree().getTextGraph(this.centralLayoutWindow.getTheTree().getRoot(), 5), SomeUsefullStuff.CONSOLE_TREE);
            this.centralLayoutWindow.openDividerIfClosed();
        } else if (object == this.generateRandomTree) {
            int n = 0;
            int n2 = 0;
            double d = 0.0;
            double d2 = 0.0;
            Random random = new Random();
            try {
                n = new Integer(JOptionPane.showInputDialog("Initial Population Size (will be sampled from):"));
                d2 = new Double(JOptionPane.showInputDialog("Probability Of Birth (value between 0 and 1):"));
                n2 = new Integer(JOptionPane.showInputDialog("Sample Size"));
                GraphicalTree graphicalTree = new GraphicalTree();
                graphicalTree.growRandomTree(n, d2, 0.0);
                int n3 = n - n2;
                String string = graphicalTree.reomoveStrainsFromTree(n3, random);
                graphicalTree.setXExpansion(graphicalTree.findBestXExpansion(GraphicalTree.INITIAL_TREE_DIAMETER_SIZE));
                graphicalTree.setYExpansion(1.0);
                this.centralLayoutWindow.addOrReplaceSessionTree(graphicalTree);
                this.centralLayoutWindow.setTheTree(graphicalTree);
                this.centralLayoutWindow.rePaintTree();
                this.centralLayoutWindow.printConsoleln("Random tree generated.", SomeUsefullStuff.CONSOLE_TREE);
                this.centralLayoutWindow.openDividerIfClosed();
            }
            catch (Exception exception) {
                this.centralLayoutWindow.printConsoleln("Check input parameters.", SomeUsefullStuff.CONSOLE_TREE);
            }
        } else if (object == this.removeRandomStrainsFromTree && this.centralLayoutWindow.getTheTree() != null) {
            int n = 0;
            Random random = new Random();
            try {
                n = new Integer(JOptionPane.showInputDialog("Number Of Strains To Remove:"));
                this.centralLayoutWindow.getTheTree().reomoveStrainsFromTree(n, random);
                this.centralLayoutWindow.rePaintTree();
                this.centralLayoutWindow.printConsoleln(n + " strain(s) removed.", SomeUsefullStuff.CONSOLE_TREE);
                this.centralLayoutWindow.openDividerIfClosed();
            }
            catch (Exception exception) {
                this.centralLayoutWindow.printConsoleln("Check input parameters.", SomeUsefullStuff.CONSOLE_TREE);
            }
        } else if (object == this.newTree) {
            try {
                String string = SomeUsefullStuff.getFile(this, true).getSelectedFile().getPath();
                String string3 = "";
                boolean bl = true;
                FileReader fileReader = new FileReader(string);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                GraphicalTree graphicalTree = null;
                boolean bl2 = false;
                while (bl) {
                    try {
                        String string4 = new String(bufferedReader.readLine());
                        string4 = string4.trim();
                        string4 = string4.replaceAll(System.getProperty("line.separator"), "");
                        if ((string3 = string3 + string4).indexOf(";") <= -1) continue;
                        graphicalTree = new GraphicalTree(string3);
                        this.centralLayoutWindow.addOrReplaceSessionTree(graphicalTree);
                        string3 = "";
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                }
                if (!bl2) {
                    graphicalTree = new GraphicalTree(string3);
                    this.centralLayoutWindow.addOrReplaceSessionTree(graphicalTree);
                }
                bufferedReader.close();
                this.centralLayoutWindow.setTheTree(graphicalTree);
                this.centralLayoutWindow.rePaintTree();
                this.centralLayoutWindow.printConsoleln(string + " loaded", SomeUsefullStuff.CONSOLE_TREE);
                this.centralLayoutWindow.openDividerIfClosed();
            }
            catch (Exception exception) {
                this.centralLayoutWindow.printConsoleln("File not be loaded - check tree is in correct NEWICK (.ph/.phb) format.", SomeUsefullStuff.CONSOLE_TREE);
                this.centralLayoutWindow.openDividerIfClosed();
            }
        } else if (object == this.loadTree) {
            try {
                String string = SomeUsefullStuff.getFile(this, true).getSelectedFile().getPath();
                FileReader fileReader = new FileReader(string);
                GraphicalTree graphicalTree = (GraphicalTree)Tree.loadTree(string);
                this.centralLayoutWindow.addOrReplaceSessionTree(graphicalTree);
                this.centralLayoutWindow.setTheTree(graphicalTree);
                this.centralLayoutWindow.rePaintTree();
                this.centralLayoutWindow.printConsoleln(string + " loaded", SomeUsefullStuff.CONSOLE_TREE);
                this.centralLayoutWindow.openDividerIfClosed();
            }
            catch (Exception exception) {
                this.centralLayoutWindow.printConsoleln("File could not be loaded.", SomeUsefullStuff.CONSOLE_TREE);
                this.centralLayoutWindow.openDividerIfClosed();
            }
        } else if (object == this.saveFormattedTree && this.centralLayoutWindow.getTheTree() != null) {
            String string = SomeUsefullStuff.getFile(this, false).getSelectedFile().getPath();
            try {
                this.centralLayoutWindow.getTheTree().saveTree(string);
                this.centralLayoutWindow.printConsoleln("Tree saved to: " + string, SomeUsefullStuff.CONSOLE_TREE);
                this.centralLayoutWindow.openDividerIfClosed();
            }
            catch (Exception exception) {
                this.centralLayoutWindow.printConsoleln("Tree could not be saved. ", SomeUsefullStuff.CONSOLE_TREE);
                this.centralLayoutWindow.openDividerIfClosed();
            }
        } else if (object == this.saveLeafCoords && this.centralLayoutWindow.getTheTree() != null) {
            this.getLeafXYCoords();
            this.centralLayoutWindow.openDividerIfClosed();
        } else if (object == this.basicTreeData && this.centralLayoutWindow.getTheTree() != null) {
            this.printBasicTreeData();
            this.centralLayoutWindow.openDividerIfClosed();
        } else if (object == this.randomTreeSDR) {
            this.centralLayoutWindow.printConsoleln("This may take a while depending on your sample size, number of samples and processor.", SomeUsefullStuff.CONSOLE_TREE);
            int n = -1;
            int n4 = -1;
            int n5 = -1;
            double d = -1.0;
            Random random = new Random();
            boolean bl = true;
            try {
                n4 = new Integer(JOptionPane.showInputDialog("No. Of Trees To Generate:"));
                n = new Integer(JOptionPane.showInputDialog("Initial Population Size:"));
                d = new Double(JOptionPane.showInputDialog("Probability Of Birth (value between 0 and 1):"));
                n5 = new Integer(JOptionPane.showInputDialog("Sample Size (max. value = 124):"));
                if (n5 > 125) {
                    bl = false;
                    this.centralLayoutWindow.printConsoleln("No. of taxa in the sample size exceeds the maximum allowed input (max = 125 taxa) for this algorithm.", SomeUsefullStuff.CONSOLE_TREE);
                }
                if (d > 1.0) {
                    bl = false;
                    this.centralLayoutWindow.printConsoleln("Probability of birth exceeds 1.", SomeUsefullStuff.CONSOLE_TREE);
                }
                if (d <= 0.0) {
                    bl = false;
                    this.centralLayoutWindow.printConsoleln("Probability of birth les than or equal to 0.", SomeUsefullStuff.CONSOLE_TREE);
                }
                if (n < n5) {
                    bl = false;
                    this.centralLayoutWindow.printConsoleln("The tree size (max. no. of leaves) is less than the sampling size.", SomeUsefullStuff.CONSOLE_TREE);
                }
            }
            catch (Exception exception) {
                bl = false;
                this.centralLayoutWindow.printConsoleln("Check input parameter formats.", SomeUsefullStuff.CONSOLE_TREE);
            }
            if (bl) {
                try {
                    double d3;
                    Object object2;
                    double[] dArray = new double[n4];
                    double[] dArray2 = new double[n4];
                    double[] dArray3 = new double[n4];
                    double[] dArray4 = new double[n4];
                    int n6 = 0;
                    while (n6 < n4) {
                        int n7;
                        object2 = new Tree();
                        ((Tree)object2).growRandomTree(n, d, 0.0);
                        int n8 = n - n5;
                        ((Tree)object2).reomoveStrainsFromTree(n8, random);
                        double d4 = 2.0;
                        int n9 = 3;
                        int n10 = 3;
                        String string = ((Tree)object2).getRoot().getTitle();
                        d3 = 100.0 / d4 + 1.0;
                        int n11 = (int)Math.round(d3);
                        if ((double)n11 < d3) {
                            ++n11;
                        }
                        double[] dArray5 = new double[n11];
                        boolean[] blArray = new boolean[n11];
                        Tree[] treeArray = new Tree[n11];
                        for (n7 = 0; n7 < treeArray.length; ++n7) {
                            dArray5[n7] = 0.0;
                            treeArray[n7] = null;
                            blArray[n7] = false;
                        }
                        n7 = 0;
                        for (double d5 = 20.0; d5 < 99.0; d5 += d4) {
                            GraphicalTree graphicalTree = new GraphicalTree(string);
                            graphicalTree.setClustersFast(d5, true, true);
                            Cluster[] clusterArray = graphicalTree.getClusters();
                            blArray[n7] = true;
                            for (int i = 0; i < clusterArray.length; ++i) {
                                if (clusterArray[i].getNoOfClusterLeaves() >= n9) continue;
                                blArray[n7] = false;
                            }
                            double[] dArray6 = graphicalTree.getTreeData();
                            dArray5[n7] = dArray6[2];
                            treeArray[n7] = graphicalTree;
                            ++n7;
                            if (graphicalTree.getClusters().length <= 1) break;
                        }
                        int n12 = -1;
                        double d6 = 1.0;
                        for (int i = 0; i < treeArray.length; ++i) {
                            if (treeArray[i] == null || !(dArray5[i] < d6) || !(dArray5[i] > 0.0) || !blArray[i] || treeArray[i].getClusters().length < n10) continue;
                            d6 = dArray5[i];
                            n12 = i;
                        }
                        if (n12 == -1) continue;
                        double[] dArray7 = treeArray[n12].getTreeData();
                        dArray[n6] = dArray7[0];
                        dArray2[n6] = dArray7[1];
                        dArray3[n6] = dArray7[2];
                        ++n6;
                    }
                    this.centralLayoutWindow.printConsoleln("Random tree analysis results: ", SomeUsefullStuff.CONSOLE_CLUSTER);
                    object2 = "";
                    String string = "";
                    for (int i = 0; i < dArray3.length; ++i) {
                        object2 = (String)object2 + dArray3[i] + ", ";
                        string = string + dArray2[i] + ", ";
                    }
                    this.centralLayoutWindow.printConsoleln("SDR value for each tree: " + (String)object2, SomeUsefullStuff.CONSOLE_CLUSTER);
                    this.centralLayoutWindow.printConsoleln("SDV value for each tree: " + string, SomeUsefullStuff.CONSOLE_CLUSTER);
                    MyStats myStats = new MyStats();
                    double d7 = myStats.getMean(dArray3);
                    double d8 = myStats.getStandardDeviation(dArray3);
                    d3 = myStats.getMean(dArray2);
                    double d9 = myStats.getStandardDeviation(dArray2);
                    this.centralLayoutWindow.printConsoleln("Mean SDR: " + d7, SomeUsefullStuff.CONSOLE_CLUSTER);
                    this.centralLayoutWindow.printConsoleln("SDR Standard Deviation: +/-" + d8, SomeUsefullStuff.CONSOLE_CLUSTER);
                    this.centralLayoutWindow.printConsoleln("Mean SDV: " + d3, SomeUsefullStuff.CONSOLE_CLUSTER);
                    this.centralLayoutWindow.printConsoleln("SDV Standard Deviation: " + d9, SomeUsefullStuff.CONSOLE_CLUSTER);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.centralLayoutWindow.printConsoleln("Check input parameters.", SomeUsefullStuff.CONSOLE_TREE);
                }
            }
        } else if (object == this.generateFileOfXRandomTrees) {
            int n = 0;
            int n13 = 0;
            int n14 = 0;
            double d = 0.0;
            double d10 = 0.0;
            Random random = new Random();
            try {
                n13 = new Integer(JOptionPane.showInputDialog("No. Of Trees To Generate:"));
                n = new Integer(JOptionPane.showInputDialog("Initial Population Size (will be sampled from):"));
                d10 = new Double(JOptionPane.showInputDialog("Probability Of Birth (value between 0 and 1):"));
                n14 = new Integer(JOptionPane.showInputDialog("Sample Size"));
                FileWriter fileWriter = null;
                PrintWriter printWriter = null;
                try {
                    String string = SomeUsefullStuff.getFile(this, false).getSelectedFile().getPath();
                    fileWriter = new FileWriter(string);
                    printWriter = new PrintWriter((Writer)fileWriter, false);
                    for (int i = 0; i < n13; ++i) {
                        Tree tree = new Tree();
                        tree.growRandomTree(n, d10, 0.0);
                        int n15 = n - n14;
                        tree = new Tree(tree.reomoveStrainsFromTree(n15, random));
                        printWriter.println(tree.getRoot().getTitle());
                    }
                    printWriter.close();
                    this.centralLayoutWindow.printConsoleln("Your trees have been saved to: " + string, SomeUsefullStuff.CONSOLE_TREE);
                    this.centralLayoutWindow.printConsoleln("  ", SomeUsefullStuff.CONSOLE_TREE);
                }
                catch (Exception exception) {
                    System.out.println("Exception cought during saving");
                }
            }
            catch (Exception exception) {
                this.centralLayoutWindow.printConsoleln("Check input parameters.", SomeUsefullStuff.CONSOLE_TREE);
            }
        } else if (object == this.getLeavesThatAreTooCloseToEachOther && this.centralLayoutWindow.getTheTree() != null) {
            try {
                double d = new Double(JOptionPane.showInputDialog("Please input a % that is the minimum distance between leaves"));
                try {
                    this.getLeavesWithinMinDistanceOfEachOther(d);
                    this.centralLayoutWindow.openDividerIfClosed();
                }
                catch (Exception exception) {
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Value must be in the format of X.XX or X where X is a number.", "alert", 0);
            }
        } else if (object == this.highlightClusters && this.centralLayoutWindow.getTheTree() != null) {
            if (this.centralLayoutWindow.getTheTree().getNumberOfLeaves() > 125) {
                this.centralLayoutWindow.printConsoleln("No. of taxa exceeds the maximum allowed input (max = 125 taxa) for this algorithm.", SomeUsefullStuff.CONSOLE_TREE);
            } else {
                this.centralLayoutWindow.printConsoleln("This may take a few minutes depending on your sample size and processor.", SomeUsefullStuff.CONSOLE_TREE);
                double d = 0.0;
                try {
                    while (d < 1.0 || d > 100.0) {
                        d = new Double(JOptionPane.showInputDialog("Please Specify the Sensitivity Of the Process (1.00 - 100.00)."));
                    }
                    int n = new Integer(JOptionPane.showInputDialog("Min No. Of Strains Allowed in Cluster - (usually 2)"));
                    try {
                        String string = this.centralLayoutWindow.getTheTree().getRoot().getTitle();
                        double d11 = 100.0 / d + 1.0;
                        int n16 = (int)Math.round(d11);
                        if ((double)n16 < d11) {
                            ++n16;
                        }
                        double[] dArray = new double[n16];
                        boolean[] blArray = new boolean[n16];
                        GraphicalTree[] graphicalTreeArray = new GraphicalTree[n16];
                        int n17 = 0;
                        for (double d12 = 20.0; d12 < 99.0; d12 += d) {
                            GraphicalTree graphicalTree = new GraphicalTree(string);
                            graphicalTree.setClustersFast(d12, true, true);
                            Cluster[] clusterArray = graphicalTree.getClusters();
                            blArray[n17] = true;
                            for (int i = 0; i < clusterArray.length; ++i) {
                                if (clusterArray[i].getNoOfClusterLeaves() >= n) continue;
                                blArray[n17] = false;
                            }
                            double[] dArray8 = graphicalTree.getTreeData();
                            dArray[n17] = dArray8[2];
                            graphicalTreeArray[n17] = graphicalTree;
                            ++n17;
                            if (graphicalTree.getClusters().length <= 1) break;
                        }
                        int n18 = -1;
                        double d13 = 1.0;
                        for (int i = 0; i < graphicalTreeArray.length - 2; ++i) {
                            if (graphicalTreeArray[i] == null || !(dArray[i] < d13) || !(dArray[i] > 0.0) || !blArray[i] || graphicalTreeArray[i].getClusters().length < 2) continue;
                            d13 = dArray[i];
                            n18 = i;
                        }
                        if (n18 != -1) {
                            GraphicalTree graphicalTree = graphicalTreeArray[n18];
                            this.centralLayoutWindow.addOrReplaceSessionTree(graphicalTree);
                            this.centralLayoutWindow.setTheTree(graphicalTree);
                            this.centralLayoutWindow.rePaintTree();
                            this.showClusterRoots.setState(true);
                            this.highlightClusterCenterLeaves.setState(true);
                        } else {
                            JOptionPane.showMessageDialog(null, "Could not heuristically find clusters on this tree - try altering input parameters!.", "alert", 0);
                        }
                        for (int i = 0; i < graphicalTreeArray.length; ++i) {
                            graphicalTreeArray[i] = null;
                        }
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception exception) {}
            }
        } else if (object == this.getClusterData && this.centralLayoutWindow.getTheTree() != null) {
            Cluster[] clusterArray = this.centralLayoutWindow.getTheTree().getClusters();
            if (clusterArray != null) {
                this.clusterDataToConsole(clusterArray);
                this.centralLayoutWindow.openDividerIfClosed();
            } else {
                this.centralLayoutWindow.printConsoleln("No clusters chosen", SomeUsefullStuff.CONSOLE_CLUSTER);
                this.centralLayoutWindow.openDividerIfClosed();
            }
        } else if (object == this.getInterClusterData && this.centralLayoutWindow.getTheTree() != null) {
            Cluster[] clusterArray = this.centralLayoutWindow.getTheTree().getClusters();
            if (clusterArray != null) {
                this.getInterClusterData(clusterArray);
            } else {
                this.centralLayoutWindow.printConsoleln("No clusters chosen", SomeUsefullStuff.CONSOLE_CLUSTER);
                this.centralLayoutWindow.openDividerIfClosed();
            }
        } else if (object == this.getIntraClusterData && this.centralLayoutWindow.getTheTree() != null) {
            Cluster[] clusterArray = this.centralLayoutWindow.getTheTree().getClusters();
            if (clusterArray != null) {
                this.getIntraClusterData(clusterArray);
                this.centralLayoutWindow.openDividerIfClosed();
            } else {
                this.centralLayoutWindow.printConsoleln("No clusters chosen", SomeUsefullStuff.CONSOLE_CLUSTER);
                this.centralLayoutWindow.openDividerIfClosed();
            }
        } else if (object == this.leafPairDistances && this.centralLayoutWindow.getTheTree() != null) {
            this.getLeafPairDistances();
            this.centralLayoutWindow.openDividerIfClosed();
        } else if (object == this.fontItalic && this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.getTheTree().setTreeFontType(2);
            if (this.centralLayoutWindow.getIsCircleTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getCircleTreeFont());
            } else if (this.centralLayoutWindow.getIsSquareTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getSquareTreeFont());
            }
        } else if (object == this.fontBold && this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.getTheTree().setTreeFontType(1);
            if (this.centralLayoutWindow.getIsCircleTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getCircleTreeFont());
            } else if (this.centralLayoutWindow.getIsSquareTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getSquareTreeFont());
            }
        } else if (object == this.fontPlain && this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.getTheTree().setTreeFontType(0);
            if (this.centralLayoutWindow.getIsCircleTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getCircleTreeFont());
            } else if (this.centralLayoutWindow.getIsSquareTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getSquareTreeFont());
            }
        } else if (object == this.fontSize_6 && this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.getTheTree().setCircleTreeFontSize(6);
            this.centralLayoutWindow.getTheTree().setSquareTreeFontSize(6);
            if (this.centralLayoutWindow.getIsCircleTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getCircleTreeFont());
            } else if (this.centralLayoutWindow.getIsSquareTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getSquareTreeFont());
            }
        } else if (object == this.fontSize_7 && this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.getTheTree().setCircleTreeFontSize(7);
            this.centralLayoutWindow.getTheTree().setSquareTreeFontSize(7);
            if (this.centralLayoutWindow.getIsCircleTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getCircleTreeFont());
            } else if (this.centralLayoutWindow.getIsSquareTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getSquareTreeFont());
            }
        } else if (object == this.fontSize_8 && this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.getTheTree().setCircleTreeFontSize(8);
            this.centralLayoutWindow.getTheTree().setSquareTreeFontSize(8);
            if (this.centralLayoutWindow.getIsCircleTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getCircleTreeFont());
            } else if (this.centralLayoutWindow.getIsSquareTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getSquareTreeFont());
            }
        } else if (object == this.fontSize_9 && this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.getTheTree().setCircleTreeFontSize(9);
            this.centralLayoutWindow.getTheTree().setSquareTreeFontSize(9);
            if (this.centralLayoutWindow.getIsCircleTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getCircleTreeFont());
            } else if (this.centralLayoutWindow.getIsSquareTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getSquareTreeFont());
            }
        } else if (object == this.fontSize_10 && this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.getTheTree().setCircleTreeFontSize(10);
            this.centralLayoutWindow.getTheTree().setSquareTreeFontSize(10);
            if (this.centralLayoutWindow.getIsCircleTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getCircleTreeFont());
            } else if (this.centralLayoutWindow.getIsSquareTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getSquareTreeFont());
            }
        } else if (object == this.fontSize_11 && this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.getTheTree().setCircleTreeFontSize(11);
            this.centralLayoutWindow.getTheTree().setSquareTreeFontSize(11);
            if (this.centralLayoutWindow.getIsCircleTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getCircleTreeFont());
            } else if (this.centralLayoutWindow.getIsSquareTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getSquareTreeFont());
            }
        } else if (object == this.fontSize_12 && this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.getTheTree().setCircleTreeFontSize(12);
            this.centralLayoutWindow.getTheTree().setSquareTreeFontSize(12);
            if (this.centralLayoutWindow.getIsCircleTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getCircleTreeFont());
            } else if (this.centralLayoutWindow.getIsSquareTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getSquareTreeFont());
            }
        } else if (object == this.fontSize_13 && this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.getTheTree().setCircleTreeFontSize(13);
            this.centralLayoutWindow.getTheTree().setSquareTreeFontSize(13);
            if (this.centralLayoutWindow.getIsCircleTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getCircleTreeFont());
            } else if (this.centralLayoutWindow.getIsSquareTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getSquareTreeFont());
            }
        } else if (object == this.fontSize_14 && this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.getTheTree().setCircleTreeFontSize(14);
            this.centralLayoutWindow.getTheTree().setSquareTreeFontSize(14);
            if (this.centralLayoutWindow.getIsCircleTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getCircleTreeFont());
            } else if (this.centralLayoutWindow.getIsSquareTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getSquareTreeFont());
            }
        } else if (object == this.fontSize_15 && this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.getTheTree().setCircleTreeFontSize(15);
            this.centralLayoutWindow.getTheTree().setSquareTreeFontSize(15);
            if (this.centralLayoutWindow.getIsCircleTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getCircleTreeFont());
            } else if (this.centralLayoutWindow.getIsSquareTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getSquareTreeFont());
            }
        } else if (object == this.fontSize_16 && this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.getTheTree().setCircleTreeFontSize(16);
            this.centralLayoutWindow.getTheTree().setSquareTreeFontSize(16);
            if (this.centralLayoutWindow.getIsCircleTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getCircleTreeFont());
            } else if (this.centralLayoutWindow.getIsSquareTree()) {
                this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getSquareTreeFont());
            }
        } else if (object == this.showLeavesFromFile && this.centralLayoutWindow.getTheTree() != null) {
            try {
                this.showLeavesFromFile(SomeUsefullStuff.getFile(this, true).getSelectedFile().getPath(), true);
            }
            catch (Exception exception) {}
        } else if (object == this.hideLeavesFromFile && this.centralLayoutWindow.getTheTree() != null) {
            try {
                this.showLeavesFromFile(SomeUsefullStuff.getFile(this, true).getSelectedFile().getPath(), false);
            }
            catch (Exception exception) {}
        } else if (object == this.showCOT && this.centralLayoutWindow.getTheTree() != null) {
            if (this.showCOT.getState()) {
                this.centralLayoutWindow.getTheTree().getCOT();
            }
            this.centralLayoutWindow.rePaintTree();
        }
        if (this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.rePaintTree();
        }
    }

    public void setCOTSelected(boolean bl) {
        this.showCOT.setState(bl);
    }

    public boolean getShowCOT() {
        return this.showCOT.getState();
    }

    public boolean getDisplayLeafLabels() {
        return this.showLeafText.getState();
    }

    public boolean getDisplayLeafNodes() {
        return this.showLeafNode.getState();
    }

    public boolean getDisplayInternalNodes() {
        return this.showInternalNode.getState();
    }

    public boolean getDisplayRootNode() {
        return this.showRootNode.getState();
    }

    public boolean getDisplayBootstrapValues() {
        return this.showBootstrapValues.getState();
    }

    public boolean getDisplayEdgeLabels() {
        return this.showEdgeLengths.getState();
    }

    public boolean getHighlightClusterRoots() {
        return this.showClusterRoots.getState();
    }

    public boolean getHighlightCladCenterLeaves() {
        return this.highlightClusterCenterLeaves.getState();
    }

    public boolean getDisplayClusterRootBootstrap() {
        return this.displayclusterRootBootstrap.getState();
    }

    private void showLeavesFromFile(String string, boolean bl) {
        Object object;
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            boolean bl2 = true;
            FileReader fileReader = new FileReader(string);
            object = new BufferedReader(fileReader);
            while (bl2) {
                try {
                    linkedList.add(new String(((BufferedReader)object).readLine()));
                }
                catch (Exception exception) {
                    bl2 = false;
                }
            }
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            System.out.println("Exception =" + exception.getMessage());
        }
        LinkedList linkedList2 = this.centralLayoutWindow.getTheTree().getRoot().getLeafList();
        for (int i = 0; i < linkedList2.size(); ++i) {
            object = (Vertex)linkedList2.get(i);
            for (int j = 0; j < linkedList.size(); ++j) {
                String string2 = (String)linkedList.get(j);
                if (!string2.equals(((Vertex)object).getTitle())) continue;
                ((Vertex)object).setHideExplicitLabel(bl);
            }
        }
    }

    private void printBasicTreeData() {
        this.centralLayoutWindow.printConsoleln(" ", SomeUsefullStuff.CONSOLE_TREE);
        this.centralLayoutWindow.printConsoleln(" ", SomeUsefullStuff.CONSOLE_TREE);
        this.centralLayoutWindow.printConsoleln("Basic Tree Data:", SomeUsefullStuff.CONSOLE_TREE);
        this.centralLayoutWindow.printConsoleln("Total No. of Nodes: " + this.centralLayoutWindow.getTheTree().getTotalNumberOfVertices(), SomeUsefullStuff.CONSOLE_TREE);
        this.centralLayoutWindow.printConsoleln("No. of Leaf Nodes (Strains): " + this.centralLayoutWindow.getTheTree().getNumberOfLeaves(), SomeUsefullStuff.CONSOLE_TREE);
        this.centralLayoutWindow.printConsoleln("No. of Internal Nodes: " + (this.centralLayoutWindow.getTheTree().getTotalNumberOfVertices() - this.centralLayoutWindow.getTheTree().getNumberOfLeaves()), SomeUsefullStuff.CONSOLE_TREE);
        LinkedList linkedList = this.centralLayoutWindow.getTheTree().getUnrepeatedPairwiseDistanceList();
        double[] dArray = new double[linkedList.size()];
        for (int i = 0; i < dArray.length; ++i) {
            Double d = (Double)linkedList.get(i);
            dArray[i] = d;
        }
        MyStats myStats = new MyStats();
        this.centralLayoutWindow.printConsoleln("Mean Pairwise Distance Between Leaf Nodes: " + myStats.getMean(dArray) + ", (Varaince: " + myStats.getVariance(dArray) + ")", SomeUsefullStuff.CONSOLE_TREE);
        double d = this.centralLayoutWindow.getTheTree().getTotalTreeLength();
        this.centralLayoutWindow.printConsoleln("Total Tree Length: " + d, SomeUsefullStuff.CONSOLE_TREE);
        this.centralLayoutWindow.printConsoleln("Mean Edge Length: " + d / (double)(this.centralLayoutWindow.getTheTree().getTotalNumberOfVertices() - 1), SomeUsefullStuff.CONSOLE_TREE);
        this.centralLayoutWindow.printConsoleln(" ", SomeUsefullStuff.CONSOLE_TREE);
        this.centralLayoutWindow.openDividerIfClosed();
    }

    private void getLeavesWithinMinDistanceOfEachOther(double d) {
        Vertex vertex;
        int n;
        double d2 = (this.centralLayoutWindow.getTheTree().getMaxDistanceFromRoot() + this.centralLayoutWindow.getTheTree().getSecondMaxDistanceFromRoot()) / 100.0;
        double d3 = d * d2;
        LinkedList linkedList = this.centralLayoutWindow.getTheTree().getRoot().getLeafList();
        this.centralLayoutWindow.printConsoleln("Strains within " + d + "% of each other are:", SomeUsefullStuff.CONSOLE_TREE);
        int n2 = 0;
        for (n = 0; n < linkedList.size() - 1; ++n) {
            vertex = (Vertex)linkedList.get(n);
            if (vertex.getTitle().length() <= n2) continue;
            n2 = vertex.getTitle().length();
        }
        for (n = 0; n < linkedList.size() - 1; ++n) {
            vertex = (Vertex)linkedList.get(n);
            for (int i = n + 1; i < linkedList.size(); ++i) {
                Vertex vertex2 = (Vertex)linkedList.get(i);
                double d4 = GraphicalTree.getDistanceBetweenTwoVertices(vertex, vertex2);
                if (!(d4 < d3)) continue;
                String string = "";
                if (vertex.getTitle().length() <= n2) {
                    string = vertex.getTitle().trim();
                    for (int j = string.length(); j < n2; ++j) {
                        string = string + " ";
                    }
                    string = string + ",    ";
                } else {
                    string = vertex.getTitle().trim().substring(0, n2) + ",    ";
                }
                String string2 = "";
                if (vertex2.getTitle().length() <= n2) {
                    string2 = vertex2.getTitle().trim();
                    for (int j = string2.length(); j < n2; ++j) {
                        string2 = string2 + " ";
                    }
                    string2 = string2 + "    ";
                } else {
                    string2 = vertex.getTitle().trim().substring(0, n2) + ",    ";
                }
                this.centralLayoutWindow.printConsoleln(string + " &&     " + string2 + ": " + d4, SomeUsefullStuff.CONSOLE_TREE);
                linkedList.remove(vertex2);
            }
        }
        this.centralLayoutWindow.printConsoleln("   ", SomeUsefullStuff.CONSOLE_TREE);
        this.centralLayoutWindow.openDividerIfClosed();
    }

    private void getInterClusterData(Cluster[] clusterArray) {
        Serializable serializable;
        int n;
        LinkedList linkedList = this.centralLayoutWindow.getTheTree().getRoot().getLeafList();
        int n2 = 0;
        for (n = 0; n < linkedList.size() - 1; ++n) {
            serializable = (Vertex)linkedList.get(n);
            if (((Vertex)serializable).getTitle().length() <= n2) continue;
            n2 = ((Vertex)serializable).getTitle().length();
        }
        this.centralLayoutWindow.printConsoleln("Cluster strains and their INTER pairwise distances: " + clusterArray.length, SomeUsefullStuff.CONSOLE_CLUSTER);
        for (n = 0; n < clusterArray.length; ++n) {
            Object object;
            Object object2;
            Object object3;
            this.centralLayoutWindow.printConsoleln("(" + (n + 1) + " out of " + clusterArray.length + ")", SomeUsefullStuff.CONSOLE_CLUSTER);
            serializable = clusterArray[n].getClusterLeaves();
            LinkedList linkedList2 = new LinkedList();
            for (int i = 0; i < clusterArray.length; ++i) {
                if (clusterArray[i].getClusterCenterLeaf() == clusterArray[n].getClusterCenterLeaf() || clusterArray[i].getNoOfClusterLeaves() < this.centralLayoutWindow.getTheTree().getMinimumClusterSize()) continue;
                object3 = clusterArray[i].getClusterLeaves();
                for (int j = 0; j < ((LinkedList)object3).size(); ++j) {
                    linkedList2.add(((LinkedList)object3).get(j));
                }
            }
            String string = "";
            for (int i = 0; i < linkedList2.size(); ++i) {
                Vertex vertex = (Vertex)linkedList2.get(i);
                object2 = "";
                if (vertex.getTitle().length() <= n2) {
                    object2 = vertex.getTitle().trim();
                    for (int j = ((String)object2).length(); j < n2; ++j) {
                        object2 = (String)object2 + " ";
                    }
                    object2 = (String)object2 + " |    ";
                } else {
                    object2 = vertex.getTitle().trim().substring(0, n2) + " |    ";
                }
                string = string + (String)object2;
            }
            object3 = "";
            for (int i = 0; i < n2; ++i) {
                object3 = (String)object3 + " ";
            }
            this.centralLayoutWindow.printConsoleln((String)object3 + " |    " + string, SomeUsefullStuff.CONSOLE_CLUSTER);
            LinkedList<Double> linkedList3 = new LinkedList<Double>();
            for (int i = ((LinkedList)serializable).size() - 1; i >= 0; --i) {
                int n3;
                string = "";
                Vertex vertex = (Vertex)((LinkedList)serializable).get(i);
                object = "";
                if (vertex.getTitle().length() <= n2) {
                    object = vertex.getTitle().trim();
                    for (n3 = ((String)object).length(); n3 < n2; ++n3) {
                        object = (String)object + " ";
                    }
                    object = (String)object + " |    ";
                } else {
                    object = vertex.getTitle().trim().substring(0, n2) + " |    ";
                }
                string = string + (String)object;
                for (n3 = 0; n3 < linkedList2.size(); ++n3) {
                    Vertex vertex2 = (Vertex)linkedList2.get(n3);
                    double d = GraphicalTree.getDistanceBetweenTwoVertices(vertex, vertex2);
                    linkedList3.add(new Double(d));
                    String string2 = d + "";
                    if (string2.length() > n2) {
                        string2 = string2.substring(0, n2);
                    } else {
                        for (int j = string2.length(); j < n2; ++j) {
                            string2 = string2 + " ";
                        }
                    }
                    string = string + string2 + " |    ";
                }
                this.centralLayoutWindow.printConsoleln(string, SomeUsefullStuff.CONSOLE_CLUSTER);
            }
            object2 = new double[linkedList3.size()];
            for (int i = 0; i < ((Object)object2).length; ++i) {
                object = (Double)linkedList3.get(i);
                object2[i] = (Double)object;
            }
            MyStats myStats = new MyStats();
            this.centralLayoutWindow.printConsoleln("   ", SomeUsefullStuff.CONSOLE_CLUSTER);
            this.centralLayoutWindow.printConsoleln("Cluster Central Strain: " + clusterArray[n].getClusterCenterLeaf().getTitle(), SomeUsefullStuff.CONSOLE_CLUSTER);
            this.centralLayoutWindow.printConsoleln("Mean Inter Pairwise Distance: " + myStats.getMean((double[])object2), SomeUsefullStuff.CONSOLE_CLUSTER);
            this.centralLayoutWindow.printConsoleln("Standard Variation: " + myStats.getStandardDeviation((double[])object2), SomeUsefullStuff.CONSOLE_CLUSTER);
            this.centralLayoutWindow.printConsoleln("   ", SomeUsefullStuff.CONSOLE_CLUSTER);
            this.centralLayoutWindow.printConsoleln("   ", SomeUsefullStuff.CONSOLE_CLUSTER);
        }
        this.centralLayoutWindow.printConsoleln("   ", SomeUsefullStuff.CONSOLE_CLUSTER);
        this.centralLayoutWindow.printConsoleln("   ", SomeUsefullStuff.CONSOLE_CLUSTER);
        this.centralLayoutWindow.openDividerIfClosed();
    }

    private void getIntraClusterData(Cluster[] clusterArray) {
        this.centralLayoutWindow.printConsoleln("Cluster strains and their INTRA pairwise distances: " + clusterArray.length, SomeUsefullStuff.CONSOLE_CLUSTER);
        for (int i = 0; i < clusterArray.length; ++i) {
            Vertex vertex;
            int n;
            LinkedList<Double> linkedList;
            Object object;
            Serializable serializable;
            Object object2;
            this.centralLayoutWindow.printConsoleln("(" + (i + 1) + " out of " + clusterArray.length + ")", SomeUsefullStuff.CONSOLE_CLUSTER);
            LinkedList linkedList2 = clusterArray[i].getClusterLeaves();
            int n2 = 0;
            for (int j = 0; j < linkedList2.size() - 1; ++j) {
                object2 = (Vertex)linkedList2.get(j);
                if (((Vertex)object2).getTitle().length() <= n2) continue;
                n2 = ((Vertex)object2).getTitle().length();
            }
            String string = "";
            for (int j = 0; j < linkedList2.size(); ++j) {
                serializable = (Vertex)linkedList2.get(j);
                object = "";
                if (((Vertex)serializable).getTitle().length() <= n2) {
                    object = ((Vertex)serializable).getTitle().trim();
                    for (int k = ((String)object).length(); k < n2; ++k) {
                        object = (String)object + " ";
                    }
                    object = (String)object + " |    ";
                } else {
                    object = ((Vertex)serializable).getTitle().trim().substring(0, n2) + " |    ";
                }
                string = string + (String)object;
            }
            object2 = "";
            for (int j = 0; j < n2; ++j) {
                object2 = (String)object2 + " ";
            }
            this.centralLayoutWindow.printConsoleln((String)object2 + " |    " + string, SomeUsefullStuff.CONSOLE_CLUSTER);
            serializable = new LinkedList();
            for (int j = linkedList2.size() - 1; j >= 0; --j) {
                string = "";
                Vertex vertex2 = (Vertex)linkedList2.get(j);
                linkedList = "";
                if (vertex2.getTitle().length() <= n2) {
                    linkedList = vertex2.getTitle().trim();
                    for (n = ((String)((Object)linkedList)).length(); n < n2; ++n) {
                        linkedList = (String)((Object)linkedList) + " ";
                    }
                    linkedList = (String)((Object)linkedList) + " |    ";
                } else {
                    linkedList = vertex2.getTitle().trim().substring(0, n2) + " |    ";
                }
                string = string + (String)((Object)linkedList);
                for (n = 0; n < j; ++n) {
                    vertex = (Vertex)linkedList2.get(n);
                    double d = GraphicalTree.getDistanceBetweenTwoVertices(vertex2, vertex);
                    ((LinkedList)serializable).add(new Double(d));
                    String string2 = d + "";
                    if (string2.length() > n2) {
                        string2 = string2.substring(0, n2);
                    } else {
                        for (int k = string2.length(); k < n2; ++k) {
                            string2 = string2 + " ";
                        }
                    }
                    string = string + string2 + " |    ";
                }
                this.centralLayoutWindow.printConsoleln(string, SomeUsefullStuff.CONSOLE_CLUSTER);
            }
            object = new double[((LinkedList)serializable).size()];
            for (int j = 0; j < ((Object)object).length; ++j) {
                linkedList = (Double)((LinkedList)serializable).get(j);
                object[j] = (Double)((Object)linkedList);
            }
            MyStats myStats = new MyStats();
            this.centralLayoutWindow.printConsoleln("   ", SomeUsefullStuff.CONSOLE_CLUSTER);
            this.centralLayoutWindow.printConsoleln("Cluster Central Strain: " + clusterArray[i].getClusterCenterLeaf().getTitle(), SomeUsefullStuff.CONSOLE_CLUSTER);
            linkedList = new LinkedList<Double>();
            for (n = 0; n < linkedList2.size() - 1; ++n) {
                vertex = (Vertex)linkedList2.get(n);
                if (vertex == clusterArray[i].getClusterCenterLeaf()) continue;
                linkedList.add(new Double(GraphicalTree.getDistanceBetweenTwoVertices(vertex, clusterArray[i].getClusterCenterLeaf())));
            }
            double[] dArray = new double[linkedList.size()];
            for (int j = 0; j < dArray.length; ++j) {
                Double d = (Double)((LinkedList)serializable).get(j);
                dArray[j] = d;
            }
            this.centralLayoutWindow.printConsoleln("Mean Distance From Cluster Center Strain: " + myStats.getMean(dArray), SomeUsefullStuff.CONSOLE_CLUSTER);
            this.centralLayoutWindow.printConsoleln("Standard Variation: " + myStats.getMean(dArray), SomeUsefullStuff.CONSOLE_CLUSTER);
            this.centralLayoutWindow.printConsoleln("   ", SomeUsefullStuff.CONSOLE_CLUSTER);
            this.centralLayoutWindow.printConsoleln("Mean Intra Pairwise Distance: " + myStats.getMean((double[])object), SomeUsefullStuff.CONSOLE_CLUSTER);
            this.centralLayoutWindow.printConsoleln("Standard Variation: " + myStats.getStandardDeviation((double[])object), SomeUsefullStuff.CONSOLE_CLUSTER);
            this.centralLayoutWindow.printConsoleln("   ", SomeUsefullStuff.CONSOLE_CLUSTER);
            this.centralLayoutWindow.printConsoleln("   ", SomeUsefullStuff.CONSOLE_CLUSTER);
        }
        this.centralLayoutWindow.printConsoleln("   ", SomeUsefullStuff.CONSOLE_CLUSTER);
        this.centralLayoutWindow.openDividerIfClosed();
    }

    private void getLeafPairDistances() {
        int n;
        Object object;
        LinkedList linkedList = this.centralLayoutWindow.getTheTree().getRoot().getLeafList();
        int n2 = 0;
        for (int i = 0; i < linkedList.size() - 1; ++i) {
            Vertex vertex = (Vertex)linkedList.get(i);
            if (vertex.getTitle().length() <= n2) continue;
            n2 = vertex.getTitle().length();
        }
        this.centralLayoutWindow.printConsoleln("Pairwise Distance Data:", SomeUsefullStuff.CONSOLE_TREE);
        String string = "";
        for (int i = 0; i < linkedList.size(); ++i) {
            Vertex vertex = (Vertex)linkedList.get(i);
            object = "";
            if (vertex.getTitle().length() <= n2) {
                object = vertex.getTitle().trim();
                for (int j = ((String)object).length(); j < n2; ++j) {
                    object = (String)object + " ";
                }
                object = (String)object + " |    ";
            } else {
                object = vertex.getTitle().trim().substring(0, n2) + " |    ";
            }
            string = string + (String)object;
        }
        String string2 = "";
        for (n = 0; n < n2; ++n) {
            string2 = string2 + " ";
        }
        this.centralLayoutWindow.printConsoleln(string2 + " |    " + string, SomeUsefullStuff.CONSOLE_TREE);
        for (n = linkedList.size() - 1; n >= 0; --n) {
            int n3;
            string = "";
            object = (Vertex)linkedList.get(n);
            String string3 = "";
            if (((Vertex)object).getTitle().length() <= n2) {
                string3 = ((Vertex)object).getTitle().trim();
                for (n3 = string3.length(); n3 < n2; ++n3) {
                    string3 = string3 + " ";
                }
                string3 = string3 + "|    ";
            } else {
                string3 = ((Vertex)object).getTitle().trim().substring(0, n2) + " |    ";
            }
            string = string + string3;
            for (n3 = 0; n3 < n; ++n3) {
                Vertex vertex = (Vertex)linkedList.get(n3);
                double d = GraphicalTree.getDistanceBetweenTwoVertices((Vertex)object, vertex);
                String string4 = d + "";
                if (string4.length() > n2) {
                    string4 = string4.substring(0, n2);
                } else {
                    for (int i = string4.length(); i < n2; ++i) {
                        string4 = string4 + " ";
                    }
                }
                string = string + string4 + " |    ";
            }
            this.centralLayoutWindow.printConsoleln(string, SomeUsefullStuff.CONSOLE_TREE);
        }
        this.centralLayoutWindow.printConsoleln("   ", SomeUsefullStuff.CONSOLE_TREE);
        this.centralLayoutWindow.openDividerIfClosed();
    }

    private void getLeafXYCoords() {
        LinkedList linkedList = this.centralLayoutWindow.getTheTree().getRoot().getLeafList();
        this.centralLayoutWindow.printConsoleln("X - Y Coordinates of leaf nodes (and chosen center point):", SomeUsefullStuff.CONSOLE_TREE);
        this.centralLayoutWindow.printConsoleln("Defined Center, " + this.centralLayoutWindow.getTheTree().getRoot().getX() + " (x), " + this.centralLayoutWindow.getTheTree().getRoot().getY() + " (y)", SomeUsefullStuff.CONSOLE_TREE);
        for (int i = 0; i < linkedList.size(); ++i) {
            Vertex vertex = (Vertex)linkedList.get(i);
            this.centralLayoutWindow.printConsoleln(vertex.getTitle() + ", " + vertex.getX() + ", " + vertex.getY(), SomeUsefullStuff.CONSOLE_TREE);
        }
        this.centralLayoutWindow.printConsoleln(" ", SomeUsefullStuff.CONSOLE_TREE);
        this.centralLayoutWindow.openDividerIfClosed();
    }

    private void clusterDataToConsole(Cluster[] clusterArray) {
        if (this.centralLayoutWindow.getTheTree().getClusters() != null && this.centralLayoutWindow.getTheTree().getClusters().length > 0) {
            String string = "";
            double[] dArray = this.centralLayoutWindow.getTheTree().getTreeData();
            this.centralLayoutWindow.printConsoleln(" " + dArray[2], SomeUsefullStuff.CONSOLE_CLUSTER);
            this.centralLayoutWindow.printConsoleln(" " + dArray[2], SomeUsefullStuff.CONSOLE_CLUSTER);
            this.centralLayoutWindow.printConsoleln("Subtype Diversity Ratio: " + dArray[2], SomeUsefullStuff.CONSOLE_CLUSTER);
            this.centralLayoutWindow.printConsoleln("Subtype Diversity Variance: " + dArray[1], SomeUsefullStuff.CONSOLE_CLUSTER);
            this.centralLayoutWindow.printConsoleln("No. of clusters included: " + this.centralLayoutWindow.getTheTree().getClusters().length, SomeUsefullStuff.CONSOLE_CLUSTER);
            this.centralLayoutWindow.printConsoleln("   ", SomeUsefullStuff.CONSOLE_CLUSTER);
        }
    }
}

