/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.CentralLayoutWindow;
import gui.ScaleBarPanel;
import gui.SearchPanel;
import gui.SpaceOptimizer;
import gui.TreeMagnificationPanel;
import gui.TreeRotator;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JPanel;
import tree.GraphicalTree;
import utils.SomeUsefullStuff;

public class TopNorthPanel
extends JPanel {
    private SpaceOptimizer spaceOpt;
    private TreeRotator rotator;
    private ScaleBarPanel scaleBar;
    private TreeMagnificationPanel treeMag;
    private CentralLayoutWindow centralLayoutWindow;

    public TopNorthPanel(CentralLayoutWindow centralLayoutWindow) {
        super(new GridLayout(1, 5));
        this.setPreferredSize(new Dimension(SomeUsefullStuff.WIDTH_OF_APPLICATION, 32));
        this.centralLayoutWindow = centralLayoutWindow;
        this.setBorder(SomeUsefullStuff.getJPaneBorders(3));
        SearchPanel searchPanel = new SearchPanel(centralLayoutWindow);
        this.add(searchPanel);
        this.treeMag = new TreeMagnificationPanel(centralLayoutWindow);
        this.add(this.treeMag);
        this.rotator = new TreeRotator(centralLayoutWindow);
        this.add(this.rotator);
        this.spaceOpt = new SpaceOptimizer(centralLayoutWindow);
        this.add(this.spaceOpt);
        this.scaleBar = new ScaleBarPanel(centralLayoutWindow);
        this.add(this.scaleBar);
    }

    public void addOrReplaceSessionTree(GraphicalTree graphicalTree) {
        this.scaleBar.addOrReplaceSessionTree(graphicalTree);
    }

    public void setUpSquareTreeSliders() {
        this.rotator.showSquareTreeMagnifier();
        this.spaceOpt.showYExpander();
        this.treeMag.showBlank();
    }

    public void setUpCircleTreeSliders() {
        this.treeMag.showCircleTreeMagnifier();
        this.rotator.showCircleTreeRotator();
        this.spaceOpt.showSpaceOptimizer();
    }
}

