/*
 * Decompiled with CFR 0.152.
 */
package tree;

import java.awt.Font;
import tree.Tree;
import tree.Vertex;
import utils.SomeUsefullStuff;

public class GraphicalTree
extends Tree {
    public static int SPACE_FROM_EDGE_OF_GRAPH = 40;
    public static int SPACE_FROM_TOP_OF_GRAPH = 40;
    public static int INITIAL_TREE_DIAMETER_SIZE = SomeUsefullStuff.HEIGHT_OF_APPLICATION - 180;
    public static int INITIAL_TREE_HEIGHT_SIZE = SomeUsefullStuff.HEIGHT_OF_APPLICATION - 180;
    private int smallestX = -1;
    private int smallestY = -1;
    private int vertexDiameter = 4;
    protected double circleTreemag;
    private int fontType = 0;
    private int fontSizeSquare = 10;
    private int fontSizeCircle = 10;
    private String fontStyle = "Ariel";
    private Font treeFont;
    private double circularStartAngle = 0.0;
    private double extraManualOptimizerSpace = 0.0;
    private double yExpansion;
    private double xExpansion;
    int yChildSeperationUnit = 0;
    int currentYChild = 0;

    public GraphicalTree(String string) {
        super(string);
        this.circleTreemag = this.findBestCircleTreeMagnification(INITIAL_TREE_DIAMETER_SIZE);
        this.xExpansion = this.findBestXExpansion(INITIAL_TREE_DIAMETER_SIZE);
        this.yExpansion = 1.0;
    }

    public GraphicalTree() {
        if (this.treeRoot != null) {
            this.circleTreemag = this.findBestCircleTreeMagnification(INITIAL_TREE_DIAMETER_SIZE);
            this.xExpansion = this.findBestXExpansion(INITIAL_TREE_DIAMETER_SIZE);
            this.yExpansion = 1.0;
        }
    }

    public void setSpaceFromEdges(int n, int n2) {
        SPACE_FROM_EDGE_OF_GRAPH = n2;
        SPACE_FROM_TOP_OF_GRAPH = n;
    }

    public Font getSquareTreeFont() {
        return new Font(this.fontStyle, this.fontType, this.fontSizeSquare);
    }

    public Font getCircleTreeFont() {
        return new Font(this.fontStyle, this.fontType, this.fontSizeCircle);
    }

    public void setTreeFontStyle(String string) {
        this.fontStyle = string;
    }

    public void setTreeFontType(int n) {
        this.fontType = n;
    }

    public void setSquareTreeFontSize(int n) {
        if (n > 4 && n < 16) {
            this.fontSizeSquare = n;
        }
    }

    public void setCircleTreeFontSize(int n) {
        this.fontSizeCircle = n;
    }

    public int findBestSquareTreeFontSize() {
        int n = (int)((double)INITIAL_TREE_HEIGHT_SIZE * this.yExpansion / (double)this.getRoot().getNoOfLeafNodes());
        return n / 2;
    }

    public String getTreeFontStyle() {
        return this.fontStyle;
    }

    public int getTreeFontType() {
        return this.fontType;
    }

    public int getSquareTreeFontSize() {
        return this.fontSizeSquare;
    }

    public int getCircleTreeFontSize() {
        return this.fontSizeCircle;
    }

    public int getVertexDiameter() {
        return this.vertexDiameter;
    }

    public Vertex getVertexWithCoordinates(Vertex vertex, int n, int n2) {
        if (vertex.getIsTheRoot() && n + this.vertexDiameter / 2 >= vertex.getX() && n - this.vertexDiameter / 2 <= vertex.getX() && n2 + this.vertexDiameter / 2 >= vertex.getY() && n2 - this.vertexDiameter / 2 <= vertex.getY()) {
            this.currentVertexPtr = vertex;
            return vertex;
        }
        Object[] objectArray = vertex.getChildren().toArray();
        for (int i = 0; i != objectArray.length; ++i) {
            Vertex vertex2 = (Vertex)objectArray[i];
            if (n + this.vertexDiameter / 2 >= vertex2.getX() && n - this.vertexDiameter / 2 <= vertex2.getX() && n2 + this.vertexDiameter / 2 >= vertex2.getY() && n2 - this.vertexDiameter / 2 <= vertex2.getY()) {
                this.currentVertexPtr = vertex2;
                return this.currentVertexPtr;
            }
            if (vertex2.getNoOfChildren() <= 0) continue;
            this.getVertexWithCoordinates(vertex2, n, n2);
        }
        return this.currentVertexPtr;
    }

    public void setXExpansion(double d) {
        this.xExpansion = d;
    }

    public double getXExpansion() {
        return this.xExpansion;
    }

    public void setYExpansion(double d) {
        this.yExpansion = d;
    }

    public double getYExpansion() {
        return this.yExpansion;
    }

    public double getWidthOfSquareTreeForPDF() {
        return this.getTreeDiameterBeforeGraphicalMods() * this.getXExpansion();
    }

    public double getHeightOfSquareTreeForPDF() {
        return this.getTreeDiameterBeforeGraphicalMods() * this.getYExpansion();
    }

    public double getFullCircleTreeDiameterForPDFSize() {
        return this.getCircleTreeMagnification() * this.getXExpansion();
    }

    public double findBestXExpansion(int n) {
        block3: {
            double d;
            block2: {
                d = this.getTreeDiameterBeforeGraphicalMods() * this.getXExpansion();
                if (!(d < (double)n)) break block2;
                while (d < (double)n) {
                    this.setXExpansion(this.getXExpansion() + 0.5);
                    d = this.getTreeDiameterBeforeGraphicalMods() * this.getXExpansion();
                }
                break block3;
            }
            if (!(d > (double)n)) break block3;
            while (d > (double)n) {
                this.setXExpansion(this.getXExpansion() - 0.5);
                d = this.getTreeDiameterBeforeGraphicalMods() * this.getXExpansion();
            }
        }
        return this.getXExpansion();
    }

    public void setCircleTreeMagnification(double d) {
        this.circleTreemag = d == 0.0 ? 0.1 : d;
    }

    public double getCircleTreeMagnification() {
        return this.circleTreemag;
    }

    public double findBestCircleTreeMagnification(int n) {
        block3: {
            double d;
            block2: {
                d = this.getTreeDiameterBeforeGraphicalMods() * this.getCircleTreeMagnification();
                if (!(d < (double)n)) break block2;
                while (d < (double)n) {
                    this.setCircleTreeMagnification(this.getCircleTreeMagnification() + 1.0);
                    d = this.getTreeDiameterBeforeGraphicalMods() * this.getCircleTreeMagnification();
                }
                break block3;
            }
            if (!(d > (double)n)) break block3;
            while (d > (double)n) {
                this.setCircleTreeMagnification(this.getCircleTreeMagnification() - 1.0);
                d = this.getTreeDiameterBeforeGraphicalMods() * this.getCircleTreeMagnification();
            }
        }
        return this.getCircleTreeMagnification();
    }

    public void growRandomTree(int n, double d, double d2) {
        super.growRandomTree(n, d, d2);
        this.findBestCircleTreeMagnification(INITIAL_TREE_DIAMETER_SIZE);
    }

    public void setCircularStartAngle(double d) {
        this.circularStartAngle = d;
    }

    public void setExtraManualOptimizerSpace(double d) {
        this.extraManualOptimizerSpace = d;
    }

    public void setVertexCoordinatesCircular(int n, int n2) {
        Vertex vertex = this.getRoot();
        vertex.setX(n);
        vertex.setY(n2);
        this.setRadialCoordonates(vertex, this.circularStartAngle);
    }

    private void setRadialCoordonates(Vertex vertex, double d) {
        double d2 = this.treeRoot.getNoOfLeafNodes();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        Object[] objectArray = vertex.getChildren().toArray();
        double d7 = 0.0;
        d7 = vertex.getNoOfLeafNodes() > 0 ? 6.283185307 / d2 * (double)vertex.getNoOfLeafNodes() + (this.extraManualOptimizerSpace - this.extraManualOptimizerSpace / (double)vertex.getNoOfLeafNodes()) : 6.283185307 / d2 * (double)vertex.getNoOfLeafNodes();
        double d8 = d7 / (double)vertex.getNoOfLeafNodes();
        for (int i = 0; i != objectArray.length; ++i) {
            Vertex vertex2 = (Vertex)objectArray[i];
            d5 = 0.0;
            d6 = 0.0;
            if (vertex2.getNoOfLeafNodes() == 0) {
                d5 = d4 + d8 / 2.0;
                d6 = d4 + d8;
            } else {
                d5 = d4 + d8 * (double)vertex2.getNoOfLeafNodes() / 2.0;
                d6 = d4 + d8 * (double)vertex2.getNoOfLeafNodes();
            }
            d4 = d6;
            d3 = d - d7 / 2.0 + d5;
            double d9 = this.circleTreemag >= 0.0 ? vertex2.getDistanceFromParent() * this.circleTreemag : vertex2.getDistanceFromParent() / Math.abs(this.circleTreemag);
            vertex2.setX(vertex2.getPtrToParent().getX() + (int)(Math.cos(d3) * d9));
            vertex2.setY(vertex2.getPtrToParent().getY() + (int)(Math.sin(d3) * d9));
            vertex2.setChildAngle(d3);
            if (vertex2.getNoOfChildren() <= 0) continue;
            this.setRadialCoordonates(vertex2, d3);
        }
    }

    public void setSquareCoordsInitialize() {
        double d = 0.0;
        this.currentYChild = this.yChildSeperationUnit = INITIAL_TREE_HEIGHT_SIZE / this.getRoot().getNoOfLeafNodes();
        this.setSquareCoords(this.getRoot(), 0, d);
    }

    private int setSquareCoords(Vertex vertex, int n, double d) {
        Object[] objectArray = vertex.getChildren().toArray();
        if (objectArray.length > 0) {
            int n2;
            int n3;
            int[] nArray = new int[objectArray.length];
            boolean bl = false;
            for (n3 = 0; n3 != objectArray.length; ++n3) {
                Vertex vertex2 = (Vertex)objectArray[n3];
                if (vertex2.getNoOfChildren() > 0) {
                    nArray[n3] = this.setSquareCoords(vertex2, n + this.yChildSeperationUnit * n3, d + vertex2.getDistanceFromParent());
                    continue;
                }
                nArray[n3] = this.setSquareCoords(vertex2, this.currentYChild, d + vertex2.getDistanceFromParent());
                this.currentYChild += this.yChildSeperationUnit;
            }
            n3 = -1;
            int n4 = -1;
            for (n2 = 0; n2 != nArray.length; ++n2) {
                if (n2 == 0) {
                    n3 = nArray[n2];
                    n4 = nArray[n2];
                    continue;
                }
                if (nArray[n2] > n3) {
                    n3 = nArray[n2];
                }
                if (nArray[n2] >= n4) continue;
                n4 = nArray[n2];
            }
            n2 = (n3 + n4) / 2;
            vertex.setLeftY(n3);
            vertex.setRightY(n4);
            vertex.setX((int)(d * this.xExpansion) + SPACE_FROM_EDGE_OF_GRAPH);
            vertex.setY(n2);
            return n2;
        }
        vertex.setX((int)(d * this.xExpansion) + SPACE_FROM_EDGE_OF_GRAPH);
        int n5 = (int)((double)n * this.yExpansion + (double)SPACE_FROM_TOP_OF_GRAPH);
        vertex.setY(n5);
        return n5;
    }
}

