/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.BottomPanel;
import gui.CTreeWrapper;
import gui.TopPanel;
import gui.TreeOptions;
import gui.TreePane;
import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import tree.GraphicalTree;
import utils.SomeUsefullStuff;

public class CentralLayoutWindow
extends JSplitPane {
    private JScrollPane scroller;
    private BottomPanel bottomPanel;
    private TopPanel topPanel;
    private CTreeWrapper ptrToWrappingFrame;

    public CentralLayoutWindow(CTreeWrapper cTreeWrapper) {
        super(0, true);
        this.setSize(SomeUsefullStuff.WIDTH_OF_APPLICATION, SomeUsefullStuff.HEIGHT_OF_APPLICATION);
        this.setBorder(SomeUsefullStuff.getJPaneBorders(2));
        this.setOneTouchExpandable(true);
        this.setOpaque(true);
        this.topPanel = new TopPanel(this);
        this.bottomPanel = new BottomPanel(this);
        this.ptrToWrappingFrame = cTreeWrapper;
        this.setDividerSize(6);
        this.setDividerLocation(SomeUsefullStuff.HEIGHT_OF_APPLICATION);
        this.addImpl(this.topPanel, "top", 1);
        this.addImpl(this.bottomPanel, "bottom", 1);
        this.setVisible(true);
    }

    public int whichTabIsSelected() {
        return this.bottomPanel.whichTabIsSelected();
    }

    public void addOrReplaceSessionTree(GraphicalTree graphicalTree) {
        this.topPanel.addOrReplaceSessionTree(graphicalTree);
    }

    public void clearConsole() {
        this.bottomPanel.clearConsole();
    }

    public String getConsoleString() {
        return this.bottomPanel.getConsoleString();
    }

    public void openDividerIfClosed() {
        if (this.getDividerLocation() + 100 > SomeUsefullStuff.HEIGHT_OF_APPLICATION) {
            this.setDividerLocation(SomeUsefullStuff.HEIGHT_OF_APPLICATION - 200);
        }
    }

    public void printConsoleln(String string, int n) {
        this.openDividerIfClosed();
        this.bottomPanel.printConsoleln(string, n);
    }

    public TreeOptions getTreeOptions() {
        return this.topPanel.getTreeOptions();
    }

    public void setUpSquareTreeSliders() {
        this.topPanel.setUpSquareTreeSliders();
    }

    public void setUpCircleTreeSliders() {
        this.topPanel.setUpCircleTreeSliders();
    }

    public boolean getDisplayLeafNodes() {
        return this.ptrToWrappingFrame.getDisplayLeafNodes();
    }

    public boolean getDisplayInternalNodes() {
        return this.ptrToWrappingFrame.getDisplayInternalNodes();
    }

    public boolean getDisplayLeafLabels() {
        return this.ptrToWrappingFrame.getDisplayLeafLabels();
    }

    public boolean getDisplayRootNode() {
        return this.ptrToWrappingFrame.getDisplayRootNode();
    }

    public boolean getDisplayBootstrapValues() {
        return this.ptrToWrappingFrame.getDisplayBootstrapValues();
    }

    public boolean getDisplayEdgeLabels() {
        return this.ptrToWrappingFrame.getDisplayEdgeLabels();
    }

    public boolean getHighlightClusterRoots() {
        return this.ptrToWrappingFrame.getHighlightClusterRoots();
    }

    public boolean getHighlightCladCenterLeaves() {
        return this.ptrToWrappingFrame.getHighlightCladCenterLeaves();
    }

    public boolean getDisplayClusterRootBootstrap() {
        return this.ptrToWrappingFrame.getDisplayClusterRootBootstrap();
    }

    public boolean getShowCOT() {
        return this.ptrToWrappingFrame.getShowCOT();
    }

    public void resetCOT() {
        this.ptrToWrappingFrame.setCOTSelected(false);
        this.topPanel.getTheTree().resetCOT();
    }

    public void setTheTree(GraphicalTree graphicalTree) {
        this.topPanel.setTheTree(graphicalTree);
    }

    public TreePane getTreePane() {
        return this.topPanel.getTreePane();
    }

    public GraphicalTree getTheTree() {
        if (this.topPanel.getTheTree() != null) {
            return this.topPanel.getTheTree();
        }
        return null;
    }

    public boolean getIsCircleTree() {
        return this.topPanel.getIsCircleTree();
    }

    public boolean getIsSquareTree() {
        return this.topPanel.getIsSquareTree();
    }

    public void rePaintTree() {
        this.getTreePane().setMaxDiameterOfGraphicTree();
        if (this.getIsCircleTree()) {
            this.getTreePane().setPreferredSize(new Dimension(this.getTreePane().getMaxDiameterOfGraphicTree(), this.getTreePane().getMaxDiameterOfGraphicTree()));
        } else {
            this.getTreePane().setMaxHeightOfGraphicTree();
            this.getTreePane().setPreferredSize(new Dimension(this.getTreePane().getMaxDiameterOfGraphicTree() + GraphicalTree.SPACE_FROM_EDGE_OF_GRAPH * 3, this.getTreePane().getMaxHeightOfGraphicTree() + GraphicalTree.SPACE_FROM_TOP_OF_GRAPH));
        }
        this.ptrToWrappingFrame.refreshContainer();
        this.getTreePane().repaint();
    }
}

