/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.CentralLayoutWindow;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import tree.GraphicalTree;
import utils.SomeUsefullStuff;

public class ScaleBarPanel
extends JPanel
implements ActionListener {
    private LinkedList treesInThisSession;
    private int treeIndex;
    private JLabel label;
    private JTextField text;
    private JRadioButton nextTree;
    private JRadioButton previousTree;
    private CentralLayoutWindow centralLayoutWindow;

    public ScaleBarPanel(CentralLayoutWindow centralLayoutWindow) {
        super(new GridLayout(1, 4));
        this.centralLayoutWindow = centralLayoutWindow;
        this.setBorder(SomeUsefullStuff.getJPaneBorders(5));
        this.treesInThisSession = new LinkedList();
        this.treeIndex = 0;
        this.previousTree = new JRadioButton(new ImageIcon(ClassLoader.getSystemResource("images/previousTree_1.gif")), false);
        this.previousTree.setPressedIcon(new ImageIcon(ClassLoader.getSystemResource("images/previousTree_2.gif")));
        this.previousTree.setDisabledIcon(new ImageIcon(ClassLoader.getSystemResource("images/previousTree_3.gif")));
        this.previousTree.setEnabled(false);
        this.previousTree.setToolTipText("Previous Tree");
        this.previousTree.setHorizontalAlignment(11);
        this.previousTree.setOpaque(false);
        this.previousTree.setPreferredSize(new Dimension(22, 8));
        this.previousTree.setBorder(null);
        this.previousTree.addActionListener(this);
        this.add(this.previousTree);
        this.nextTree = new JRadioButton(new ImageIcon(ClassLoader.getSystemResource("images/nextTree_1.gif")), false);
        this.nextTree.setPressedIcon(new ImageIcon(ClassLoader.getSystemResource("images/nextTree_2.gif")));
        this.nextTree.setDisabledIcon(new ImageIcon(ClassLoader.getSystemResource("images/nextTree_3.gif")));
        this.nextTree.setEnabled(false);
        this.nextTree.setToolTipText("Next Tree");
        this.nextTree.setHorizontalAlignment(0);
        this.nextTree.setOpaque(false);
        this.nextTree.setPreferredSize(new Dimension(22, 8));
        this.nextTree.addActionListener(this);
        this.nextTree.setBorder(null);
        this.add(this.nextTree);
        JLabel jLabel = new JLabel("Scale ");
        jLabel.setFont(new Font("Ariel", 1, 12));
        jLabel.setHorizontalAlignment(4);
        this.add(jLabel);
        this.text = new JTextField();
        this.text.setFont(new Font("Ariel", 0, 11));
        this.text.addActionListener(this);
        this.add(this.text);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.text && this.centralLayoutWindow.getTheTree() != null) {
            try {
                Double d = new Double(this.text.getText());
                this.centralLayoutWindow.getTreePane().setScale(d);
            }
            catch (Exception exception) {
                this.centralLayoutWindow.getTreePane().setScale(0.0);
            }
        } else if (object == this.nextTree) {
            this.showNextTree();
        } else if (object == this.previousTree) {
            this.showPreviousTree();
        }
        if (this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.rePaintTree();
        }
    }

    public void addOrReplaceSessionTree(GraphicalTree graphicalTree) {
        boolean bl = this.treesInThisSession.contains(graphicalTree);
        if (!bl) {
            this.treesInThisSession.add(graphicalTree);
        }
        this.treeIndex = this.treesInThisSession.indexOf(graphicalTree);
        if (this.treesInThisSession.size() > 0) {
            this.previousTree.setEnabled(true);
        }
    }

    private void showPreviousTree() {
        if (this.treeIndex > 0) {
            this.centralLayoutWindow.setTheTree((GraphicalTree)this.treesInThisSession.get(--this.treeIndex));
            this.nextTree.setEnabled(true);
            if (this.treeIndex == 0) {
                this.previousTree.setEnabled(false);
            }
        }
    }

    private void showNextTree() {
        if (this.treeIndex < this.treesInThisSession.size() - 1) {
            this.centralLayoutWindow.setTheTree((GraphicalTree)this.treesInThisSession.get(++this.treeIndex));
            this.previousTree.setEnabled(true);
            if (this.treeIndex == this.treesInThisSession.size() - 1) {
                this.nextTree.setEnabled(false);
            }
        }
    }
}

