/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.CentralLayoutWindow;
import gui.SearchPanel;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tree.Vertex;
import utils.SomeUsefullStuff;

public class SearchButtons
extends JPanel
implements ActionListener {
    private JRadioButton colLab;
    private JRadioButton clearButton;
    private CentralLayoutWindow centralLayoutWindow;
    private SearchPanel searchPanel;

    public SearchButtons(CentralLayoutWindow centralLayoutWindow, SearchPanel searchPanel) {
        this.centralLayoutWindow = centralLayoutWindow;
        this.searchPanel = searchPanel;
        this.setLayout(new GridLayout(1, 2));
        this.setBorder(SomeUsefullStuff.getJPaneBorders(5));
        this.colLab = new JRadioButton(new ImageIcon(ClassLoader.getSystemResource("images/colorSearch_1.gif")));
        this.colLab.setPressedIcon(new ImageIcon(ClassLoader.getSystemResource("images/colorSearch_2.gif")));
        this.colLab.setDisabledIcon(new ImageIcon(ClassLoader.getSystemResource("images/colorSearch_3.gif")));
        this.colLab.setToolTipText("Color search results");
        this.colLab.addActionListener(this);
        this.add(this.colLab);
        this.clearButton = new JRadioButton(new ImageIcon(ClassLoader.getSystemResource("images/erase_1.gif")));
        this.clearButton.setPressedIcon(new ImageIcon(ClassLoader.getSystemResource("images/erase_2.gif")));
        this.clearButton.setDisabledIcon(new ImageIcon(ClassLoader.getSystemResource("images/erase_3.gif")));
        this.clearButton.setToolTipText("Clear search results");
        this.clearButton.addActionListener(this);
        this.add(this.clearButton);
        this.setEnabled(false);
    }

    public void setEnabled(boolean bl) {
        this.colLab.setEnabled(bl);
        this.clearButton.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.colLab && this.centralLayoutWindow.getTheTree() != null) {
            Serializable serializable;
            LinkedList linkedList = this.centralLayoutWindow.getTheTree().getRoot().getLeafList();
            boolean bl = false;
            for (int i = 0; i < linkedList.size(); ++i) {
                serializable = (Vertex)linkedList.get(i);
                if (!((Vertex)serializable).getExplicitHighlight()) continue;
                bl = true;
                i = linkedList.size();
            }
            if (bl) {
                JColorChooser jColorChooser = new JColorChooser();
                serializable = JColorChooser.showDialog(this, "Choose Color", new Color(0, 0, 0));
                if (serializable != null) {
                    for (int i = 0; i < linkedList.size(); ++i) {
                        Vertex vertex = (Vertex)linkedList.get(i);
                        if (!vertex.getExplicitHighlight()) continue;
                        vertex.setColor(((Color)serializable).getRed(), ((Color)serializable).getGreen(), ((Color)serializable).getBlue());
                        vertex.setExplicitHighlight(false);
                    }
                }
            }
        } else if (object == this.clearButton && this.centralLayoutWindow.getTheTree() != null) {
            LinkedList linkedList = this.centralLayoutWindow.getTheTree().getRoot().getLeafList();
            for (int i = 0; i < linkedList.size(); ++i) {
                Vertex vertex = (Vertex)linkedList.get(i);
                vertex.setExplicitHighlight(false);
            }
            this.searchPanel.setText("Search Tree");
        }
        this.setEnabled(false);
        if (this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.rePaintTree();
        }
    }
}

