/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.CentralLayoutWindow;
import gui.SearchButtons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import tree.Vertex;
import utils.SomeUsefullStuff;

public class SearchPanel
extends JPanel
implements ActionListener {
    private JButton searchButton;
    private JButton colorButton;
    private JRadioButton colLab;
    SearchButtons searchButtons;
    private JTextField text;
    private CentralLayoutWindow centralLayoutWindow;

    public SearchPanel(CentralLayoutWindow centralLayoutWindow) {
        this.centralLayoutWindow = centralLayoutWindow;
        this.setLayout(new BorderLayout());
        this.setBorder(SomeUsefullStuff.getJPaneBorders(5));
        this.text = new JTextField(20);
        this.text.setText("Search Tree");
        this.text.setToolTipText("Comma delimited terms");
        this.text.setFont(new Font("Ariel", 0, 10));
        this.text.addActionListener(this);
        this.add((Component)this.text, "Center");
        this.searchButtons = new SearchButtons(this.centralLayoutWindow, this);
        this.add((Component)this.searchButtons, "East");
    }

    public void setText(String string) {
        this.text.setText("Search");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.text && this.centralLayoutWindow.getTheTree() != null) {
            String string = this.text.getText().trim();
            String[] stringArray = string.split(" ");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
            LinkedList linkedList = this.centralLayoutWindow.getTheTree().getRoot().getLeafList();
            int n = 0;
            for (int i = 0; i < linkedList.size(); ++i) {
                Vertex vertex = (Vertex)linkedList.get(i);
                boolean bl = true;
                for (int j = 0; j < stringArray.length; ++j) {
                    if (vertex.isSubstringInTitle(stringArray[j])) continue;
                    bl = false;
                }
                if (bl) {
                    vertex.setExplicitHighlight(true);
                    ++n;
                    continue;
                }
                vertex.setExplicitHighlight(false);
            }
            if (n == 1) {
                this.searchButtons.setEnabled(true);
                this.centralLayoutWindow.printConsoleln(n + " match found.", SomeUsefullStuff.CONSOLE_TREE);
            } else if (n > 1) {
                this.searchButtons.setEnabled(true);
                this.centralLayoutWindow.printConsoleln(n + " matches found.", SomeUsefullStuff.CONSOLE_TREE);
            } else {
                this.centralLayoutWindow.printConsoleln("No matches found.", SomeUsefullStuff.CONSOLE_TREE);
            }
        }
        if (this.centralLayoutWindow.getTheTree() != null) {
            this.centralLayoutWindow.rePaintTree();
        }
    }
}

