/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.CentralLayoutWindow;
import gui.OptionSlider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Slider
extends JPanel
implements ChangeListener {
    private JSlider slider;
    private CentralLayoutWindow centralLayoutWindow;
    private int whichSlider;
    private int currentState;
    private JTextField textField;

    public Slider(int n, int n2, int n3, int n4, CentralLayoutWindow centralLayoutWindow, int n5) {
        this.setLayout(new BorderLayout());
        this.setBorder(null);
        this.centralLayoutWindow = centralLayoutWindow;
        this.whichSlider = n;
        this.slider = new JSlider(0, n3, n2, n4);
        this.slider.setPaintTicks(false);
        this.slider.addChangeListener(this);
        this.slider.setPreferredSize(new Dimension(n5, 21));
        this.add((Component)this.slider, "West");
        this.currentState = n4;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.slider) {
            if (this.whichSlider == OptionSlider.CIRCLE_TREE_MAG) {
                if (this.centralLayoutWindow.getTheTree() != null) {
                    this.centralLayoutWindow.getTheTree().setCircleTreeMagnification(this.centralLayoutWindow.getTheTree().findBestCircleTreeMagnification(this.slider.getValue()));
                    this.centralLayoutWindow.rePaintTree();
                }
            } else if (this.whichSlider == OptionSlider.ROTATOR_SLIDER) {
                if (this.centralLayoutWindow.getTheTree() != null) {
                    int n = this.slider.getValue();
                    double d = (double)n * (Math.PI / 180);
                    this.centralLayoutWindow.getTheTree().setCircularStartAngle(d);
                    this.centralLayoutWindow.rePaintTree();
                }
            } else if (this.whichSlider == OptionSlider.MAG_Y_SLIDER) {
                if (this.centralLayoutWindow.getTheTree() != null) {
                    double d = Math.abs(this.currentState - this.slider.getValue());
                    if (this.slider.getValue() >= this.currentState) {
                        this.centralLayoutWindow.getTheTree().setYExpansion(this.centralLayoutWindow.getTheTree().getYExpansion() + d);
                    } else {
                        this.centralLayoutWindow.getTheTree().setYExpansion(this.centralLayoutWindow.getTheTree().getYExpansion() - d);
                    }
                    int n = this.centralLayoutWindow.getTheTree().findBestSquareTreeFontSize();
                    this.centralLayoutWindow.getTheTree().setSquareTreeFontSize(n);
                    this.centralLayoutWindow.getTreePane().setFont(this.centralLayoutWindow.getTheTree().getSquareTreeFont());
                    this.currentState = this.slider.getValue();
                    this.centralLayoutWindow.rePaintTree();
                }
            } else if (this.whichSlider == OptionSlider.MAG_X_SLIDER) {
                if (this.centralLayoutWindow.getTheTree() != null) {
                    this.centralLayoutWindow.getTheTree().setXExpansion(this.centralLayoutWindow.getTheTree().findBestXExpansion(this.slider.getValue()));
                    this.centralLayoutWindow.rePaintTree();
                }
            } else if (this.whichSlider == OptionSlider.SPACE_OTPIMIZER_SLIDER && this.centralLayoutWindow.getTheTree() != null) {
                int n = this.slider.getValue();
                double d = (double)n * (Math.PI / 180);
                this.centralLayoutWindow.getTheTree().setExtraManualOptimizerSpace(d);
                this.centralLayoutWindow.rePaintTree();
            }
        }
    }

    public int getMySliderStateValue() {
        return this.slider.getValue();
    }
}

