/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import gui.CentralLayoutWindow;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileOutputStream;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import tree.GraphicalTree;
import tree.Vertex;
import utils.SomeUsefullStuff;

public class TreePane
extends JPanel
implements MouseListener {
    private GraphicalTree theTree;
    private CentralLayoutWindow centralLayoutWindow;
    private int maxDiameterOfGraphicTree;
    private int maxHeightOfGraphicTree;
    private Font font;
    private double scale = 0.0;

    public TreePane(CentralLayoutWindow centralLayoutWindow) {
        this.setBorder(SomeUsefullStuff.getJPaneBorders(1));
        this.theTree = null;
        this.centralLayoutWindow = centralLayoutWindow;
        this.setBackground(Color.white);
        this.addMouseListener(this);
    }

    public int getMaxDiameterOfGraphicTree() {
        return this.maxDiameterOfGraphicTree;
    }

    public void setMaxDiameterOfGraphicTree() {
        if (this.theTree != null) {
            double d = 0.0;
            d = this.centralLayoutWindow.getIsCircleTree() ? (this.theTree.getMaxDistanceFromRoot() + this.theTree.getSecondMaxDistanceFromRoot()) * this.theTree.getCircleTreeMagnification() : this.theTree.getMaxDistanceFromRoot() * this.theTree.getXExpansion();
            this.maxDiameterOfGraphicTree = (int)d;
        }
    }

    public int getMaxHeightOfGraphicTree() {
        return this.maxHeightOfGraphicTree;
    }

    public void setMaxHeightOfGraphicTree() {
        if (this.theTree != null) {
            this.maxHeightOfGraphicTree = (int)((double)GraphicalTree.INITIAL_TREE_HEIGHT_SIZE * this.theTree.getYExpansion());
        }
    }

    public void setTheTree(GraphicalTree graphicalTree) {
        this.theTree = graphicalTree;
        if (this.centralLayoutWindow.getIsCircleTree()) {
            this.setFont(this.theTree.getCircleTreeFont());
        } else if (this.centralLayoutWindow.getIsSquareTree()) {
            this.setFont(this.theTree.getSquareTreeFont());
        }
        this.repaint();
    }

    public GraphicalTree getTheTree() {
        if (this.theTree != null) {
            return this.theTree;
        }
        return null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Vertex vertex;
        if (this.theTree != null && (vertex = this.theTree.getVertexWithCoordinates(this.theTree.getRoot(), mouseEvent.getX(), mouseEvent.getY())) != null && mouseEvent.getX() + this.theTree.getVertexDiameter() / 2 >= vertex.getX() && mouseEvent.getX() - this.theTree.getVertexDiameter() / 2 <= vertex.getX() && mouseEvent.getY() + this.theTree.getVertexDiameter() / 2 >= vertex.getY() && mouseEvent.getY() - this.theTree.getVertexDiameter() / 2 <= vertex.getY()) {
            if (this.centralLayoutWindow.getTreeOptions().getSwapSiblings()) {
                vertex.swapOrderOfChildrenRandomly();
                this.theTree.setCurrentVertexPtr(null);
                this.centralLayoutWindow.addOrReplaceSessionTree(this.theTree);
            } else if (this.centralLayoutWindow.getTreeOptions().getPickCenterPoint()) {
                this.theTree.reRootTree(vertex);
                this.centralLayoutWindow.addOrReplaceSessionTree(this.theTree);
            } else if (this.centralLayoutWindow.getTreeOptions().getColorTree()) {
                JColorChooser jColorChooser = new JColorChooser();
                Color color = JColorChooser.showDialog(this, "Choose Color", vertex.getColor());
                if (color != null) {
                    vertex.setColorOnVertexAndAllDecendents(color);
                    this.theTree.setCurrentVertexPtr(null);
                    this.centralLayoutWindow.addOrReplaceSessionTree(this.theTree);
                }
            } else if (this.centralLayoutWindow.getTreeOptions().getPickManualCluster()) {
                if (vertex.getNoOfChildren() > 0 && !vertex.getIsTheRoot()) {
                    JColorChooser jColorChooser = new JColorChooser();
                    Color color = JColorChooser.showDialog(this, "Choose Color", vertex.getColor());
                    if (color != null) {
                        vertex.setColorOnVertexAndAllDecendents(color);
                        this.theTree.addManualCluster(vertex, color);
                        this.theTree.setCurrentVertexPtr(null);
                        this.centralLayoutWindow.addOrReplaceSessionTree(this.theTree);
                    }
                }
            } else if (this.centralLayoutWindow.getTreeOptions().getRemoveStrain()) {
                if (vertex.getNoOfChildren() == 0) {
                    this.theTree.removeLeafStrain(vertex);
                    this.centralLayoutWindow.addOrReplaceSessionTree(this.theTree);
                    this.centralLayoutWindow.resetCOT();
                }
            } else if (this.centralLayoutWindow.getTreeOptions().getRemoveGroupOfStrains()) {
                if (!vertex.getIsTheRoot()) {
                    this.theTree.removeStrainAndAllDescendents(vertex);
                    this.centralLayoutWindow.addOrReplaceSessionTree(this.theTree);
                    this.centralLayoutWindow.resetCOT();
                }
            } else if (this.centralLayoutWindow.getTreeOptions().getRemoveClusterDataStructure()) {
                if (vertex.getIsClusterRoot()) {
                    this.theTree.getRidOfClusterDataStructure(vertex);
                    this.centralLayoutWindow.addOrReplaceSessionTree(this.theTree);
                }
            } else if (this.centralLayoutWindow.getTreeOptions().getIsPointer()) {
                if (vertex.getHideExplicitLabel()) {
                    vertex.setHideExplicitLabel(false);
                    this.centralLayoutWindow.addOrReplaceSessionTree(this.theTree);
                } else {
                    vertex.setHideExplicitLabel(true);
                    this.centralLayoutWindow.addOrReplaceSessionTree(this.theTree);
                }
            }
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.theTree != null) {
            this.setMaxDiameterOfGraphicTree();
            if (this.centralLayoutWindow.getIsSquareTree()) {
                this.setMaxHeightOfGraphicTree();
            }
            if (this.centralLayoutWindow.getIsCircleTree()) {
                this.theTree.setVertexCoordinatesCircular(this.getWidth() / 2, this.getHeight() / 2);
            } else {
                this.theTree.setSquareCoordsInitialize();
            }
            this.displayTree(graphics);
            this.displayScaleBar(graphics);
        }
    }

    public void setFont(Font font) {
        if (this.theTree != null) {
            this.font = font;
            super.setFont(font);
        }
    }

    private void displayTree(Graphics graphics) {
        Vertex vertex = this.theTree.getRoot();
        if (vertex.getIsCot() && this.centralLayoutWindow.getShowCOT()) {
            graphics.setColor(Color.green);
            graphics.fillOval(vertex.getX(), vertex.getY(), this.theTree.getVertexDiameter() + 4, this.theTree.getVertexDiameter() + 4);
        }
        if (this.centralLayoutWindow.getDisplayRootNode()) {
            graphics.setColor(Color.red);
            graphics.fillOval(vertex.getX(), vertex.getY(), this.theTree.getVertexDiameter() + 2, this.theTree.getVertexDiameter() + 2);
        }
        graphics.setColor(Color.black);
        this.displayNodes(vertex, graphics);
        if (!this.centralLayoutWindow.getIsCircleTree()) {
            Object[] objectArray = vertex.getChildren().toArray();
            for (int i = 0; i != objectArray.length; ++i) {
                Vertex vertex2 = (Vertex)objectArray[i];
                graphics.drawLine(vertex.getX(), vertex.getY(), vertex.getX(), vertex2.getY());
            }
        }
        this.displayScaleBar(graphics);
    }

    public void setScale(double d) {
        this.scale = d;
    }

    private void displayScaleBar(Graphics graphics) {
        int n = (int)Math.floor(this.getMaxDiameterOfGraphicTree());
        double d = this.theTree.getMaxDistanceFromRoot() + this.theTree.getSecondMaxDistanceFromRoot();
        int n2 = this.theTree.getRoot().getX();
        if (this.scale == 0.0) {
            int n3 = n2 + n / 10;
            graphics.drawLine(n2, 16, n3, 16);
            graphics.drawString(SomeUsefullStuff.tidyDouble(d / 10.0, 5) + "", (n2 - 10 + n3) / 2, 32);
        } else {
            int n4 = 0;
            n4 = this.centralLayoutWindow.getIsCircleTree() ? (int)Math.floor((double)n2 + this.scale * this.theTree.getCircleTreeMagnification()) : (int)Math.floor((double)n2 + this.scale * this.theTree.getXExpansion());
            graphics.drawLine(n2, 16, n4, 16);
            graphics.drawString(this.scale + "", (n2 - 10 + n4) / 2, 32);
        }
    }

    private void displayNodes(Vertex vertex, Graphics graphics) {
        Object[] objectArray = vertex.getChildren().toArray();
        for (int i = 0; i != objectArray.length; ++i) {
            Vertex vertex2 = (Vertex)objectArray[i];
            if (this.centralLayoutWindow.getDisplayLeafLabels() && !vertex2.getHideExplicitLabel() && vertex2.getNoOfChildren() == 0) {
                if (this.centralLayoutWindow.getIsCircleTree()) {
                    boolean bl = false;
                    int n = vertex2.getX() + (int)(Math.cos(vertex2.getChildAngle()) * 100.0);
                    if (n < vertex2.getX()) {
                        bl = true;
                    }
                    if (vertex2.getClusterIndex() != 0) {
                        if (bl) {
                            graphics.drawString(vertex2.getTitle() + " (" + vertex2.getClusterIndex() + ")", vertex2.getX() - vertex2.getTitle().length() * 6, vertex2.getY());
                        } else {
                            graphics.drawString(vertex2.getTitle() + " (" + vertex2.getClusterIndex() + ")", vertex2.getX(), vertex2.getY());
                        }
                    } else if (bl) {
                        graphics.drawString(vertex2.getTitle(), vertex2.getX() - vertex2.getTitle().length() * 6, vertex2.getY());
                    } else {
                        graphics.drawString(vertex2.getTitle(), vertex2.getX(), vertex2.getY());
                    }
                } else if (this.centralLayoutWindow.getIsSquareTree()) {
                    if (vertex2.getClusterIndex() != 0) {
                        graphics.drawString(vertex2.getTitle() + " (" + vertex2.getClusterIndex() + ")", vertex2.getX() + 6, vertex2.getY() + 4);
                    } else {
                        graphics.drawString(vertex2.getTitle(), vertex2.getX() + 6, vertex2.getY() + 4);
                    }
                }
            }
            if (this.centralLayoutWindow.getDisplayLeafNodes() && vertex2.getNoOfChildren() == 0) {
                graphics.setColor(vertex2.getColor());
                graphics.fillOval(vertex2.getX() - this.theTree.getVertexDiameter() / 2, vertex2.getY() - this.theTree.getVertexDiameter() / 2, this.theTree.getVertexDiameter(), this.theTree.getVertexDiameter());
            }
            if (vertex2.getIsCot() && this.centralLayoutWindow.getShowCOT()) {
                graphics.setColor(Color.green);
                graphics.fillOval(vertex2.getX() - this.theTree.getVertexDiameter() / 2, vertex2.getY() - this.theTree.getVertexDiameter() / 2, this.theTree.getVertexDiameter() + 4, this.theTree.getVertexDiameter() + 4);
                graphics.setColor(vertex2.getColor());
            }
            if (vertex2.getNoOfChildren() == 0 && vertex2.getExplicitHighlight()) {
                graphics.setColor(Color.red);
                graphics.drawOval(vertex2.getX() - this.theTree.getVertexDiameter() / 2, vertex2.getY() - this.theTree.getVertexDiameter() / 2, this.theTree.getVertexDiameter() + 4, this.theTree.getVertexDiameter() + 4);
                graphics.setColor(vertex2.getColor());
            }
            if (vertex2.getIsClusterParentLeaf() && this.centralLayoutWindow.getHighlightCladCenterLeaves()) {
                graphics.setColor(vertex2.getColor());
                graphics.drawOval(vertex2.getX() - 5, vertex2.getY() - 5, this.theTree.getVertexDiameter() / 2 + 6, this.theTree.getVertexDiameter() / 2 + 6);
            }
            if (this.centralLayoutWindow.getDisplayInternalNodes() && vertex2.getNoOfChildren() > 0) {
                graphics.setColor(vertex2.getColor());
                graphics.fillOval(vertex2.getX() - this.theTree.getVertexDiameter() / 2, vertex2.getY() - this.theTree.getVertexDiameter() / 2, this.theTree.getVertexDiameter(), this.theTree.getVertexDiameter());
            }
            if (vertex2.getIsClusterRoot() && this.centralLayoutWindow.getHighlightClusterRoots()) {
                graphics.setColor(vertex2.getColor());
                graphics.drawOval(vertex2.getX() - 5, vertex2.getY() - 5, this.theTree.getVertexDiameter() / 2 + 6, this.theTree.getVertexDiameter() / 2 + 6);
            }
            graphics.setColor(vertex2.getColor());
            if (this.centralLayoutWindow.getIsCircleTree()) {
                graphics.drawLine(vertex2.getX(), vertex2.getY(), vertex2.getPtrToParent().getX(), vertex2.getPtrToParent().getY());
            } else if (this.centralLayoutWindow.getIsSquareTree()) {
                graphics.drawLine(vertex2.getX(), vertex2.getLeftY(), vertex2.getX(), vertex2.getRightY());
                graphics.drawLine(vertex2.getX(), vertex2.getY(), vertex2.getPtrToParent().getX(), vertex2.getY());
            }
            graphics.setColor(Color.black);
            if (this.centralLayoutWindow.getDisplayEdgeLabels()) {
                if (this.centralLayoutWindow.getIsCircleTree()) {
                    graphics.drawString("" + vertex2.getDistanceFromParent(), vertex2.getXPointBetweenHereAndParent(), vertex2.getYPointBetweenHereAndParent());
                } else if (this.centralLayoutWindow.getIsSquareTree()) {
                    graphics.drawString("" + vertex2.getDistanceFromParent(), vertex2.getX() - (int)((double)(vertex2.getX() - vertex2.getPtrToParent().getX()) / 1.2), vertex2.getY() - 1);
                }
            }
            graphics.setColor(Color.black);
            if (this.centralLayoutWindow.getDisplayBootstrapValues() && vertex2.getBootstrapValue() != 0) {
                graphics.drawString("" + vertex2.getBootstrapValue(), vertex2.getX() + 5, vertex2.getY());
            }
            if (vertex2.getIsClusterRoot() && this.centralLayoutWindow.getDisplayClusterRootBootstrap() && vertex2.getBootstrapValue() != 0) {
                graphics.drawString("" + vertex2.getBootstrapValue(), vertex2.getX() + 5, vertex2.getY());
            }
            if (vertex2.getNoOfChildren() <= 0) continue;
            this.displayNodes(vertex2, graphics);
        }
    }

    public int getWidthOfTreePane() {
        return this.getWidth();
    }

    public int getHeightOfTreePane() {
        return this.getHeight();
    }

    public void makePDF(String string) {
        System.out.println(this.getHeight() + " " + this.getWidth());
        Document document = new Document(new Rectangle(this.getWidth(), this.getHeight()));
        try {
            PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(string));
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            Graphics2D graphics2D = pdfContentByte.createGraphics(this.getWidth(), this.getHeight());
            if (this.theTree != null) {
                if (this.centralLayoutWindow.getIsCircleTree()) {
                    this.setMaxDiameterOfGraphicTree();
                    this.theTree.setVertexCoordinatesCircular(this.theTree.getRoot().getX(), this.theTree.getRoot().getY());
                } else if (this.centralLayoutWindow.getIsSquareTree()) {
                    this.theTree.setSquareCoordsInitialize();
                }
                this.displayTree(graphics2D);
                this.displayScaleBar(graphics2D);
            }
            graphics2D.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        document.close();
    }
}

