/*
 * Decompiled with CFR 0.152.
 */
package tree;

import java.io.Serializable;
import java.util.LinkedList;
import tree.GraphicalTree;
import tree.Tree;
import tree.Vertex;

public class Cluster
implements Serializable {
    private LinkedList vertexList = null;
    private Vertex clusterRoot;
    private Tree tree;

    public Cluster(Tree tree) {
        this.tree = tree;
        this.vertexList = new LinkedList();
        this.clusterRoot = null;
    }

    public Cluster(GraphicalTree graphicalTree) {
        this.tree = graphicalTree;
        this.vertexList = new LinkedList();
        this.clusterRoot = null;
    }

    public void setClusterRoot(Vertex vertex) {
        if (this.clusterRoot != null) {
            this.clusterRoot.setIsClusterRoot(false);
        }
        this.clusterRoot = vertex;
        this.clusterRoot.setIsClusterRoot(true);
    }

    public int getBootstrapOfRoot() {
        return this.getClusterRoot().getBootstrapValue();
    }

    public Vertex getClusterRoot() {
        return this.clusterRoot;
    }

    public boolean getIsClusterRoot(Vertex vertex) {
        return vertex == this.clusterRoot;
    }

    public void addVertex(Vertex vertex) {
        this.vertexList.add(vertex);
    }

    public void setCenterLeaf(Vertex vertex) {
        Vertex vertex2 = this.getClusterCenterLeaf();
        if (vertex2 != null) {
            vertex2.setIsClusterCenterLeaf(false);
        }
        this.vertexList.remove(vertex);
        this.vertexList.addFirst(vertex);
        vertex.setIsClusterCenterLeaf(true);
    }

    public void removeVertex(Vertex vertex) {
        this.vertexList.remove(vertex);
    }

    public void setClusterRoot() {
        for (int i = 0; i < this.vertexList.size(); ++i) {
            if (this.vertexList.get(i) == this.tree.getRoot()) {
                this.clusterRoot = this.tree.getRoot();
                continue;
            }
            if (this.isCenterLeafWithinThisCluster((Vertex)this.vertexList.get(i))) continue;
            this.clusterRoot = (Vertex)this.vertexList.get(i);
        }
        this.clusterRoot.setIsClusterRoot(true);
    }

    public Vertex getNewManualCenterLeaf() {
        LinkedList linkedList = this.getClusterLeaves();
        LinkedList linkedList2 = this.getClusterLeaves();
        double d = 0.0;
        Vertex vertex = null;
        for (int i = 0; i < linkedList.size(); ++i) {
            Vertex vertex2 = (Vertex)linkedList.get(i);
            double d2 = 0.0;
            for (int j = 0; j < linkedList2.size(); ++j) {
                Vertex vertex3 = (Vertex)linkedList2.get(j);
                if (vertex2 == vertex3) continue;
                d2 += Tree.getDistanceBetweenTwoVertices(vertex2, vertex3);
            }
            double d3 = d2 / (double)linkedList2.size();
            if (i == 0) {
                d = d3;
                vertex = vertex2;
                continue;
            }
            if (!(d3 < d)) continue;
            d = d3;
            vertex = vertex2;
        }
        return vertex;
    }

    public boolean containsVertex(Vertex vertex) {
        for (int i = 0; i < this.vertexList.size(); ++i) {
            Vertex vertex2 = (Vertex)this.vertexList.get(i);
            if (vertex2 != vertex) continue;
            return true;
        }
        return false;
    }

    private boolean isCenterLeafWithinThisCluster(Vertex vertex) {
        for (int i = 0; i < this.vertexList.size(); ++i) {
            if (this.vertexList.get(i) != vertex.getPtrToParent()) continue;
            return true;
        }
        return false;
    }

    public LinkedList getClusterMembers() {
        if (this.vertexList.size() > 0) {
            return this.vertexList;
        }
        return null;
    }

    public LinkedList getClusterLeaves() {
        LinkedList<Vertex> linkedList = new LinkedList<Vertex>();
        for (int i = 0; i < this.vertexList.size(); ++i) {
            Vertex vertex = (Vertex)this.vertexList.get(i);
            if (vertex.getNoOfChildren() != 0) continue;
            linkedList.add(vertex);
        }
        return linkedList;
    }

    public int getNoOfClusterLeaves() {
        LinkedList<Vertex> linkedList = new LinkedList<Vertex>();
        for (int i = 0; i < this.vertexList.size(); ++i) {
            Vertex vertex = (Vertex)this.vertexList.get(i);
            if (vertex.getNoOfChildren() != 0) continue;
            linkedList.add(vertex);
        }
        return linkedList.size();
    }

    public Vertex getVertex(int n) {
        if (this.vertexList.size() > 0) {
            return (Vertex)this.vertexList.get(n);
        }
        return null;
    }

    public Vertex getClusterCenterLeaf() {
        for (int i = 0; i < this.vertexList.size(); ++i) {
            Vertex vertex = (Vertex)this.vertexList.get(i);
            if (!vertex.getIsClusterParentLeaf()) continue;
            return vertex;
        }
        return null;
    }

    public int getSize() {
        if (this.vertexList.size() > 0) {
            return this.vertexList.size();
        }
        return 0;
    }

    public double getClusterRadius() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.vertexList.size(); ++i) {
            d = Tree.getDistanceBetweenTwoVertices((Vertex)this.vertexList.get(0), (Vertex)this.vertexList.get(i));
            if (!(d2 < d)) continue;
            d2 = d;
        }
        return d2;
    }

    public double getIntraPairwiseDistance() {
        if (this.vertexList.size() > 0) {
            LinkedList linkedList = this.getClusterLeaves();
            double d = 0.0;
            double d2 = 0.0;
            int n = 0;
            for (int i = 0; i < linkedList.size(); ++i) {
                for (int j = i + 1; j < linkedList.size(); ++j) {
                    d += Tree.getDistanceBetweenTwoVertices((Vertex)linkedList.get(i), (Vertex)linkedList.get(j));
                    ++n;
                }
            }
            d2 = d / (double)n;
            return d2;
        }
        return 0.0;
    }

    public double getAverageDistanceFromClusterRoot() {
        if (this.vertexList.size() > 0) {
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < this.vertexList.size(); ++i) {
                d += Tree.getDistanceBetweenTwoVertices((Vertex)this.vertexList.get(i), this.clusterRoot);
            }
            d2 = d / (double)this.vertexList.size();
            return d2;
        }
        return 0.0;
    }
}

