/*
 * Decompiled with CFR 0.152.
 */
package tree;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Random;
import tree.Cluster;
import tree.GraphicalTree;
import tree.Vertex;
import utils.MyStats;
import utils.SomeUsefullStuff;

public class Tree
implements Serializable {
    protected Vertex treeRoot = null;
    protected Vertex currentVertexPtr = null;
    protected static double distanceBetweenTwoVertices;
    protected double maxDistanceFromRoot = 0.0;
    protected double secondMaxDistanceFromRoot = 0.0;
    protected double smallestDistanceFromRoot = 9.999999999999E12;
    protected boolean treeRootSet = false;
    protected double totalTreeLength;
    protected Cluster[] clusters = null;
    private int minimumClusterSize = 2;
    protected double initialMaxClusterRadius;
    private String txtGraph;

    public Tree() {
    }

    public Tree(String string) {
        this.buildTreeFromNewick(string);
        this.setKeyLeafDistancesFromRoot(this.treeRoot);
    }

    public void setUpDistances() {
        this.setKeyLeafDistancesFromRoot(this.treeRoot);
    }

    protected void setRootInitial(Vertex vertex) {
        Vertex vertex2 = this.getRoot();
        if (vertex2 != null) {
            vertex2.setIsTheRoot(false);
        }
        vertex.setIsTheRoot(true);
        this.treeRoot = vertex;
        this.treeRootSet = true;
        this.currentVertexPtr = this.treeRoot;
    }

    public int getMinimumClusterSize() {
        return this.minimumClusterSize;
    }

    public Vertex getVertex(String string) {
        LinkedList linkedList = this.treeRoot.getLeafList();
        for (int i = 0; i < linkedList.size(); ++i) {
            Vertex vertex = (Vertex)linkedList.get(i);
            if (!vertex.getTitle().equals(string)) continue;
            return vertex;
        }
        return null;
    }

    public void resetCOT() {
        LinkedList linkedList = this.getRoot().getDecendentsList();
        linkedList.add(this.getRoot());
        boolean bl = false;
        double d = 0.0;
        Object var5_4 = null;
        for (int i = 0; i < linkedList.size(); ++i) {
            Vertex vertex = (Vertex)linkedList.get(i);
            vertex.setIsCot(false);
        }
    }

    public Vertex getCOT() {
        this.resetCOT();
        LinkedList linkedList = this.getRoot().getDecendentsList();
        linkedList.add(this.getRoot());
        LinkedList linkedList2 = this.getRoot().getLeafList();
        int n = 0;
        double d = 0.0;
        Vertex vertex = null;
        for (int i = 0; i < linkedList.size(); ++i) {
            Vertex vertex2 = (Vertex)linkedList.get(i);
            double d2 = 0.0;
            for (int j = 0; j < linkedList2.size(); ++j) {
                Vertex vertex3 = (Vertex)linkedList.get(j);
                if (vertex2 == vertex3) continue;
                d2 += GraphicalTree.getDistanceBetweenTwoVertices(vertex2, vertex3);
            }
            double d3 = d2 / (double)(linkedList2.size() - 1);
            if (i == 0) {
                d = d3;
                n = i;
                vertex = vertex2;
                continue;
            }
            if (!(d3 < d)) continue;
            d = d3;
            n = i;
            vertex = vertex2;
        }
        vertex.setIsCot(true);
        return vertex;
    }

    public void growRandomTree(int n, double d, double d2) {
        Random random = new Random();
        double d3 = 1.0;
        int n2 = 0;
        this.setRandomTreeRoot();
        boolean bl = false;
        while (n2 < n && !bl) {
            int n3;
            LinkedList linkedList = this.getRoot().getLeafList();
            linkedList.remove(this.getRoot());
            if (linkedList.size() == 0) {
                linkedList.add(this.getRoot());
            }
            LinkedList linkedList2 = new LinkedList();
            int n4 = linkedList.size();
            for (n3 = 0; n3 < n4; ++n3) {
                int n5 = Math.abs(random.nextInt() % linkedList.size());
                linkedList2.add(linkedList.remove(n5));
            }
            bl = true;
            for (n3 = 0; n3 < n4 && n2 < n; ++n3) {
                Vertex vertex = (Vertex)linkedList2.get(n3);
                if (!vertex.getIsExtinct()) {
                    bl = false;
                    double d4 = random.nextDouble();
                    if (d4 < d2) {
                        vertex.setIsExtinct(true);
                    } else {
                        double d5 = random.nextDouble();
                        if (d5 <= d) {
                            double d6;
                            Vertex vertex2 = null;
                            Vertex vertex3 = null;
                            if (vertex.getIsTheRoot()) {
                                if (vertex.getPotentialDistanceToPotentialChild(1) == 0.0) {
                                    d6 = random.nextDouble() % d3 + 1.0E-6;
                                    this.getRoot().setPotentialDistanceToPotentialChild(1, d6);
                                }
                                if (vertex.getPotentialDistanceToPotentialChild(2) == 0.0) {
                                    d6 = random.nextDouble() % d3 + 1.0E-6;
                                    this.getRoot().setPotentialDistanceToPotentialChild(2, d6);
                                }
                                vertex2 = new Vertex("not labled yet", vertex, false, vertex.getPotentialDistanceToPotentialChild(1) / 2.0);
                                vertex3 = new Vertex("not labled yet", vertex, false, vertex.getPotentialDistanceToPotentialChild(2) / 2.0);
                            } else {
                                if (vertex.getPotentialDistanceToPotentialChild(1) == 0.0) {
                                    d6 = random.nextDouble() % d3 + 1.0E-6;
                                    vertex.setPotentialDistanceToPotentialChild(1, d6);
                                }
                                if (vertex.getPotentialDistanceToPotentialChild(2) == 0.0) {
                                    d6 = random.nextDouble() % d3 + 1.0E-6;
                                    vertex.setPotentialDistanceToPotentialChild(2, d6);
                                }
                                vertex2 = new Vertex("not labled yet", vertex, false, vertex.getPotentialDistanceToPotentialChild(1));
                                vertex3 = new Vertex("not labled yet", vertex, false, vertex.getPotentialDistanceToPotentialChild(2));
                            }
                            this.addVertex(vertex2, vertex);
                            this.addVertex(vertex3, vertex);
                        }
                    }
                }
                n2 = this.getRoot().getLeafList().size();
            }
            this.getRoot().setDistanceFromParent(0.0);
        }
        this.generateNewicFormatNodeLables(true);
        this.setKeyLeafDistancesFromRoot(this.getRoot());
    }

    public void getRidOfClusterDataStructure(Vertex vertex) {
        Cluster[] clusterArray;
        int n;
        LinkedList linkedList = vertex.getDecendentsList();
        linkedList.add(vertex);
        if (this.clusters != null) {
            for (n = 0; n < this.clusters.length; ++n) {
                int n2;
                if (!this.clusters[n].getIsClusterRoot(vertex)) continue;
                this.clusters[n] = null;
                clusterArray = new Cluster[this.clusters.length - 1];
                int n3 = 0;
                for (n2 = 0; n2 < this.clusters.length; ++n2) {
                    if (this.clusters[n2] == null) continue;
                    clusterArray[n3++] = this.clusters[n2];
                }
                this.clusters = null;
                this.clusters = new Cluster[clusterArray.length];
                for (n2 = 0; n2 < this.clusters.length; ++n2) {
                    this.clusters[n2] = clusterArray[n2];
                }
            }
        }
        for (n = 0; n < linkedList.size(); ++n) {
            clusterArray = (Cluster[])linkedList.get(n);
            clusterArray.setClusterIndex(0);
            clusterArray.setIsClusterCenterLeaf(false);
            clusterArray.setIsClusterRoot(false);
            clusterArray.setCircleCenter(false);
        }
    }

    public void removeLeafStrain(Vertex vertex) {
        if (vertex.getNoOfChildren() == 0) {
            Cluster[] clusterArray;
            Vertex vertex2 = vertex.getPtrToParent();
            vertex2.removeChild(vertex);
            if (this.clusters != null) {
                for (int i = 0; i < this.clusters.length; ++i) {
                    if (!this.clusters[i].containsVertex(vertex)) continue;
                    if (this.clusters[i].getIsClusterRoot(vertex)) {
                        int n;
                        this.clusters[i].removeVertex(vertex);
                        this.clusters[i] = null;
                        clusterArray = new Cluster[this.clusters.length - 1];
                        int n2 = 0;
                        for (n = 0; n < this.clusters.length; ++n) {
                            if (this.clusters[n] == null) continue;
                            clusterArray[n2++] = this.clusters[n];
                        }
                        this.clusters = null;
                        this.clusters = new Cluster[clusterArray.length];
                        for (n = 0; n < this.clusters.length; ++n) {
                            this.clusters[n] = clusterArray[n];
                        }
                        continue;
                    }
                    this.clusters[i].removeVertex(vertex);
                }
            }
            if (vertex2.getNoOfChildren() == 1 && !vertex2.getIsTheRoot()) {
                Vertex vertex3 = vertex2.getPtrToParent();
                clusterArray = vertex2.getLastChild();
                double d = vertex2.getDistanceFromParent() + clusterArray.getDistanceFromParent();
                clusterArray.setDistanceFromParent(d);
                vertex3.addChild((Vertex)clusterArray);
                vertex3.removeChild(vertex2);
            }
            this.generateNewicFormatNodeLables(false);
        }
    }

    public void removeStrainAndAllDescendents(Vertex vertex) {
        if (!vertex.getIsTheRoot() && vertex.getNoOfChildren() > 1) {
            int n;
            Vertex vertex2 = vertex.getPtrToParent();
            LinkedList linkedList = vertex.getDecendentsList();
            linkedList.add(vertex);
            vertex2.removeChild(vertex);
            if (this.clusters != null) {
                for (n = 0; n < this.clusters.length; ++n) {
                    for (int i = 0; i < linkedList.size(); ++i) {
                        Vertex vertex3 = (Vertex)linkedList.get(i);
                        if (this.clusters[n] == null || !this.clusters[n].containsVertex(vertex3)) continue;
                        if (this.clusters[n].getIsClusterRoot(vertex3)) {
                            int n2;
                            this.clusters[n].removeVertex(vertex3);
                            this.clusters[n] = null;
                            Cluster[] clusterArray = new Cluster[this.clusters.length - 1];
                            int n3 = 0;
                            for (n2 = 0; n2 < this.clusters.length; ++n2) {
                                if (this.clusters[n2] == null) continue;
                                clusterArray[n3++] = this.clusters[n2];
                            }
                            this.clusters = null;
                            this.clusters = new Cluster[clusterArray.length];
                            for (n2 = 0; n2 < this.clusters.length; ++n2) {
                                this.clusters[n2] = clusterArray[n2];
                            }
                            continue;
                        }
                        this.clusters[n].removeVertex(vertex3);
                    }
                }
            }
            for (n = 0; n < linkedList.size(); ++n) {
                Vertex vertex4 = (Vertex)linkedList.get(n);
                vertex4 = null;
            }
            if (vertex2.getNoOfChildren() == 1 && !vertex2.getIsTheRoot()) {
                Vertex vertex5 = vertex2.getPtrToParent();
                Vertex vertex6 = vertex2.getLastChild();
                double d = vertex2.getDistanceFromParent() + vertex6.getDistanceFromParent();
                vertex6.setDistanceFromParent(d);
                vertex5.addChild(vertex6);
                vertex5.removeChild(vertex2);
            }
            this.generateNewicFormatNodeLables(false);
        }
    }

    public String reomoveStrainsFromTree(int n, Random random) {
        int n2;
        LinkedList linkedList = this.getRoot().getLeafList();
        int[] nArray = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            boolean bl;
            int n3 = -1;
            do {
                bl = false;
                n3 = Math.abs(random.nextInt() % linkedList.size());
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != n3) continue;
                    bl = true;
                }
            } while (bl);
            nArray[n2] = n3;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            Vertex vertex = (Vertex)linkedList.get(nArray[n2]);
            this.removeLeafStrain(vertex);
        }
        this.setKeyLeafDistancesFromRoot(this.getRoot());
        return this.getRoot().getTitle();
    }

    public void generateNewicFormatNodeLables(boolean bl) {
        int n;
        LinkedList linkedList = this.getRoot().getLeafList();
        if (bl) {
            for (int i = 0; i < linkedList.size(); ++i) {
                Vertex vertex = (Vertex)linkedList.get(i);
                vertex.setTitle(i + 1 + "");
            }
        }
        LinkedList linkedList2 = this.getRoot().getDecendentsList();
        linkedList2.add(this.getRoot());
        for (n = 0; n < linkedList2.size(); ++n) {
            Vertex vertex = (Vertex)linkedList2.get(n);
            if (vertex.getNoOfChildren() <= 0) continue;
            vertex.setRandomTreeVertexCorrectTitleSet(false);
        }
        n = 1;
        do {
            for (int i = 0; i < linkedList.size(); ++i) {
                Vertex vertex = (Vertex)linkedList.get(i);
                Vertex vertex2 = vertex.getPtrToParent();
                n = this.iterativeNamingMethod(vertex2) ? 1 : 0;
            }
        } while (n == 0);
        this.newickNamingOfRoot();
    }

    protected void newickNamingOfRoot() {
        LinkedList linkedList = this.treeRoot.getChildren();
        String string = "";
        for (int i = 0; i < linkedList.size(); ++i) {
            Vertex vertex = (Vertex)linkedList.get(i);
            String string2 = vertex.getTitle();
            string = string + ", " + string2 + ":" + vertex.getDistanceFromParent();
        }
        string = "(" + string.substring(1).trim();
        string = string + ");";
        this.treeRoot.setTitle(string);
    }

    protected boolean iterativeNamingMethod(Vertex vertex) {
        if (!vertex.getIsTheRoot()) {
            LinkedList linkedList = vertex.getChildren();
            boolean bl = true;
            for (int i = 0; i < linkedList.size(); ++i) {
                Vertex vertex2 = (Vertex)linkedList.get(i);
                if (vertex2.getRandomTreeVertexCorrectTitleSet()) continue;
                bl = false;
                break;
            }
            if (bl) {
                if (!vertex.getRandomTreeVertexCorrectTitleSet()) {
                    String string = "";
                    for (int i = 0; i < linkedList.size(); ++i) {
                        Vertex vertex3 = (Vertex)linkedList.get(i);
                        String string2 = vertex3.getTitle();
                        string = string + ", " + string2 + ":" + vertex3.getDistanceFromParent();
                    }
                    string = "(" + string.substring(1).trim();
                    string = string + ")";
                    vertex.setTitle(string);
                    this.iterativeNamingMethod(vertex.getPtrToParent());
                } else {
                    this.iterativeNamingMethod(vertex.getPtrToParent());
                }
            } else {
                return true;
            }
        }
        return true;
    }

    public void reRootTree(Vertex vertex) {
        Vertex vertex2;
        int n;
        Vertex vertex3 = this.getRoot();
        LinkedList<Vertex> linkedList = new LinkedList<Vertex>();
        for (Vertex vertex4 = vertex; vertex4 != vertex3; vertex4 = vertex4.getPtrToParent()) {
            linkedList.add(vertex4);
        }
        linkedList.add(vertex3);
        double[] dArray = new double[linkedList.size()];
        for (n = 0; n < linkedList.size(); ++n) {
            vertex2 = (Vertex)linkedList.get(n);
            dArray[n] = vertex2.getDistanceFromParent();
        }
        for (n = linkedList.size() - 1; n > 0; --n) {
            vertex2 = (Vertex)linkedList.get(n);
            Vertex vertex5 = (Vertex)linkedList.get(n - 1);
            vertex2.removeChild(vertex5);
            vertex5.addChild(vertex2);
            vertex2.setDistanceFromParent(dArray[n - 1]);
        }
        this.treeRoot = vertex;
        this.treeRoot.setIsTheRoot(true);
        this.treeRoot.setPtrToParent(null);
        this.treeRoot.setDistanceFromParent(0.0);
        this.treeRoot.resetDistanceFromRoot();
        this.treeRootSet = true;
        vertex3.setIsTheRoot(false);
        this.setPointersToParents(this.treeRoot);
        this.reAllocateDistancesFromRoot(this.treeRoot, this.treeRoot);
        this.reSetDescentListsForAllVertices(this.treeRoot);
        this.generateNewicFormatNodeLables(false);
        this.setKeyLeafDistancesFromRoot(this.treeRoot);
    }

    protected void reSetDescentListsForAllVertices(Vertex vertex) {
        LinkedList linkedList = vertex.getChildren();
        for (int i = 0; i < linkedList.size(); ++i) {
            Vertex vertex2 = (Vertex)linkedList.get(i);
            vertex2.setDecendentsList(vertex2);
            if (vertex2.getNoOfChildren() <= 0) continue;
            this.reSetDescentListsForAllVertices(vertex2);
        }
    }

    protected void setPointersToParents(Vertex vertex) {
        LinkedList linkedList = vertex.getChildren();
        for (int i = 0; i < linkedList.size(); ++i) {
            Vertex vertex2 = (Vertex)linkedList.get(i);
            vertex2.setPtrToParent(vertex);
            if (vertex2.getNoOfChildren() <= 0) continue;
            this.setPointersToParents(vertex2);
        }
    }

    protected void reAllocateDistancesFromRoot(Vertex vertex, Vertex vertex2) {
        LinkedList linkedList = vertex.getChildren();
        for (int i = 0; i < linkedList.size(); ++i) {
            Vertex vertex3 = (Vertex)linkedList.get(i);
            vertex3.setDistanceFromRoot(vertex2);
            if (vertex3.getNoOfChildren() <= 0) continue;
            this.reAllocateDistancesFromRoot(vertex3, vertex2);
        }
    }

    protected void resetDistancesFromRootToZerro(Vertex vertex) {
        LinkedList linkedList = vertex.getChildren();
        for (int i = 0; i < linkedList.size(); ++i) {
            Vertex vertex2 = (Vertex)linkedList.get(i);
            vertex2.resetDistanceFromRoot();
            if (vertex2.getNoOfChildren() <= 0) continue;
            this.resetDistancesFromRootToZerro(vertex2);
        }
    }

    public double getMaxDistanceFromRoot() {
        return this.maxDistanceFromRoot;
    }

    public Vertex getRoot() {
        return this.treeRoot;
    }

    public double getSecondMaxDistanceFromRoot() {
        return this.secondMaxDistanceFromRoot;
    }

    public double getSmallestDistanceFromRoot() {
        return this.smallestDistanceFromRoot;
    }

    public void setCurrentVertexPtr(Vertex vertex) {
        this.currentVertexPtr = vertex;
    }

    protected boolean getIsWithinClusterRange(Vertex vertex, Vertex vertex2, double d) {
        distanceBetweenTwoVertices = 0.0;
        if (vertex2.getIsTheRoot()) {
            return vertex.getDistanceFromRoot() <= d;
        }
        if (vertex.getIsTheRoot()) {
            return vertex2.getDistanceFromRoot() <= d;
        }
        if (vertex == vertex2) {
            return true;
        }
        if (Tree.hasDifferentRootLineages(vertex, vertex2)) {
            return vertex.getDistanceFromRoot() + vertex2.getDistanceFromRoot() <= d;
        }
        this.searchForIsWithinClusterRange(vertex, vertex2, d);
        return !(distanceBetweenTwoVertices > d);
    }

    protected boolean searchForIsWithinClusterRange(Vertex vertex, Vertex vertex2, double d) {
        if (vertex == vertex2) {
            return true;
        }
        if (vertex.isDecendent(vertex2)) {
            LinkedList linkedList = vertex.getChildren();
            for (int i = 0; i < linkedList.size(); ++i) {
                Vertex vertex3 = (Vertex)linkedList.get(i);
                if (vertex3 == vertex2) {
                    distanceBetweenTwoVertices += vertex3.getDistanceFromParent();
                    i = linkedList.size();
                    return true;
                }
                if (!vertex3.isDecendent(vertex2)) continue;
                if ((distanceBetweenTwoVertices += vertex3.getDistanceFromParent()) > d) {
                    return true;
                }
                this.searchForIsWithinClusterRange(vertex3, vertex2, d);
            }
        } else {
            if ((distanceBetweenTwoVertices += vertex.getDistanceFromParent()) > d) {
                return true;
            }
            this.searchForIsWithinClusterRange(vertex.getPtrToParent(), vertex2, d);
        }
        return true;
    }

    public LinkedList getUnrepeatedPairwiseDistanceList() {
        LinkedList<Double> linkedList = new LinkedList<Double>();
        LinkedList linkedList2 = this.getRoot().getLeafList();
        for (int i = 0; i < linkedList2.size(); ++i) {
            Vertex vertex = (Vertex)linkedList2.get(i);
            for (int j = i + 1; j < linkedList2.size() - 1; ++j) {
                Vertex vertex2 = (Vertex)linkedList2.get(j);
                linkedList.add(new Double(Tree.getDistanceBetweenTwoVertices(vertex, vertex2)));
            }
        }
        return linkedList;
    }

    public static double getDistanceBetweenTwoVertices(Vertex vertex, Vertex vertex2) {
        distanceBetweenTwoVertices = 0.0;
        if (vertex2.getIsTheRoot()) {
            distanceBetweenTwoVertices = vertex.getDistanceFromRoot();
        } else if (vertex.getIsTheRoot()) {
            distanceBetweenTwoVertices = vertex2.getDistanceFromRoot();
        } else if (vertex == vertex2) {
            distanceBetweenTwoVertices = 0.0;
        } else if (Tree.hasDifferentRootLineages(vertex, vertex2)) {
            distanceBetweenTwoVertices = vertex.getDistanceFromRoot() + vertex2.getDistanceFromRoot();
        } else {
            Tree.searchForDistanceBetweenTwoVertices(vertex, vertex2);
        }
        return distanceBetweenTwoVertices;
    }

    protected static void searchForDistanceBetweenTwoVertices(Vertex vertex, Vertex vertex2) {
        if (vertex != vertex2) {
            if (vertex.isDecendent(vertex2)) {
                LinkedList linkedList = vertex.getChildren();
                Vertex vertex3 = null;
                for (int i = 0; i < linkedList.size(); ++i) {
                    vertex3 = (Vertex)linkedList.get(i);
                    if (vertex3 == vertex2) {
                        distanceBetweenTwoVertices += vertex3.getDistanceFromParent();
                        i = linkedList.size();
                        continue;
                    }
                    if (!vertex3.isDecendent(vertex2)) continue;
                    distanceBetweenTwoVertices += vertex3.getDistanceFromParent();
                    Tree.searchForDistanceBetweenTwoVertices(vertex3, vertex2);
                    i = linkedList.size();
                }
            } else {
                distanceBetweenTwoVertices += vertex.getDistanceFromParent();
                Tree.searchForDistanceBetweenTwoVertices(vertex.getPtrToParent(), vertex2);
            }
        }
    }

    public void saveTree(String string) {
        File file = new File(string);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string, false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Exception = " + fileNotFoundException.getMessage());
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Exception = " + iOException.getMessage());
        }
    }

    public static Tree loadTree(String string) {
        Tree tree = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Exception =" + fileNotFoundException.getMessage());
        }
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            tree = (Tree)objectInputStream.readObject();
        }
        catch (Exception exception) {
            System.out.println("Exception = " + exception.getMessage());
        }
        return tree;
    }

    protected void addVertex(Vertex vertex) {
        if (this.currentVertexPtr != null) {
            this.currentVertexPtr.addChild(vertex);
        }
    }

    public void addVertex(Vertex vertex, Vertex vertex2) {
        if (vertex2 != null) {
            vertex2.addChild(vertex);
        }
    }

    public double getTotalTreeLength() {
        this.totalTreeLength = 0.0;
        this.setTotEdgeLength(this.getRoot());
        return this.totalTreeLength;
    }

    private void setTotEdgeLength(Vertex vertex) {
        Object[] objectArray = vertex.getChildren().toArray();
        for (int i = 0; i != objectArray.length; ++i) {
            Vertex vertex2 = (Vertex)objectArray[i];
            this.totalTreeLength += vertex2.getDistanceFromParent();
            if (vertex2.getNoOfChildren() <= 0) continue;
            this.setTotEdgeLength(vertex2);
        }
    }

    public void setRandomTreeRoot() {
        String string = "0";
        Vertex vertex = new Vertex(string, this.currentVertexPtr, true, 0.0);
        this.setRootInitial(vertex);
        this.treeRootSet = true;
        this.currentVertexPtr = this.treeRoot;
    }

    protected void buildTreeFromNewick(String string) {
        String string2 = string + " ";
        String string3 = "";
        boolean bl = false;
        String string4 = "";
        for (int i = 0; i < string2.length() - 1; ++i) {
            if (string2.charAt(i) == ';') {
                i = string2.length();
                continue;
            }
            if (string2.charAt(i) == '(') {
                Object object;
                int n = i;
                int n2 = 0;
                String string5 = "";
                boolean bl2 = true;
                while (bl2) {
                    if (n < string2.length()) {
                        if (string2.charAt(n) == '(') {
                            ++n2;
                        } else if (string2.charAt(n) == ')') {
                            --n2;
                        }
                        string5 = string5 + string2.charAt(n++);
                    } else {
                        bl2 = false;
                    }
                    if (n2 != 0) continue;
                    bl2 = false;
                }
                if (!this.treeRootSet) {
                    if (string2.indexOf(";") == -1) {
                        string2 = string2 + ";";
                    }
                    object = new Vertex(string2, this.currentVertexPtr, true, 0.0);
                    this.setRootInitial((Vertex)object);
                    this.treeRootSet = true;
                    this.currentVertexPtr = this.treeRoot;
                    continue;
                }
                object = "";
                if (string2.charAt(n) == ':') {
                    boolean bl3 = true;
                    int n3 = n;
                    while (bl3) {
                        if ((string2.charAt(n3) != ')' || string2.charAt(n3) == ',') && string2.charAt(n3) != ':') {
                            object = (String)object + string2.charAt(n3);
                        }
                        if (string2.charAt(++n3) != ')' && string2.charAt(n3) != ',' && string2.charAt(n3) != ';') continue;
                        bl3 = false;
                    }
                }
                if (!string5.equals("")) {
                    Vertex vertex;
                    if (!((String)object).equals("")) {
                        String[] stringArray = new String[2];
                        stringArray = this.parseDistanceAndBootstrapVals((String)object);
                        double d = new Double(stringArray[0]);
                        if (d < 0.0) {
                            d = 0.0;
                        }
                        vertex = new Vertex(string5, this.currentVertexPtr, false, d, new Integer(stringArray[1]));
                    } else {
                        vertex = new Vertex(string5, this.currentVertexPtr, false);
                    }
                    this.addVertex(vertex);
                }
                this.currentVertexPtr = this.currentVertexPtr.getLastChild();
                continue;
            }
            if (string2.charAt(i) == ')') {
                boolean bl4 = true;
                String string6 = "";
                if (string2.charAt(i - 1) != ')') {
                    int n = i - 1;
                    while (string2.charAt(n) != ',' && bl4) {
                        if (string2.charAt(n) == ':' && string2.charAt(n - 1) == ')') {
                            bl4 = false;
                            continue;
                        }
                        string6 = string2.charAt(n--) + "" + string6;
                    }
                } else {
                    bl4 = false;
                }
                if (bl4 && !string6.equals("")) {
                    String[] stringArray = new String[2];
                    stringArray = this.parseVertexNameDistanceForComma(string6);
                    if (!stringArray[1].equals("")) {
                        double d;
                        String[] stringArray2 = new String[2];
                        stringArray2 = this.parseDistanceAndBootstrapVals(stringArray[1]);
                        if (!stringArray2[1].equals("")) {
                            d = new Double(stringArray2[0]);
                            if (d < 0.0) {
                                d = 0.0;
                            }
                            this.addVertex(new Vertex(stringArray[0], this.currentVertexPtr, false, d, new Integer(stringArray2[1])));
                        } else {
                            d = new Double(stringArray[1]);
                            if (d < 0.0) {
                                d = 0.0;
                            }
                            this.addVertex(new Vertex(stringArray[0], this.currentVertexPtr, false, d));
                        }
                    } else {
                        this.addVertex(new Vertex(stringArray[0], this.currentVertexPtr, false));
                    }
                }
                string3 = "";
                string6 = "";
                this.currentVertexPtr = this.currentVertexPtr.getPtrToParent();
                continue;
            }
            if (string2.charAt(i) != ',') {
                string3 = string3 + string2.charAt(i);
                continue;
            }
            String[] stringArray = new String[2];
            stringArray = this.parseVertexNameDistanceForComma(string3);
            if (!stringArray[0].equals("")) {
                if (!stringArray[1].equals("")) {
                    double d;
                    String[] stringArray3 = new String[2];
                    stringArray3 = this.parseDistanceAndBootstrapVals(stringArray[1]);
                    if (!stringArray3[1].equals("")) {
                        d = new Double(stringArray3[0]);
                        if (d < 0.0) {
                            d = 0.0;
                        }
                        this.addVertex(new Vertex(stringArray[0], this.currentVertexPtr, false, d, new Integer(stringArray3[1])));
                    } else {
                        d = new Double(stringArray[1]);
                        if (d < 0.0) {
                            d = 0.0;
                        }
                        this.addVertex(new Vertex(stringArray[0], this.currentVertexPtr, false, d));
                    }
                } else {
                    this.addVertex(new Vertex(stringArray[0], this.currentVertexPtr, false));
                }
            }
            string3 = "";
        }
        this.setCurrentVertexPtr(null);
    }

    protected String[] parseDistanceAndBootstrapVals(String string) {
        String string2 = string;
        String[] stringArray = new String[]{"", ""};
        boolean bl = false;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '[') {
                bl = true;
            }
            if (!bl) {
                stringArray[0] = stringArray[0] + string2.charAt(i);
                continue;
            }
            if (string2.charAt(i) == '[' || string2.charAt(i) == ']') continue;
            stringArray[1] = stringArray[1] + string2.charAt(i);
        }
        if (stringArray[1].trim().equals("")) {
            stringArray[1] = "0";
        }
        return stringArray;
    }

    protected String[] parseVertexNameDistanceForComma(String string) {
        return string.split(":");
    }

    public LinkedList getClusterCenterLeaves() {
        LinkedList<Vertex> linkedList = new LinkedList<Vertex>();
        if (this.clusters != null) {
            for (int i = 0; i < this.clusters.length; ++i) {
                linkedList.add(this.clusters[i].getClusterCenterLeaf());
            }
            return linkedList;
        }
        return null;
    }

    public LinkedList getClusterRoots() {
        LinkedList<Vertex> linkedList = new LinkedList<Vertex>();
        if (this.clusters != null) {
            for (int i = 0; i < this.clusters.length; ++i) {
                linkedList.add(this.clusters[i].getClusterRoot());
            }
            return linkedList;
        }
        return null;
    }

    public Cluster[] getClusters() {
        if (this.clusters != null) {
            return this.clusters;
        }
        return null;
    }

    public Cluster getCluster(Vertex vertex) {
        if (this.clusters != null) {
            for (int i = 0; i != this.clusters.length; ++i) {
                if (this.clusters[i].getClusterCenterLeaf() != vertex) continue;
                return this.clusters[i];
            }
        }
        return null;
    }

    public double getInitialMaxClusterRadius_() {
        return this.initialMaxClusterRadius;
    }

    public double getActualMaxClusterRadius() {
        if (this.clusters != null) {
            return this.clusters[0].getClusterRadius();
        }
        return 0.0;
    }

    public double getInterClusterPairwiseDistance(Vertex vertex) {
        if (this.clusters != null) {
            int n;
            LinkedList linkedList = this.getCluster(vertex).getClusterLeaves();
            LinkedList linkedList2 = new LinkedList();
            for (int i = 0; i < this.clusters.length; ++i) {
                if (this.clusters[i].getClusterCenterLeaf() == vertex || this.clusters[i].getNoOfClusterLeaves() < this.minimumClusterSize) continue;
                LinkedList linkedList3 = this.clusters[i].getClusterLeaves();
                for (n = 0; n < linkedList3.size(); ++n) {
                    linkedList2.add(linkedList3.get(n));
                }
            }
            double d = 0.0;
            for (n = 0; n < linkedList.size(); ++n) {
                for (int i = 0; i < linkedList2.size(); ++i) {
                    d += Tree.getDistanceBetweenTwoVertices((Vertex)linkedList.get(n), (Vertex)linkedList2.get(i));
                }
            }
            return d / (double)(linkedList2.size() * linkedList.size());
        }
        return 0.0;
    }

    private double getInterClusterPairwiseDistance(Vertex vertex, Vertex vertex2) {
        if (this.clusters != null) {
            LinkedList linkedList = this.getCluster(vertex).getClusterLeaves();
            LinkedList linkedList2 = this.getCluster(vertex2).getClusterLeaves();
            double d = 0.0;
            for (int i = 0; i < linkedList.size(); ++i) {
                for (int j = 0; j < linkedList2.size(); ++j) {
                    d += Tree.getDistanceBetweenTwoVertices((Vertex)linkedList.get(i), (Vertex)linkedList2.get(j));
                }
            }
            return d / (double)(linkedList.size() * linkedList2.size());
        }
        return 0.0;
    }

    public double getInterClusterPairwiseDistance() {
        if (this.clusters != null) {
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < this.clusters.length; ++i) {
                for (int j = i + 1; j < this.clusters.length; ++j) {
                    if (this.clusters[i].getNoOfClusterLeaves() < this.minimumClusterSize || this.clusters[j].getNoOfClusterLeaves() < this.minimumClusterSize) continue;
                    d2 += this.getInterClusterPairwiseDistance(this.clusters[i].getClusterCenterLeaf(), this.clusters[j].getClusterCenterLeaf());
                    d += 1.0;
                }
            }
            return d2 / d;
        }
        return 0.0;
    }

    public void addManualCluster(Vertex vertex, Color color) {
        int n;
        int n2;
        int n3;
        int n4 = -1;
        LinkedList linkedList = vertex.getDecendentsList();
        linkedList.add(vertex);
        boolean bl = false;
        if (this.clusters == null) {
            n4 = 0;
        } else {
            int n5;
            for (n5 = 0; n5 < this.clusters.length; ++n5) {
                if (this.clusters[n5].getClusterRoot() != vertex) continue;
                bl = true;
            }
            if (!bl) {
                int n6;
                Serializable serializable;
                n5 = 0;
                n3 = 0;
                n2 = 1;
                for (n = 0; n < this.clusters.length; ++n) {
                    if (!this.clusters[n].containsVertex(vertex)) continue;
                    n5 = 1;
                    n2 = 0;
                    n = this.clusters.length;
                }
                if (n5 == 0) {
                    for (n = 0; n < linkedList.size(); ++n) {
                        serializable = (Vertex)linkedList.get(n);
                        for (n6 = 0; n6 < this.clusters.length; ++n6) {
                            if (serializable != this.clusters[n6].getClusterRoot()) continue;
                            n3 = 1;
                            n2 = 0;
                            n = linkedList.size();
                            n6 = this.clusters.length;
                        }
                    }
                }
                if (n2 != 0) {
                    n4 = this.clusters.length;
                } else if (n5 != 0) {
                    n4 = this.clusters.length;
                    for (n = 0; n < this.clusters.length; ++n) {
                        Vertex vertex2;
                        int n7;
                        if (!this.clusters[n].containsVertex(vertex)) continue;
                        serializable = this.clusters[n].getClusterMembers();
                        for (n7 = 0; n7 < ((LinkedList)serializable).size(); ++n7) {
                            vertex2 = (Vertex)((LinkedList)serializable).get(n7);
                        }
                        for (n7 = 0; n7 < linkedList.size(); ++n7) {
                            vertex2 = (Vertex)linkedList.get(n7);
                            this.clusters[n].removeVertex(vertex2);
                        }
                        LinkedList linkedList2 = this.clusters[n].getClusterMembers();
                        for (int i = 0; i < linkedList2.size(); ++i) {
                            Vertex vertex3 = (Vertex)linkedList2.get(i);
                        }
                        this.clusters[n].setClusterRoot();
                        vertex2 = this.clusters[n].getNewManualCenterLeaf();
                        this.clusters[n].setCenterLeaf(vertex2);
                        n = this.clusters.length;
                    }
                } else if (n3 != 0) {
                    n4 = this.clusters.length;
                    for (n = 0; n < linkedList.size(); ++n) {
                        serializable = (Vertex)linkedList.get(n);
                        for (n6 = 0; n6 < this.clusters.length; ++n6) {
                            if (serializable != this.clusters[n6].getClusterRoot()) continue;
                            this.clusters[n6] = null;
                            --n4;
                        }
                    }
                }
            }
        }
        if (!bl) {
            if (this.clusters == null) {
                this.clusters = new Cluster[1];
                this.clusters[0] = null;
            }
            Cluster[] clusterArray = new Cluster[n4 + 1];
            for (n3 = 0; n3 < clusterArray.length; ++n3) {
                clusterArray[n3] = new Cluster(this);
            }
            n3 = 0;
            for (n2 = 0; n2 < this.clusters.length; ++n2) {
                if (this.clusters[n2] == null) continue;
                clusterArray[n3++] = this.clusters[n2];
            }
            for (n2 = 0; n2 < linkedList.size(); ++n2) {
                Vertex vertex4 = (Vertex)linkedList.get(n2);
                vertex4.setColor(color.getRed(), color.getGreen(), color.getBlue());
                clusterArray[n4].addVertex(vertex4);
                vertex4.setClusterIndex(n4 + 1);
            }
            Vertex vertex5 = clusterArray[n4].getNewManualCenterLeaf();
            clusterArray[n4].setCenterLeaf(vertex5);
            clusterArray[n4].setClusterRoot(vertex);
            this.clusters = null;
            this.clusters = new Cluster[clusterArray.length];
            for (n = 0; n < this.clusters.length; ++n) {
                this.clusters[n] = clusterArray[n];
                clusterArray[n] = null;
            }
            clusterArray = null;
        }
    }

    public void setClustersFast(double d, boolean bl, boolean bl2) {
        int n;
        Serializable serializable;
        int n2;
        double d2 = (this.getMaxDistanceFromRoot() + this.getSecondMaxDistanceFromRoot()) / 100.0;
        this.initialMaxClusterRadius = bl ? d * d2 : d;
        LinkedList linkedList = this.treeRoot.getLeafList();
        LinkedList linkedList2 = this.treeRoot.getLeafList();
        this.clusters = null;
        for (int i = 0; i < linkedList2.size(); ++i) {
            Vertex vertex = (Vertex)linkedList2.get(i);
            vertex.setIsClusterCenterLeaf(false);
            vertex.setClusterIndex(0);
            vertex.setIsClusterRoot(false);
        }
        LinkedList[] linkedListArray = new LinkedList[linkedList.size()];
        for (n2 = 0; n2 < linkedList.size(); ++n2) {
            Vertex vertex = (Vertex)linkedList.get(n2);
            linkedListArray[n2] = new LinkedList();
            linkedListArray[n2].add(vertex);
            for (int i = 0; i < linkedList2.size(); ++i) {
                if (vertex == linkedList2.get(i) || !this.getIsWithinClusterRange((Vertex)linkedList.get(n2), (Vertex)linkedList2.get(i), this.initialMaxClusterRadius)) continue;
                linkedListArray[n2].add(linkedList2.get(i));
            }
        }
        for (n2 = 0; n2 < linkedListArray.length; ++n2) {
            for (int i = n2 + 1; i < linkedListArray.length; ++i) {
                if (linkedListArray[n2].size() >= linkedListArray[i].size()) continue;
                LinkedList linkedList3 = linkedListArray[n2];
                linkedListArray[n2] = linkedListArray[i];
                linkedListArray[i] = linkedList3;
            }
        }
        for (n2 = 0; n2 < linkedListArray.length; ++n2) {
            int n3;
            LinkedList linkedList4 = linkedListArray[n2];
            for (n3 = 0; n3 < linkedList4.size(); ++n3) {
                Vertex vertex = (Vertex)linkedList4.get(n3);
                for (int i = n2 + 1; i < linkedListArray.length; ++i) {
                    serializable = linkedListArray[i];
                    for (n = 0; n < ((LinkedList)serializable).size(); ++n) {
                        Vertex vertex2 = (Vertex)((LinkedList)serializable).get(n);
                        if (vertex2 != vertex) continue;
                        if (n == 0) {
                            for (int j = 0; j < ((LinkedList)serializable).size(); ++j) {
                                ((LinkedList)serializable).remove(j);
                            }
                            n = ((LinkedList)serializable).size();
                            continue;
                        }
                        ((LinkedList)serializable).remove(n);
                    }
                }
            }
            for (n3 = n2 + 1; n3 < linkedListArray.length; ++n3) {
                for (int i = n3 + 1; i < linkedListArray.length; ++i) {
                    if (linkedListArray[n3].size() >= linkedListArray[i].size()) continue;
                    LinkedList linkedList5 = linkedListArray[n3];
                    linkedListArray[n3] = linkedListArray[i];
                    linkedListArray[i] = linkedList5;
                    linkedList5 = null;
                }
            }
        }
        for (n2 = 0; n2 < linkedListArray.length; ++n2) {
            if (linkedListArray[n2].size() <= 2) continue;
            Vertex vertex = this.getCentralLeaf(linkedListArray[n2]);
            Vertex vertex3 = (Vertex)linkedListArray[n2].removeFirst();
            linkedListArray[n2].addLast(vertex3);
            linkedListArray[n2].remove(vertex);
            linkedListArray[n2].addFirst(vertex);
        }
        n2 = 1;
        while (n2 != 0) {
            n2 = 0;
            for (int i = 0; i < linkedListArray.length; ++i) {
                if (linkedListArray[i].size() <= 1) continue;
                int n4 = linkedListArray[i].size();
                for (int j = 1; j < n4; ++j) {
                    if (linkedListArray[i].get(j) == null) continue;
                    double d3 = Tree.getDistanceBetweenTwoVertices((Vertex)linkedListArray[i].get(0), (Vertex)linkedListArray[i].get(j));
                    for (n = 0; n < linkedListArray.length && j < n4; ++n) {
                        double d4;
                        if (linkedListArray[n].size() <= 1 || linkedListArray[n] == linkedListArray[i] || !(d3 > (d4 = Tree.getDistanceBetweenTwoVertices((Vertex)linkedListArray[n].get(0), (Vertex)linkedListArray[i].get(j))))) continue;
                        Vertex vertex = (Vertex)linkedListArray[i].get(j);
                        double d5 = d4;
                        int n5 = n;
                        double d6 = 0.0;
                        for (int k = n; k < linkedListArray.length; ++k) {
                            if (linkedListArray[k].size() <= 0 || !((d6 = Tree.getDistanceBetweenTwoVertices((Vertex)linkedListArray[k].get(0), vertex)) < d5)) continue;
                            d5 = d6;
                            n5 = k;
                        }
                        linkedListArray[n5].add(vertex);
                        Vertex vertex4 = this.getCentralLeaf(linkedListArray[n5]);
                        Vertex vertex5 = (Vertex)linkedListArray[n5].removeFirst();
                        linkedListArray[n5].addLast(vertex5);
                        linkedListArray[n5].remove(vertex4);
                        linkedListArray[n5].addFirst(vertex4);
                        linkedListArray[i].remove(vertex);
                        vertex4 = this.getCentralLeaf(linkedListArray[i]);
                        vertex5 = (Vertex)linkedListArray[i].removeFirst();
                        linkedListArray[i].addLast(vertex5);
                        linkedListArray[i].remove(vertex4);
                        linkedListArray[i].addFirst(vertex4);
                        n2 = 1;
                        n4 = linkedListArray[i].size();
                    }
                }
            }
        }
        int n6 = 0;
        for (int i = 0; i < linkedListArray.length; ++i) {
            if (linkedListArray[i].size() <= 0) continue;
            ++n6;
        }
        this.clusters = new Cluster[n6];
        LinkedList linkedList6 = SomeUsefullStuff.getAvailableColors();
        int n7 = 0;
        Color color = null;
        serializable = new Random();
        for (n = 0; n < linkedListArray.length; ++n) {
            if (linkedListArray[n].size() <= 0) continue;
            if (bl2) {
                color = null;
                color = (Color)linkedList6.get(Math.abs(((Random)serializable).nextInt() % linkedList6.size()));
                linkedList6.remove(color);
            }
            this.clusters[n7] = new Cluster(this);
            for (int i = 0; i < linkedListArray[n].size(); ++i) {
                Vertex vertex = (Vertex)linkedListArray[n].get(i);
                if (bl2) {
                    vertex.setColor(color.getRed(), color.getGreen(), color.getBlue());
                }
                vertex.setClusterIndex(n7 + 1);
                this.clusters[n7].addVertex(vertex);
                if (i != 0) continue;
                this.clusters[n7].setCenterLeaf(vertex);
            }
            this.clusters[n7].setClusterRoot();
            ++n7;
        }
    }

    protected Vertex getCentralLeaf(LinkedList linkedList) {
        double d = 0.0;
        Vertex vertex = null;
        for (int i = 0; i < linkedList.size(); ++i) {
            Vertex vertex2 = (Vertex)linkedList.get(i);
            double d2 = 0.0;
            for (int j = 0; j < linkedList.size(); ++j) {
                Vertex vertex3 = (Vertex)linkedList.get(j);
                if (vertex2 == vertex3) continue;
                d2 += Tree.getDistanceBetweenTwoVertices(vertex2, vertex3);
            }
            double d3 = d2 / (double)linkedList.size();
            if (i == 0) {
                d = d3;
                vertex = vertex2;
                continue;
            }
            if (!(d3 < d)) continue;
            d = d3;
            vertex = vertex2;
        }
        return vertex;
    }

    protected static boolean hasDifferentRootLineages(Vertex vertex, Vertex vertex2) {
        return vertex.getRootLineageParent(vertex) != vertex2.getRootLineageParent(vertex2);
    }

    public double getTreeDiameterBeforeGraphicalMods() {
        if (this.maxDistanceFromRoot == 0.0) {
            return this.secondMaxDistanceFromRoot + this.maxDistanceFromRoot;
        }
        this.setKeyLeafDistancesFromRoot(this.treeRoot);
        return this.secondMaxDistanceFromRoot + this.maxDistanceFromRoot;
    }

    public void setKeyLeafDistancesFromRoot(Vertex vertex) {
        LinkedList linkedList = this.treeRoot.getLeafList();
        for (int i = 0; i != linkedList.size(); ++i) {
            Vertex vertex2 = (Vertex)linkedList.get(i);
            if (this.smallestDistanceFromRoot > vertex2.getDistanceFromRoot()) {
                this.smallestDistanceFromRoot = vertex2.getDistanceFromRoot();
            }
            if (!(this.maxDistanceFromRoot < vertex2.getDistanceFromRoot())) continue;
            this.secondMaxDistanceFromRoot = this.maxDistanceFromRoot;
            this.maxDistanceFromRoot = vertex2.getDistanceFromRoot();
        }
    }

    public String getTextGraph(Vertex vertex, int n) {
        this.txtGraph = "";
        this.getTextGraphString(vertex, n);
        return this.txtGraph;
    }

    private void getTextGraphString(Vertex vertex, int n) {
        Object[] objectArray = vertex.getChildren().toArray();
        for (int i = 0; i != objectArray.length; ++i) {
            Vertex vertex2 = (Vertex)objectArray[i];
            String string = "";
            for (int j = 0; j != n; ++j) {
                string = string + " ";
            }
            this.txtGraph = this.txtGraph + " \n " + string + "|-> " + vertex2.getTitle();
            if (vertex2.getNoOfChildren() <= 0) continue;
            this.getTextGraphString(vertex2, n + 8);
        }
    }

    public int getNumberOfLeaves() {
        return this.treeRoot.getNoOfLeafNodes();
    }

    public int getTotalNumberOfVertices() {
        return this.treeRoot.getNoOfDecendents() + 1;
    }

    public LinkedList getLeavesWithinMinDistanceOfEachOther(double d) {
        double d2 = (this.getMaxDistanceFromRoot() + this.getSecondMaxDistanceFromRoot()) / 100.0;
        double d3 = d * d2;
        LinkedList linkedList = this.getRoot().getLeafList();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        for (int i = 0; i < linkedList.size() - 1; ++i) {
            for (int j = i + 1; j < linkedList.size(); ++j) {
                Vertex vertex;
                Vertex vertex2 = (Vertex)linkedList.get(i);
                double d4 = Tree.getDistanceBetweenTwoVertices(vertex2, vertex = (Vertex)linkedList.get(j));
                if (!(d4 < d3)) continue;
                linkedList2.add(vertex.getTitle());
                linkedList.remove(vertex);
            }
        }
        return linkedList2;
    }

    public double[] getTreeData() {
        int n;
        Cluster[] clusterArray = this.getClusters();
        double[] dArray = new double[3];
        MyStats myStats = new MyStats();
        double d = 0.0;
        double[] dArray2 = new double[clusterArray.length];
        double[] dArray3 = new double[clusterArray.length];
        for (n = 0; n < dArray3.length; ++n) {
            dArray3[n] = 0.0;
            dArray2[n] = 0.0;
        }
        for (n = 0; n < clusterArray.length; ++n) {
            if (clusterArray[n].getNoOfClusterLeaves() >= this.minimumClusterSize) {
                double d2 = this.getInterClusterPairwiseDistance(clusterArray[n].getClusterCenterLeaf());
                double d3 = clusterArray[n].getIntraPairwiseDistance();
                dArray3[n] = d3 / d2;
                dArray2[n] = d3;
                continue;
            }
            d += 1.0;
        }
        double d4 = myStats.getMean(dArray2, d);
        double d5 = this.getInterClusterPairwiseDistance();
        double d6 = d4 / d5;
        double d7 = myStats.getMean(dArray3, d);
        double d8 = myStats.getVariance(dArray3, d);
        dArray[0] = d7;
        dArray[1] = d8;
        dArray[2] = d6;
        return dArray;
    }
}

