/*
 * Decompiled with CFR 0.152.
 */
package tree;

import java.awt.Color;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Random;

public class Vertex
implements Serializable {
    public static int count = 0;
    private String title;
    private Vertex ptrToParent;
    private LinkedList ptrToChildren;
    private LinkedList decendentsList;
    private LinkedList leafList;
    private double distanceFromParent;
    private double potentialDistanceToPotentialChild1;
    private double potentialDistanceToPotentialChild2;
    private int xPos;
    private int yPos;
    private int clusterIndex;
    private double distanceFromRoot;
    private boolean isTheRoot;
    private boolean randomTreeVertexCorrectTitleSet;
    private boolean isExtinct;
    private double childAngle = 0.0;
    private int bootstrapValue;
    private int rColor;
    private int gColor;
    private int bColor;
    private int noOfLeafNodes = 0;
    private boolean circleCenter;
    private boolean isClusterParentLeaf;
    private boolean isClusterRoot;
    private boolean hideExplicitLabel;
    private boolean explicitHighlight;
    private boolean isCot;
    private int leftY;
    private int rightY;

    public Vertex(String string, Vertex vertex, boolean bl) {
        this.title = string;
        this.isExtinct = false;
        this.randomTreeVertexCorrectTitleSet = false;
        this.ptrToParent = vertex;
        this.isTheRoot = bl;
        this.circleCenter = false;
        this.clusterIndex = 0;
        this.hideExplicitLabel = false;
        this.isClusterParentLeaf = false;
        this.isClusterRoot = false;
        this.isCot = false;
        this.explicitHighlight = false;
        this.ptrToChildren = new LinkedList();
        this.distanceFromParent = 50.5;
        this.potentialDistanceToPotentialChild1 = 0.0;
        this.potentialDistanceToPotentialChild2 = 0.0;
        this.bootstrapValue = 0;
        if (this.ptrToParent != null) {
            this.setDistanceFromRoot(this.ptrToParent.getDistanceFromRoot());
        }
        this.decendentsList = new LinkedList();
        this.leafList = new LinkedList();
        this.yPos = 0;
        this.xPos = 0;
        this.rightY = 0;
        this.leftY = 0;
        this.setColor(1, 1, 1);
    }

    public Vertex(String string, Vertex vertex, boolean bl, double d) {
        this.title = string;
        this.isExtinct = false;
        this.randomTreeVertexCorrectTitleSet = false;
        this.ptrToParent = vertex;
        this.isTheRoot = bl;
        this.circleCenter = false;
        this.clusterIndex = 0;
        this.hideExplicitLabel = false;
        this.isClusterParentLeaf = false;
        this.isClusterRoot = false;
        this.isCot = false;
        this.explicitHighlight = false;
        this.ptrToChildren = new LinkedList();
        this.distanceFromParent = d;
        this.potentialDistanceToPotentialChild1 = 0.0;
        this.potentialDistanceToPotentialChild2 = 0.0;
        this.bootstrapValue = 0;
        if (this.ptrToParent != null) {
            this.setDistanceFromRoot(this.ptrToParent.getDistanceFromRoot());
        }
        this.decendentsList = new LinkedList();
        this.leafList = new LinkedList();
        this.yPos = 0;
        this.xPos = 0;
        this.rightY = 0;
        this.leftY = 0;
        this.setColor(1, 1, 1);
    }

    public Vertex(String string, Vertex vertex, boolean bl, double d, int n) {
        this.title = string;
        this.isExtinct = false;
        this.randomTreeVertexCorrectTitleSet = false;
        this.ptrToParent = vertex;
        this.isTheRoot = bl;
        this.circleCenter = false;
        this.clusterIndex = 0;
        this.hideExplicitLabel = false;
        this.isClusterParentLeaf = false;
        this.isClusterRoot = false;
        this.isCot = false;
        this.explicitHighlight = false;
        this.ptrToChildren = new LinkedList();
        this.distanceFromParent = d;
        this.potentialDistanceToPotentialChild1 = 0.0;
        this.potentialDistanceToPotentialChild2 = 0.0;
        this.bootstrapValue = n;
        if (this.ptrToParent != null) {
            this.setDistanceFromRoot(this.ptrToParent.getDistanceFromRoot());
        }
        this.decendentsList = new LinkedList();
        this.leafList = new LinkedList();
        this.yPos = 0;
        this.xPos = 0;
        this.rightY = 0;
        this.leftY = 0;
        this.setColor(1, 1, 1);
    }

    public void setLeftY(int n) {
        this.leftY = n;
    }

    public int getLeftY() {
        return this.leftY;
    }

    public void setRightY(int n) {
        this.rightY = n;
    }

    public int getRightY() {
        return this.rightY;
    }

    public boolean getIsCot() {
        return this.isCot;
    }

    public void setIsCot(boolean bl) {
        this.isCot = bl;
    }

    public boolean getExplicitHighlight() {
        return this.explicitHighlight;
    }

    public void setExplicitHighlight(boolean bl) {
        this.explicitHighlight = bl;
    }

    public void setIsExtinct(boolean bl) {
        this.isExtinct = bl;
    }

    public boolean getIsExtinct() {
        return this.isExtinct;
    }

    public void setPotentialDistanceToPotentialChild(int n, double d) {
        if (n == 1) {
            this.potentialDistanceToPotentialChild1 = d;
        } else {
            this.potentialDistanceToPotentialChild2 = d;
        }
    }

    public double getPotentialDistanceToPotentialChild(int n) {
        if (n == 1) {
            return this.potentialDistanceToPotentialChild1;
        }
        return this.potentialDistanceToPotentialChild2;
    }

    public void setColor(int n, int n2, int n3) {
        this.rColor = n;
        this.gColor = n2;
        this.bColor = n3;
    }

    public boolean getHideExplicitLabel() {
        return this.hideExplicitLabel;
    }

    public void setHideExplicitLabel(boolean bl) {
        this.hideExplicitLabel = bl;
    }

    public void setClusterIndex(int n) {
        this.clusterIndex = n;
    }

    public int getClusterIndex() {
        return this.clusterIndex;
    }

    public void setIsClusterCenterLeaf(boolean bl) {
        this.isClusterParentLeaf = bl;
    }

    public boolean getIsClusterParentLeaf() {
        return this.isClusterParentLeaf;
    }

    public void setIsClusterRoot(boolean bl) {
        this.isClusterRoot = bl;
    }

    public boolean getIsClusterRoot() {
        return this.isClusterRoot;
    }

    public int getBootstrapValue() {
        return this.bootstrapValue;
    }

    public boolean getCircleCenter() {
        return this.circleCenter;
    }

    public void setCircleCenter(boolean bl) {
        this.circleCenter = bl;
    }

    public Color getColor() {
        return new Color(this.rColor, this.gColor, this.bColor);
    }

    public boolean getIsTheRoot() {
        return this.isTheRoot;
    }

    public void setIsTheRoot(boolean bl) {
        this.isTheRoot = bl;
    }

    public Vertex getRootLineageParent(Vertex vertex) {
        Vertex vertex2 = null;
        if (vertex.getPtrToParent().isTheRoot) {
            vertex2 = vertex;
        } else {
            boolean bl = true;
            vertex2 = vertex;
            while (bl) {
                vertex2 = vertex2.getPtrToParent();
                if (!vertex2.getPtrToParent().isTheRoot) continue;
                bl = false;
            }
        }
        return vertex2;
    }

    private void setLeafList(Vertex vertex) {
        LinkedList linkedList = vertex.getChildren();
        for (int i = 0; i != linkedList.size(); ++i) {
            Vertex vertex2 = (Vertex)linkedList.get(i);
            if (vertex2.getNoOfChildren() == 0) {
                this.leafList.add(vertex2);
                continue;
            }
            this.setLeafList(vertex2);
        }
    }

    public int getNoOfLeafNodes() {
        this.leafList = new LinkedList();
        this.setLeafList(this);
        return this.leafList.size();
    }

    public LinkedList getLeafList() {
        this.leafList = new LinkedList();
        this.setLeafList(this);
        return this.leafList;
    }

    public void setDecendentsList(Vertex vertex) {
        LinkedList linkedList = vertex.getChildren();
        for (int i = 0; i < linkedList.size(); ++i) {
            Vertex vertex2 = (Vertex)linkedList.get(i);
            this.decendentsList.add(vertex2);
            if (vertex2.getNoOfChildren() <= 0) continue;
            this.setDecendentsList(vertex2);
        }
    }

    public int getNoOfDecendents() {
        this.decendentsList.clear();
        this.setDecendentsList(this);
        return this.decendentsList.size();
    }

    public LinkedList getDecendentsList() {
        this.decendentsList.clear();
        this.setDecendentsList(this);
        return this.decendentsList;
    }

    public boolean isDecendent(Vertex vertex) {
        LinkedList linkedList = this.getDecendentsList();
        for (int i = 0; i != linkedList.size(); ++i) {
            Vertex vertex2 = (Vertex)linkedList.get(i);
            if (vertex != vertex2) continue;
            return true;
        }
        return false;
    }

    public void setColorOnVertexAndAllDecendents(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        this.setColor(n, n2, n3);
        if (this.getNoOfChildren() > 0) {
            Object[] objectArray = this.getChildren().toArray();
            for (int i = 0; i != objectArray.length; ++i) {
                Vertex vertex = (Vertex)objectArray[i];
                vertex.setColor(n, n2, n3);
                if (vertex.getNoOfChildren() <= 0) continue;
                vertex.setColorOnVertexAndAllDecendents(color);
            }
        }
    }

    public void arrangeChildrenWithMostDescendentsFirst() {
        Object[] objectArray = this.ptrToChildren.toArray();
        for (int i = 0; i != objectArray.length; ++i) {
            Vertex vertex = (Vertex)objectArray[i];
            for (int j = i + 1; j != objectArray.length; ++j) {
                Vertex vertex2 = (Vertex)objectArray[j];
                if (vertex.getNoOfLeafNodes() >= vertex2.getNoOfLeafNodes()) continue;
                Object e = this.ptrToChildren.get(i);
                Object e2 = this.ptrToChildren.get(j);
                this.ptrToChildren.set(i, e2);
                this.ptrToChildren.set(j, e);
            }
        }
    }

    public void swapOrderOfChildrenRandomly() {
        if (this.getNoOfChildren() > 1) {
            Object[] objectArray = this.ptrToChildren.toArray();
            int n = -1;
            int n2 = -1;
            Random random = new Random();
            n = Math.abs(random.nextInt() % this.getNoOfChildren());
            boolean bl = true;
            while (bl) {
                n2 = Math.abs(random.nextInt() % this.getNoOfChildren());
                if (n == n2) continue;
                bl = false;
            }
            Object e = this.ptrToChildren.get(n);
            Object e2 = this.ptrToChildren.get(n2);
            this.ptrToChildren.set(n, e2);
            this.ptrToChildren.set(n2, e);
        }
    }

    public int getXPointBetweenHereAndParent() {
        if (this.ptrToParent != null) {
            return (this.xPos + this.ptrToParent.getX()) / 2;
        }
        return 0;
    }

    public int getYPointBetweenHereAndParent() {
        if (this.ptrToParent != null) {
            return (this.yPos + this.ptrToParent.getY()) / 2;
        }
        return 0;
    }

    public void setDistanceFromRoot(double d) {
        this.distanceFromRoot = this.distanceFromParent + d;
    }

    public void setDistanceFromRoot(Vertex vertex) {
        this.distanceFromRoot = 0.0;
        for (Vertex vertex2 = this; vertex2 != vertex; vertex2 = vertex2.getPtrToParent()) {
            this.distanceFromRoot += vertex2.getDistanceFromParent();
        }
    }

    public boolean isSubstringInTitle(String string) {
        return this.title.indexOf(string) != -1;
    }

    public void resetDistanceFromRoot() {
        this.distanceFromRoot = 0.0;
    }

    public double getDistanceFromRoot() {
        return this.distanceFromRoot;
    }

    public double getDistanceFromParent() {
        return this.distanceFromParent;
    }

    public void setDistanceFromParent(double d) {
        this.distanceFromParent = d;
    }

    public void setPtrToParent(Vertex vertex) {
        this.ptrToParent = vertex;
    }

    public Vertex getPtrToParent() {
        return this.ptrToParent;
    }

    public void addChild(Vertex vertex) {
        this.ptrToChildren.add(vertex);
        vertex.setPtrToParent(this);
    }

    public void removeChild(Vertex vertex) {
        this.ptrToChildren.remove(vertex);
        vertex.setPtrToParent(null);
        vertex.setDistanceFromParent(0.0);
        vertex = null;
    }

    public int getNoOfChildren() {
        return this.ptrToChildren.size();
    }

    public int getNoOfSiblingsNodes() {
        return this.getPtrToParent().getNoOfDecendents() - 1;
    }

    public Vertex getLastChild() {
        return (Vertex)this.ptrToChildren.getLast();
    }

    public LinkedList getChildren() {
        return this.ptrToChildren;
    }

    public int getIndexOfChild(Vertex vertex) {
        return this.ptrToChildren.indexOf(vertex);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
        this.randomTreeVertexCorrectTitleSet = true;
    }

    public boolean getRandomTreeVertexCorrectTitleSet() {
        return this.randomTreeVertexCorrectTitleSet;
    }

    public void setRandomTreeVertexCorrectTitleSet(boolean bl) {
        this.randomTreeVertexCorrectTitleSet = bl;
    }

    public int getX() {
        return this.xPos;
    }

    public int getY() {
        return this.yPos;
    }

    public void setX(int n) {
        this.xPos = n;
    }

    public void setY(int n) {
        this.yPos = n;
    }

    public double getChildAngle() {
        return this.childAngle;
    }

    public void setChildAngle(double d) {
        this.childAngle = d;
    }
}

