/*
 * Decompiled with CFR 0.152.
 */
package utils;

public class MyStats {
    public double getPearsonCorrelation(double[] dArray, double[] dArray2) {
        if (dArray.length == dArray2.length) {
            double d = this.getMean(dArray);
            double d2 = this.getMean(dArray2);
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                d3 += (dArray[i] - d) * (dArray2[i] - d2);
                d4 += Math.pow(dArray[i] - d, 2.0);
                d5 += Math.pow(dArray2[i] - d2, 2.0);
            }
            return d3 / Math.sqrt(d4 * d5);
        }
        System.out.println("arrays of different sizes!");
        return -9.99999999E8;
    }

    public double getPearsonCorrelation(int[] nArray, int[] nArray2) {
        if (nArray.length == nArray2.length) {
            double d = this.getMean(nArray);
            double d2 = this.getMean(nArray2);
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            for (int i = 0; i < nArray.length; ++i) {
                d3 += ((double)nArray[i] - d) * ((double)nArray2[i] - d2);
                d4 += Math.pow((double)nArray[i] - d, 2.0);
                d5 += Math.pow((double)nArray2[i] - d2, 2.0);
            }
            return d3 / Math.sqrt(d4 * d5);
        }
        System.out.println("arrays of different sizes!");
        return -9.99999999E8;
    }

    public double getMean(int[] nArray) {
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += (double)nArray[i];
        }
        return d / (double)nArray.length;
    }

    public double getMean(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d / (double)dArray.length;
    }

    public double getMean(double[] dArray, double d) {
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += dArray[i];
        }
        return d2 / ((double)dArray.length - d);
    }

    public double getSumation(int[] nArray) {
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += (double)nArray[i];
        }
        return d;
    }

    public double getVariance(double[] dArray) {
        double d = this.getMean(dArray);
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += Math.pow(dArray[i] - d, 2.0);
        }
        return d2 / (double)(dArray.length - 1);
    }

    public double getVariance(double[] dArray, double d) {
        double d2 = this.getMean(dArray, d);
        double d3 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == 0.0) continue;
            d3 += Math.pow(dArray[i] - d2, 2.0);
        }
        return d3 / ((double)(dArray.length - 1) - d);
    }

    public double getVariance(int[] nArray) {
        double d = this.getMean(nArray);
        double d2 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d2 += Math.pow((double)nArray[i] - d, 2.0);
        }
        return d2 / (double)(nArray.length - 1);
    }

    public double getConfidenceInterval(double[] dArray, double d) {
        return d * (this.getStandardDeviation(dArray) / Math.sqrt(dArray.length));
    }

    public double getStandardDeviation(double d) {
        return Math.sqrt(d);
    }

    public double getStandardDeviation(int[] nArray) {
        return Math.sqrt(this.getVariance(nArray));
    }

    public double getStandardDeviation(double[] dArray) {
        return Math.sqrt(this.getVariance(dArray));
    }

    public double getStandardDeviation(double[] dArray, double d) {
        return Math.sqrt(this.getVariance(dArray, d));
    }

    public double getStandardError(int[] nArray) {
        return this.getStandardDeviation(nArray) / Math.sqrt(nArray.length);
    }

    public double getStandardError(double[] dArray) {
        return this.getStandardDeviation(dArray) / Math.sqrt(dArray.length);
    }

    public double getStandardError(double[] dArray, double d) {
        return this.getStandardDeviation(dArray, d) / Math.sqrt((double)dArray.length - d);
    }

    public double[] getQuartiles(double[] dArray) {
        double[] dArray2 = new double[3];
        int n = dArray.length / 2 - 1;
        dArray2[1] = (dArray[n] + dArray[n + 1]) / 2.0;
        int n2 = n / 2;
        dArray2[0] = (dArray[n2] + dArray[n2 + 1]) / 2.0;
        int n3 = n + n2 + 1;
        dArray2[2] = (dArray[n3] + dArray[n3 + 1]) / 2.0;
        return dArray2;
    }

    public double[] sortArray(double[] dArray, boolean bl) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = i + 1; j < dArray.length; ++j) {
                double d;
                if (bl) {
                    if (!(dArray[i] > dArray[j])) continue;
                    d = dArray[i];
                    dArray[i] = dArray[j];
                    dArray[j] = d;
                    continue;
                }
                if (!(dArray[i] < dArray[j])) continue;
                d = dArray[i];
                dArray[i] = dArray[j];
                dArray[j] = d;
            }
        }
        return dArray;
    }
}

