#!/usr/perl/bin/perl
#


#	codonanalysis.pl - The program generates codon usage and MORF statisitics for lists of coding sequences.  
#    Copyright (C) 2006  Sanjay Connare
#	email: bhuether@hwi.buffalo.edu

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc.,
#    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.




#
# Documentation Section to describe functions and usage
#
#errorwarning -> a function to display errors and warnings
#ex.
#errorwarning("Couldn't find sequence fuke", "type warning or error")
#
#catchctrlc -> makes sure ctrl-c wasn't pressed by accident asks if want quit
#ex. none	
#
#determineinput -> figures out if single accnu, pdb id, hssp
#			returns a value with data entry
#ex. none
#
#downloadaccnumseq -> downloads the sequence file and tosses the data into a 1x2 arrary
#ex.
#downloadaccnumseq(accesionnumber);
#
#pdbid ->grabs the hssp output from a pdbid and then snags the accsion numbers from the pdb
#ex.
#pdbid(pdbid)
#
#
#checkarraryforduplicates ->does as name implies and returns a non redudant arrary
#ex. checkarraryforduplicates(@arrarytobechecked)
#
#
#outputsequencelist ->outputs the sequences in various lists
#ex outputallsequencelist(@sequencearrary);
#
#
#Variables explained-
#$runname -> the name of the current run, will be used for file output naming
#@mainseqarrary is a 2x1 arrary which contains accesion number, followed by sequence html
#[0][X] = accesion number, [1][X] = sequence data, X = sequence number
#
#
#
#
#
#$morfrun helps with outputs as to if your running normally, or you're running a specific run
#
#multidimesion too confuzing so going with just two main arrarys can add more if needed
#
#@hsspseq variable to hold accesion numbers from hssp output
# 	this is then used in a forloop to download sequences which is put in the mainseqarrary
#@errors -> to store the various errors that occur
#
#translate -> translates dna into amino acid sequence also does output
#
#
# countcodons -> does the number crunching for counting codons, 
#
#
#	The way the output works is that the codons are stored in an arrary
#	then when each frame is proccesed another arrary that is the same length as the codon arrary is used for storing the numbers
#	the output is then called and when it pulls out the codon for that row it pulls out the correspoding number
#	the order of the codons is defined in this function under @codon in two columns
#	the output should be self explanitory
#
# lots of variables for this run are set in the function beggining
#	calcframetotals -> function in countcodons to calculate the total number in a sent frame
# 	ex. $total = calcframetotals(@frameonenumbers)
#
#	processframe -> function in countcodons used to process the actual frame 
#	ex. processframe(1, @framesequence)
# 
#sortcodontable -> this will sort the codon tables using a row number
#	ex. sortcodontable( column#tosort, @frame1, @frame2, @frame3, @frametotal);
#


my $appname = "Codon Analysis App";
my $author = "Sanjay Connare";
my $version = "20050205";

use strict;
use LWP::Simple;
use FileHandle;
STDOUT->autoflush(1);
use locale; #for character case
#use DBI; #to connect to Lukas' database
#use PGPLOT; #to setup graphs and shit

my @errors = ();
print `clear`;
print "
	Codonanalysis.pl - The program generates codon usage and MORF statisitics for lists of coding sequences. 
    Copyright (C) 2006  Sanjay Connare
	email: bhuether\@hwi.buffalo.edu

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
";

#have to define variables here because they are global and need to be used in running sessions
my $runname = "";
my $dir = "";
my $dirchoice = "";
my $outdir = "";
my $fileoutputchoice = "";
my $atgcmode = "";
my $columnsort = "";
my $columnsortupdown = "";
my $swapifbigger = "";
my $sixtyfourcodonlist = "";
my $graphyon = "";


my ($runname, $dir, $dirchoice, $outdir, $fileoutputchoice, $atgcmode, $columnsort, $columsortupdown, $swapifbigger, $sixtyfourcodonlist, $graphyon) = "";
my (%graph1ato,%graph1atr,%graph1gcr,%graph1gco) = ();
my (%graph2ato,%graph2atr,%graph2gcr,%graph2gco) = ();
my (%graph3ato,%graph3atr,%graph3gcr,%graph3gco) = ();
my (%graph4ato,%graph4atr,%graph4gcr,%graph4gco) = ();
#for codons with multiple definitions, need to store definition, codon # and actual data value
#so, key will be codon # cuz thats whats needed for graph and data will be value
my (%graph1atomultidef, %graph2atomultidef,%graph3atomultidef,%graph4atomultidef) = ();
my (%graph1atrmultidef, %graph2atrmultidef,%graph3atrmultidef,%graph4atrmultidef) = ();
my (%graph1gcrmultidef, %graph2gcrmultidef,%graph3gcrmultidef,%graph4gcrmultidef) = ();
my (%graph1gcomultidef, %graph2gcomultidef,%graph3gcomultidef,%graph4gcomultidef) = ();
my ($graphymax, $graph2ymax) = 0;

#also set up graph colors and symbols here
my $atocolor = 2; #red
my $atrcolor = 7; #yellow
my $gcrcolor = 4; #sky-blue11, blue 4 so it shows up on black well
my $gcocolor = 3; #green

my $multidefsym = 5; # "X"
my $atosym = 0;   #hollow plus
my $atrsym = 7;		# triangle
my $gcrsym = 11;	# diamond
my $gcosym = 17;		

#these are used to control some aspects of mainproccesisng so need to be outside a function
my (@sorflist, @sorflistdata, @dorflist, @dorflistdata, @torflist, @torflistdata, @qorflist, @qorflistdata, @porflist, @porflistdata, @horflist, @horflistdata) = ();
my $morfrun = "off";
#this is used to fix the problem with sequences getting fucked up while proccessing
my %masterhash = "";
my $fastalist = 0;




# start session mode, where read settings from file and can run on multiple directories all in one exeuction session
if($ARGV[0] eq "sessionmode"){
	
	printappinfo();
	print "You have entered session mode.\n";
	my $sesopt = sessionmodemenu();
	if($sesopt == 1 ){executesessinfile();}
	elsif($sesopt == 2){createsessionfile();}

	
	sub sessionmodemenu(){
		print "1) Execute a session\n";
		print "2) Create a new sesion\n";
		print "3) Exit\n";
		print "\nPlease select an input type\n>";
		my $choice = <STDIN>;
		chomp($choice);
		if($choice == 1 ){return 1;}
		elsif($choice == 2){return 2;}
		elsif($choice == 3){return 3;}
		else{
			printappinfo();
			errorwarning("Invalid choice selection!  Please try again.", "Warning");
			sleep(1);
			print `clear`;
			sessionmodemenu();
		} #end for menu choice check
	} #end for session mode menu
	
	
	
	sub createsessionfile(){
		# create and setup a session mode file
		print `clear`;
		printappinfo();
		print "You are going to create and setup a session file.\n";
		print "In order to do so, please answer the following questions.\n";
		print "\n\nWhat do you want your session file to be called?\n>";
		my $sessionfilename = <STDIN>;
		chomp($sessionfilename);
		print "What do you want the session to be called?\n>";
		my $sessionlabel = <STDIN>;
		chomp($sessionlabel);
		print "Do you want to store the files for each run in this session in their own directories?\n";
		print "The files will be stored in a directory named $sessionlabel in each run directory\nThe default is yes. (yes/no)\n>";
		my $sessiondirchoice = <STDIN>;
		chomp($sessiondirchoice);
		#puts yes unless specifically says no
		if(!($sessiondirchoice eq "no")){
			$sessiondirchoice = "yes";
		}
		print "Also do you want output results to all be in one file for example\n";
		print "one file for translation, one for sequences, one for codon analysis? (default)\n";
		print "or do you want to have everything in its own indivudal file?\n";
		print "For indivdual files type (without quotes) \"indvidfil\".\nOtherwise press return to assume default choice\n>";
		my $sessionfileoutputchoice = <STDIN>;
		chomp($sessionfileoutputchoice);
		#puts yes unless specifically says yes
		if(!($sessionfileoutputchoice eq "yes")){
			$sessionfileoutputchoice = "no";
		}
	
		
		print "There are two specific modes do you want to have this session run in\n";
		print "AT or GC mode?\nType without quotes \"AT\" for AT mode and \"GC\" for GC mode\n>";
		my $sessionatgcmode = <STDIN>;
		chomp($sessionatgcmode);
		&sescheckmode;

		sub sescheckmode( ){
			if( $sessionatgcmode eq "AT" || $sessionatgcmode eq "GC"){
				#good a mode is set, clear to go
			}
			else{
				print "\n$sessionatgcmode\n";
				print "I did not understand your input please try again...\n";
 				print "Last but not least...do you want to have this session run in\n";
				print "AT or GC mode?\nType without quotes \"AT\" for AT mode and \"GC\" for GC mode\n>";
				$sessionatgcmode = <STDIN>;
				chomp($sessionatgcmode);
				&sescheckmode;
			}
		}
		print "You also have the option to sort codon tables by a certain column in each frame. \n";
		print "Each Number corresponds to the column listed above that it will sort.\n\n";
		print  "                               FRAME 1:        FRAME 2:        FRAME 3:         TOTAL\n";
		print " Codon(A):  Complement(B):  A    B   A+B    A    B   A+B    A    B   A+B    A    B   A+B\n";
		print "    -            -          2    3    4    5     6    7    8     9    10   11    12   13\n";
		print "If you want to have codon tables sorted enter the column number you want to sort by.\n\n";
		print "If you do not want any sorting to be done and just use the default $sessionatgcmode sorted table enter 0\n"; 
		print "This will also affect how your graph will look since graphs are an exact replica of the tables.\nWhat column do you want to sort by?\n>";
		my $sessioncolumnsort = <STDIN>;
		chomp($sessioncolumnsort);

		if( $sessioncolumnsort != 2 &&  $sessioncolumnsort != 3 && $sessioncolumnsort != 4 && $sessioncolumnsort != 5 && $sessioncolumnsort != 6 && $sessioncolumnsort != 7 && $sessioncolumnsort != 8 && 
			$sessioncolumnsort != 9 && $sessioncolumnsort != 10 && $sessioncolumnsort != 11 && $sessioncolumnsort != 12 && $sessioncolumnsort != 13){
			$sessioncolumnsort = 0;
		}
		my $sessioncolumnsortupdown = "";
		if($sessioncolumnsort != 0){
			print "Do you want to sort ascending or descending.\n";
			print "Type without quotes \"asc\" for ascending or \"desc\" for descending.\n";
			print "If you do not type in asc or desc, descending will be the default sort.\n>";
			$sessioncolumnsortupdown = <STDIN>;
			chomp ($sessioncolumnsortupdown);
		}

		#if not asc switch to default
		if(!($sessioncolumnsortupdown eq "asc")){
			$sessioncolumnsortupdown = "desc";
		}
		print "There also is the option to switch codons and their results in frame 1 and the totals\n";
		print "if codon b is greater than codon a.  Do you want this enabled?\n";
		print "Default is no.  Type 1 for yes and 0 for no\n>";
		my $sessionswapifbigger = <STDIN>;
		chomp($sessionswapifbigger);
		#insert default if not 1
		if($sessionswapifbigger != 1){
			$sessionswapifbigger = "off";
		}
		print "There is an option to generate a list of all 64 codons sorted independently of the codon table.\n";
		print "If you have selected individual files they will be generated in their own files.\n";
		print "If not all the results will be saved as $sessionlabel.64codonlist.txt\n";
		print "Would you like to enable this feature for this session, default is no? (yes/no)\n>";
		my $sessionsixtyfourcodonlist = <STDIN>;
		chomp($sessionsixtyfourcodonlist);
		if(!($sessionsixtyfourcodonlist eq "yes")){
			$sessionsixtyfourcodonlist = "no";
		}
		my %sessionsixtyfourlisthash = ();


		print "Would you like to generate graph data for this run, default is yes? (yes/no)\n>";
		my $sessiongraphyon = <STDIN>;
		chomp($sessiongraphyon);
		if($sessiongraphyon eq "no"){
			$sessiongraphyon = 0;
		}else{$sessiongraphyon = 1;}
		
		my @sesdirs = ();
		sessiondirlist();
		sub sessiondirlist() {
			print "Please enter the directories that you want this session to run on using these settings you have defined.\n";
			print "Enter a directory's absolute path, and one directory per line.  Enter withoutquotes \"done\" when you are finished entering all directories\n";
			print "Enter the next directory to be added to the list\n>";
			my $sessiondirlistentry = <STDIN>;
			chomp($sessiondirlistentry);
			if(!($sessiondirlistentry eq "done")){
				push @sesdirs, $sessiondirlistentry;
				&sessiondirlist;
			}
			else{
				 #ok we're done
			}
		}
		print "Creating session file $sessionfilename ....\nPlease wait...";
		open (CSESFILE, ">$sessionfilename");
		print CSESFILE "Session Name \=$sessionlabel\n";
		print CSESFILE "Run Dir choice \=$sessiondirchoice\n";
		print CSESFILE "Output file choice \=$sessionfileoutputchoice\n";
		print CSESFILE "Mode \=$sessionatgcmode\n";
		print CSESFILE "Columnsort \=$sessioncolumnsort\n";
		print CSESFILE "Columnsortascordesc \=$sessioncolumnsortupdown\n";
		print CSESFILE "Swap if bigger \=$sessionswapifbigger\n";
		print CSESFILE "64 Codon List ind of table \=$sessionsixtyfourcodonlist\n";
		print CSESFILE "Graph choice \=$sessiongraphyon\n";
		print CSESFILE "Directories to be run on:\n";
		foreach(@sesdirs){
			print CSESFILE "$_\n";
		}
		print CSESFILE "You can manually add directories here.. just follow format above...DO NOT DELETE THIS LINE!!!\n";
		print CSESFILE "End of Codon Analysis Session Created file\n";
		close CSESFILE;
		print "Would you like to execute this session file? (yes/no).\nIf not the program will exit. The default choice is yes\n>";
		my $exeseschoice = <STDIN>;
		chomp($exeseschoice);
		if(!($exeseschoice eq "no")){
			
			#so start session
		}
		
	} #end of creating session file
	
	
	sub executesessinfile(){
	
	
		#first open the file with the stored session data
		print "What is the name and if applicable full path of the session file?\n";
		my $sesfilenameloc = <STDIN>;
		chomp($sesfilenameloc);
		#so load all variables from file
		
		my @rawsessionfiledata = `cat $sesfilenameloc`;
		my @sessiondata = ();
		my @dirstoproc = ();
		my $dirflag = 0;
		foreach(@rawsessionfiledata){
			if( $_ =~ "="){
				my @splita = split(/=/, $_);
				chomp($splita[1]);
				push @sessiondata, $splita[1];
			}
			elsif($_ =~ "Directories to be run on:"){
				$dirflag = 1;
			}
			elsif($dirflag == 1){
				if($_ =~ "You can manually"){
					$dirflag = 0;
				}
				else{
					chomp($_);
					push @dirstoproc, $_;
				}
			}
		}
		#ok data is all loaded now...
		#init all the variables used in a session
		$runname = $sessiondata[0];
		$dirchoice = $sessiondata[1];
		$fileoutputchoice = $sessiondata[2];
		$atgcmode = $sessiondata[3];
		$columnsort = $sessiondata[4];
		$columnsortupdown = $sessiondata[5];
		$swapifbigger = $sessiondata[6];
		$sixtyfourcodonlist = $sessiondata[7];
		$graphyon = $sessiondata[8];
		
		#do the directories part last because not just one
		foreach(@dirstoproc){
			$dir = $_;
			chomp($dir);
			
			$outdir = $dir . "/" . "$runname";
			
			if(!(-e "$outdir")){
				print "Creating directory $outdir..";
				`mkdir $outdir`;
				print "created\n";
			}
					
			#$outdir = $dir . "/";
			#create all the files in the session directory then move the directory to where it should go yes!
			
			
			#print "$outdir\n";
			#sleep(5);
			#setup and run the rest of the application
			

			 (%graph1ato,%graph1atr,%graph1gcr,%graph1gco) = ();
			 (%graph2ato,%graph2atr,%graph2gcr,%graph2gco) = ();
			 (%graph3ato,%graph3atr,%graph3gcr,%graph3gco) = ();
			 (%graph4ato,%graph4atr,%graph4gcr,%graph4gco) = ();
			#for codons with multiple definitions, need to store definition, codon # and actual data value
			#so, key will be codon # cuz thats whats needed for graph and data will be value
			 (%graph1atomultidef, %graph2atomultidef,%graph3atomultidef,%graph4atomultidef) = ();
			 (%graph1atrmultidef, %graph2atrmultidef,%graph3atrmultidef,%graph4atrmultidef) = ();
			 (%graph1gcrmultidef, %graph2gcrmultidef,%graph3gcrmultidef,%graph4gcrmultidef) = ();
			 (%graph1gcomultidef, %graph2gcomultidef,%graph3gcomultidef,%graph4gcomultidef) = ();
			 ($graphymax, $graph2ymax) = 0;

			#also set up graph colors and symbols here
			 $atocolor = 2; #red
			 $atrcolor = 7; #yellow
			 $gcrcolor = 4; #sky-blue11, blue 4 so it shows up on black well
			 $gcocolor = 3; #green

			 $multidefsym = 5; # "X"
			 $atosym = 0;   #hollow plus
			 $atrsym = 7;		# triangle
			 $gcrsym = 11;	# diamond
			 $gcosym = 17;		

			#these are used to control some aspects of mainproccesisng so need to be outside a function
			 (@sorflist, @sorflistdata, @dorflist, @dorflistdata, @torflist, @torflistdata, @qorflist, @qorflistdata, @porflist, @porflistdata, @horflist, @horflistdata) = ();
			 $morfrun = "off";
			#this is used to fix the problem with sequences getting fucked up while proccessing
			 %masterhash = "";
			 $fastalist = 0;
			 
			my $starttime = `date`;
			my $pdbid = "";
			my $listname = "";
			my $listchoice = "";
			my $singleaccnum = "";
			#catch quits 
			$SIG{INT} = \&catchctrlc;
			print `clear`;
			printappinfo();
			print "Welcome!\n";
			#my $inputchoice = determineput();, already determined
			
			my $listname = "";
			
			#because list name was not enterend manually it should be the direcotry'es name .txt so here goes
			my @getlistname = split(/\//, $dir);
			foreach(@getlistname){ print "$_\n";}
			my $numparts = @getlistname;
			$listname = "$dir" . "/" . $getlistname[$numparts-1] . ".txt";

			
			## because session mode is setup to only work with fasfa list directories here goes
			$fastalist = 1; #so outputting sequnces is easier
			my $filedata = `cat $listname`;
			my @coredata = split(/>/, $filedata);
			#so now all data is split
			my $loopcounter = 1;
			my $total = @coredata;
			my @mainaccnumlist = ();
			my @mainseqdatalist = ();
			foreach(@coredata){
				my @dataparts = split(/~/, $_);
				my @sequence = split(/\n/, $dataparts[1]);
				print "Processing $dataparts[0]-$sequence[0]...$loopcounter / $total\n";
				$loopcounter++;
				push @mainaccnumlist, $dataparts[0];
				shift(@sequence); #remove the first line
				my $finalseq = join(/''/, @sequence);
				push @mainseqdatalist, $finalseq;
					
			}
			

			outputallsequencelist(@mainaccnumlist,@mainseqdatalist );
			translate(@mainaccnumlist,@mainseqdatalist );
	
	
			
			#create empty variables to do sorf, dorf, torf only runs
	  		#helps with mainproccessing function as to how to output files and such
			print "Processing full list...\n";
			mainprocessing(@mainaccnumlist,@mainseqdatalist );
			$fileoutputchoice = 0; #turn this off because we no longer want individual files if it was turned on
			#now this gets a little complicated because there were problems with just pusshing seuqneces into the arrarys
			#so instead of pushing sequence will pull the sequence out from the masterhash and then push it 
	
	
			#clear the previous array to free memory

			$morfrun = "sorf";
			mainprocessing(@sorflist,@sorflistdata ) unless not defined @sorflistdata;
			$morfrun = "dorf";
			mainprocessing(@dorflist,@dorflistdata ) unless not defined @dorflistdata;
			$morfrun = "torf";
			mainprocessing(@torflist,@torflistdata ) unless not defined @torflistdata;
			$morfrun = "qorf";
			mainprocessing(@qorflist,@qorflistdata ) unless not defined @qorflistdata;
			$morfrun = "porf";
			mainprocessing(@porflist,@porflistdata ) unless not defined @porflistdata;
			$morfrun = "horf";
			mainprocessing(@horflist,@horflistdata ) unless not defined @horflistdata;
	
			#now that we are down output the errors into an error log
			open (ERRLOG, ">$outdir$runname.errors.log");
			print ERRLOG "$appname - $version\t\tWritten By: $author\n";
			print ERRLOG "Session Variables:\n\tCodon Analysis in dir ";
			print ERRLOG  `pwd`;
			print ERRLOG "Runname: $runname\tRun Date: ";
			print ERRLOG `date`;
			print ERRLOG "Mode: $atgcmode\tColumn Sort: $columnsort-$columnsortupdown Swap Mode: $swapifbigger\tMORF Run: n/a  Graph: $graphyon\n\n";
			foreach(@errors){
				print ERRLOG "$_\n";
		
			}
			#also now that we are done print run information
	
			open (RUNINF, ">$outdir$runname.sessioninfo.txt");
			print RUNINF "$appname - $version\t\tWritten By: $author\n";
			print RUNINF "Session Variables:\n\tCodon Analysis in dir ";
			print RUNINF  `pwd`;
			print RUNINF "Runname: $runname\tStart Date: $starttime";
			print RUNINF "Finish Date: ";
			print RUNINF `date`;
			print RUNINF "Mode: $atgcmode\tColumn Sort: $columnsort-$columnsortupdown Swap Mode: $swapifbigger\tMORF Run: n/a    Graph: $graphyon\n";
			print RUNINF "Menu Choice: Session Mode using file $sesfilenameloc\tFile list: $listname \tPDB ID: $pdbid\tSingle Acc Num: $singleaccnum Special 64 List: $sixtyfourcodonlist\n";
			my $numorf = @sorflist;
			print RUNINF "Number SORFS: $numorf\n";
			$numorf = @dorflist;
			print RUNINF "Number DORFS: $numorf\n";
			$numorf = @torflist;
			print RUNINF "Number TORFS: $numorf\n";
			$numorf = @qorflist;
			print RUNINF "Number QORFS: $numorf\n";
			$numorf = @porflist;
			print RUNINF "Number PORFS: $numorf\n";
			$numorf = @horflist;
			print RUNINF "Number HORFS: $numorf\n";
			close FILE;
			printappinfo();
			 
			 
			 
		}
		
	
	
	
	
	
	
	
	
	
	
	
	
	
	}# end of executing session file
	# end of everything
	exit;
} # end of check for session mode 

#begin regular mode


printappinfo();

#change this into a function called setup

print "Welcome before we begin you need to setup this session\nYou will be asked some questions.\nFirst what would you like to call this run?\n";
print "Eg. 1HDChssp, 1abcsorflist, etc..\n";
my $runname = <STDIN>;
chomp($runname);
print "Do you want to store the files for this run in a run directory?\n";
print "The directory would be ";
my $dir = `pwd`;
chomp($dir);
print "$dir/$runname\nDefault is yes. (yes/no)\n>";
my $dirchoice = <STDIN>;
my $outdir = $dir . "/";
chomp($dirchoice);
if(!($dirchoice eq "no")){ 
	#go with default unless no was entered
	$dirchoice = "yes";
	$outdir = "$dir/$runname";
	if(!(-e "/$runname")){
		print "Creating directory $outdir..";
		`mkdir $outdir`;
		print "created\n";
	}
	$outdir = "$dir/$runname/";  #for outputting files and such
		
}	

print "Also do you want output results to all be in one file for example\n";
print "one file for translation, one for sequences, one for codon analysis? (default)\n";
print "or do you want to have everything in its own indivudal file?\n";
print "For indivdual files type (without quotes) \"indvidfil\".\nOtherwise press return to assume default choice\n>";
my $fileoutputchoice = <STDIN>;
chomp($fileoutputchoice);
print "There are two specific modes do you want to have this session run in\n";
print "AT or GC mode?\nType without quotes \"AT\" for AT mode and \"GC\" for GC mode\n>";
my $atgcmode = <STDIN>;
chomp($atgcmode);
&checkmode;




sub checkmode( ){
	if( $atgcmode eq "AT" || $atgcmode eq "GC"){
		#good a mode is set, clear to go
	}
	else{
		print "\n$atgcmode\n";
		print "I did not understand your input please try again...\n";
 		print "Last but not least...do you want to have this session run in\n";
		print "AT or GC mode?\nType without quotes \"AT\" for AT mode and \"GC\" for GC mode\n>";
		$atgcmode = <STDIN>;
		chomp($atgcmode);
		&checkmode;
	}
}
print "You also have the option to sort codon tables by a certain column in each frame. \n";
print "Each Number corresponds to the column listed above that it will sort.\n\n";
print  "                               FRAME 1:        FRAME 2:        FRAME 3:         TOTAL\n";
print " Codon(A):  Complement(B):  A    B   A+B    A    B   A+B    A    B   A+B    A    B   A+B\n";
print "    -            -          2    3    4    5     6    7    8     9    10   11    12   13\n";
print "If you want to have codon tables sorted enter the column number you want to sort by.\n\n";
print "If you do not want any sorting to be done and just use the default $atgcmode sorted table enter 0\n"; 
print "This will also affect how your graph will look since graphs are an exact replica of the tables.\nWhat column do you want to sort by?\n>";
my $columnsort = <STDIN>;
chomp($columnsort);

if( $columnsort != 2 &&  $columnsort != 3 && $columnsort != 4 && $columnsort != 5 && $columnsort != 6 && $columnsort != 7 && $columnsort != 8 && 
	$columnsort != 9 && $columnsort != 10 && $columnsort != 11 && $columnsort != 12 && $columnsort != 13){
	$columnsort = 0;
}
my $columnsortupdown = "";
if($columnsort != 0){
	print "Do you want to sort ascending or descending.\n";
	print "Type without quotes \"asc\" for ascending or \"desc\" for descending.\n";
	print "If you do not type in asc or desc, descending will be the default sort.\n>";
	$columnsortupdown = <STDIN>;
	chomp ($columnsortupdown);
}

#if not asc switch to default
if(!($columnsortupdown eq "asc")){
	$columnsortupdown = "desc";
}
print "There also is the option to switch codons and their results in frame 1 and the totals\n";
print "if codon b is greater than codon a.  Do you want this enabled?\n";
print "Default is no.  Type 1 for yes and 0 for no\n>";
my $swapifbigger = <STDIN>;
chomp($swapifbigger);
#insert default if not 1
if($swapifbigger != 1){
	$swapifbigger = "off";
}
print "There is an option to generate a list of all 64 codons sorted independently of the codon table.\n";
print "If you have selected individual files they will be generated in their own files.\n";
print "If not all the results will be saved as $runname.64codonlist.txt\n";
print "Would you like to enable this feature for this session, default is no? (yes/no)\n>";
my $sixtyfourcodonlist = <STDIN>;
chomp($sixtyfourcodonlist);
if(!($sixtyfourcodonlist eq "yes")){
	$sixtyfourcodonlist = "no";
}
my %sixtyfourlisthash = ();


print "Would you like to generate graph data for this run, default is yes? (yes/no)\n>";
my $graphyon = <STDIN>;
chomp($graphyon);
if($graphyon eq "no"){
	$graphyon = 0;
}else{$graphyon = 1;}
#graphdata variables, have to change value to hash to store position # since thrown off with multidefs
my (%graph1ato,%graph1atr,%graph1gcr,%graph1gco) = ();
my (%graph2ato,%graph2atr,%graph2gcr,%graph2gco) = ();
my (%graph3ato,%graph3atr,%graph3gcr,%graph3gco) = ();
my (%graph4ato,%graph4atr,%graph4gcr,%graph4gco) = ();
#for codons with multiple definitions, need to store definition, codon # and actual data value
#so, key will be codon # cuz thats whats needed for graph and data will be value
my (%graph1atomultidef, %graph2atomultidef,%graph3atomultidef,%graph4atomultidef) = ();
my (%graph1atrmultidef, %graph2atrmultidef,%graph3atrmultidef,%graph4atrmultidef) = ();
my (%graph1gcrmultidef, %graph2gcrmultidef,%graph3gcrmultidef,%graph4gcrmultidef) = ();
my (%graph1gcomultidef, %graph2gcomultidef,%graph3gcomultidef,%graph4gcomultidef) = ();
my ($graphymax, $graph2ymax) = 0;

#also set up graph colors and symbols here
my $atocolor = 2; #red
my $atrcolor = 7; #yellow
my $gcrcolor = 4; #sky-blue11, blue 4 so it shows up on black well
my $gcocolor = 3; #green

my $multidefsym = 5; # "X"
my $atosym = 0;   #hollow plus
my $atrsym = 7;		# triangle
my $gcrsym = 11;	# diamond
my $gcosym = 17;		

#these are used to control some aspects of mainproccesisng so need to be outside a function
my (@sorflist, @sorflistdata, @dorflist, @dorflistdata, @torflist, @torflistdata, @qorflist, @qorflistdata, @porflist, @porflistdata, @horflist, @horflistdata) = ();
my $morfrun = "off";
#this is used to fix the problem with sequences getting fucked up while proccessing
my %masterhash = "";
my $fastalist = 0;

&main;


sub main(){
	my $starttime = `date`;
	my $pdbid = "";
	my $listname = "";
	my $listchoice = "";
	my $singleaccnum = "";
	#catch quits 
	$SIG{INT} = \&catchctrlc;
	print `clear`;
	printappinfo();
	print "Welcome!\n";
	my $inputchoice = determineput();
	my @mainaccnumlist = ( );
	my @mainseqdatalist = ();
	if($inputchoice == 1){
		print "What is the accesion number id?\n>";
		$singleaccnum = <STDIN>;
		chomp($singleaccnum);
		my @values = downloadaccnumseq($singleaccnum);
		push @mainaccnumlist,  $values[0] unless not defined $values[1];
		push @mainseqdatalist, $values[1] unless not defined $values[1];
		$masterhash{"$values[0]"} = $values[1] unless not defined $values[1];
		#then perhaps process this data
	
	}
	
	elsif($inputchoice == 2){
		print "What is the PDB ID?\n>";
		$pdbid = <STDIN>;
		chomp($pdbid);
		my @hsspseq = procpdbid($pdbid);
		@hsspseq = checkarraryforduplicates(@hsspseq);
		my $numofac = @hsspseq;
		#now get sequence files
		my $statusnum = 0;
		foreach(@hsspseq){
			$statusnum++;
			print "Processing PDB ID $pdbid - Sequence $statusnum / $numofac\n";
			my @values = downloadaccnumseq($_);
			push @mainaccnumlist,  $values[0] unless not defined $values[1];
			push @mainseqdatalist, $values[1] unless not defined $values[1];
			$masterhash{"$values[0]"} = $values[1] unless not defined $values[1];

		}
	
	}
	
	elsif($inputchoice ==3){
		
		print "Please note that only accession number lists and fasta sequence listsare currently supported.\nThe $appname does not support PDB Lists at the moment.\n";
		print "--List Input Menu--\n";
		print "1) Accesion Number\n";
		print "2) Fasta Sequence List\n";
		print "3) Return to Main Menu\n";
		print "\nPlease select a list type\n>";
		$listchoice = <STDIN>;
		chomp($listchoice);
		if($listchoice == 2 ){
			print "Please enter the list name\n>";
			$listname = <STDIN>;
			chomp($listname);
			if(-e $listname){
				#so the fasta (our version not offical)
				$fastalist = 1; #so outputting sequnces is easier
				my $filedata = `cat $listname`;
				my @coredata = split(/>/, $filedata);
				#so now all data is split
				shift @coredata;
				my $loopcounter = 1;
				my $total = @coredata;
				foreach(@coredata){
					#my @dataparts = split(/~/, $_);
					#my @sequence = split(/\n/, $dataparts[1]);
					#print "Processing $dataparts[0]-$sequence[0]...$loopcounter / $total\n";
					#$loopcounter++;
					#push @mainaccnumlist, $dataparts[0];
					#shift(@sequence); #remove the first line
					#my $finalseq = join(/''/, @sequence);
					#push @mainseqdatalist, $finalseq;
					
					my @dataparts = split(/\n/, $_);
					print "Processing $dataparts[0]-$dataparts[1]...$loopcounter / $total\n";
					$loopcounter++;
					push @mainaccnumlist, $dataparts[0];
					push @mainseqdatalist, $dataparts[1];
				}
			}
		
		
		}
		elsif($listchoice == 1){
		
			print "Please enter the list name\n>";
			$listname = <STDIN>;
			chomp($listname);
			if(-e $listname){
				my @locallistdata = split(/\n/, `cat $listname`);
				my $counter = 0;
				my $max = @locallistdata;
				foreach(@locallistdata){
					$counter++;
					print "Processing local list $listname - Sequence $counter / $max\n";
					my @values = downloadaccnumseq($_);
					push @mainaccnumlist,  $values[0]; #unless not defined $values[1];
					push @mainseqdatalist, $values[1]; #unless not defined $values[1];
					$masterhash{"$values[0]"} = $values[1] unless not defined $values[1];
				}
			}
			else{
				errorwarning("The list file you entered does not exist", "ERROR");
				&main;
			}
		
		
		
		}
		elsif($listchoice == 3){
			print `clear`;
			printappinfo();
			determineput();
		
		}
		else{
			printappinfo();
			errorwarning("Invalid choice selection!  Please try again.", "Warning");
			sleep(1);
			print `clear`;
			determineput();
		}

		
			
	}
	
	#for(my $testloopcv = 0; $testloopcv < @mainaccnumlist; $testloopcv++){
	#	print "$mainaccnumlist[$testloopcv]\n";
	#	print "$mainseqdatalist[$testloopcv]\n";
	#}
	#exit;
	
	outputallsequencelist(@mainaccnumlist,@mainseqdatalist );
	translate(@mainaccnumlist,@mainseqdatalist );
	
	
	#so first do a main proccessing
	#create empty variables to do sorf, dorf, torf only runs
	  #helps with mainproccessing function as to how to output files and such
	print "Processing full list...\n";
	mainprocessing(@mainaccnumlist,@mainseqdatalist );
	$fileoutputchoice = 0; #turn this off because we no longer want individual files if it was turned on
	#now this gets a little complicated because there were problems with just pusshing seuqneces into the arrarys
	#so instead of pushing sequence will pull the sequence out from the masterhash and then push it 
	
	
	#clear the previous array to free memory

	$morfrun = "sorf";
	mainprocessing(@sorflist,@sorflistdata ) unless not defined @sorflistdata;
	$morfrun = "dorf";
	mainprocessing(@dorflist,@dorflistdata ) unless not defined @dorflistdata;
	$morfrun = "torf";
	mainprocessing(@torflist,@torflistdata ) unless not defined @torflistdata;
	$morfrun = "qorf";
	mainprocessing(@qorflist,@qorflistdata ) unless not defined @qorflistdata;
	$morfrun = "porf";
	mainprocessing(@porflist,@porflistdata ) unless not defined @porflistdata;
	$morfrun = "horf";
	mainprocessing(@horflist,@horflistdata ) unless not defined @horflistdata;
	
	#now that we are down output the errors into an error log
	open (ERRLOG, ">$outdir$runname.errors.log");
	print ERRLOG "$appname - $version\t\tWritten By: $author\n";
	print ERRLOG "Session Variables:\n\tCodon Analysis in dir ";
	print ERRLOG  `pwd`;
	print ERRLOG "Runname: $runname\tRun Date: ";
	print ERRLOG `date`;
	print ERRLOG "Mode: $atgcmode\tColumn Sort: $columnsort-$columnsortupdown Swap Mode: $swapifbigger\tMORF Run: n/a  Graph: $graphyon\n\n";
	foreach(@errors){
		print ERRLOG "$_\n";
		
	}
	#also now that we are done print run information
	
	open (RUNINF, ">$outdir$runname.sessioninfo.txt");
	print RUNINF "$appname - $version\t\tWritten By: $author\n";
	print RUNINF "Session Variables:\n\tCodon Analysis in dir ";
	print RUNINF  `pwd`;
	print RUNINF "Runname: $runname\tStart Date: $starttime";
	print RUNINF "Finish Date: ";
	print RUNINF `date`;
	print RUNINF "Mode: $atgcmode\tColumn Sort: $columnsort-$columnsortupdown Swap Mode: $swapifbigger\tMORF Run: n/a    Graph: $graphyon\n";
	print RUNINF "Menu Choice: $inputchoice\tFile list: $listname \tPDB ID: $pdbid\tSingle Acc Num: $singleaccnum Special 64 List: $sixtyfourcodonlist\n";
	my $numorf = @sorflist;
	print RUNINF "Number SORFS: $numorf\n";
	$numorf = @dorflist;
	print RUNINF "Number DORFS: $numorf\n";
	$numorf = @torflist;
	print RUNINF "Number TORFS: $numorf\n";
	$numorf = @qorflist;
	print RUNINF "Number QORFS: $numorf\n";
	$numorf = @porflist;
	print RUNINF "Number PORFS: $numorf\n";
	$numorf = @horflist;
	print RUNINF "Number HORFS: $numorf\n";
	close FILE;
	printappinfo();
	print "Thanks for using this program!\n";

}

sub mainprocessing(){
	
	#need to setup way to take in both arrarys which were went when the function was called
	#so since I do not know how to do it properly and you send two arrarys will do this
	#this is included in the intro to all subfunctions linked from main that send arguments
	my @funcargs = @_;
	my $argtotal = @funcargs;
	my @seqlist = ();
	my @seqdata = ();
	
	for(my $importary = 0; $importary < $argtotal; $importary++){
		
		if( $importary < ($argtotal/2)){
			push @seqlist, $funcargs[$importary];
		}
		else{
			push @seqdata, $funcargs[$importary];
		}
	}
	
	#clear memory up
	@_ = ();
	
	#use this to define order codons are outputted
	my @codon = (); #just to intialize to make perl's xstrict happy
	#this is defined here & later on when proccessing frames  to keep order after multiple runs
	#things got screwy after one main run
	
	if($atgcmode eq "GC"){
		@codon = (	#Codon(A)	#Complement(B)
	
			"TTA",		 "TAA",
			"TAT",		 "ATA",
			"TTT",		 "AAA",
			"AAT",		 "ATT",
			"CTA",		 "TAG",
			"ACT",		 "AGT",
			"TAC",		 "GTA",
			"TCT",		 "AGA",
			"AAG",		 "CTT",
			"TTC",		 "GAA",
			"ACA",		 "TGT",
			"TTG",		 "CAA",
			"AAC",		 "GTT",
			"ATG",		 "CAT",
			"TCA",		 "TGA",
			"ATC",		 "GAT",
			"AGC",		 "GCT",
			"CTG",		 "CAG",
			"TGC",		 "GCA",
			"TCC",		 "GGA",
			"AGG",		 "CCT",
			"GAG",		 "CTC",
			"GTG",		 "CAC",
			"TGG",		 "CCA",
			"ACC",		 "GGT",
			"ACG",		 "CGT",
			"GTC",		 "GAC",
			"TCG",		 "CGA",
			"GGG",		 "CCC",
			"GGC",		 "GCC",
			"CGG",		 "CCG",
			"GCG",		 "CGC"
			);
	}
	elsif($atgcmode eq "AT"){
	
		 @codon = (	      #Codon(A)       #Complement(B)
		    	    
		    	     	     "GGG",	      "CCC",
		    	     	     "GGC",	      "GCC",
		    	     	     "CCG",	      "CGG",
		    	     	     "CTA",	      "TAG",
		    	     	     "GCG",	      "CGC",
		    	     	     "GAG",	      "CTC",
		    	     	     "CCT",	      "AGG",
		    	     	     "GGT",	      "ACC",
		    	     	     "GAC",	      "GTC",
		    	     	     "GTG",	      "CAC",
		    	     	     "CCA",	      "TGG",
		    	     	     "GGA",	      "TCC",
		    	     	     "CGA",	      "TCG",
		    	     	     "CAG",	      "CTG",
		    	     	     "ATG",	      "CAT",
		    	     	     "ATA",	      "TAT",
		    	     	     "GCT",	      "AGC",
		    	     	     "GCA",	      "TGC",
		    	     	     "ACT",	      "AGT",
		    	     	     "GTA",	      "TAC",
		    	     	     "GAT",	      "ATC",
		    	     	     "CGT",	      "ACG",
		    	     	     "TCA",	      "TGA",
		    	     	     "ACA",	      "TGT",
		    	     	     "TTA",	      "TAA",
		    	     	     "AGA",	      "TCT",
		    	     	     "GTT",	      "AAC",
		    	     	     "AAT",	      "ATT",
		    	     	     "CAA",	      "TTG",
		    	     	     "AAG",	      "CTT",
		    	     	     "GAA",	      "TTC",
		 	     	     "AAA",	      "TTT",
			);
	
	}
	#use this to add on proteins after sequence is outputted
	#has nothing to do with actual ordering of output!!
	my %dnaseqtoaa =(
	       TTA => "L",	     TAA=> "*QY",
	       TAT => "Y",	     ATA=> "IM",
	       TTT => "F",	     AAA=> "KN",
	       AAT => "N",	     ATT=> "I",
	       CTA => "LT",	     TAG=> "*QL",
	       ACT => "T",	     AGT=> "S",
	       TAC => "Y",	     GTA=> "V",
	       TCT => "S",	     AGA=> "RSG*",
	       AAG => "K",	     CTT=> "LT",
	       TTC => "F",	     GAA=> "E",
	       ACA => "T",	     TGT=> "C",
	       TTG => "LMf",	     CAA=> "Q",
	       AAC => "N",	     GTT=> "V",
	       ATG => "MMf",	     CAT=> "H",
	       TCA => "S",	     TGA=> "*WCU",
	       ATC => "I",	     GAT=> "D",
	       AGC => "S",	     GCT=> "A",
	       CTG => "LST",	     CAG=> "Q",
	       TGC => "C",	     GCA=> "A",
	       TCC => "S",	     GGA=> "G",
	       AGG => "RSG*",	     CCT=> "P",
	       GAG => "E",	     CTC=> "LT",
	       GTG => "VMf",	     CAC=> "H",
	       TGG => "W",	     CCA=> "P",
	       ACC => "T",	     GGT=> "G",
	       ACG => "T",	     CGT=> "R",
	       GTC => "V",	     GAC=> "D",
	       TCG => "S",	     CGA=> "R",
	       GGG => "G",	     CCC=> "P",
	       GGC => "G",	     GCC=> "A",
	       CGG => "R",	     CCG=> "P",
	       GCG => "A",	     CGC=> "R"
		
	);
	
	# this will for calculating the last 4 sections of the distribtion percetnages
	#at only, at, rich, gc rich, gc only etc...
	my %codondisttype = (
	
	 	TTA => "AT Only",	      TAA=> "AT Only",
                TAT => "AT Only",	      ATA=> "AT Only",
              	TTT => "AT Only",	      AAA=> "AT Only",
              	AAT => "AT Only",	      ATT=> "AT Only",
              	CTA => "AT Rich",	      TAG=> "AT Rich",
              	ACT => "AT Rich",	      AGT=> "AT Rich",
              	TAC => "AT Rich",	      GTA=> "AT Rich",
              	TCT => "AT Rich",	      AGA=> "AT Rich",
              	AAG => "AT Rich",	      CTT=> "AT Rich",
              	TTC => "AT Rich",	      GAA=> "AT Rich",
              	ACA => "AT Rich",	      TGT=> "AT Rich",
              	TTG => "AT Rich",	      CAA=> "AT Rich",
              	AAC => "AT Rich",	      GTT=> "AT Rich",
              	ATG => "AT Rich",	      CAT=> "AT Rich",
              	TCA => "AT Rich",	      TGA=> "AT Rich",
              	ATC => "AT Rich",	      GAT=> "AT Rich",
              	AGC => "GC Rich",	      GCT=> "GC Rich",
              	CTG => "GC Rich",	      CAG=> "GC Rich",
              	TGC => "GC Rich",	      GCA=> "GC Rich",
              	TCC => "GC Rich",	      GGA=> "GC Rich",
              	AGG => "GC Rich",      	      CCT=> "GC Rich",
              	GAG => "GC Rich",             CTC=> "GC Rich",,
              	GTG => "GC Rich",             CAC=> "GC Rich",
              	TGG => "GC Rich",             CCA=> "GC Rich",
              	ACC => "GC Rich",	      GGT=> "GC Rich",
              	ACG => "GC Rich",	      CGT=> "GC Rich",
              	GTC => "GC Rich",	      GAC=> "GC Rich",
              	TCG => "GC Rich",	      CGA=> "GC Rich",
              	GGG => "GC Only",	      CCC=> "GC Only",
		GGC => "GC Only",	      GCC=> "GC Only",
		CGG => "GC Only",	      CCG=> "GC Only",
 		GCG => "GC Only",	      CGC=> "GC Only"
  
	);
	
	
	
	#this default text is stored in an arrary so easier for outputting options
	my @codonsets = ( "1-4", "5-7", "8-10", "11-13", "14-16", "17-19", "20-22", "23-25", "26-28", "29-32" ,"AT only", "AT rich", "GC rich", "GC only");
	my @codonsetpercents = ( "(12.5%)", "( 9.4%)" , "( 9.4%)", "( 9.4%)", "( 9.4%)", "( 9.4%)", "( 9.4%)", "( 9.4%)", "( 9.4%)", "(12.5%)" , "(12.5%)", "(37.5%)", "(37.5%)", "(12.5%)");
	
	
	#one file output
	
	if(!($fileoutputchoice eq "indvidfil")){	
		if($morfrun eq "off"){		
			open (FILE, ">$outdir$runname.codonanalysis.txt");
			
		}
		else{
			print "Processing $morfrun list\n";
			open (FILE, ">$outdir$runname.$morfrun.codonanalysis.txt");
		}
		print FILE "$appname - $version\t\tWritten By: $author\n";
		print FILE "Session Variables:\nCodon Analysis in dir ";
		print FILE  `pwd`;
		print FILE "Runname: $runname\tRun Date: ";
		print FILE `date`;
		print FILE "Mode: $atgcmode\tColumn Sort: $columnsort-$columnsortupdown Swap Mode: $swapifbigger Graph: $graphyon\t";
		if(!($morfrun eq "off")){	
		
			print FILE "MORF Run: $morfrun";
		}
		else{
			print FILE "MORF Run: All";
		
		}
		print FILE "\n\n";
		
	}
	if(!($fileoutputchoice eq "indvidfil") && $sixtyfourcodonlist eq "yes"){	
		if($morfrun eq "off"){		
			open (SFFILE, ">$outdir$runname.64codonlist.txt");
		}
		else{
			print "Processing $morfrun list\n";
			open (SFFILE, ">$outdir$runname.$morfrun.64codonlist.txt");
		}
		print SFFILE "$appname - $version\t\tWritten By: $author\n";
		print SFFILE "Session Variables:\nCodon Analysis in dir ";
		print SFFILE  `pwd`;
		print SFFILE "Runname: $runname\tRun Date: ";
		print SFFILE `date`;
		print SFFILE "Mode: $atgcmode\tColumn Sort: $columnsort-$columnsortupdown Swap Mode: $swapifbigger Graph: $graphyon\t";
		if(!($morfrun eq "off")){	
		
			print SFFILE "MORF Run: $morfrun";
		}
		else{
			print SFFILE "MORF Run: All";
		
		}
		print SFFILE "\n\n";
		
	}
	
	#these variables are used for totals and are thus put outside the main loop for delcreation and int
	
	my @frame1grandtotalcount = ();
	my @frame2grandtotalcount = ();
	my @frame3grandtotalcount = ();
	my $frame1grandtotcodon = "";
	my $frame2grandtotcodon = "";
	my $frame3grandtotcodon = "";
	
	
	
	my @totalstopcodons = ();
	my @totalunusedcodons = ();
	my @totaltotalcodons = ();
	
	
	my @frame1distgtotal = ();
	my @frame2distgtotal = ();
	my @frame3distgtotal = ();
	my @grandtotaltotaldist = ();
	
	my @totalatonly = ();
	my @totalatrich = ();
	my @totalgcrich = ();
	my @totalgconly = ();
	
	my $totaldnastring = "";
	
	
	for(my $lcv =0; $lcv < @seqlist; $lcv++){
		my $max = @seqlist;
		#these next two variables used so when morf is determined
		#appropriate data gets put in appropriate spot
		my $accnum = $seqlist[$lcv];
		my $dnastring = $seqdata[$lcv];
		
		#since now stored in data we can shift them off the master array can we?
		
		if($fileoutputchoice eq "indvidfil"){
			open (FILE, ">$outdir$runname.$seqlist[$lcv].codonanalysis.txt");
			print FILE "$appname - $version\t\tWritten By: $author\n";
			print FILE "Session Variables:\n\tCodon Analysis in dir ";
			print FILE  `pwd`;
			print FILE "Runname: $runname\tRun Date: ";
			print FILE `date`;
			print FILE "Mode: $atgcmode\tColumn Sort: $columnsort-$columnsortupdown Swap Mode: $swapifbigger\tMORF Run: All Graph: $graphyon\n\n";
		
				
			open (SFFILE, ">$outdir$runname.$seqlist[$lcv].64codonlist.txt");
			print SFFILE "$appname - $version\t\tWritten By: $author\n";
			print SFFILE "Session Variables:\nCodon Analysis in dir ";
			print SFFILE  `pwd`;
			print SFFILE "Runname: $runname\tRun Date: ";
			print SFFILE `date`;
			print SFFILE "Mode: $atgcmode\tColumn Sort: $columnsort-$columnsortupdown Swap Mode: $swapifbigger Graph: $graphyon\t";
			if(!($morfrun eq "off")){	
			
				print SFFILE "MORF Run: $morfrun";
			}
			else{
				print SFFILE "MORF Run: All";
			
			}
			
		}
	
	
		print "Starting Codon Analysis for $seqlist[$lcv]...";
		print $lcv+1;
		print " / $max   \n";
		# use these variables to store data
		#
		#$seqdata[$lcv] cotnains main sequence data
		print FILE $lcv +1;
		print FILE "\n\n--$runname-- ";
		print FILE "--Sequence $seqlist[$lcv]\n";
		my @frame1dna = ();
		my @frame1count = ();
		my @frame2dna = ();
		my @frame2count = ();
		my @frame3dna = ();
		my @frame3count = ();
		#my @frame4dna = ();
		#my @frame4count = ();
		#my @frame5dna = ();
		#my @frame5count = ();
		#my @frame6dna = ();
		#my @frame6count = ();
		
		
		my @stopcodons = ();
		my @unusedcodons = ();
		my @totalcodons = ();
		
		my @frame1dist	= ();
		my @frame2dist	= ();
		my @frame3dist	= ();
		my @totaldist = ();

		my @atonly = ();
		my @atrich = ();
		my @gcrich = ();
		my @gconly = ();


		#loop through the list of codon stuff
		#first set up all the frames to be counted so...
		my @frame1dna = split(//, $seqdata[$lcv]);
		my $dnastring = $seqdata[$lcv]; #used for later on at, gc proccessing
		#add this to the total dna string so total base usage can be calculated
		$totaldnastring = $totaldnastring . $seqdata[$lcv];
		my @frame2dna = @frame1dna;
		shift(@frame2dna);
		my @frame3dna = @frame2dna;
		shift(@frame3dna);
		
		
		#this code is not needed so dont use
		#my $reverse = reverse($seqdata[$lcv]);
		#my @chars = split(//, $reverse);
		#my $complimentoferverse = "";
		#foreach(@chars){
		#	if($_ eq "A"){
		#		$complimentoferverse = $complimentoferverse . "T";
		#	}
		#	elsif($_ eq "T"){
		#		$complimentoferverse = $complimentoferverse . "A";
		#	}
		#	elsif($_ eq "G"){
		#		$complimentoferverse = $complimentoferverse . "C";
		#	}
		#	elsif($_ eq "C"){
		#		$complimentoferverse = $complimentoferverse . "G";
		#	}
		#	
		#	
		#}

		#my @frame4dna = split(//, $complimentoferverse);
		#my @frame5dna = @frame4dna;
		#shift(@frame5dna);
		#my @frame6dna = @frame5dna;
		#shift(@frame6dna);
		
		#there now all the frames for this sequence are loaded and stored in memory 
		#so proccess each frame, count the codons yippie!
		my @frame1count = processframe(1, @frame1dna);
		my @frame2count = processframe(2, @frame2dna);
		my @frame3count = processframe(3, @frame3dna);
		
		
		
		#open (T, ">>countdebug.txt");
		#print T "\n\n\n";
		#for(0..63){
		#	print T "$codon[$_]\t$frame1count[$_]\t$frame2count[$_]\t$frame3count[$_]\n";
		#}
		
		#@frame4count = processframe(4, @frame4dna);
		#@frame5count = processframe(5, @frame5dna);
		#@frame6count = processframe(6, @frame6dna);
		
		
		#now that all the frames are calculated add them to the grand totals
		#by looping through each frame and adding to appropriate place in grandtotal arrary
		
		my $ctrlvar = 0;
		foreach(@frame1count){
			$frame1grandtotalcount[$ctrlvar] += $_;
			$ctrlvar++;
		}
		my $ctrlvar = 0;
		foreach(@frame2count){
			$frame2grandtotalcount[$ctrlvar] += $_;
			$ctrlvar++;
		}
		my $ctrlvar = 0;
		foreach(@frame3count){
			$frame3grandtotalcount[$ctrlvar] += $_;
			$ctrlvar++;
		}
		
		#calculate total codons in frame
		
		my $frame1total = calcframetotals(@frame1count);
		my $frame2total = calcframetotals(@frame2count);
		my $frame3total = calcframetotals(@frame3count);
		#my $frame4total = calcframetotals(@frame4count);
		#my $frame5total = calcframetotals(@frame5count);
		#my $frame6total = calcframetotals(@frame6count);
		
		
		if($frame1total == 0){
			
			errorwarning("$seqlist[$lcv] would result in illegal div by 0", "ERROR");
			next; #skip this sequence and proceede to next sequence in list
					
		}
		#now add frame totals to grandtotal
	
		
		$frame1grandtotcodon += $frame1total;
		$frame2grandtotcodon += $frame2total;
		$frame3grandtotcodon += $frame3total;
		
		
		
		#now that the ouput is stored and formatted lets sort it the way we want to
		
		my @notsorted = ();
		my %sortinghash = ();
		
		if($columnsort != 0) { #then you can sort it so
			if($atgcmode eq "GC"){
		@codon = (	#Codon(A)	#Complement(B)
	
			"TTA",		 "TAA",
			"TAT",		 "ATA",
			"TTT",		 "AAA",
			"AAT",		 "ATT",
			"CTA",		 "TAG",
			"ACT",		 "AGT",
			"TAC",		 "GTA",
			"TCT",		 "AGA",
			"AAG",		 "CTT",
			"TTC",		 "GAA",
			"ACA",		 "TGT",
			"TTG",		 "CAA",
			"AAC",		 "GTT",
			"ATG",		 "CAT",
			"TCA",		 "TGA",
			"ATC",		 "GAT",
			"AGC",		 "GCT",
			"CTG",		 "CAG",
			"TGC",		 "GCA",
			"TCC",		 "GGA",
			"AGG",		 "CCT",
			"GAG",		 "CTC",
			"GTG",		 "CAC",
			"TGG",		 "CCA",
			"ACC",		 "GGT",
			"ACG",		 "CGT",
			"GTC",		 "GAC",
			"TCG",		 "CGA",
			"GGG",		 "CCC",
			"GGC",		 "GCC",
			"CGG",		 "CCG",
			"GCG",		 "CGC"
			);
	}
	elsif($atgcmode eq "AT"){
	
		 @codon = (	      #Codon(A)       #Complement(B)
		    	    
		    	     	     "GGG",	      "CCC",
		    	     	     "GGC",	      "GCC",
		    	     	     "CCG",	      "CGG",
		    	     	     "CTA",	      "TAG",
		    	     	     "GCG",	      "CGC",
		    	     	     "GAG",	      "CTC",
		    	     	     "CCT",	      "AGG",
		    	     	     "GGT",	      "ACC",
		    	     	     "GAC",	      "GTC",
		    	     	     "GTG",	      "CAC",
		    	     	     "CCA",	      "TGG",
		    	     	     "GGA",	      "TCC",
		    	     	     "CGA",	      "TCG",
		    	     	     "CAG",	      "CTG",
		    	     	     "ATG",	      "CAT",
		    	     	     "ATA",	      "TAT",
		    	     	     "GCT",	      "AGC",
		    	     	     "GCA",	      "TGC",
		    	     	     "ACT",	      "AGT",
		    	     	     "GTA",	      "TAC",
		    	     	     "GAT",	      "ATC",
		    	     	     "CGT",	      "ACG",
		    	     	     "TCA",	      "TGA",
		    	     	     "ACA",	      "TGT",
		    	     	     "TTA",	      "TAA",
		    	     	     "AGA",	      "TCT",
		    	     	     "GTT",	      "AAC",
		    	     	     "AAT",	      "ATT",
		    	     	     "CAA",	      "TTG",
		    	     	     "AAG",	      "CTT",
		    	     	     "GAA",	      "TTC",
		 	     	     "AAA",	      "TTT",
			);
	
	}
			#from the current data make a multidimensional array
			#by calculating the current numbers and such to be sorted
			for(my $lcvb = 0; $lcvb < @codon; $lcvb += 2){
	
				
				
				my $frame1a = 100 * ($frame1count[$lcvb]/$frame1total);
				my $frame1b = 100 *($frame1count[$lcvb + 1] /$frame1total);
				my $frame2a = 100 * ($frame2count[$lcvb]/$frame2total);
				my $frame2b = 100 *($frame2count[$lcvb + 1] /$frame2total);
				my $frame3a = 100 * ($frame3count[$lcvb]/$frame3total);
				my $frame3b = 100 *($frame3count[$lcvb + 1] /$frame3total);
				my $totala =  100 * (($frame1count[$lcvb] + $frame2count[$lcvb] + $frame3count[$lcvb]) / ($frame1total + $frame2total + $frame3total));
				my $totalb = 100 * (($frame1count[$lcvb +1] + $frame2count[$lcvb +1] + $frame3count[$lcvb +1]) / ($frame1total + $frame2total + $frame3total));
				my $codona = $codon[$lcvb];
				my $codonb = $codon[$lcvb+1];
				
				
				#this variable is used to add sorting values to the hash
				push @notsorted, [ $codona, $codonb, $frame1a, $frame1b, $frame1a + $frame1b, $frame2a, $frame2b, $frame2a + $frame2b, $frame3a, $frame3b, $frame3a + $frame3b, $totala, $totalb, $totala + $totalb];

			}
		
			#so add the value to the hash and link it to the codon which is on its line
			for(0..31){
				#hash ->codon ->linkes to sort value
				#may need to be revesred not sure yet
				#print "$notsorted[$_][$columnsort] - $notsorted[$_][0]\n";
				if($morfrun eq "off"){
					#then display this error otherwise ignore it
					if(exists($sortinghash{$notsorted[$_][0]})){
						errorwarning("$notsorted[$_][0] already exists.  You need to fix your codon Tables", "ERROR");
						sleep(3);
					}
				}	#add value to hash codon  line = whatever value pulled from column
					$sortinghash{$notsorted[$_][0]} = $notsorted[$_][$columnsort];
			}
		
			#now the data has been sorted so now return it to the original arrays so it can be outputted correctly
			#clear the main variables then add the sorted data into them
			@frame1count = ();
			@frame2count = ();
			@frame3count = ();
			@codon = ();
			
			
			#so now figure out how to actually sort the data
			if ($columnsortupdown eq "asc"){
			foreach my $key (sort {$sortinghash{$a} <=> $sortinghash{$b}} keys %sortinghash) { 
			
				
				#so find line where codon is matched
				#print "$key = $sortinghash{$key} \n";
				
				for(0..31){
				
					if($notsorted[$_][0] eq $key){ #then this is the line you want to use
							
						
					
						#this puts everything back into the original arrays but now they are sorted
						#change the numbers back from their final output numbers to their raw numbers
						push @frame1count, ($notsorted[$_][2]/100)*$frame1total; 
						push @frame1count, ($notsorted[$_][3]/100)*$frame1total;
						
						push @frame2count, ($notsorted[$_][5]/100)*$frame2total;
						push @frame2count, ($notsorted[$_][6]/100)*$frame2total;
						
						push @frame3count, ($notsorted[$_][8]/100)*$frame3total;
						push @frame3count, ($notsorted[$_][9]/100)*$frame3total;
							
						push @codon, $notsorted[$_][0]; #add first codon
						push @codon, $notsorted[$_][1];

					} #end of if for checking if equals key
				} #end of for lop
			} #end of foreach key loop
			}#end of if asc loop
			else{ #default and desc
			
			foreach my $key (sort {$sortinghash{$b} <=> $sortinghash{$a}} keys %sortinghash) { 
			
				
				#so find line where codon is matched
				#print "$key = $sortinghash{$key} \n";
				
				for(0..31){
				
					if($notsorted[$_][0] eq $key){ #then this is the line you want to use
							
						
					
						#this puts everything back into the original arrays but now they are sorted
						#change the numbers back from their final output numbers to their raw numbers
						push @frame1count, ($notsorted[$_][2]/100)*$frame1total; 
						push @frame1count, ($notsorted[$_][3]/100)*$frame1total;
						
						push @frame2count, ($notsorted[$_][5]/100)*$frame2total;
						push @frame2count, ($notsorted[$_][6]/100)*$frame2total;
						
						push @frame3count, ($notsorted[$_][8]/100)*$frame3total;
						push @frame3count, ($notsorted[$_][9]/100)*$frame3total;
							
						push @codon, $notsorted[$_][0]; #add first codon
						push @codon, $notsorted[$_][1];

					} #end of if for checking if equals key
				} #end of for lop
			} #end of foreach key loop
			
			
			
			
			
			
			
			
			}		
			
			
			
			
		} #end of if statement for checking to see if sorting will be done
		#now that sorting is done undef hash so won't get error when next run is done
		
		#calculate distriubtion totals, a lot of just redudant math stuff
		#eventually just change all this into a for loop with a subfunction that returns the correct array
		push @frame1dist, 100 * (($frame1count[0] + $frame1count[1] + $frame1count[2] + $frame1count[3] 
					+ $frame1count[4] + $frame1count[5] + $frame1count[6] + $frame1count[7] )/$frame1total);
		push @frame1dist, 100 * (($frame1count[8] + $frame1count[9] + $frame1count[10] + $frame1count[11] 
					+ $frame1count[12] + $frame1count[13])/$frame1total);
		push @frame1dist, 100 * (($frame1count[14] + $frame1count[15] + $frame1count[16] + $frame1count[17] 
					+ $frame1count[18] + $frame1count[19])/$frame1total);
		push @frame1dist, 100 * (($frame1count[20] + $frame1count[21] + $frame1count[22] + $frame1count[23] 
					+ $frame1count[24] + $frame1count[25])/$frame1total);
		push @frame1dist, 100 * (($frame1count[26] + $frame1count[27] + $frame1count[28] + $frame1count[29] 
					+ $frame1count[30] + $frame1count[31])/$frame1total);
		push @frame1dist, 100 * (($frame1count[32] + $frame1count[33] + $frame1count[34] + $frame1count[35] 
					+ $frame1count[36] + $frame1count[37])/$frame1total);
		push @frame1dist, 100 * (($frame1count[38] + $frame1count[39] + $frame1count[40] + $frame1count[41] 
					+ $frame1count[42] + $frame1count[43])/$frame1total);
		push @frame1dist, 100 * (($frame1count[44] + $frame1count[45] + $frame1count[46] + $frame1count[47] 
					+ $frame1count[48] + $frame1count[49])/$frame1total);
		push @frame1dist, 100 * (($frame1count[50] + $frame1count[51] + $frame1count[52] + $frame1count[53] 
					+ $frame1count[54] + $frame1count[55])/$frame1total);
		push @frame1dist, 100 * (($frame1count[56] + $frame1count[57] + $frame1count[58] + $frame1count[59] 
					+ $frame1count[60] + $frame1count[61] + $frame1count[62] + $frame1count[63] )/$frame1total);
					
					
					
					
					
		push @frame2dist, 100 * (($frame2count[0] + $frame2count[1] + $frame2count[2] + $frame2count[3] 
					+ $frame2count[4] + $frame2count[5] + $frame2count[6] + $frame2count[7] )/$frame2total);
		push @frame2dist, 100 * (($frame2count[8] + $frame2count[9] + $frame2count[10] + $frame2count[11] 
					+ $frame2count[12] + $frame2count[13])/$frame2total);
		push @frame2dist, 100 * (($frame2count[14] + $frame2count[15] + $frame2count[16] + $frame2count[17] 
					+ $frame2count[18] + $frame2count[19])/$frame2total);
		push @frame2dist, 100 * (($frame2count[20] + $frame2count[21] + $frame2count[22] + $frame2count[23] 
					+ $frame2count[24] + $frame2count[25])/$frame2total);
		push @frame2dist, 100 * (($frame2count[26] + $frame2count[27] + $frame2count[28] + $frame2count[29] 
					+ $frame2count[30] + $frame2count[31])/$frame2total);
		push @frame2dist, 100 * (($frame2count[32] + $frame2count[33] + $frame2count[34] + $frame2count[35] 
					+ $frame2count[36] + $frame2count[37])/$frame2total);
		push @frame2dist, 100 * (($frame2count[38] + $frame2count[39] + $frame2count[40] + $frame2count[41] 
					+ $frame2count[42] + $frame2count[43])/$frame2total);
		push @frame2dist, 100 * (($frame2count[44] + $frame2count[45] + $frame2count[46] + $frame2count[47] 
					+ $frame2count[48] + $frame2count[49])/$frame2total);
		push @frame2dist, 100 * (($frame2count[50] + $frame2count[51] + $frame2count[52] + $frame2count[53] 
					+ $frame2count[54] + $frame2count[55])/$frame2total);
		push @frame2dist, 100 * (($frame2count[56] + $frame2count[57] + $frame2count[58] + $frame2count[59] 
					+ $frame2count[60] + $frame2count[61] + $frame2count[62] + $frame2count[63] )/$frame2total);
					
					
					
					
					
		push @frame3dist, 100 * (($frame3count[0] + $frame3count[1] + $frame3count[2] + $frame3count[3] 
					+ $frame3count[4] + $frame3count[5] + $frame3count[6] + $frame3count[7] )/$frame3total);
		push @frame3dist, 100 * (($frame3count[8] + $frame3count[9] + $frame3count[10] + $frame3count[11] 
					+ $frame3count[12] + $frame3count[13])/$frame3total);
		push @frame3dist, 100 * (($frame3count[14] + $frame3count[15] + $frame3count[16] + $frame3count[17] 
					+ $frame3count[18] + $frame3count[19])/$frame3total);
		push @frame3dist, 100 * (($frame3count[20] + $frame3count[21] + $frame3count[22] + $frame3count[23] 
					+ $frame3count[24] + $frame3count[25])/$frame3total);
		push @frame3dist, 100 * (($frame3count[26] + $frame3count[27] + $frame3count[28] + $frame3count[29] 
					+ $frame3count[30] + $frame3count[31])/$frame3total);
		push @frame3dist, 100 * (($frame3count[32] + $frame3count[33] + $frame3count[34] + $frame3count[35] 
					+ $frame3count[36] + $frame3count[37])/$frame3total);
		push @frame3dist, 100 * (($frame3count[38] + $frame3count[39] + $frame3count[40] + $frame3count[41] 
					+ $frame3count[42] + $frame3count[43])/$frame3total);
		push @frame3dist, 100 * (($frame3count[44] + $frame3count[45] + $frame3count[46] + $frame3count[47] 
					+ $frame3count[48] + $frame3count[49])/$frame3total);
		push @frame3dist, 100 * (($frame3count[50] + $frame3count[51] + $frame3count[52] + $frame3count[53] 
					+ $frame3count[54] + $frame3count[55])/$frame3total);
		push @frame3dist, 100 * (($frame3count[56] + $frame3count[57] + $frame3count[58] + $frame3count[59] 
					+ $frame3count[60] + $frame3count[61] + $frame3count[62] + $frame3count[63] )/$frame3total);
		
		#leave spaces between code here or else errors will come up when attempting to execute don't no why
					
		push @totaldist, 100 * ( ($frame1count[0] + $frame1count[1] + $frame1count[2] + $frame1count[3] +
					+ $frame1count[4] + $frame1count[5] + $frame1count[6] + $frame1count[7] +
					$frame2count[0] + $frame2count[1] + $frame2count[2] + $frame2count[3] +
					+ $frame2count[4] + $frame2count[5] + $frame2count[6] + $frame2count[7] + 
					$frame3count[0] + $frame3count[1] + $frame3count[2] + $frame3count[3] + 
					+ $frame3count[4] + $frame3count[5] + $frame3count[6] + $frame3count[7])/($frame1total + $frame2total + $frame3total));			
		
		push @totaldist, 100 * ( ($frame1count[8] + $frame1count[9] + $frame1count[10] + 
					 $frame1count[11] + $frame1count[12] + $frame1count[13] + 
					$frame2count[8] + $frame2count[9] + $frame2count[10] + 
					 $frame2count[11] + $frame2count[12] + $frame2count[13]  +
					$frame3count[8] + $frame3count[9] + $frame3count[10] + 
					 $frame3count[11] + $frame3count[12] + $frame3count[13] )/($frame1total + $frame2total + $frame3total));
					 
		push @totaldist, 100 * ( ($frame1count[14] + $frame1count[15] + $frame1count[16] + 
					  $frame1count[17] + $frame1count[18] + $frame1count[19] +
					  $frame2count[14] + $frame2count[15] + $frame2count[16] + 
					  $frame2count[17] + $frame2count[18] + $frame2count[19] + 
					  $frame3count[14] + $frame3count[15] + $frame3count[16] + 
					  $frame3count[17] + $frame3count[18] + $frame3count[19] )/($frame1total + $frame2total + $frame3total));
					  
		push @totaldist, 100 * ( ($frame1count[20] + $frame1count[21] + $frame1count[22] + 
					  $frame1count[23] + $frame1count[24] + $frame1count[25] +
					  $frame2count[20] + $frame2count[21] + $frame2count[22] + 
					  $frame2count[23] + $frame2count[24] + $frame2count[25] + 
					  $frame3count[20] + $frame3count[21] + $frame3count[22] + 
					  $frame3count[23] + $frame3count[24] + $frame3count[25] )/($frame1total + $frame2total + $frame3total));
					  
		push @totaldist, 100 * ( ($frame1count[26] + $frame1count[27] + $frame1count[28] + 
					  $frame1count[29] + $frame1count[20] + $frame1count[31] +
					  $frame2count[26] + $frame2count[27] + $frame2count[28] + 
					  $frame2count[29] + $frame2count[20] + $frame2count[31] + 
					  $frame3count[26] + $frame3count[27] + $frame3count[28] + 
					  $frame3count[29] + $frame3count[20] + $frame3count[31] )/($frame1total + $frame2total + $frame3total));
				
		push @totaldist, 100 * ( ($frame1count[32] + $frame1count[33] + $frame1count[34] + 
					  $frame1count[35] + $frame1count[36] + $frame1count[37] +
					  $frame2count[32] + $frame2count[33] + $frame2count[34] + 
					  $frame2count[35] + $frame2count[36] + $frame2count[37] + 
					  $frame3count[32] + $frame3count[33] + $frame3count[34] + 
					  $frame3count[35] + $frame3count[36] + $frame3count[37] )/($frame1total + $frame2total + $frame3total));
					  
		push @totaldist, 100 * ( ($frame1count[38] + $frame1count[39] + $frame1count[40] + 
					  $frame1count[41] + $frame1count[42] + $frame1count[43] +
					  $frame2count[38] + $frame2count[39] + $frame2count[40] + 
					  $frame2count[41] + $frame2count[42] + $frame2count[43] + 
					  $frame3count[38] + $frame3count[39] + $frame3count[40] + 
					  $frame3count[41] + $frame3count[42] + $frame3count[43] )/($frame1total + $frame2total + $frame3total));
					  
		push @totaldist, 100 * ( ($frame1count[44] + $frame1count[45] + $frame1count[46] + 
					  $frame1count[47] + $frame1count[48] + $frame1count[49] +
					  $frame2count[44] + $frame2count[45] + $frame2count[46] + 
					  $frame2count[47] + $frame2count[48] + $frame2count[49] + 
					  $frame3count[44] + $frame3count[45] + $frame3count[46] + 
					  $frame3count[47] + $frame3count[48] + $frame3count[49] )/($frame1total + $frame2total + $frame3total));
					  
		push @totaldist, 100 * ( ($frame1count[50] + $frame1count[51] + $frame1count[52] + 
					  $frame1count[53] + $frame1count[54] + $frame1count[55] +
					  $frame2count[50] + $frame2count[51] + $frame2count[52] + 
					  $frame2count[53] + $frame2count[54] + $frame2count[55] + 
					  $frame3count[50] + $frame3count[51] + $frame3count[52] + 
					  $frame3count[53] + $frame3count[54] + $frame3count[55] )/($frame1total + $frame2total + $frame3total));
		
		push @totaldist, 100 * ( (	$frame1count[56] + $frame1count[57] + $frame1count[58] + $frame1count[59] +
					 	$frame1count[60] + $frame1count[61] + $frame1count[62] + $frame1count[63] +
						$frame2count[56] + $frame2count[57] + $frame2count[58] + $frame2count[59] +
						$frame2count[60] + $frame2count[61] + $frame2count[62] + $frame2count[63] + 
						$frame3count[56] + $frame3count[57] + $frame3count[58] + $frame3count[59] + 
					 	$frame3count[60] + $frame3count[61] + $frame3count[62] + $frame3count[63])/($frame1total + $frame2total + $frame3total));   
		


		
		#at only, at rich, gc rich, gc only distribution percentages
		#check to see what type of run this is at or gc?
		
		
		
		
		
		
		
		
		sub calcframetotals(){
		
			my @numstoadd = @_;
			my $frametot = 0;
			foreach(@numstoadd){
				$frametot = $frametot + $_;
			}
			return $frametot;
		
		}
		
		
		print FILE "                               FRAME 1:        FRAME 2:        FRAME 3:         TOTAL\n";
		print FILE " Codon(A):  Complement(B):  A    B   A+B    A    B   A+B    A    B   A+B    A    B   A+B\n";
		my $outputsidecounter = 1;
		for(my $lcvb = 0; $lcvb < @codon; $lcvb += 2){
			
			# - $frame1count[$lcv] $frame2count[$lcv]  $frame3count[$lcv]  $frame4count[$lcv]  $frame5count[$lcv]  $frame6count[$lcv]\n";
			#because printf is funny about the way things would be should store everything in variables so easier to print out
			#kinda long and tedious but oh well it works and is pretty easy to follow
			
			my $frame1a = 100 * ($frame1count[$lcvb]/$frame1total);
			my $frame1b = 100 *($frame1count[$lcvb + 1] /$frame1total);
			my $frame2a = 100 * ($frame2count[$lcvb]/$frame2total);
			my $frame2b = 100 *($frame2count[$lcvb + 1] /$frame2total);
			my $frame3a = 100 * ($frame3count[$lcvb]/$frame3total);
			my $frame3b = 100 *($frame3count[$lcvb + 1] /$frame3total);
			my $totala =  100 * (($frame1count[$lcvb] + $frame2count[$lcvb] + $frame3count[$lcvb]) / ($frame1total + $frame2total + $frame3total));
			my $totalb = 100 * (($frame1count[$lcvb +1] + $frame2count[$lcvb +1] + $frame3count[$lcvb +1]) / ($frame1total + $frame2total + $frame3total));
			
			#here is out this printf line works so its easier to understand			#links to hash $hashname{this is actually the codonname) then pulls out result
												#eg.	$dnatoseqaa{TAA} -> outputs *QY 
								#counter		#codonname	#aminoacid of codon		#complimentcodon	#aminoacid of compliment
			#printf FILE "%2s%5s-%-4s%4s%4s-%-4s", $outputsidecounter++, $codon[$lcvb] ,$dnaseqtoaa{$codon[$lcvb]},  "" ,$codon[$lcvb+1], $dnaseqtoaa{$codon[$lcvb+1]};
			
			if($sixtyfourcodonlist eq "yes"){
				#the option to output a special list has been turned on so
				#add to the hash which will then be sorted.
				$sixtyfourlisthash{"$codon[$lcvb]-$dnaseqtoaa{$codon[$lcvb]}"} = $frame1a;
				$sixtyfourlisthash{"$codon[$lcvb+1]-$dnaseqtoaa{$codon[$lcvb+1]}"} = $frame1b; 
				
			}
			
			
			
			
			 
			#count the codons and add them to the lovely array
			#total codonds this is easy
			$totalcodons[0] += $frame1count[$lcvb];
			$totalcodons[1] += $frame1count[$lcvb + 1];
			$totalcodons[2] += $frame1count[$lcvb] + $frame1count[$lcvb + 1];
			$totalcodons[3] += $frame2count[$lcvb];
			$totalcodons[4] += $frame2count[$lcvb + 1];
			$totalcodons[5] += $frame2count[$lcvb] + $frame1count[$lcvb + 1];
			$totalcodons[6] += $frame3count[$lcvb];
			$totalcodons[7] += $frame3count[$lcvb + 1];
			$totalcodons[8] += $frame3count[$lcvb] + $frame1count[$lcvb + 1];
			$totalcodons[9] += $frame1count[$lcvb] + $frame2count[$lcvb] + $frame3count[$lcvb];
			$totalcodons[10] += $frame1count[$lcvb +1] + $frame2count[$lcvb +1] + $frame3count[$lcvb +1];
			$totalcodons[11] += $frame1count[$lcvb] + $frame2count[$lcvb] + $frame3count[$lcvb] + $frame1count[$lcvb +1] + $frame2count[$lcvb +1] + $frame3count[$lcvb +1];
			
			
			#stop codons, well check if it actually is a stop codon first check framea, then do frame b
			if( $codon[$lcvb] eq "TAG" || $codon[$lcvb +1] eq "TAG" || $codon[$lcvb] eq "TGA" || $codon[$lcvb +1] eq "TGA" || $codon[$lcvb] eq "TAA" || $codon[$lcvb +1] eq "TAA"){
			
				
				#so frame1
				$stopcodons[0] += $frame1count[$lcvb];
				$stopcodons[1] += $frame1count[$lcvb + 1];
				$stopcodons[2] += $frame1count[$lcvb] + $frame1count[$lcvb + 1];
				
				#frame 2
				$stopcodons[3] += $frame2count[$lcvb];
				$stopcodons[4] += $frame2count[$lcvb + 1];
				$stopcodons[5] += $frame2count[$lcvb] + $frame2count[$lcvb + 1];
				
				#frame 3
				$stopcodons[6] += $frame3count[$lcvb];
				$stopcodons[7] += $frame3count[$lcvb + 1];
				$stopcodons[8] += $frame3count[$lcvb] + $frame3count[$lcvb + 1];
				
				#frame totals
				$stopcodons[9] += $frame1count[$lcvb] + $frame2count[$lcvb] + $frame3count[$lcvb];
				$stopcodons[10] += $frame1count[$lcvb +1] + $frame2count[$lcvb +1] + $frame3count[$lcvb +1];
				$stopcodons[11] += $frame1count[$lcvb] + $frame2count[$lcvb] + $frame3count[$lcvb] + $frame1count[$lcvb +1] + $frame2count[$lcvb +1] + $frame3count[$lcvb +1];
			
			
			}
			
			
			
			
			#while going through use these lines to calculate at only gc only distribution and such
			#let's see
			#
			# and also add graph data if needed
			#
			if(exists($codondisttype{$codon[$lcvb]})) { #whcih there should be no reason why it doesn't exist
			

				if($codondisttype{$codon[$lcvb]} eq "AT Only"){
					#this line of outputting is at only so record vlaues in at only dist array
					$atonly[0] = $atonly[0] + $frame1count[$lcvb] + $frame1count[$lcvb+1];  #raw numbers, not percentages
					$atonly[1] = $atonly[1] + $frame2count[$lcvb] + $frame2count[$lcvb+1];
					$atonly[2] = $atonly[2] + $frame3count[$lcvb] + $frame3count[$lcvb+1];
					$atonly[3] = $atonly[3] + $frame1count[$lcvb] + $frame2count[$lcvb] + $frame3count[$lcvb] + $frame1count[$lcvb +1] + $frame2count[$lcvb +1] + $frame3count[$lcvb +1];
					
					
					
					
					#figure out if multidef codon or not
					if($codon[$lcvb] eq "TAA" || $codon[$lcvb] eq "ATA" || $codon[$lcvb] eq "AAA"){
						#multi def codon so add to special list
						$graph1atomultidef{$lcvb} = $frame1a; 
						$graph3atomultidef{$lcvb} = $totala;
						 
					}elsif($codon[$lcvb+1] eq "TAA" || $codon[$lcvb+1] eq "ATA" || $codon[$lcvb+1] eq "AAA"){
						$graph1atomultidef{$lcvb+1} = $frame1b; 
						$graph3atomultidef{$lcvb+1} = $totalb; 
						
						
					
					}
					if(!(exists($graph1atomultidef{$lcvb}))){
							$graph1ato{$lcvb} =  $frame1a;
							$graph3ato{$lcvb} =  $totala;
					}
					if(!(exists($graph1atomultidef{$lcvb+1}))){
							$graph1ato{$lcvb+1} =  $frame1b;
							$graph3ato{$lcvb+1} =  $totalb;
					}
					
					$graph2ato{$outputsidecounter} = $frame1a + $frame1b;
					$graph4ato{$outputsidecounter} = ($totala + $totalb);
					
				
				}
				elsif($codondisttype{$codon[$lcvb]} eq "AT Rich"){
				
					#this line of outputting is at only so record vlaues in at only dist array
					$atrich[0] = $atrich[0] + $frame1count[$lcvb] + $frame1count[$lcvb+1];
					$atrich[1] = $atrich[1] + $frame2count[$lcvb] + $frame2count[$lcvb+1];
					$atrich[2] = $atrich[2] + $frame3count[$lcvb] + $frame3count[$lcvb+1];
					$atrich[3] = $atrich[3] + $frame1count[$lcvb] + $frame2count[$lcvb] + $frame3count[$lcvb] + $frame1count[$lcvb +1] + $frame2count[$lcvb +1] + $frame3count[$lcvb +1];
					

					#figure out if multidef codon or not
					if($codon[$lcvb] eq "CTA" || $codon[$lcvb] eq "TAG" || $codon[$lcvb] eq "AGA" || $codon[$lcvb] eq "CTT" || $codon[$lcvb] eq "TTG" || $codon[$lcvb] eq "ATG" || $codon[$lcvb] eq "TGA"){
						#multi def codon so add to special list
						$graph1atrmultidef{$lcvb} = $frame1a; 
						$graph3atrmultidef{$lcvb} = $totala;
						 
					}elsif($codon[$lcvb+1] eq "CTA" || $codon[$lcvb+1] eq "TAG" || $codon[$lcvb+1] eq "AGA" || $codon[$lcvb+1] eq "CTT" || $codon[$lcvb+1] eq "TTG" || $codon[$lcvb+1] eq "ATG" || $codon[$lcvb+1] eq "TGA"){
						$graph1atrmultidef{$lcvb+1} = $frame1b; 
						$graph3atrmultidef{$lcvb+1} = $totalb; 
					
						
					
					}
					if(!(exists($graph1atrmultidef{$lcvb}))){
							$graph1atr{$lcvb} =  $frame1a;
							$graph3atr{$lcvb} =  $totala;
					}
					if(!(exists($graph1atrmultidef{$lcvb+1}))){
							$graph1atr{$lcvb+1} =  $frame1b;
							$graph3atr{$lcvb+1} =  $totalb;
					}
					
					$graph2atr{$outputsidecounter} = $frame1a + $frame1b;
					$graph4atr{$outputsidecounter} = ($totala + $totalb);
					
				}elsif($codondisttype{$codon[$lcvb]} eq "GC Rich"){
				
					$gcrich[0] = $gcrich[0] + $frame1count[$lcvb] + $frame1count[$lcvb+1];
					$gcrich[1] = $gcrich[1] + $frame2count[$lcvb] + $frame2count[$lcvb+1];
					$gcrich[2] = $gcrich[2] + $frame3count[$lcvb] + $frame3count[$lcvb+1];
					$gcrich[3] = $gcrich[3] + $frame1count[$lcvb] + $frame2count[$lcvb] + $frame3count[$lcvb] + $frame1count[$lcvb +1] + $frame2count[$lcvb +1] + $frame3count[$lcvb +1];
				


					#figure out if multidef codon or not
					if($codon[$lcvb] eq "CTG" || $codon[$lcvb] eq "AGG" || $codon[$lcvb] eq "CTC" || $codon[$lcvb] eq "GTG"){
						#multi def codon so add to special list
						$graph1gcrmultidef{$lcvb} = $frame1a; 
						$graph3gcrmultidef{$lcvb} = $totala;
						 
					}elsif($codon[$lcvb+1] eq "CTG" || $codon[$lcvb+1] eq "AGG" || $codon[$lcvb+1] eq "CTC" || $codon[$lcvb+1] eq "GTG"){
						$graph1gcrmultidef{$lcvb+1} = $frame1b; 
						$graph3gcrmultidef{$lcvb+1} = $totalb; 
					
						
					
					}
					if(!(exists($graph1gcrmultidef{$lcvb}))){
							$graph1gcr{$lcvb} =  $frame1a;
							$graph3gcr{$lcvb} =  $totala;
					}
					if(!(exists($graph1gcrmultidef{$lcvb+1}))){
							$graph1gcr{$lcvb+1} =  $frame1b;
							$graph3gcr{$lcvb+1} =  $totalb;
					}
					
					$graph2gcr{$outputsidecounter} = $frame1a + $frame1b;
					$graph4gcr{$outputsidecounter} = ($totala + $totalb);
				}
				elsif($codondisttype{$codon[$lcvb]} eq "GC Only"){
				
				
					$gconly[0] = $gconly[0] + $frame1count[$lcvb] + $frame1count[$lcvb+1];
					$gconly[1] = $gconly[1] + $frame2count[$lcvb] + $frame2count[$lcvb+1];
					$gconly[2] = $gconly[2] + $frame3count[$lcvb] + $frame3count[$lcvb+1];
					$gconly[3] = $gconly[3] + $frame1count[$lcvb] + $frame2count[$lcvb] + $frame3count[$lcvb] + $frame1count[$lcvb +1] + $frame2count[$lcvb +1] + $frame3count[$lcvb +1];
				

					#don't need checks for orf cuz gc only doesnt have ne
					$graph1gco{$lcvb} =  $frame1a;
					$graph3gco{$lcvb} =  $totala;
					$graph1gco{$lcvb+1} =  $frame1b;
					$graph3gco{$lcvb+1} =  $totalb;
					
					$graph2gco{$outputsidecounter} = $frame1a + $frame1b;
					$graph4gco{$outputsidecounter} = ($totala + $totalb);
						
					
					
				}
				#now check max values for graph
				if($graphymax < ($totala + $totalb)) {$graphymax = ($totala + $totalb);}
			
			
			
			}
			#now that all the other stuff is out of the way lets do the actual ouputting  
		 	#first check to see if swap option was turned on
			if($swapifbigger  == 0) { #nope it wasn't so output as normal
			
				printf FILE "%2s%5s-%-4s%4s%4s-%-4s", $outputsidecounter++, $codon[$lcvb] ,$dnaseqtoaa{$codon[$lcvb]},  "" ,$codon[$lcvb+1], $dnaseqtoaa{$codon[$lcvb+1]};
				printf FILE "%5.1f" , $frame1a;
				printf FILE "%5.1f" , $frame1b;
				printf FILE "%5.1f",  $frame1a + $frame1b;
				printf FILE "%2s";
				printf FILE "%5.1f" , $frame2a;
				printf FILE "%5.1f" , $frame2b;
				printf FILE "%5.1f", $frame2a + $frame2b;
				printf FILE "%5.1f" , $frame3a;
				printf FILE "%5.1f" , $frame3b;
				printf FILE "%5.1f",  $frame3a + $frame3b;
				printf FILE "%1s";
				printf FILE "%5.1f", $totala;
				printf FILE "%5.1f", $totalb; 
				printf FILE "%5.1f", $totala + $totalb;
				print FILE "\n";
			}
			elsif($swapifbigger == 1){ #option was turned on 
				
				#see if codons need to be switched first
				if( ($frame1b > $frame1a) || ($totalb > $totala)){
					#print "swap needed\n";
					#yes they do since there somewhere where b is greater than a
					#so reverse the codons
					printf FILE "%2s%5s-%-4s%4s%4s-%-4s", $outputsidecounter++, $codon[$lcvb +1] ,$dnaseqtoaa{$codon[$lcvb+1]},  "" ,$codon[$lcvb], $dnaseqtoaa{$codon[$lcvb]};
				
				
				}
				else{  #Nope
				
					printf FILE "%2s%5s-%-4s%4s%4s-%-4s", $outputsidecounter++, $codon[$lcvb] ,$dnaseqtoaa{$codon[$lcvb]},  "" ,$codon[$lcvb+1], $dnaseqtoaa{$codon[$lcvb+1]};

				}
				
				
				#now check if frame1b is grater than frame1a
				if($frame1b > $frame1a){
					printf FILE "%5.1f" , $frame1b;
					printf FILE "%5.1f" , $frame1a;
		
				}
				else{
					printf FILE "%5.1f" , $frame1a;
					printf FILE "%5.1f" , $frame1b;
				}
				printf FILE "%5.1f",  $frame1a + $frame1b;
				printf FILE "%2s";
				printf FILE "%5.1f" , $frame2a;
				printf FILE "%5.1f" , $frame2b;
				printf FILE "%5.1f", $frame2a + $frame2b;
				printf FILE "%5.1f" , $frame3a;
				printf FILE "%5.1f" , $frame3b;
				printf FILE "%5.1f",  $frame3a + $frame3b;
				printf FILE "%1s";
				
				
				
				
				if($totalb > $totala){
					
					printf FILE "%5.1f", $totalb;
					printf FILE "%5.1f", $totala;
				}
				else{
					printf FILE "%5.1f", $totala;
					printf FILE "%5.1f", $totalb; 
				}
				
				printf FILE "%5.1f", $totala + $totalb;
				print FILE "\n";
			
			}
			
			
			
			
		}
		
		#print out codon counts
		printf FILE "%6sStop Codons:%7s%5d%5d%5d%1s%5d%5d%5d%1s%5d%5d%5d%1s%5d%5d%5d", "", "", $stopcodons[0] , $stopcodons[1], $stopcodons[2], "", $stopcodons[3], $stopcodons[4], $stopcodons[5], "", $stopcodons[6], $stopcodons[7], $stopcodons[8], "", $stopcodons[9], $stopcodons[10], $stopcodons[11];
		printf FILE "\n%6sTotal Codons:%6s%5d%5d%5d%1s%5d%5d%5d%1s%5d%5d%5d%1s%5d%5d%5d", "", "", $totalcodons[0] , $totalcodons[1], $totalcodons[2], "", $totalcodons[3], $totalcodons[4], $totalcodons[5], "", $totalcodons[6], $totalcodons[7], $totalcodons[8],"", $totalcodons[9], $totalcodons[10], $totalcodons[11];
		print FILE "\n";
		
		print FILE "\n                                        DISTRIBUTION Percentage(%)\n";
		print FILE "      CODON SET                FRAME 1:        FRAME 2:        FRAME 3:         TOTAL\n";
		for(my $lcv = 0; $lcv < @frame1dist; $lcv++){
			printf FILE "%5s%5s%5s%5s%10s%5.2f%11s%5.2f%11s%5.2f%11s%5.2f", "" , $codonsets[$lcv], "", $codonsetpercents[$lcv], "", $frame1dist[$lcv] , "" , $frame2dist[$lcv], "" , $frame3dist[$lcv], "", $totaldist[$lcv];
			print FILE "\n";
		}
		
		#print out the bottom distribtion precentages
		#at only 
		print FILE "\n";
		printf FILE "%5s%5s%5s%5s%8s%5.2f%11s%5.2f%11s%5.2f%11s%5.2f", "", $codonsets[10], "", $codonsetpercents[10], "", 100 *($atonly[0]/$frame1total), "" , 100 *($atonly[1]/$frame2total), "",  100*($atonly[2]/$frame3total), "",  100*($atonly[3]/($frame1total + $frame2total + $frame3total));  
		#at rich
		print FILE "\n";
		printf FILE "%5s%5s%5s%5s%8s%5.2f%11s%5.2f%11s%5.2f%11s%5.2f", "", $codonsets[11], "", $codonsetpercents[11], "", 100 *($atrich[0]/$frame1total), "" , 100 *($atrich[1]/$frame2total), "",  100*($atrich[2]/$frame3total), "",  100*($atrich[3]/($frame1total + $frame2total + $frame3total));  
		#gc rich
		print FILE "\n";
		printf FILE "%5s%5s%5s%5s%8s%5.2f%11s%5.2f%11s%5.2f%11s%5.2f", "", $codonsets[12], "", $codonsetpercents[12], "", 100 *($gcrich[0]/$frame1total), "" , 100 *($gcrich[1]/$frame2total), "",  100*($gcrich[2]/$frame3total), "",  100*($gcrich[3]/($frame1total + $frame2total + $frame3total));  
		#gc only
		print FILE "\n";
		printf FILE "%5s%5s%5s%5s%8s%5.2f%11s%5.2f%11s%5.2f%11s%5.2f", "", $codonsets[13], "", $codonsetpercents[13], "", 100 *($gconly[0]/$frame1total), "" , 100 *($gconly[1]/$frame2total), "",  100*($gconly[2]/$frame3total), "",  100*($gconly[3]/($frame1total + $frame2total + $frame3total));  
		
		
	
		
		
		
		
		#now proccess the at and gc count
		my $totala = ($dnastring =~ tr/A//);
		my $totalt = ($dnastring =~ tr/T//);
		my $totalg = ($dnastring =~ tr/G//);
		my $totalc = ($dnastring =~ tr/C//);

		
		print FILE "\n\t\tBase Usage:\t\tA,T:  ";
		printf FILE "%5.2f\%", 100 * (($totala + $totalt)/($totala + $totalt + $totalg + $totalc));
		print FILE "\t\tG,C:  ";
		printf FILE "%5.2f\%", 100 *(($totalg + $totalc)/($totala + $totalt + $totalg + $totalc));
		print FILE "\n\n";
		#close FILE;  //why was this closed? need rest of data for files
		
		#great now add the atonly gc, only gc rich etc to the total for the run
		
		for(0..3){
		
			$totalatonly[$_] += $atonly[$_];
			$totalatrich[$_] += $atrich[$_];
			$totalgcrich[$_] += $gcrich[$_];
			$totalgconly[$_] += $gconly[$_];
		
		
		}
		#also add the codon count to the grand total codon count
		for(0..11){
			$totalstopcodons[$_] += $stopcodons[$_];
			$totaltotalcodons[$_] += $totalcodons[$_];
		}
		
		
		#check to see morf tag of file before finishing
		my $morftype = "";
		if( $morfrun eq "off") {
			my $accnum = $seqlist[$lcv];
			my $dnastring = $seqdata[$lcv];
			#then this is the first actual run
			#so figure out what types of morfs these are
			#there has to be a better way to write this stuff!
			
	               if($stopcodons[0] > 0 && $stopcodons[1] == 1   && $stopcodons[3] > 0 && $stopcodons[4] > 0 && $stopcodons[6] > 0 && $stopcodons[7] > 0  ){
	
	                       $morftype = "sorf";
	                       push @sorflist, $accnum;
	                       push @sorflistdata, $dnastring;
	
	               }elsif($stopcodons[0] > 0 && $stopcodons[1] == 0   && $stopcodons[3] > 0 && $stopcodons[4] > 0 && $stopcodons[6] > 0 && $stopcodons[7] > 0 ){
	
	                       $morftype = "sorf";
			       push @sorflist, $accnum;
	                       push @sorflistdata, $dnastring;
	
	               }elsif($stopcodons[0] == 0 && $stopcodons[1] == 1  && $stopcodons[3] > 0 && $stopcodons[4] > 0 && $stopcodons[6] > 0 && $stopcodons[7] > 0  ){
	
	                       $morftype = "dorf";
			       push @dorflist, $accnum;
	                       push @dorflistdata, $dnastring;
			       
	               }elsif($stopcodons[0] == 0 && $stopcodons[1] == 0 && $stopcodons[3] > 0 && $stopcodons[4] > 0 && $stopcodons[6] > 0 && $stopcodons[7] > 0   ){
	
	              		$morftype = "dorf";
			       	push @dorflist, $accnum;
	                       	push @dorflistdata, $dnastring;
		       
		       }elsif($stopcodons[0] > 0 && $stopcodons[1] == 1  && $stopcodons[3] > 0 && $stopcodons[4] > 0 && $stopcodons[6] == 0 && $stopcodons[7] > 0   ){
	
	                       $morftype = "dorf";
			       push @dorflist, $accnum;
	                       push @dorflistdata, $dnastring;
			       
	               }elsif($stopcodons[0] > 0 && $stopcodons[1] == 1  && $stopcodons[3] > 0 && $stopcodons[4] > 0 && $stopcodons[6] == 0 && $stopcodons[7] > 0   ){
	
	                       $morftype = "dorf";
			       push @dorflist, $accnum;
	                       push @dorflistdata, $dnastring;
			       
	               }elsif($stopcodons[0] > 0 && $stopcodons[1] == 0 && $stopcodons[3] > 0 && $stopcodons[4] > 0 && $stopcodons[6] == 0 && $stopcodons[7] > 0   ){
	
	              		$morftype = "dorf";
			       	push @dorflist, $accnum;
	                       	push @dorflistdata, $dnastring;
		       
		       }elsif($stopcodons[0] > 0 && $stopcodons[1] == 1  && $stopcodons[3] > 0 && $stopcodons[4] > 0 && $stopcodons[6] > 0 && $stopcodons[7] == 0   ){
	
	                       $morftype = "dorf";
			       push @dorflist, $accnum;
	                       push @dorflistdata, $dnastring;
			       
	               }elsif($stopcodons[0] > 0 && ($stopcodons[1] > 0 && $stopcodons[1] < 2) && $stopcodons[3] > 0 && $stopcodons[4] > 0  && ($stopcodons[7] =  $stopcodons[8]) ){
				#means stop codon 6 = 0
	              		$morftype = "dorf";
			       	push @dorflist, $accnum;
	                       	push @dorflistdata, $dnastring;
		       
		       }elsif($stopcodons[0] > 0 && $stopcodons[1] == 1 && $stopcodons[3] == 0 && $stopcodons[4] > 0  && ($stopcodons[7] =  $stopcodons[8]) ){
				#means stop codon 6 = 0
	              		$morftype = "dorf";
			       	push @dorflist, $accnum;
	                       	push @dorflistdata, $dnastring;
		       
		       }elsif($stopcodons[0] == 0 && $stopcodons[1] == 1  && $stopcodons[3] > 0 && $stopcodons[4] > 0 && $stopcodons[6] > 0 && $stopcodons[7] == 0  ){
	
	                       $morftype = "torf";
			       push @torflist, $accnum;
	                       push @torflistdata, $dnastring;
			       
	               }elsif($stopcodons[0] == 0 && $stopcodons[1] == 0 && $stopcodons[3] > 0 && $stopcodons[4] > 0 && $stopcodons[6] > 0 && $stopcodons[7] == 0  ){
	
	                       $morftype = "torf";
			       push @torflist, $accnum;
	                       push @torflistdata, $dnastring;
			       
	               }elsif($stopcodons[0] == 0 && $stopcodons[1] == 1  && $stopcodons[3] > 0 && $stopcodons[4] > 0 && $stopcodons[6] == 0 && $stopcodons[7] > 0 ){
	
	                       $morftype = "torf";
			       push @torflist, $accnum;
	                       push @torflistdata, $dnastring;
			       
	               }elsif($stopcodons[0] == 0 && $stopcodons[1] == 0 && $stopcodons[3] > 0 && $stopcodons[4] > 0 && $stopcodons[6] == 0 && $stopcodons[7] > 0   ){
	
	                       $morftype = "torf";
			       push @torflist, $accnum;
	                       push @torflistdata, $dnastring;
			       
	               }elsif($stopcodons[0] > 1 && $stopcodons[1] == 1 && $stopcodons[3] > 0 && $stopcodons[4] > 0 && $stopcodons[6] == 0 && $stopcodons[7] == 0   ){
	
	                       $morftype = "torf";
			       push @torflist, $accnum;
	                       push @torflistdata, $dnastring;
			       
	               }elsif($stopcodons[0] > 1 && $stopcodons[1] == 1 && $stopcodons[3] == 0 && $stopcodons[4] > 0 && $stopcodons[6] == 0 && $stopcodons[7] > 0   ){
	
	                       $morftype = "torf";
			       push @torflist, $accnum;
	                       push @torflistdata, $dnastring;
			       
	               }elsif($stopcodons[0] == 0 && $stopcodons[1] == 1 && $stopcodons[3] > 0 && $stopcodons[4] == 0 && $stopcodons[6] > 0 && $stopcodons[7] > 0   ){
	
	                       $morftype = "torf";
			       push @torflist, $accnum;
	                       push @torflistdata, $dnastring;
			       
	               }elsif( ($stopcodons[0] < 1 && $stopcodons[0] > -1) &&  ($stopcodons[1] < 1 && $stopcodons[1] > -1) && ($stopcodons[3] < 1 && $stopcodons[3] > -1) && $stopcodons[4] > 0 && $stopcodons[6] > 0 && ($stopcodons[7] < 1 && $stopcodons[7] > -1)  ){
	
	                       $morftype = "qorf";
			       push @qorflist, $accnum;
	                       push @qorflistdata, $dnastring;
	               }elsif( $stopcodons[0] == 0 &&  ($stopcodons[1] < 1 && $stopcodons[1] > -1) && $stopcodons[3] == 0 && $stopcodons[4] > 0 && $stopcodons[6] > 0 && ($stopcodons[7] < 1 && $stopcodons[7] > -1)  ){
	
	                       $morftype = "qorf";
			       push @qorflist, $accnum;
	                       push @qorflistdata, $dnastring;
			       
	               }elsif( $stopcodons[0] == 0 &&  ($stopcodons[1] < 1 && $stopcodons[1] > -1) && $stopcodons[3] == 0 && $stopcodons[4] == 0 && $stopcodons[6] > 0 && $stopcodons[7] > 0 ){
	
	                       $morftype = "qorf";
			       push @qorflist, $accnum;
	                       push @qorflistdata, $dnastring;
			       
	               }elsif( $stopcodons[0] == 0 &&  $stopcodons[1] == 1 && $stopcodons[3] == 0 && $stopcodons[4] > 0 && $stopcodons[6] > 0 && $stopcodons[7] > 0 ){
	
	                       $morftype = "qorf";
			       push @qorflist, $accnum;
	                       push @qorflistdata, $dnastring;
			       
	               }elsif( $stopcodons[0] == 0 &&  $stopcodons[1] == 0 && $stopcodons[3] > 0 && $stopcodons[4] > 0 && $stopcodons[6] == 0 && $stopcodons[7] == 0 ){
	
	                       $morftype = "qorf";
			       push @qorflist, $accnum;
	                       push @qorflistdata, $dnastring;
			       
	               }elsif( $stopcodons[0] == 0 &&  $stopcodons[1] == 1 && $stopcodons[3] == 0 && $stopcodons[4] > 0 && $stopcodons[6] == 0 && $stopcodons[7] > 0 ){
	
	                       $morftype = "qorf";
			       push @qorflist, $accnum;
	                       push @qorflistdata, $dnastring;
			       
	               }elsif($stopcodons[0] == 0 &&  $stopcodons[1] == 1 && $stopcodons[3] > 0 && $stopcodons[4] > 0 && $stopcodons[6] == 0 && $stopcodons[7] == 0 ){
	
	                       $morftype = "qorf";
			       push @qorflist, $accnum;
	                       push @qorflistdata, $dnastring;
			       
	               }elsif($stopcodons[0] == 0 && ($stopcodons[1] > 0 && $stopcodons[1] < 2)  && $stopcodons[3] == 0 && $stopcodons[4] > 0 && $stopcodons[6] == 0 && $stopcodons[7] == 0  ){
	
	                       $morftype = "porf";
			       push @porflist, $accnum;
	                       push @porflistdata, $dnastring;
	               }elsif($stopcodons[0] == 0 && $stopcodons[1] == 0  && $stopcodons[3] == 0 && $stopcodons[4] > 0 && $stopcodons[6] == 0 && $stopcodons[7] == 0  ){
	
	                       $morftype = "porf";
			       push @porflist, $accnum;
	                       push @porflistdata, $dnastring;
	               }elsif($stopcodons[0] == 0 && $stopcodons[1] == 1  && $stopcodons[3] == 0 && $stopcodons[4] == 0 && $stopcodons[6] == 0 && $stopcodons[7] > 0  ){
	
	                       $morftype = "porf";
			       push @porflist, $accnum;
	                       push @porflistdata, $dnastring;
	               }elsif($stopcodons[0] == 0 && $stopcodons[1] == 0  && $stopcodons[3] > 0 && $stopcodons[4] == 0 && $stopcodons[6] == 0 && $stopcodons[7] == 0  ){
	
	                       $morftype = "porf";
			       push @porflist, $accnum;
	                       push @porflistdata, $dnastring;
	               }elsif($stopcodons[0] == 0 && $stopcodons[1] == 1  && $stopcodons[3] > 0 && $stopcodons[4] == 0 && $stopcodons[6] == 0 && $stopcodons[7] == 0  ){
	
	                       $morftype = "porf";
			       push @porflist, $accnum;
	                       push @porflistdata, $dnastring;
	               }elsif($stopcodons[0] == 0 && $stopcodons[1] == 0  && $stopcodons[3] == 0 && $stopcodons[4] == 0 && $stopcodons[6] > 0 && $stopcodons[7] == 0  ){
	
	                       $morftype = "porf";
			       push @porflist, $accnum;
	                       push @porflistdata, $dnastring;
	               }elsif($stopcodons[0] == 0 && ($stopcodons[1] > -1 && $stopcodons[1] < 2)  && $stopcodons[3] == 0 && $stopcodons[4] == 0 && $stopcodons[6] == 0 && $stopcodons[7] == 0  ){
	
	                       $morftype = "horf";
			       push @horflist, $accnum;
	                       push @horflistdata, $dnastring;
	               }elsif($stopcodons[0] == 0 && $stopcodons[1] == 0  && $stopcodons[3] == 0 && $stopcodons[4] == 0 && $stopcodons[6] == 0 && $stopcodons[7] == 0  ){
	
	                       $morftype = "horf";
			       push @horflist, $accnum;
	                       push @horflistdata, $dnastring;
	               }else{
		       		
				$morftype = "??";
				errorwarning("Did not recognize Morf type for: $seqlist[$lcv]", "ERROR");
				
				
			}
			sub trimwhitespace($){

				my $string = shift;
				$string =~ s/^\s+//;
				$string =~ s/\s+$//;
				return $string;
			}
			open(MRFDBG, ">>morfdebug.txt");
			print MRFDBG "$seqlist[$lcv]\t$morftype\t";
			for(0..8){
				print MRFDBG "$stopcodons[$_]\t";
			}
			print MRFDBG "\n";
			close MRFDBG;
	               print FILE "\tMorf Type: $morftype\n";
	               print FILE "\n\n\n\n\n\n\n\n\n\n\n";
	               if($fileoutputchoice eq "indvidfil"){
	                       #change the individual file name to represent morf
	                       `mv $outdir$runname.$seqlist[$lcv].codonanalysis.txt	    $outdir$runname.$seqlist[$lcv].codonanalysis.$morftype.txt `;
	                       
	               }
		       #outputspeical list if it was enabled
		       if($sixtyfourcodonlist eq "yes"){
		       		print "\tOutputting special 64 Codon List Table\n";
				my ($set1, $set2, $set3, $set4, $counter) = 0;
		       		print SFFILE "$runname-$seqlist[$lcv]\n";
		       		foreach my $key (sort {$sixtyfourlisthash{$a} <=> $sixtyfourlisthash{$b}} keys %sixtyfourlisthash){ 
					#print SFFILE " $sixtyfourlisthash = $sixtyfourlisthash{$key}\n"; 
					#print SFFILE " $key\t$sixtyfourlisthash{$key}\n";
					printf SFFILE "%-4s%-18s",$counter+1, $key;
					printf SFFILE "%5.1f", $sixtyfourlisthash{$key};
					print SFFILE "\n";
					
					if($counter < 16){
						$set1 += $sixtyfourlisthash{$key};
					}
					elsif($counter < 32){
						$set2 += $sixtyfourlisthash{$key};
					}elsif($counter < 48){
						$set3 += $sixtyfourlisthash{$key};
					}elsif($counter < 64){
						$set4 += $sixtyfourlisthash{$key};
					}
					$counter++;
					
				};
				printf SFFILE "Set 1 - 16%5s%5.1f", "", $set1;
				printf SFFILE "\nSet 17 - 32%5s%5.1f", "", $set2;
				printf SFFILE "\nSet 33 - 48%5s%5.1f", "", $set3;
				printf SFFILE "\nSet 49 - 64%5s%5.1f", "", $set4;
				print SFFILE "\n\n\n";
			}
			%sixtyfourlisthash = ();
		       #and to end the accessnion number for this run make the graph
		       if($graphyon == 1){  #wooohoo lets make the graph
		       		#open(GFILE, ">$runname.$seqlist[$lcv].graphdata.txt");
				$ENV{PGPLOT_DIR} = "/home/connare/unixapps/pgplot";
				$ENV{PGPLOT_FONT} = "/home/connare/unixapps/pgplot/grfont.data";
				$ENV{PGPLOT_RGB} = "/home/connare/unixapps/pgplot/rgb.txt";
				$ENV{PGPLOT_BACKGROUND} = "grey";
				$ENV{PGPLOT_FOREGROUND} = "black";
				#at only ->red
				#at rich ->yellow
				#gc rich ->blue
				#gc only -> green
				
				
				#need to make the four graphs now
				#so make graph
				print "\tMaking Graph...#1";
				#first graph
				pgbegin(0,'"temp.gif"/GIF',1,1);
				pgsci(1);
				#pgscr(0, 0,0,0); #black background for now until colors are fixed
				
				if($graphymax < 10){
					pgenv(0,64,0,10,0,0);	#setup enviroment
				}
				elsif($graphymax < 20){
					pgenv(0,64,0,20,0,0);	#setup enviroment
				}
				elsif($graphymax < 30){
					pgenv(0,64,0,30,0,0);	#setup enviroment
				}
				pglabel('X - Codon #',  'Percentage (%)',"Codon Analysis Graph $runname - $seqlist[$lcv] - Codons ");
				pgsch(.5);
				pgmtext('B', 5, 1, 1, "Sanjay Connare");
				pgmtext('B', 6, 1, 1, "Codon Analysis App $version");
				pgsch(.75);
				pgsci($atocolor);
				pgmtext('T', 1, 0, 1, "AT Only");
				pgsci($atrcolor);
				pgmtext('T', 2, 0, 1, "AT Rich");
				pgsci($gcrcolor);
				pgmtext('T', 3, 0, 1, "GC Rich");
				pgsci($gcocolor);
				pgmtext('T', 4, 0, 1, "GC Only");
				pgsch(1);
				#graph normal at only points for graph one
				pgsci($atocolor); #set red color
				foreach my $key (keys %graph1ato) { 
					#print "$key = $graph1ato{$key}\n"; 
					pgpoint(1, ($key +1), $graph1ato{$key}, $atosym);
				} 
				foreach my $key (keys %graph1atomultidef) { 
					#print "$key = $graph1atomultidef{$key}\n"; 
					pgpoint(1, ($key +1), $graph1atomultidef{$key}, $multidefsym);
				} 
				pgsci($atrcolor); #set yellow color
				foreach my $key (keys %graph1atr){
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key,  $graph1atr{$key}, $atrsym);
				}
				#now graph mutlidef orfs for atonly
				foreach my $key (keys %graph1atrmultidef){ 
				 	
				#	pgpoint(#, x, y, symbol);
					
					pgpoint(1, $key, $graph1atrmultidef{$key}, $multidefsym);
				}
				pgsci($gcrcolor); #set yellow color
				foreach my $key (keys %graph1gcr){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph1gcr{$key}, $gcrsym);
				}
				#now graph mutlidef orfs for atonly
				foreach my $key (keys %graph1gcrmultidef){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph1gcrmultidef{$key}, $multidefsym);
				}
				#now for gc only can do a one loop because no multiorfs
				pgsci($gcocolor); 
				foreach my $key (keys %graph1gco){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph1gco{$key}, $gcosym);
				}
				pgend();
				`mv temp.gif $outdir$runname.$seqlist[$lcv].Graph1.gif`; 
				print "...#2";
				#graph 2, totals so no multiorf check
				pgbegin(0,'"temp.gif"/GIF',1,1);
				pgsci(1);
				#pgscr(0, 0,0,0); #black background for now until colors are fixed
				if($graphymax < 10){
					pgenv(0,32,0,10,0,0);	#setup enviroment
				}
				elsif($graphymax < 20){
					pgenv(0,32,0,20,0,0);	#setup enviroment
				}
				elsif($graphymax < 30){
					pgenv(0,32,0,30,0,0);	#setup enviroment
				}
				pglabel('X - Codon #',  'Percentage (%)',"Codon Analysis Graph $runname - $seqlist[$lcv] - Codon Complements ");
				pgsch(.5);
				pgmtext('B', 5, 1, 1, "Sanjay Connare");
				pgmtext('B', 6, 1, 1, "Codon Analysis App $version");
				pgsch(.75);
				pgsci($atocolor);
				pgmtext('T', 1, 0, 1, "AT Only");
				pgsci($atrcolor);
				pgmtext('T', 2, 0, 1, "AT Rich");
				pgsci($gcrcolor);
				pgmtext('T', 3, 0, 1, "GC Rich");
				pgsci($gcocolor);
				pgmtext('T', 4, 0, 1, "GC Only");
				pgsch(1);
				#graph normal at only points for graph one
				pgsci($atocolor); #set red color
				my $counter = 0;
				foreach my $key (keys %graph2ato){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph2ato{$key}, $atosym);
				}
				pgsci($atrcolor); #set yellow color
				foreach my $key (keys %graph2atr){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph2atr{$key}, $atrsym);
				}
				#now graph mutlidef orfs for atonly
				pgsci($gcrcolor); #set yellow color
				foreach my $key (keys %graph2gcr){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph2gcr{$key}, $gcrsym);
				}
				#now graph mutlidef orfs for atonly for gc only can do a one loop because no multiorfs
				pgsci($gcocolor); #set yellow color
				foreach my $key (keys %graph2gco){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph2gco{$key}, $gcosym);
				}
				pgend();
				`mv temp.gif $outdir$runname.$seqlist[$lcv].Graph2.gif`; 
				
				
				#graph 3
				print "...#3";
				pgbegin(0,'"temp.gif"/GIF',1,1);
				pgsci(1);
				#pgscr(0, 0,0,0); #black background for now until colors are fixed
				if($graphymax < 10){
					pgenv(0,64,0,10,0,0);	#setup enviroment
				}
				elsif($graphymax < 20){
					pgenv(0,64,0,20,0,0);	#setup enviroment
				}
				elsif($graphymax < 30){
					pgenv(0,64,0,30,0,0);	#setup enviroment
				}
				pglabel('X - Codon #',  'Percentage (%)',"Codon Analysis Graph $runname - $seqlist[$lcv] - Triple Frequency ");
				pgsch(.5);
				pgmtext('B', 5, 1, 1, "Sanjay Connare");
				pgmtext('B', 6, 1, 1, "Codon Analysis App $version");
				pgsch(.75);
				pgsci($atocolor);
				pgmtext('T', 1, 0, 1, "AT Only");
				pgsci($atrcolor);
				pgmtext('T', 2, 0, 1, "AT Rich");
				pgsci($gcrcolor);
				pgmtext('T', 3, 0, 1, "GC Rich");
				pgsci($gcocolor);
				pgmtext('T', 4, 0, 1, "GC Only");
				pgsch(1);
				#graph normal at only points for graph one
				pgsci($atocolor); #set red color
				foreach my $key (keys %graph3ato) { 
					#print "$key = $graph1ato{$key}\n"; 
					pgpoint(1, ($key +1), $graph3ato{$key}, $atosym);
				} 
				foreach my $key (keys %graph3atomultidef) { 
					#print "$key = $graph1atomultidef{$key}\n"; 
					pgpoint(1, ($key +1), $graph3atomultidef{$key}, $multidefsym);
				} 
				pgsci($atrcolor); #set yellow color
				foreach my $key (keys %graph2atr){
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key,  $graph3atr{$key}, $atrsym);
				}
				#now graph mutlidef orfs for atonly
				foreach my $key (keys %graph3atrmultidef){ 
				 	
				#	pgpoint(#, x, y, symbol);
					
					pgpoint(1, $key, $graph3atrmultidef{$key}, $multidefsym);
				}
				pgsci($gcrcolor); #set yellow color
				foreach my $key (keys %graph3gcr){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph3gcr{$key}, $gcrsym);
				}
				#now graph mutlidef orfs for atonly
				foreach my $key (keys %graph3gcrmultidef){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph3gcrmultidef{$key}, $multidefsym);
				}
				#now for gc only can do a one loop because no multiorfs
				pgsci($gcocolor); 
				foreach my $key (keys %graph3gco){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph3gco{$key}, $gcosym);
				}
				pgend();
				`mv temp.gif $outdir$runname.$seqlist[$lcv].Graph3.gif`; 
				
				print "...#4\n";
				#graph 4
				pgbegin(0,'"temp.gif"/GIF',1,1);
				pgsci(1);
				#pgscr(0, 0,0,0); #black background for now until colors are fixed
				if($graphymax < 10){
					pgenv(0,32,0,10,0,0);	#setup enviroment
				}
				elsif($graphymax < 20){
					pgenv(0,32,0,20,0,0);	#setup enviroment
				}
				elsif($graphymax < 30){
					pgenv(0,32,0,30,0,0);	#setup enviroment
				}
				pglabel('X - Codon #',  'Percentage (%)',"Codon Analysis Graph $runname - $seqlist[$lcv] - Triple Frequency Complements ");
				pgsch(.5);
				pgmtext('B', 5, 1, 1, "Sanjay Connare");
				pgmtext('B', 6, 1, 1, "Codon Analysis App $version");
				pgsch(.75);
				pgsci($atocolor);
				pgmtext('T', 1, 0, 1, "AT Only");
				pgsci($atrcolor);
				pgmtext('T', 2, 0, 1, "AT Rich");
				pgsci($gcrcolor);
				pgmtext('T', 3, 0, 1, "GC Rich");
				pgsci($gcocolor);
				pgmtext('T', 4, 0, 1, "GC Only");
				pgsch(1);
				#graph normal at only points for graph one
				pgsci($atocolor); #set red color
				my $counter = 0;
				foreach my $key (keys %graph4ato){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph4ato{$key}, $atosym);
				}
				pgsci($atrcolor); #set yellow color
				foreach my $key (keys %graph4atr){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph4atr{$key}, $atrsym);
				}
				#now graph mutlidef orfs for atonly
				pgsci($gcrcolor); #set yellow color
				foreach my $key (keys %graph2gcr){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph4gcr{$key}, $gcrsym);
				}
				#now graph mutlidef orfs for atonly for gc only can do a one loop because no multiorfs
				pgsci($gcocolor); #set yellow color
				foreach my $key (keys %graph4gco){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph4gco{$key}, $gcosym);
				}
				pgend();
				`mv temp.gif $outdir$runname.$seqlist[$lcv].Graph4.gif`;
				
				$graphymax = 0;
				$graph2ymax = 0;
				#and now that graphs are complete clear variables so no data overlap or funny looking graphs
			        (%graph1ato,%graph1atr,%graph1gcr,%graph1gco) = ();
			        (%graph2ato,%graph2atr,%graph2gcr,%graph2gco) = ();
			        (%graph3ato,%graph3atr,%graph3gcr,%graph3gco) = ();
			        (%graph4ato,%graph4atr,%graph4gcr,%graph4gco) = ();
				#for codons with multiple definitions, need to store definition, codon # and actual data value
				#so, key will be codon # cuz thats whats needed for graph and data will be value
			        (%graph1atomultidef, %graph2atomultidef,%graph3atomultidef,%graph4atomultidef) = ();
			        (%graph1atrmultidef, %graph2atrmultidef,%graph3atrmultidef,%graph4atrmultidef) = ();
			        (%graph1gcrmultidef, %graph2gcrmultidef,%graph3gcrmultidef,%graph4gcrmultidef) = ();
			        (%graph1gcomultidef, %graph2gcomultidef,%graph3gcomultidef,%graph4gcomultidef) = ();
				
	        	}
		}
		
		
		
		
		
		
		
		
		sub processframe(){
			my %codonmatch = ();
			if($atgcmode eq "GC"){
				@codon = (	#Codon(A)	#Complement(B)
	
						"TTA",		 "TAA",
						"TAT",		 "ATA",
						"TTT",		 "AAA",
						"AAT",		 "ATT",
						"CTA",		 "TAG",
						"ACT",		 "AGT",
						"TAC",		 "GTA",
						"TCT",		 "AGA",
						"AAG",		 "CTT",
						"TTC",		 "GAA",
						"ACA",		 "TGT",
						"TTG",		 "CAA",
						"AAC",		 "GTT",
						"ATG",		 "CAT",
						"TCA",		 "TGA",
						"ATC",		 "GAT",
						"AGC",		 "GCT",
						"CTG",		 "CAG",
						"TGC",		 "GCA",
						"TCC",		 "GGA",
						"AGG",		 "CCT",
						"GAG",		 "CTC",
						"GTG",		 "CAC",
						"TGG",		 "CCA",
						"ACC",		 "GGT",
						"ACG",		 "CGT",
						"GTC",		 "GAC",
						"TCG",		 "CGA",
						"GGG",		 "CCC",
						"GGC",		 "GCC",
						"CGG",		 "CCG",
						"GCG",		 "CGC"
				);
				#used to speed up so do not have to use for loop when codon found
				#can just call the number and insert into the array
				%codonmatch = (	#Codon(A)	#Complement(B)
	
					"TTA"=> 0,	       "TAA"=> 1,
					"TAT"=> 2,	       "ATA"=> 3,
					"TTT"=> 4,	       "AAA"=> 5,
					"AAT"=> 6,	       "ATT"=> 7,
					"CTA"=> 8,	       "TAG"=> 9,
					"ACT"=> 10,	       "AGT"=> 11,
					"TAC"=> 12,	       "GTA"=> 13,
					"TCT"=> 14,	       "AGA"=> 15,
					"AAG"=> 16,	       "CTT"=> 17,
					"TTC"=> 18,	       "GAA"=> 19,
					"ACA"=> 20,	       "TGT"=> 21,
					"TTG"=> 22,	       "CAA"=> 23,
					"AAC"=> 24,	       "GTT"=> 25,
					"ATG"=> 26,	       "CAT"=> 27,
					"TCA"=> 28,	       "TGA"=> 29,
					"ATC"=> 30,	       "GAT"=> 31,
					"AGC"=> 32,	       "GCT"=> 33,
					"CTG"=> 34,	       "CAG"=> 35,
					"TGC"=> 36,	       "GCA"=> 37,
					"TCC"=> 38,	       "GGA"=> 39,
					"AGG"=> 40,	       "CCT"=> 41,
					"GAG"=> 42,	       "CTC"=> 43,
					"GTG"=> 44,	       "CAC"=> 45,
					"TGG"=> 46,	       "CCA"=> 47,
					"ACC"=> 48,	       "GGT"=> 49,
					"ACG"=> 50,	       "CGT"=> 51,
					"GTC"=> 52,	       "GAC"=> 53,
					"TCG"=> 54,	       "CGA"=> 55,
					"GGG"=> 56,	       "CCC"=> 57,
					"GGC"=> 58,	       "GCC"=> 59,
					"CGG"=> 60,	       "CCG"=> 61,
					"GCG"=> 62,	       "CGC"=> 63
				);
			}
			elsif($atgcmode eq "AT"){
	
		 		@codon = (	      #Codon(A)       #Complement(B)
		    	    
		    	     	     "GGG",	      "CCC",
		    	     	     "GGC",	      "GCC",
		    	     	     "CCG",	      "CGG",
		    	     	     "CTA",	      "TAG",
		    	     	     "GCG",	      "CGC",
		    	     	     "GAG",	      "CTC",
		    	     	     "CCT",	      "AGG",
		    	     	     "GGT",	      "ACC",
		    	     	     "GAC",	      "GTC",
		    	     	     "GTG",	      "CAC",
		    	     	     "CCA",	      "TGG",
		    	     	     "GGA",	      "TCC",
		    	     	     "CGA",	      "TCG",
		    	     	     "CAG",	      "CTG",
		    	     	     "ATG",	      "CAT",
		    	     	     "ATA",	      "TAT",
		    	     	     "GCT",	      "AGC",
		    	     	     "GCA",	      "TGC",
		    	     	     "ACT",	      "AGT",
		    	     	     "GTA",	      "TAC",
		    	     	     "GAT",	      "ATC",
		    	     	     "CGT",	      "ACG",
		    	     	     "TCA",	      "TGA",
		    	     	     "ACA",	      "TGT",
		    	     	     "TTA",	      "TAA",
		    	     	     "AGA",	      "TCT",
		    	     	     "GTT",	      "AAC",
		    	     	     "AAT",	      "ATT",
		    	     	     "CAA",	      "TTG",
		    	     	     "AAG",	      "CTT",
		    	     	     "GAA",	      "TTC",
		 	     	     "AAA",	      "TTT",
			);
			%codonmatch = (	#Codon(A)	#Complement(B)
	
					"GGG"=> 0, 		 "CCC"=> 1,
					"GGC"=> 2, 		 "GCC"=> 3,
					"CCG"=> 4, 		 "CGG"=> 5,
					"CTA"=> 6, 		 "TAG"=> 7,
					"GCG"=> 8, 		 "CGC"=> 9,
					"GAG"=> 10,		 "CTC"=> 11,
					"CCT"=> 12,		 "AGG"=> 13,
					"GGT"=> 14,		 "ACC"=> 15,
					"GAC"=> 16,		 "GTC"=> 17,
					"GTG"=> 18,		 "CAC"=> 19,
					"CCA"=> 20,		 "TGG"=> 21,
					"GGA"=> 22,		 "TCC"=> 23,
					"CGA"=> 24,		 "TCG"=> 25,
					"CAG"=> 26,		 "CTG"=> 27,
					"ATG"=> 28,		 "CAT"=> 29,
					"ATA"=> 30,		 "TAT"=> 31,
					"GCT"=> 32,		 "AGC"=> 33,
					"GCA"=> 34,		 "TGC"=> 35,
					"ACT"=> 36,		 "AGT"=> 37,
					"GTA"=> 38,		 "TAC"=> 39,
					"GAT"=> 40,		 "ATC"=> 41,
					"CGT"=> 42,		 "ACG"=> 43,
					"TCA"=> 44,		 "TGA"=> 45,
					"ACA"=> 46,		 "TGT"=> 47,
					"TTA"=> 48,		 "TAA"=> 49,
					"AGA"=> 50,		 "TCT"=> 51,
					"GTT"=> 52,		 "AAC"=> 53,
					"AAT"=> 54,		 "ATT"=> 55,
					"CAA"=> 56,		 "TTG"=> 57,
					"AAG"=> 58,		 "CTT"=> 59,
					"GAA"=> 60,		 "TTC"=> 61,
					"AAA"=> 62,		 "TTT"=> 63
			);
	
	}
			my @countresults = ("0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0",
						"0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0",
						"0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0",
						"0","0","0","0");
			my ($framenum, @seq) = @_;  #store framenumber and the sequencedata coming in
			my $count = 0; #used to count in 3s
			my $code = "";
			#print "@seq\n";
			foreach(@seq){  #now go through each of the sequences 
				$count++;
				$code = $code . $_;
				if($count == 3){  #if we have 3 characters then find the codon it matches with
					
					my $position = $codonmatch{$code} unless not defined $codonmatch{$code};
					
					#used for deubbing increment
					#print "$code has $countresults[$position], position is $position and now has ";
					
					#sleep(1);  
					#account for N's in sequence and such eg echeck sequence Q7PIK8
					#print "$code - $position\n";
					if($codonmatch{$code}){
						$countresults[$position]++;
					}
					elsif($position == 0){
						#need to manually increment the value
						 $countresults[0]++;
					}	
					else{
						errorwarning("Could not increment count for $code", "ERROR");

					
					}
					
					#print "$countresults[$position]\n";
					#reset values, even if improper codon
					$count = 0;
					$code = "";
					
				}	
			}
			
			return @countresults;
		
		}

	}
	
	
	close FILE; #closes the last sequence file and opens the final result
	
	#begin grand total totals for entire run
	
	
	print "Starting grand total run for MORF: $morfrun\n";
	if($morfrun eq "off"){
		open (FILE, ">$outdir$runname.TOTAL.codonanalysis.txt");
	}
	else{
		open (FILE, ">$outdir$runname.$morfrun.TOTAL.codonanalysis.txt");
	}
	print FILE "$appname - $version\t\tWritten By: $author\n";
	print FILE "Session Variables:\nCodon Analysis in dir ";
	print FILE  `pwd`;
	print FILE "Runname: $runname\tRun Date: ";
	print FILE `date`;
	print FILE "Mode: $atgcmode\tColumn Sort: $columnsort-$columnsortupdown Swap Mode: $swapifbigger Graph: $graphyon\t";
	if(!($morfrun eq "off")){	
		
			print FILE "MORF Run: $morfrun";
	}
	else{
		print FILE "MORF Run: All";
	
	}
	print FILE "\n\n";
	
	if($morfrun eq "off" && $sixtyfourcodonlist eq "yes" ){
		open (SFFILE, ">$outdir$runname.TOTAL.64codonlist.txt");
	}
	elsif($sixtyfourcodonlist eq "yes"){
		open (SFFILE, ">$outdir$runname.$morfrun.TOTAL.64codonlist.txt");
	}
	print SFFILE "$appname - $version\t\tWritten By: $author\n";
	print SFFILE "Session Variables:\nCodon Analysis in dir ";
	print SFFILE  `pwd`;
	print SFFILE "Runname: $runname\tRun Date: ";
	print SFFILE `date`;
	print SFFILE "Mode: $atgcmode\tColumn Sort: $columnsort-$columnsortupdown Swap Mode: $swapifbigger Graph: $graphyon\t";
	if(!($morfrun eq "off")){	
		
			print SFFILE "MORF Run: $morfrun";
	}
	else{
		print SFFILE "MORF Run: All";
	
	}
	#now that all of the codon output has been finished do a total for the total output
	
	#clear variables so more memory is avail
	@seqlist = ();
	@seqdata = ();
	
	#however before we do that, lets sort the totals, if we need to
	#now that the ouput is stored and formatted lets sort it the way we want to
		
		my @notsorted = ();
		my %sortinghash = ();
		if( $columnsort != 0){
		if($atgcmode eq "GC"){
			@codon = (	#Codon(A)	#Complement(B)
	
					"TTA",		 "TAA",
					"TAT",		 "ATA",
					"TTT",		 "AAA",
					"AAT",		 "ATT",
					"CTA",		 "TAG",
					"ACT",		 "AGT",
					"TAC",		 "GTA",
					"TCT",		 "AGA",
					"AAG",		 "CTT",
					"TTC",		 "GAA",
					"ACA",		 "TGT",
					"TTG",		 "CAA",
					"AAC",		 "GTT",
					"ATG",		 "CAT",
					"TCA",		 "TGA",
					"ATC",		 "GAT",
					"AGC",		 "GCT",
					"CTG",		 "CAG",
					"TGC",		 "GCA",
					"TCC",		 "GGA",
					"AGG",		 "CCT",
					"GAG",		 "CTC",
					"GTG",		 "CAC",
					"TGG",		 "CCA",
					"ACC",		 "GGT",
					"ACG",		 "CGT",
					"GTC",		 "GAC",
					"TCG",		 "CGA",
					"GGG",		 "CCC",
					"GGC",		 "GCC",
					"CGG",		 "CCG",
					"GCG",		 "CGC"
			);
			
			
	}
	elsif($atgcmode eq "AT"){
	
		 @codon = (	      #Codon(A)       #Complement(B)
		    	    
		    	     	     "GGG",	      "CCC",
		    	     	     "GGC",	      "GCC",
		    	     	     "CCG",	      "CGG",
		    	     	     "CTA",	      "TAG",
		    	     	     "GCG",	      "CGC",
		    	     	     "GAG",	      "CTC",
		    	     	     "CCT",	      "AGG",
		    	     	     "GGT",	      "ACC",
		    	     	     "GAC",	      "GTC",
		    	     	     "GTG",	      "CAC",
		    	     	     "CCA",	      "TGG",
		    	     	     "GGA",	      "TCC",
		    	     	     "CGA",	      "TCG",
		    	     	     "CAG",	      "CTG",
		    	     	     "ATG",	      "CAT",
		    	     	     "ATA",	      "TAT",
		    	     	     "GCT",	      "AGC",
		    	     	     "GCA",	      "TGC",
		    	     	     "ACT",	      "AGT",
		    	     	     "GTA",	      "TAC",
		    	     	     "GAT",	      "ATC",
		    	     	     "CGT",	      "ACG",
		    	     	     "TCA",	      "TGA",
		    	     	     "ACA",	      "TGT",
		    	     	     "TTA",	      "TAA",
		    	     	     "AGA",	      "TCT",
		    	     	     "GTT",	      "AAC",
		    	     	     "AAT",	      "ATT",
		    	     	     "CAA",	      "TTG",
		    	     	     "AAG",	      "CTT",
		    	     	     "GAA",	      "TTC",
		 	     	     "AAA",	      "TTT",
			);
	
	}
		
			#from the current data make a multidimensional array
			#by calculating the current numbers and such to be sorted
			$graphymax = 0;
			#and now that graphs are complete clear variables so no data overlap or funny looking graphs
		        (%graph1ato,%graph1atr,%graph1gcr,%graph1gco) = ();
		        (%graph2ato,%graph2atr,%graph2gcr,%graph2gco) = ();
		        (%graph3ato,%graph3atr,%graph3gcr,%graph3gco) = ();
		        (%graph4ato,%graph4atr,%graph4gcr,%graph4gco) = ();
			#for codons with multiple definitions, need to store definition, codon # and actual data value
			#so, key will be codon # cuz thats whats needed for graph and data will be value
		        (%graph1atomultidef, %graph2atomultidef,%graph3atomultidef,%graph4atomultidef) = ();
		        (%graph1atrmultidef, %graph2atrmultidef,%graph3atrmultidef,%graph4atrmultidef) = ();
		        (%graph1gcrmultidef, %graph2gcrmultidef,%graph3gcrmultidef,%graph4gcrmultidef) = ();
		        (%graph1gcomultidef, %graph2gcomultidef,%graph3gcomultidef,%graph4gcomultidef) = ();
			#print "Starting frame counts...\n";
			for(my $lcvb = 0; $lcvb < @codon; $lcvb += 2){
				#print "Proccessing $codon[$lcvb] and $codon[$lcvb+1]\n";
				my $frame1a = 100 * ($frame1grandtotalcount[$lcvb]/$frame1grandtotcodon);
				my $frame1b = 100 *($frame1grandtotalcount[$lcvb + 1] /$frame1grandtotcodon);
				my $frame2a = 100 * ($frame2grandtotalcount[$lcvb]/$frame2grandtotcodon);
				my $frame2b = 100 *($frame2grandtotalcount[$lcvb + 1] /$frame2grandtotcodon);
				my $frame3a = 100 * ($frame3grandtotalcount[$lcvb]/$frame3grandtotcodon);
				my $frame3b = 100 *($frame3grandtotalcount[$lcvb + 1] /$frame3grandtotcodon);
				my $totala =  100 * (($frame1grandtotalcount[$lcvb] + $frame2grandtotalcount[$lcvb] + $frame3grandtotalcount[$lcvb]) / ($frame1grandtotcodon + $frame2grandtotcodon + $frame3grandtotcodon));
				my $totalb = 100 * (($frame1grandtotalcount[$lcvb +1] + $frame2grandtotalcount[$lcvb +1] + $frame3grandtotalcount[$lcvb +1]) / ($frame1grandtotcodon + $frame2grandtotcodon + $frame3grandtotcodon));
				my $codona = $codon[$lcvb];
				my $codonb = $codon[$lcvb+1];
				
				
				#only push into this arrary if sorting otherwise who cares, surely not me!
				if($columnsort > 0){
					#this variable is used to add sorting values to the hash
					push @notsorted, [ $codona, $codonb, $frame1a, $frame1b, $frame1a + $frame1b, $frame2a, $frame2b, $frame2a + $frame2b, $frame3a, $frame3b, $frame3a + $frame3b, $totala, $totalb, $totala + $totalb];
				}
			
			}
		
			#so add the value to the hash and link it to the codon which is on its line
			#print "Creating sorting hash\n";
				for(0..31){
					#hash ->codon ->linkes to sort value
					#may need to be revesred not sure yet
					#print "$notsorted[$_][$columnsort] - $notsorted[$_][0]\n";
					if($morfrun eq "off"){
						if(exists($sortinghash{$notsorted[$_][0]})){
							errorwarning("$notsorted[$_][0] already exists.  You need to fix your codon Tables", "ERROR");
							sleep(3);
						}
					}
						#add value to hash codon  line = whatever value pulled from column
						$sortinghash{$notsorted[$_][0]} = $notsorted[$_][$columnsort];
				}
			
			#now the data has been sorted so now return it to the original arrays so it can be outputted correctly
			#clear the main variables then add the sorted data into them
			@frame1grandtotalcount = ();
			@frame2grandtotalcount = ();
			@frame3grandtotalcount = ();
			@codon = ();
			#print "Begin sorting...\n";
			
			#so now figure out how to actually sort the data
			if ($columnsortupdown eq "asc"){
			foreach my $key (sort {$sortinghash{$a} <=> $sortinghash{$b}} keys %sortinghash) { 
			
				
				#so find line where codon is matched
				#print "$key = $sortinghash{$key} \n";
				
				for(0..31){
				
					if($notsorted[$_][0] eq $key){ #then this is the line you want to use
							
						
					
						#this puts everything back into the original arrays but now they are sorted
						#change the numbers back from their final output numbers to their raw numbers
						push @frame1grandtotalcount, ($notsorted[$_][2]/100)*$frame1grandtotcodon; 
						push @frame1grandtotalcount, ($notsorted[$_][3]/100)*$frame1grandtotcodon;
						
						push @frame2grandtotalcount, ($notsorted[$_][5]/100)*$frame2grandtotcodon;
						push @frame2grandtotalcount, ($notsorted[$_][6]/100)*$frame2grandtotcodon;
						
						push @frame3grandtotalcount, ($notsorted[$_][8]/100)*$frame3grandtotcodon;
						push @frame3grandtotalcount, ($notsorted[$_][9]/100)*$frame3grandtotcodon;
							
						push @codon, $notsorted[$_][0]; #add first codon
						push @codon, $notsorted[$_][1];

					} #end of if for checking if equals key
				} #end of for lop
			} #end of foreach key loop
			}#end of if asc loop
			else{ #default and desc
			
			foreach my $key (sort {$sortinghash{$b} <=> $sortinghash{$a}} keys %sortinghash) { 
			
				
				#so find line where codon is matched
				#print "$key = $sortinghash{$key} \n";
				
				for(0..31){
				
					if($notsorted[$_][0] eq $key){ #then this is the line you want to use
							
						
					
						#this puts everything back into the original arrays but now they are sorted
						#change the numbers back from their final output numbers to their raw numbers
						push @frame1grandtotalcount, ($notsorted[$_][2]/100)*$frame1grandtotcodon; 
						push @frame1grandtotalcount, ($notsorted[$_][3]/100)*$frame1grandtotcodon;
						
						push @frame2grandtotalcount, ($notsorted[$_][5]/100)*$frame2grandtotcodon;
						push @frame2grandtotalcount, ($notsorted[$_][6]/100)*$frame2grandtotcodon;
						
						push @frame3grandtotalcount, ($notsorted[$_][8]/100)*$frame3grandtotcodon;
						push @frame3grandtotalcount, ($notsorted[$_][9]/100)*$frame3grandtotcodon;
							
						push @codon, $notsorted[$_][0]; #add first codon
						push @codon, $notsorted[$_][1];

					} #end of if for checking if equals key
				} #end of for lop
			} #end of foreach key loop
			
			
			
			
			
			
			
			
			}		
			
			
			
			
		} #end of if statement for checking to see if sorting will be done
		#now that sorting is finished lets see if undefine the hash works
	#print "Begin file output\n";
	my $outputsidecounter = 1;
	print FILE "--Totals\n";
	print FILE "                               FRAME 1:        FRAME 2:        FRAME 3:         TOTAL\n";
	print FILE " Codon(A):  Complement(B):  A    B   A+B    A    B   A+B    A    B   A+B    A    B   A+B\n";
		for(my $lcvb = 0; $lcvb < @codon; $lcvb += 2){
			#print "Proccesing $codon[$lcvb] and $codon[$lcvb+1]\n";
			my $frame1a = 100 * ($frame1grandtotalcount[$lcvb]/$frame1grandtotcodon);
			my $frame1b = 100 *($frame1grandtotalcount[$lcvb + 1] /$frame1grandtotcodon);
			my $frame2a = 100 * ($frame2grandtotalcount[$lcvb]/$frame2grandtotcodon);
			my $frame2b = 100 *($frame2grandtotalcount[$lcvb + 1] /$frame2grandtotcodon);
			my $frame3a = 100 * ($frame3grandtotalcount[$lcvb]/$frame3grandtotcodon);
			my $frame3b = 100 *($frame3grandtotalcount[$lcvb + 1] /$frame3grandtotcodon);
			my $totala =  100 * (($frame1grandtotalcount[$lcvb] + $frame2grandtotalcount[$lcvb] + $frame3grandtotalcount[$lcvb]) / ($frame1grandtotcodon + $frame2grandtotcodon + $frame3grandtotcodon));
			my $totalb = 100 * (($frame1grandtotalcount[$lcvb +1] + $frame2grandtotalcount[$lcvb +1] + $frame3grandtotalcount[$lcvb +1]) / ($frame1grandtotcodon + $frame2grandtotcodon + $frame3grandtotcodon));
			
			
			
			if($sixtyfourcodonlist eq "yes"){
				#the option to output a special list has been turned on so
				#add to the hash which will then be sorted.
				$sixtyfourlisthash{"$codon[$lcvb]-$dnaseqtoaa{$codon[$lcvb]}"} = $frame1a;
				$sixtyfourlisthash{"$codon[$lcvb+1]-$dnaseqtoaa{$codon[$lcvb+1]}"} = $frame1b; 
				
			}
			
			
			
			
			
			#calculate graph data
			#print "Calculating graph data if nessesary\n";
			if(exists($codondisttype{$codon[$lcvb]})) { #whcih there should be no reason why it doesn't exist
			

				if($codondisttype{$codon[$lcvb]} eq "AT Only"){
					#this line of outputting is at only so record vlaues in at only dist array
					
					#figure out if multidef codon or not
					if($codon[$lcvb] eq "TAA" || $codon[$lcvb] eq "ATA" || $codon[$lcvb] eq "AAA"){
						#multi def codon so add to special list
						$graph1atomultidef{$lcvb} = $frame1a; 
						$graph3atomultidef{$lcvb} = $frame3a;
						 
					}elsif($codon[$lcvb+1] eq "TAA" || $codon[$lcvb+1] eq "ATA" || $codon[$lcvb+1] eq "AAA"){
						$graph1atomultidef{$lcvb+1} = $frame1b; 
						$graph3atomultidef{$lcvb+1} = $frame3b; 
						
						
					
					}
					if(!(exists($graph1atomultidef{$lcvb}))){
							$graph1ato{$lcvb} =  $frame1a;
							$graph3ato{$lcvb} =  $totala;
					}
					if(!(exists($graph1atomultidef{$lcvb+1}))){
							$graph1ato{$lcvb+1} =  $frame1b;
							$graph3ato{$lcvb+1} =  $totalb;
					}
					
					$graph2ato{$outputsidecounter} = $frame1a + $frame1b;  #becuase lcvb is incremented by 2s, use row num
					$graph4ato{$outputsidecounter} = ($totala + $totalb);
					
				
				}
				elsif($codondisttype{$codon[$lcvb]} eq "AT Rich"){
				
					#figure out if multidef codon or not
					if($codon[$lcvb] eq "CTA" || $codon[$lcvb] eq "TAG" || $codon[$lcvb] eq "AGA" || $codon[$lcvb] eq "CTT" || $codon[$lcvb] eq "TTG" || $codon[$lcvb] eq "ATG" || $codon[$lcvb] eq "TGA"){
						#multi def codon so add to special list
						$graph1atrmultidef{$lcvb} = $frame1a; 
						$graph3atrmultidef{$lcvb} = $totala;
						 
					}elsif($codon[$lcvb+1] eq "CTA" || $codon[$lcvb+1] eq "TAG" || $codon[$lcvb+1] eq "AGA" || $codon[$lcvb+1] eq "CTT" || $codon[$lcvb+1] eq "TTG" || $codon[$lcvb+1] eq "ATG" || $codon[$lcvb+1] eq "TGA"){
						$graph1atrmultidef{$lcvb+1} = $frame1b; 
						$graph3atrmultidef{$lcvb+1} = $totalb; 
					
						
					
					}
					if(!(exists($graph1atrmultidef{$lcvb}))){
							$graph1atr{$lcvb} =  $frame1a;
							$graph3atr{$lcvb} =  $totala;
					}
					if(!(exists($graph1atrmultidef{$lcvb+1}))){
							$graph1atr{$lcvb+1} =  $frame1b;
							$graph3atr{$lcvb+1} =  $totalb;
					}
					
					$graph2atr{$outputsidecounter} = $frame1a + $frame1b;
					$graph4atr{$outputsidecounter} = ($totala + $totalb);
					
				}elsif($codondisttype{$codon[$lcvb]} eq "GC Rich"){
				
					#figure out if multidef codon or not
					if($codon[$lcvb] eq "CTG" || $codon[$lcvb] eq "AGG" || $codon[$lcvb] eq "CTC" || $codon[$lcvb] eq "GTG"){
						#multi def codon so add to special list
						$graph1gcrmultidef{$lcvb} = $frame1a; 
						$graph3gcrmultidef{$lcvb} = $totala;
						 
					}elsif($codon[$lcvb+1] eq "CTG" || $codon[$lcvb+1] eq "AGG" || $codon[$lcvb+1] eq "CTC" || $codon[$lcvb+1] eq "GTG"){
						$graph1gcrmultidef{$lcvb+1} = $frame1b; 
						$graph3gcrmultidef{$lcvb+1} = $totalb; 
					
						
					
					}
					if(!(exists($graph1gcrmultidef{$lcvb}))){
							$graph1gcr{$lcvb} =  $frame1a;
							$graph3gcr{$lcvb} = $totala;
					}
					if(!(exists($graph1gcrmultidef{$lcvb+1}))){
							$graph1gcr{$lcvb+1} =  $frame1b;
							$graph3gcr{$lcvb+1} =  $totalb;
					}
					
					$graph2gcr{$outputsidecounter} = $frame1a + $frame1b;
					$graph4gcr{$outputsidecounter} = ($totala + $totalb);
				}
				elsif($codondisttype{$codon[$lcvb]} eq "GC Only"){
				
					#don't need checks for orf cuz gc only doesnt have ne
					$graph1gco{$lcvb} =  $frame1a;
					$graph3gco{$lcvb} =  $totala;
					$graph1gco{$lcvb+1} =  $frame1b;
					$graph3gco{$lcvb+1} =  $totalb;
					
					$graph2gco{$outputsidecounter} = $frame1a + $frame1b;
					$graph4gco{$outputsidecounter} = ($totala + $totalb);
						
					
					
				}
				#now check max values for graph
				if($graphymax < ($totala + $totalb)) {
					$graphymax = ($totala + $totalb);
				}
				if($graph2ymax < ($frame1a + $frame1b)) {
					$graph2ymax = ($frame1a + $frame1b);

				}
				
			
			
			
			}
			
			
			#print "Printing row (swaping if required)...\n";
			if($swapifbigger  == 0) { #nope it wasn't so output as normal
			
				printf FILE "%2s%5s-%-4s%4s%4s-%-4s", $outputsidecounter++, $codon[$lcvb] ,$dnaseqtoaa{$codon[$lcvb]},  "" ,$codon[$lcvb+1], $dnaseqtoaa{$codon[$lcvb+1]};
				printf FILE "%5.1f" , $frame1a;
				printf FILE "%5.1f" , $frame1b;
				printf FILE "%5.1f",  $frame1a + $frame1b;
				printf FILE "%2s";
				printf FILE "%5.1f" , $frame2a;
				printf FILE "%5.1f" , $frame2b;
				printf FILE "%5.1f", $frame2a + $frame2b;
				printf FILE "%5.1f" , $frame3a;
				printf FILE "%5.1f" , $frame3b;
				printf FILE "%5.1f",  $frame3a + $frame3b;
				printf FILE "%1s";
				printf FILE "%5.1f", $totala;
				printf FILE "%5.1f", $totalb; 
				printf FILE "%5.1f", $totala + $totalb;
				print FILE "\n";
			}
			elsif($swapifbigger == 1){ #option was turned on 
				
				#see if codons need to be switched first
				if( ($frame1b > $frame1a) || ($totalb > $totala)){
					#print "swap needed\n";
					#yes they do since there somewhere where b is greater than a
					#so reverse the codons
					printf FILE "%2s%5s-%-4s%4s%4s-%-4s", $outputsidecounter++, $codon[$lcvb +1] ,$dnaseqtoaa{$codon[$lcvb+1]},  "" ,$codon[$lcvb], $dnaseqtoaa{$codon[$lcvb]};
				
				
				}
				else{  #Nope
				
					printf FILE "%2s%5s-%-4s%4s%4s-%-4s", $outputsidecounter++, $codon[$lcvb] ,$dnaseqtoaa{$codon[$lcvb]},  "" ,$codon[$lcvb+1], $dnaseqtoaa{$codon[$lcvb+1]};

				}
				
				
				#now check if frame1b is grater than frame1a
				if($frame1b > $frame1a){
					printf FILE "%5.1f" , $frame1b;
					printf FILE "%5.1f" , $frame1a;
		
				}
				else{
					printf FILE "%5.1f" , $frame1a;
					printf FILE "%5.1f" , $frame1b;
				}
				printf FILE "%5.1f",  $frame1a + $frame1b;
				printf FILE "%2s";
				printf FILE "%5.1f" , $frame2a;
				printf FILE "%5.1f" , $frame2b;
				printf FILE "%5.1f", $frame2a + $frame2b;
				printf FILE "%5.1f" , $frame3a;
				printf FILE "%5.1f" , $frame3b;
				printf FILE "%5.1f",  $frame3a + $frame3b;
				printf FILE "%1s";
				
				
				#print "priting totals\n";
				
				if($totalb > $totala){
					
					printf FILE "%5.1f", $totalb;
					printf FILE "%5.1f", $totala;
				}
				else{
					printf FILE "%5.1f", $totala;
					printf FILE "%5.1f", $totalb; 
				}
				
				printf FILE "%5.1f", $totala + $totalb;
				print FILE "\n";
			
			}
			
		}
		
		
	#here is the math for calculating distribution.. kinda  abit long
	 
	 #this needs to be rewritten because it is what crashes the damn program when
	 #proccessing lists of over a couple thousand
	
	
	
	#so what we need to do is take everything in memory the frame1grandtotalcount, frame2grandtotalcount and frame3 etc
	#and write out each of these items to a file, then clear the variables so there is memory to the math	
	
	
	
	#so clear all the data variables by outputting them
	my $filecounter =0;
	foreach(@frame1grandtotalcount){
		my $fname = "frame1distgtotal_$filecounter.txt";
		my $numbdata = $_;
		my @filedta = ($fname, $numbdata);
		fileouttxt($fname, $numbdata); 
		$filecounter++;
	}
	$filecounter =0;
	foreach(@frame2grandtotalcount){
		my $fname = "frame2distgtotal_$filecounter.txt";
		my $numbdata = $_;
		my @filedta = ($fname, $numbdata);
		fileouttxt($fname, $numbdata); 
		$filecounter++;
	}
	$filecounter =0;
	foreach(@frame3grandtotalcount){
		my $fname = "frame3distgtotal_$filecounter.txt";
		my $numbdata = $_;
		my @filedta = ($fname, $numbdata);
		fileouttxt($fname, $numbdata); 
		$filecounter++;
	}
	@frame1grandtotalcount = ();
	@frame2grandtotalcount = ();
	@frame3grandtotalcount = ();
	
	
	
	
	#then ok do the math now that memory is cleared up
	 	#print "Doing math on Frame1 Distrubtion totals\n";
		
		
		
		push @frame1distgtotal, 100 * ( (fileintxt("frame1distgtotal_0.txt")  + fileintxt("frame1distgtotal_1.txt") + fileintxt("frame1distgtotal_2.txt") + fileintxt("frame1distgtotal_3.txt") 
					+ fileintxt("frame1distgtotal_4.txt") + fileintxt("frame1distgtotal_5.txt") + fileintxt("frame1distgtotal_6.txt") + fileintxt("frame1distgtotal_7.txt") )/$frame1grandtotcodon);
		push @frame1distgtotal, 100 * ((fileintxt("frame1distgtotal_8.txt") + fileintxt("frame1distgtotal_8.txt") + fileintxt("frame1distgtotal_10.txt") + fileintxt("frame1distgtotal_11.txt")
					+ fileintxt("frame1distgtotal_12.txt") + fileintxt("frame1distgtotal_13.txt"))/$frame1grandtotcodon);
		push @frame1distgtotal, 100 * ((fileintxt("frame1distgtotal_14.txt") + fileintxt("frame1distgtotal_15.txt") + fileintxt("frame1distgtotal_16.txt") + fileintxt("frame1distgtotal_17.txt")
					+ fileintxt("frame1distgtotal_18.txt") + fileintxt("frame1distgtotal_19.txt"))/$frame1grandtotcodon);
		push @frame1distgtotal, 100 * ((fileintxt("frame1distgtotal_20.txt") + fileintxt("frame1distgtotal_21.txt") + fileintxt("frame1distgtotal_22.txt") + fileintxt("frame1distgtotal_23.txt")
					+ fileintxt("frame1distgtotal_24.txt") + fileintxt("frame1distgtotal_25.txt"))/$frame1grandtotcodon);
		push @frame1distgtotal, 100 * ((fileintxt("frame1distgtotal_26.txt") + fileintxt("frame1distgtotal_27.txt") + fileintxt("frame1distgtotal_28.txt") + fileintxt("frame1distgtotal_29.txt")
					+ fileintxt("frame1distgtotal_30.txt") + fileintxt("frame1distgtotal_31.txt"))/$frame1grandtotcodon);
		push @frame1distgtotal, 100 * ((fileintxt("frame1distgtotal_32.txt") + fileintxt("frame1distgtotal_33.txt") + fileintxt("frame1distgtotal_34.txt") + fileintxt("frame1distgtotal_35.txt")
					+ fileintxt("frame1distgtotal_36.txt") + fileintxt("frame1distgtotal_37.txt"))/$frame1grandtotcodon);
		push @frame1distgtotal, 100 * ((fileintxt("frame1distgtotal_38.txt") + fileintxt("frame1distgtotal_39.txt") + fileintxt("frame1distgtotal_40.txt") + fileintxt("frame1distgtotal_41.txt")
					+ fileintxt("frame1distgtotal_42.txt") + fileintxt("frame1distgtotal_43.txt"))/$frame1grandtotcodon);
		push @frame1distgtotal, 100 * ((fileintxt("frame1distgtotal_44.txt") + fileintxt("frame1distgtotal_45.txt") + fileintxt("frame1distgtotal_46.txt") + fileintxt("frame1distgtotal_47.txt")
					+ fileintxt("frame1distgtotal_48.txt") + fileintxt("frame1distgtotal_49.txt"))/$frame1grandtotcodon);
		push @frame1distgtotal, 100 * ((fileintxt("frame1distgtotal_50.txt") + fileintxt("frame1distgtotal_51.txt") + fileintxt("frame1distgtotal_52.txt") + fileintxt("frame1distgtotal_53.txt")
					+ fileintxt("frame1distgtotal_54.txt") + fileintxt("frame1distgtotal_55.txt"))/$frame1grandtotcodon);
		push @frame1distgtotal, 100 * ((fileintxt("frame1distgtotal_56.txt")  + fileintxt("frame1distgtotal_57.txt") + fileintxt("frame1distgtotal_58.txt") + fileintxt("frame1distgtotal_59.txt") 
					+ fileintxt("frame1distgtotal_60.txt") + fileintxt("frame1distgtotal_61.txt") + fileintxt("frame1distgtotal_62.txt") + fileintxt("frame1distgtotal_63.txt") )/$frame1grandtotcodon);
					
					
		
					
		#print "Doing math on Frame2 Distrubtion totals\n";			
		push @frame2distgtotal, 100 * ( (fileintxt("frame2distgtotal_0.txt")  + fileintxt("frame2distgtotal_1.txt") + fileintxt("frame2distgtotal_2.txt") + fileintxt("frame2distgtotal_3.txt") 
					+ fileintxt("frame2distgtotal_4.txt") + fileintxt("frame2distgtotal_5.txt") + fileintxt("frame2distgtotal_6.txt") + fileintxt("frame2distgtotal_7.txt") )/$frame2grandtotcodon);
		push @frame2distgtotal, 100 * ((fileintxt("frame2distgtotal_8.txt") + fileintxt("frame2distgtotal_8.txt") + fileintxt("frame2distgtotal_10.txt") + fileintxt("frame2distgtotal_11.txt")
					+ fileintxt("frame2distgtotal_12.txt") + fileintxt("frame2distgtotal_13.txt"))/$frame2grandtotcodon);
		push @frame2distgtotal, 100 * ((fileintxt("frame2distgtotal_14.txt") + fileintxt("frame2distgtotal_15.txt") + fileintxt("frame2distgtotal_16.txt") + fileintxt("frame2distgtotal_17.txt")
					+ fileintxt("frame2distgtotal_18.txt") + fileintxt("frame2distgtotal_19.txt"))/$frame2grandtotcodon);
		push @frame2distgtotal, 100 * ((fileintxt("frame2distgtotal_20.txt") + fileintxt("frame2distgtotal_21.txt") + fileintxt("frame2distgtotal_22.txt") + fileintxt("frame2distgtotal_23.txt")
					+ fileintxt("frame2distgtotal_24.txt") + fileintxt("frame2distgtotal_25.txt"))/$frame2grandtotcodon);
		push @frame2distgtotal, 100 * ((fileintxt("frame2distgtotal_26.txt") + fileintxt("frame2distgtotal_27.txt") + fileintxt("frame2distgtotal_28.txt") + fileintxt("frame2distgtotal_29.txt")
					+ fileintxt("frame2distgtotal_30.txt") + fileintxt("frame2distgtotal_31.txt"))/$frame2grandtotcodon);
		push @frame2distgtotal, 100 * ((fileintxt("frame2distgtotal_32.txt") + fileintxt("frame2distgtotal_33.txt") + fileintxt("frame2distgtotal_34.txt") + fileintxt("frame2distgtotal_35.txt")
					+ fileintxt("frame2distgtotal_36.txt") + fileintxt("frame2distgtotal_37.txt"))/$frame2grandtotcodon);
		push @frame2distgtotal, 100 * ((fileintxt("frame2distgtotal_38.txt") + fileintxt("frame2distgtotal_39.txt") + fileintxt("frame2distgtotal_40.txt") + fileintxt("frame2distgtotal_41.txt")
					+ fileintxt("frame2distgtotal_42.txt") + fileintxt("frame2distgtotal_43.txt"))/$frame2grandtotcodon);
		push @frame2distgtotal, 100 * ((fileintxt("frame2distgtotal_44.txt") + fileintxt("frame2distgtotal_45.txt") + fileintxt("frame2distgtotal_46.txt") + fileintxt("frame2distgtotal_47.txt")
					+ fileintxt("frame2distgtotal_48.txt") + fileintxt("frame2distgtotal_49.txt"))/$frame2grandtotcodon);
		push @frame2distgtotal, 100 * ((fileintxt("frame2distgtotal_50.txt") + fileintxt("frame2distgtotal_51.txt") + fileintxt("frame2distgtotal_52.txt") + fileintxt("frame2distgtotal_53.txt")
					+ fileintxt("frame2distgtotal_54.txt") + fileintxt("frame2distgtotal_55.txt"))/$frame2grandtotcodon);
		push @frame2distgtotal, 100 * ((fileintxt("frame2distgtotal_56.txt")  + fileintxt("frame2distgtotal_57.txt") + fileintxt("frame2distgtotal_58.txt") + fileintxt("frame2distgtotal_59.txt") 
					+ fileintxt("frame2distgtotal_60.txt") + fileintxt("frame2distgtotal_61.txt") + fileintxt("frame2distgtotal_62.txt") + fileintxt("frame2distgtotal_63.txt") )/$frame2grandtotcodon);
					
					
		#print "Doing math on Frame3 Distrubition totals\n";			
					
					
		push @frame3distgtotal, 100 * ( (fileintxt("frame3distgtotal_0.txt")  + fileintxt("frame3distgtotal_1.txt") + fileintxt("frame3distgtotal_2.txt") + fileintxt("frame3distgtotal_3.txt") 
					+ fileintxt("frame3distgtotal_4.txt") + fileintxt("frame3distgtotal_5.txt") + fileintxt("frame3distgtotal_6.txt") + fileintxt("frame3distgtotal_7.txt") )/$frame3grandtotcodon);
		push @frame3distgtotal, 100 * ((fileintxt("frame3distgtotal_8.txt") + fileintxt("frame3distgtotal_8.txt") + fileintxt("frame3distgtotal_10.txt") + fileintxt("frame3distgtotal_11.txt")
					+ fileintxt("frame3distgtotal_12.txt") + fileintxt("frame3distgtotal_13.txt"))/$frame3grandtotcodon);
		push @frame3distgtotal, 100 * ((fileintxt("frame3distgtotal_14.txt") + fileintxt("frame3distgtotal_15.txt") + fileintxt("frame3distgtotal_16.txt") + fileintxt("frame3distgtotal_17.txt")
					+ fileintxt("frame3distgtotal_18.txt") + fileintxt("frame3distgtotal_19.txt"))/$frame3grandtotcodon);
		push @frame3distgtotal, 100 * ((fileintxt("frame3distgtotal_20.txt") + fileintxt("frame3distgtotal_21.txt") + fileintxt("frame3distgtotal_22.txt") + fileintxt("frame3distgtotal_23.txt")
					+ fileintxt("frame3distgtotal_24.txt") + fileintxt("frame3distgtotal_25.txt"))/$frame3grandtotcodon);
		push @frame3distgtotal, 100 * ((fileintxt("frame3distgtotal_26.txt") + fileintxt("frame3distgtotal_27.txt") + fileintxt("frame3distgtotal_28.txt") + fileintxt("frame3distgtotal_29.txt")
					+ fileintxt("frame3distgtotal_30.txt") + fileintxt("frame3distgtotal_31.txt"))/$frame3grandtotcodon);
		push @frame3distgtotal, 100 * ((fileintxt("frame3distgtotal_32.txt") + fileintxt("frame3distgtotal_33.txt") + fileintxt("frame3distgtotal_34.txt") + fileintxt("frame3distgtotal_35.txt")
					+ fileintxt("frame3distgtotal_36.txt") + fileintxt("frame3distgtotal_37.txt"))/$frame3grandtotcodon);
		push @frame3distgtotal, 100 * ((fileintxt("frame3distgtotal_38.txt") + fileintxt("frame3distgtotal_39.txt") + fileintxt("frame3distgtotal_40.txt") + fileintxt("frame3distgtotal_41.txt")
					+ fileintxt("frame3distgtotal_42.txt") + fileintxt("frame3distgtotal_43.txt"))/$frame3grandtotcodon);
		push @frame3distgtotal, 100 * ((fileintxt("frame3distgtotal_44.txt") + fileintxt("frame3distgtotal_45.txt") + fileintxt("frame3distgtotal_46.txt") + fileintxt("frame3distgtotal_47.txt")
					+ fileintxt("frame3distgtotal_48.txt") + fileintxt("frame3distgtotal_49.txt"))/$frame3grandtotcodon);
		push @frame3distgtotal, 100 * ((fileintxt("frame3distgtotal_50.txt") + fileintxt("frame3distgtotal_51.txt") + fileintxt("frame3distgtotal_52.txt") + fileintxt("frame3distgtotal_53.txt")
					+ fileintxt("frame3distgtotal_54.txt") + fileintxt("frame3distgtotal_55.txt"))/$frame3grandtotcodon);
		push @frame3distgtotal, 100 * ((fileintxt("frame3distgtotal_56.txt")  + fileintxt("frame3distgtotal_57.txt") + fileintxt("frame3distgtotal_58.txt") + fileintxt("frame3distgtotal_59.txt") 
					+ fileintxt("frame3distgtotal_60.txt") + fileintxt("frame3distgtotal_61.txt") + fileintxt("frame3distgtotal_62.txt") + fileintxt("frame3distgtotal_63.txt") )/$frame3grandtotcodon);
					
		
		#leave spaces between code here or else errors will come up when attempting to execute don't no why
		
		#hang on not sure if this will work out if done like this
		print "Clearning Memory of math just performed...\n";
		$filecounter =0;
		foreach(@frame1distgtotal){
			my $fname = "frame1granddistgtotal_$filecounter.txt";
			my $numbdata = $_;
			my @filedta = ($fname, $numbdata);
			fileouttxt($fname, $numbdata); 
			$filecounter++;
		}
		$filecounter =0;
		foreach(@frame2distgtotal){
			my $fname = "frame2granddistgtotal_$filecounter.txt";
			my $numbdata = $_;
			my @filedta = ($fname, $numbdata);
				fileouttxt($fname, $numbdata); 
			$filecounter++;
		}
		$filecounter =0;
		foreach(@frame3distgtotal){
			my $fname = "frame3granddistgtotal_$filecounter.txt";
			my $numbdata = $_;
			my @filedta = ($fname, $numbdata);
			fileouttxt($fname, $numbdata); 
			$filecounter++;
		}
		@frame1distgtotal= ();
		@frame2distgtotal= ();
		@frame3distgtotal= ();
		
		#print "AT Only \%atages\n";			
		push @grandtotaltotaldist, 100 * ( ( fileintxt("frame1distgtotal_0.txt") + fileintxt("frame1distgtotal_1.txt") + fileintxt("frame1distgtotal_2.txt") + fileintxt("frame1distgtotal_3.txt") +
					+ fileintxt("frame1distgtotal_4.txt") + fileintxt("frame1distgtotal_5.txt") + fileintxt("frame1distgtotal_6.txt") + fileintxt("frame1distgtotal_7.txt") +
					fileintxt("frame2distgtotal_0.txt") + fileintxt("frame2distgtotal_1.txt") + fileintxt("frame2distgtotal_2.txt") + fileintxt("frame2distgtotal_3.txt") +
					+ fileintxt("frame2distgtotal_4.txt") + fileintxt("frame2distgtotal_5.txt") + fileintxt("frame2distgtotal_6.txt") + fileintxt("frame2distgtotal_7.txt") +
					fileintxt("frame3distgtotal_0.txt") + fileintxt("frame3distgtotal_1.txt") + fileintxt("frame3distgtotal_2.txt") + fileintxt("frame3distgtotal_3.txt") +
					+ fileintxt("frame3distgtotal_4.txt") + fileintxt("frame3distgtotal_5.txt") + fileintxt("frame3distgtotal_6.txt") + fileintxt("frame3distgtotal_7.txt"))/($frame1grandtotcodon + $frame2grandtotcodon + $frame3grandtotcodon));			
		
		
		#need these after to clear memory
		
		my $fname = "granddistgtotaltotal_0.txt";
		my $numbdata = $grandtotaltotaldist[0];
		my @filedta = ($fname, $numbdata);
		fileouttxt($fname, $numbdata); 
		@grandtotaltotaldist= ();
		
		push @grandtotaltotaldist, 100 * ( (fileintxt("frame1distgtotal_8.txt") + fileintxt("frame1distgtotal_9.txt") + fileintxt("frame1distgtotal_10.txt") + 
					fileintxt("frame1distgtotal_11.txt") + fileintxt("frame1distgtotal_12.txt") + fileintxt("frame1distgtotal_13.txt") +  
					fileintxt("frame2distgtotal_8.txt") + fileintxt("frame2distgtotal_9.txt") + fileintxt("frame2distgtotal_10.txt") + 
					fileintxt("frame2distgtotal_11.txt") + fileintxt("frame2distgtotal_12.txt") + fileintxt("frame2distgtotal_13.txt") +  
					fileintxt("frame3distgtotal_8.txt") + fileintxt("frame3distgtotal_9.txt") + fileintxt("frame3distgtotal_10.txt") + 
					fileintxt("frame3distgtotal_11.txt") + fileintxt("frame3distgtotal_12.txt") + fileintxt("frame3distgtotal_13.txt")   )/($frame1grandtotcodon + $frame2grandtotcodon + $frame3grandtotcodon));
		
		
		my $fname = "granddistgtotaltotal_1.txt";
		my $numbdata = $grandtotaltotaldist[0];
		my @filedta = ($fname, $numbdata);
		fileouttxt($fname, $numbdata); 
		@grandtotaltotaldist= ();
					 
		push @grandtotaltotaldist, 100 * ( (fileintxt("frame1distgtotal_14.txt") + fileintxt("frame1distgtotal_15.txt") + fileintxt("frame1distgtotal_16.txt") + 
					fileintxt("frame1distgtotal_17.txt") + fileintxt("frame1distgtotal_18.txt") + fileintxt("frame1distgtotal_19.txt") +  
					fileintxt("frame2distgtotal_14.txt") + fileintxt("frame2distgtotal_15.txt") + fileintxt("frame2distgtotal_16.txt") + 
					fileintxt("frame2distgtotal_17.txt") + fileintxt("frame2distgtotal_18.txt") + fileintxt("frame2distgtotal_19.txt") +  
					fileintxt("frame3distgtotal_14.txt") + fileintxt("frame3distgtotal_15.txt") + fileintxt("frame3distgtotal_16.txt") + 
					fileintxt("frame3distgtotal_17.txt") + fileintxt("frame3distgtotal_18.txt") + fileintxt("frame3distgtotal_19.txt")  )/($frame1grandtotcodon + $frame2grandtotcodon + $frame3grandtotcodon));
					  
		my $fname = "granddistgtotaltotal_2.txt";
		my $numbdata = $grandtotaltotaldist[0];
		my @filedta = ($fname, $numbdata);
		fileouttxt($fname, $numbdata); 
		@grandtotaltotaldist= ();
		
		push @grandtotaltotaldist, 100 * ( (fileintxt("frame1distgtotal_20.txt") + fileintxt("frame1distgtotal_21.txt") + fileintxt("frame1distgtotal_22.txt") + 
					fileintxt("frame1distgtotal_23.txt") + fileintxt("frame1distgtotal_24.txt") + fileintxt("frame1distgtotal_25.txt") +  
					fileintxt("frame2distgtotal_20.txt") + fileintxt("frame2distgtotal_21.txt") + fileintxt("frame2distgtotal_22.txt") + 
					fileintxt("frame2distgtotal_23.txt") + fileintxt("frame2distgtotal_24.txt") + fileintxt("frame2distgtotal_25.txt") +  
					fileintxt("frame3distgtotal_20.txt") + fileintxt("frame3distgtotal_21.txt") + fileintxt("frame3distgtotal_22.txt") + 
					fileintxt("frame3distgtotal_23.txt") + fileintxt("frame3distgtotal_24.txt") + fileintxt("frame3distgtotal_25.txt")   )/($frame1grandtotcodon + $frame2grandtotcodon + $frame3grandtotcodon));
					  
		my $fname = "granddistgtotaltotal_3.txt";
		my $numbdata = $grandtotaltotaldist[0];
		my @filedta = ($fname, $numbdata);
		fileouttxt($fname, $numbdata); 
		@grandtotaltotaldist= ();
		
		
		push @grandtotaltotaldist, 100 * ( (fileintxt("frame1distgtotal_26.txt") + fileintxt("frame1distgtotal_27.txt") + fileintxt("frame1distgtotal_28.txt") + 
					fileintxt("frame1distgtotal_29.txt") + fileintxt("frame1distgtotal_30.txt") + fileintxt("frame1distgtotal_31.txt") +  
					fileintxt("frame2distgtotal_26.txt") + fileintxt("frame2distgtotal_27.txt") + fileintxt("frame2distgtotal_28.txt") + 
					fileintxt("frame2distgtotal_29.txt") + fileintxt("frame2distgtotal_30.txt") + fileintxt("frame2distgtotal_31.txt") +  
					fileintxt("frame3distgtotal_26.txt") + fileintxt("frame3distgtotal_27.txt") + fileintxt("frame3distgtotal_28.txt") + 
					fileintxt("frame3distgtotal_29.txt") + fileintxt("frame3distgtotal_30.txt") + fileintxt("frame3distgtotal_31.txt")  )/($frame1grandtotcodon + $frame2grandtotcodon + $frame3grandtotcodon));
				
		my $fname = "granddistgtotaltotal_4.txt";
		my $numbdata = $grandtotaltotaldist[0];
		my @filedta = ($fname, $numbdata);
		fileouttxt($fname, $numbdata); 
		@grandtotaltotaldist= ();
		
		
		push @grandtotaltotaldist, 100 * ( (fileintxt("frame1distgtotal_32.txt") + fileintxt("frame1distgtotal_33.txt") + fileintxt("frame1distgtotal_34.txt") + 
					fileintxt("frame1distgtotal_35.txt") + fileintxt("frame1distgtotal_36.txt") + fileintxt("frame1distgtotal_37.txt") +  
					fileintxt("frame2distgtotal_32.txt") + fileintxt("frame2distgtotal_33.txt") + fileintxt("frame2distgtotal_35.txt") + 
					fileintxt("frame2distgtotal_35.txt") + fileintxt("frame2distgtotal_36.txt") + fileintxt("frame2distgtotal_37.txt") +  
					fileintxt("frame3distgtotal_32.txt") + fileintxt("frame3distgtotal_33.txt") + fileintxt("frame3distgtotal_34.txt") + 
					fileintxt("frame3distgtotal_35.txt") + fileintxt("frame3distgtotal_36.txt") + fileintxt("frame3distgtotal_37.txt")  )/($frame1grandtotcodon + $frame2grandtotcodon + $frame3grandtotcodon));
					  
		my $fname = "granddistgtotaltotal_5.txt";
		my $numbdata = $grandtotaltotaldist[0];
		my @filedta = ($fname, $numbdata);
		fileouttxt($fname, $numbdata); 
		@grandtotaltotaldist= ();
	
	
		push @grandtotaltotaldist, 100 * ( (fileintxt("frame1distgtotal_38.txt") + fileintxt("frame1distgtotal_39.txt") + fileintxt("frame1distgtotal_40.txt") + 
					fileintxt("frame1distgtotal_41.txt") + fileintxt("frame1distgtotal_42.txt") + fileintxt("frame1distgtotal_43.txt") +  
					fileintxt("frame2distgtotal_38.txt") + fileintxt("frame2distgtotal_39.txt") + fileintxt("frame2distgtotal_40.txt") + 
					fileintxt("frame2distgtotal_41.txt") + fileintxt("frame2distgtotal_42.txt") + fileintxt("frame2distgtotal_43.txt") +  
					fileintxt("frame3distgtotal_38.txt") + fileintxt("frame3distgtotal_39.txt") + fileintxt("frame3distgtotal_40.txt") + 
					fileintxt("frame3distgtotal_41.txt") + fileintxt("frame3distgtotal_42.txt") + fileintxt("frame3distgtotal_43.txt")  )/($frame1grandtotcodon + $frame2grandtotcodon + $frame3grandtotcodon));
					  
		my $fname = "granddistgtotaltotal_6.txt";
		my $numbdata = $grandtotaltotaldist[0];
		my @filedta = ($fname, $numbdata);
		fileouttxt($fname, $numbdata); 
		@grandtotaltotaldist= ();
		
		push @grandtotaltotaldist, 100 * ( (fileintxt("frame1distgtotal_44.txt") + fileintxt("frame1distgtotal_45.txt") + fileintxt("frame1distgtotal_46.txt") + 
					fileintxt("frame1distgtotal_47.txt") + fileintxt("frame1distgtotal_48.txt") + fileintxt("frame1distgtotal_49.txt") +  
					fileintxt("frame2distgtotal_44.txt") + fileintxt("frame2distgtotal_45.txt") + fileintxt("frame2distgtotal_46.txt") + 
					fileintxt("frame2distgtotal_47.txt") + fileintxt("frame2distgtotal_48.txt") + fileintxt("frame2distgtotal_49.txt") +  
					fileintxt("frame3distgtotal_44.txt") + fileintxt("frame3distgtotal_45.txt") + fileintxt("frame3distgtotal_46.txt") + 
					fileintxt("frame3distgtotal_47.txt") + fileintxt("frame3distgtotal_48.txt") + fileintxt("frame3distgtotal_49.txt")  )/($frame1grandtotcodon + $frame2grandtotcodon + $frame3grandtotcodon));
					  
		
		my $fname = "granddistgtotaltotal_7.txt";
		my $numbdata = $grandtotaltotaldist[0];
		my @filedta = ($fname, $numbdata);
		fileouttxt($fname, $numbdata); 
		@grandtotaltotaldist= ();
		
		
		push @grandtotaltotaldist, 100 * ( (fileintxt("frame1distgtotal_50.txt") + fileintxt("frame1distgtotal_51.txt") + fileintxt("frame1distgtotal_52.txt") + 
					fileintxt("frame1distgtotal_53.txt") + fileintxt("frame1distgtotal_54.txt") + fileintxt("frame1distgtotal_55.txt") +  
					fileintxt("frame2distgtotal_50.txt") + fileintxt("frame2distgtotal_51.txt") + fileintxt("frame2distgtotal_52.txt") + 
					fileintxt("frame2distgtotal_53.txt") + fileintxt("frame2distgtotal_54.txt") + fileintxt("frame2distgtotal_55.txt") +  
					fileintxt("frame3distgtotal_50.txt") + fileintxt("frame3distgtotal_51.txt") + fileintxt("frame3distgtotal_52.txt") + 
					fileintxt("frame3distgtotal_53.txt") + fileintxt("frame3distgtotal_54.txt") + fileintxt("frame3distgtotal_55.txt") )/($frame1grandtotcodon + $frame2grandtotcodon + $frame3grandtotcodon));
	
		my $fname = "granddistgtotaltotal_8.txt";
		my $numbdata = $grandtotaltotaldist[0];
		my @filedta = ($fname, $numbdata);
		fileouttxt($fname, $numbdata); 
		@grandtotaltotaldist= ();
	
		
		push @grandtotaltotaldist, 100 * ( ( fileintxt("frame1distgtotal_56.txt") + fileintxt("frame1distgtotal_57.txt") + fileintxt("frame1distgtotal_58.txt") + fileintxt("frame1distgtotal_59.txt") +
					+ fileintxt("frame1distgtotal_60.txt") + fileintxt("frame1distgtotal_61.txt") + fileintxt("frame1distgtotal_62.txt") + fileintxt("frame1distgtotal_63.txt") +
					fileintxt("frame2distgtotal_56.txt") + fileintxt("frame2distgtotal_57.txt") + fileintxt("frame2distgtotal_58.txt") + fileintxt("frame2distgtotal_59.txt") +
					+ fileintxt("frame2distgtotal_60.txt") + fileintxt("frame2distgtotal_61.txt") + fileintxt("frame2distgtotal_62.txt") + fileintxt("frame2distgtotal_63.txt") +
					fileintxt("frame3distgtotal_56.txt") + fileintxt("frame3distgtotal_57.txt") + fileintxt("frame3distgtotal_58.txt") + fileintxt("frame3distgtotal_59.txt") +
					+ fileintxt("frame3distgtotal_60.txt") + fileintxt("frame3distgtotal_61.txt") + fileintxt("frame3distgtotal_62.txt") + fileintxt("frame3distgtotal_63.txt"))/($frame1grandtotcodon + $frame2grandtotcodon + $frame3grandtotcodon));			
	
		my $fname = "granddistgtotaltotal_9.txt";
		my $numbdata = $grandtotaltotaldist[0];
		my @filedta = ($fname, $numbdata);
		fileouttxt($fname, $numbdata); 
		@grandtotaltotaldist= ();		
	
	
	#print "Done with math, memory all cleared\n";

	#print out codon counts
	printf FILE "%6sStop Codons:%7s%5d%5d%5d%1s%5d%5d%5d%1s%5d%5d%5d%1s%5d%5d%5d", "", "", $totalstopcodons[0] , $totalstopcodons[1], $totalstopcodons[2], "", $totalstopcodons[3], $totalstopcodons[4], $totalstopcodons[5], "", $totalstopcodons[6], $totalstopcodons[7], $totalstopcodons[8], "", $totalstopcodons[9], $totalstopcodons[10], $totalstopcodons[11];
	printf FILE "\n%6sTotal Codons:%6s%5d%5d%5d%1s%5d%5d%5d%1s%5d%5d%5d%1s%5d%5d%5d", "", "", $totaltotalcodons[0] , $totaltotalcodons[1], $totaltotalcodons[2], "", $totaltotalcodons[3], $totaltotalcodons[4], $totaltotalcodons[5], "", $totaltotalcodons[6], $totaltotalcodons[7], $totaltotalcodons[8],"", $totaltotalcodons[9], $totaltotalcodons[10], $totaltotalcodons[11];
	print FILE "\n";
	
	#print "Outputting Distribution (codon sets)\%tages\n";
	print FILE "\n                                        DISTRIBUTION Percentage(%)\n";
	print FILE "      CODON SET                FRAME 1:        FRAME 2:        FRAME 3:         TOTAL\n";
	for(my $lcv = 0; $lcv < 10; $lcv++){
			printf FILE "%5s%5s%5s%5s%10s%5.2f%11s%5.2f%11s%5.2f%11s%5.2f", "" , $codonsets[$lcv], "", $codonsetpercents[$lcv], "", fileintxt("frame1granddistgtotal_$lcv.txt"), "" , fileintxt("frame2granddistgtotal_$lcv.txt"), "" , fileintxt("frame3granddistgtotal_$lcv.txt"), "", fileintxt("granddistgtotaltotal_$lcv.txt");
			print FILE "\n";
		}
	

	#rest of distribution at only, gc rich etc.
	print FILE "\n\n";
	printf FILE "%5s%5s%5s%5s%10s%5.2f%11s%5.2f%11s%5.2f%11s%5.2f", "", $codonsets[10], "", $codonsetpercents[10], "", 100 *($totalatonly[0]/$frame1grandtotcodon), "" , 100 *($totalatonly[1]/$frame2grandtotcodon), "",  100*($totalatonly[2]/$frame3grandtotcodon), "",  100*($totalatonly[3]/($frame1grandtotcodon + $frame2grandtotcodon + $frame3grandtotcodon));  
	#at rich
	print FILE "\n";
	printf FILE "%5s%5s%5s%5s%10s%5.2f%11s%5.2f%11s%5.2f%11s%5.2f", "", $codonsets[11], "", $codonsetpercents[11], "", 100 *($totalatrich[0]/$frame1grandtotcodon), "" , 100 *($totalatrich[1]/$frame2grandtotcodon), "",  100*($totalatrich[2]/$frame3grandtotcodon), "",  100*($totalatrich[3]/($frame1grandtotcodon + $frame2grandtotcodon + $frame3grandtotcodon));  
	#gc rich
	print FILE "\n";
	printf FILE "%5s%5s%5s%5s%10s%5.2f%11s%5.2f%11s%5.2f%11s%5.2f", "", $codonsets[12], "", $codonsetpercents[12], "", 100 *($totalgcrich[0]/$frame1grandtotcodon), "" , 100 *($totalgcrich[1]/$frame2grandtotcodon), "",  100*($totalgcrich[2]/$frame3grandtotcodon), "",  100*($totalgcrich[3]/($frame1grandtotcodon + $frame2grandtotcodon + $frame3grandtotcodon));  
	#gc only
	print FILE "\n";
	printf FILE "%5s%5s%5s%5s%10s%5.2f%11s%5.2f%11s%5.2f%11s%5.2f", "", $codonsets[13], "", $codonsetpercents[13], "", 100 *($totalgconly[0]/$frame1grandtotcodon), "" , 100 *($totalgconly[1]/$frame2grandtotcodon), "",  100*($totalgconly[2]/$frame3grandtotcodon), "",  100*($totalgconly[3]/($frame1grandtotcodon + $frame2grandtotcodon + $frame3grandtotcodon));  
	
	
	
	#now done with files so remove them, there are a lot of them!
	#need this otherwise args are too long for remove
	my $rmfiles = $outdir . "frame1*.txt";
	`rm $rmfiles`;	
	$rmfiles = $outdir . "frame2*.txt";
	`rm $rmfiles`;	
	$rmfiles = $outdir . "frame3*.txt";
	`rm $rmfiles`;	
	$rmfiles = $outdir . "granddistgtotaltotal*.txt";
	`rm $rmfiles`;	
	
	sub fileintxt(){
		my @filevars = @_;
		my $filename = $filevars[0];
		#print "Trying to access $outdir$filename\n";
		my $data = `cat $filename`;
		return($data);
		
	}
	
	
	sub fileouttxt(){
		my @filevars = @_;
		my $filename = $filevars[0];
		my $content = $filevars[1];
		#print "File out $filename with content $content\n";
		open(TFILE, ">$filename");
		print TFILE $content;
		close TFILE;
		
	
	}
	
	
	
	
	print "Calculating DNA AT GC Percentage\n";	
	#now proccess the at and gc count
	#rewrote to output entire dna to a file to refree the memory
	#then read the massive file (if huge list), in bits and pieces
		
		my $totala = ($totaldnastring =~ tr/A//);
		my $totalt = ($totaldnastring =~ tr/T//);
		my $totalg = ($totaldnastring =~ tr/G//);
		my $totalc = ($totaldnastring =~ tr/C//);
		$totaldnastring = "";
		
		print FILE "\n\t\tBase Usage:\t\tA,T:  ";
		printf FILE "%5.2f\%", 100 * (($totala + $totalt)/($totala + $totalt + $totalg + $totalc));
		print FILE "\t\tG,C:  ";
		printf FILE "%5.2f\%", 100 *(($totalg + $totalc)/($totala + $totalt + $totalg + $totalc));
		print FILE "\n\n";
		close FILE;
		if($sixtyfourcodonlist eq "yes"){
		       		print "\tOutputting special 64 Codon List Table\n";
				my ($set1, $set2, $set3, $set4, $counter) = 0;
				if($morfrun eq "off"){
		       			print SFFILE "\n$runname-TOTAL\n";
				}else{
					print SFFILE "\n$runname-TOTAL-$morfrun\n";
				}
		       		foreach my $key (sort {$sixtyfourlisthash{$a} <=> $sixtyfourlisthash{$b}} keys %sixtyfourlisthash){ 
					#print SFFILE " $sixtyfourlisthash = $sixtyfourlisthash{$key}\n"; 
					#print SFFILE " $key\t$sixtyfourlisthash{$key}\n";
					printf SFFILE "%-4s%-18s", $counter+1, $key;
					printf SFFILE "%5.1f", $sixtyfourlisthash{$key};
					print SFFILE "\n";
					
					if($counter < 16){
						$set1 += $sixtyfourlisthash{$key};
					}
					elsif($counter < 32){
						$set2 += $sixtyfourlisthash{$key};
					}elsif($counter < 48){
						$set3 += $sixtyfourlisthash{$key};
					}elsif($counter < 64){
						$set4 += $sixtyfourlisthash{$key};
					}
					$counter++;
					
				};
				printf SFFILE "Set 1 - 16%5s%5.1f", "", $set1;
				printf SFFILE "\nSet 17 - 32%5s%5.1f", "", $set2;
				printf SFFILE "\nSet 33 - 48%5s%5.1f", "", $set3;
				printf SFFILE "\nSet 49 - 64%5s%5.1f", "", $set4;
				print SFFILE "\n\n";
			}
			%sixtyfourlisthash = ();
		#output TOTAL graphs
		if($graphyon == 1){  #wooohoo lets make the graph
		       		#open(GFILE, ">$runname.$seqlist[$lcv].graphdata.txt");
				$ENV{PGPLOT_DIR} = "/home/connare/unixapps/pgplot";
				$ENV{PGPLOT_FONT} = "/home/connare/unixapps/pgplot/grfont.data";
				$ENV{PGPLOT_RGB} = "/home/connare/unixapps/pgplot/rgb.txt";
				$ENV{PGPLOT_BACKGROUND} = "black";
				$ENV{PGPLOT_FOREGROUND} = "white";
				#at only ->red
				#at rich ->yellow
				#gc rich ->blue
				#gc only -> green
				
				
				#need to make the four graphs now
				#so make graph
				print "Making $runname-$morfrun Totals Graph...#1";
				#first graph
				pgbegin(0,'"temp.gif"/GIF',1,1);
				pgsci(1);
				#pgscr(0, 0,0,0); #black background for now until colors are fixed
				
				if($graphymax < 10){
					pgenv(0,64,0,10,0,0);	#setup enviroment
				}
				elsif($graphymax < 20){
					pgenv(0,64,0,20,0,0);	#setup enviroment
				}
				elsif($graphymax < 30){
					pgenv(0,64,0,30,0,0);	#setup enviroment
				}
				pglabel('X - Codon #',  'Percentage (%)',"Codon Analysis Graph $runname - TOTAL - Codons ");
				pgsch(.5);
				pgmtext('B', 5, 1, 1, "Sanjay Connare");
				pgmtext('B', 6, 1, 1, "Codon Analysis App $version");
				pgsch(.75);
				pgsci($atocolor);
				pgmtext('T', 1, 0, 1, "AT Only");
				pgsci($atrcolor);
				pgmtext('T', 2, 0, 1, "AT Rich");
				pgsci($gcrcolor);
				pgmtext('T', 3, 0, 1, "GC Rich");
				pgsci($gcocolor);
				pgmtext('T', 4, 0, 1, "GC Only");
				pgsch(1);
				#graph normal at only points for graph one
				pgsci($atocolor); #set red color
				foreach my $key (keys %graph1ato) { 
					#print "$key = $graph1ato{$key}\n"; 
					pgpoint(1, ($key +1), $graph1ato{$key}, $atosym);
				} 
				foreach my $key (keys %graph1atomultidef) { 
					#print "$key = $graph1atomultidef{$key}\n"; 
					pgpoint(1, ($key +1), $graph1atomultidef{$key}, $multidefsym);
				} 
				pgsci($atrcolor); #set yellow color
				foreach my $key (keys %graph1atr){
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key,  $graph1atr{$key}, $atrsym);
				}
				#now graph mutlidef orfs for atonly
				foreach my $key (keys %graph1atrmultidef){ 
				 	
				#	pgpoint(#, x, y, symbol);
					
					pgpoint(1, $key, $graph1atrmultidef{$key}, $multidefsym);
				}
				pgsci($gcrcolor); #set yellow color
				foreach my $key (keys %graph1gcr){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph1gcr{$key}, $gcrsym);
				}
				#now graph mutlidef orfs for atonly
				foreach my $key (keys %graph1gcrmultidef){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph1gcrmultidef{$key}, $multidefsym);
				}
				#now for gc only can do a one loop because no multiorfs
				pgsci($gcocolor); 
				foreach my $key (keys %graph1gco){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph1gco{$key}, $gcosym);
				}
				pgend();
				`mv temp.gif $outdir$runname.$morfrun.TOTAL.Graph1.gif`; 
				print "...#2";
				#graph 2, totals so no multiorf check
				pgbegin(0,'"temp.gif"/GIF',1,1);
				pgsci(1);
				#pgscr(0, 0,0,0); #black background for now until colors are fixed
				if($graph2ymax < 10){
					pgenv(0,32,0,10,0,0);	#setup enviroment
				}
				elsif($graph2ymax < 20){
					pgenv(0,32,0,20,0,0);	#setup enviroment
				}
				elsif($graph2ymax < 30){
					pgenv(0,32,0,30,0,0);	#setup enviroment
				}
				pglabel('X - Codon #',  'Percentage (%)',"Codon Analysis Graph $runname - TOTAL - Codon Complements");
				pgsch(.5);
				pgmtext('B', 5, 1, 1, "Sanjay Connare");
				pgmtext('B', 6, 1, 1, "Codon Analysis App $version");
				pgsch(.75);
				pgsci($atocolor);
				pgmtext('T', 1, 0, 1, "AT Only");
				pgsci($atrcolor);
				pgmtext('T', 2, 0, 1, "AT Rich");
				pgsci($gcrcolor);
				pgmtext('T', 3, 0, 1, "GC Rich");
				pgsci($gcocolor);
				pgmtext('T', 4, 0, 1, "GC Only");
				pgsch(1);
				#graph normal at only points for graph one
				pgsci($atocolor); #set red color
				my $counter = 0;
				foreach my $key (keys %graph2ato){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph2ato{$key}, $atosym);
				}
				pgsci($atrcolor); #set yellow color
				foreach my $key (keys %graph2atr){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph2atr{$key}, $atrsym);
				}
				#now graph mutlidef orfs for atonly
				pgsci($gcrcolor); #set yellow color
				foreach my $key (keys %graph2gcr){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph2gcr{$key}, $gcrsym);
				}
				#now graph mutlidef orfs for atonly for gc only can do a one loop because no multiorfs
				pgsci($gcocolor); #set yellow color
				foreach my $key (keys %graph2gco){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph2gco{$key}, $gcosym);
				}
				pgend();
				`mv temp.gif $outdir$runname.$morfrun.TOTAL.Graph2.gif`; 
				
				
				#graph 3
				print "...#3";
				pgbegin(0,'"temp.gif"/GIF',1,1);
				pgsci(1);
				#pgscr(0, 0,0,0); #black background for now until colors are fixed
				if($graphymax < 10){
					pgenv(0,64,0,10,0,0);	#setup enviroment
				}
				elsif($graphymax < 20){
					pgenv(0,64,0,20,0,0);	#setup enviroment
				}
				elsif($graphymax < 30){
					pgenv(0,64,0,30,0,0);	#setup enviroment
				}
				pglabel('X - Codon #',  'Percentage (%)',"Codon Analysis Graph $runname - TOTAL - Triple Frequency ");
				pgsch(.5);
				pgmtext('B', 5, 1, 1, "Sanjay Connare");
				pgmtext('B', 6, 1, 1, "Codon Analysis App $version");
				pgsch(.75);
				pgsci($atocolor);
				pgmtext('T', 1, 0, 1, "AT Only");
				pgsci($atrcolor);
				pgmtext('T', 2, 0, 1, "AT Rich");
				pgsci($gcrcolor);
				pgmtext('T', 3, 0, 1, "GC Rich");
				pgsci($gcocolor);
				pgmtext('T', 4, 0, 1, "GC Only");
				pgsch(1);
				#graph normal at only points for graph one
				pgsci($atocolor); #set red color
				foreach my $key (keys %graph3ato) { 
					#print "$key = $graph1ato{$key}\n"; 
					pgpoint(1, ($key +1), $graph3ato{$key}, $atosym);
				} 
				foreach my $key (keys %graph3atomultidef) { 
					#print "$key = $graph1atomultidef{$key}\n"; 
					pgpoint(1, ($key +1), $graph3atomultidef{$key}, $multidefsym);
				} 
				pgsci($atrcolor); #set yellow color
				foreach my $key (keys %graph2atr){
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key,  $graph3atr{$key}, $atrsym);
				}
				#now graph mutlidef orfs for atonly
				foreach my $key (keys %graph3atrmultidef){ 
				 	
				#	pgpoint(#, x, y, symbol);
					
					pgpoint(1, $key, $graph3atrmultidef{$key}, $multidefsym);
				}
				pgsci($gcrcolor); #set yellow color
				foreach my $key (keys %graph3gcr){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph3gcr{$key}, $gcrsym);
				}
				#now graph mutlidef orfs for atonly
				foreach my $key (keys %graph3gcrmultidef){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph3gcrmultidef{$key}, $multidefsym);
				}
				#now for gc only can do a one loop because no multiorfs
				pgsci($gcocolor); 
				foreach my $key (keys %graph3gco){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph3gco{$key}, $gcosym);
				}
				pgend();
				`mv temp.gif $outdir$runname.$morfrun.TOTAL.Graph3.gif`; 
				
				
				#graph 4
				print "...#4\n";
				pgbegin(0,'"temp.gif"/GIF',1,1);
				pgsci(1);
				#pgscr(0, 0,0,0); #black background for now until colors are fixed
				if($graphymax < 10){
					pgenv(0,32,0,10,0,0);	#setup enviroment
				}
				elsif($graphymax < 20){
					pgenv(0,32,0,20,0,0);	#setup enviroment
				}
				elsif($graphymax < 30){
					pgenv(0,32,0,30,0,0);	#setup enviroment
				}
				pglabel('X - Codon #',  'Percentage (%)',"Codon Analysis Graph $runname - TOTAL - Triple Frequencey Complements");
				pgsch(.5);
				pgmtext('B', 5, 1, 1, "Sanjay Connare");
				pgmtext('B', 6, 1, 1, "Codon Analysis App $version");
				pgsch(.75);
				pgsci($atocolor);
				pgmtext('T', 1, 0, 1, "AT Only");
				pgsci($atrcolor);
				pgmtext('T', 2, 0, 1, "AT Rich");
				pgsci($gcrcolor);
				pgmtext('T', 3, 0, 1, "GC Rich");
				pgsci($gcocolor);
				pgmtext('T', 4, 0, 1, "GC Only");
				pgsch(1);
				#graph normal at only points for graph one
				pgsci($atocolor); #set red color
				my $counter = 0;
				foreach my $key (keys %graph4ato){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph4ato{$key}, $atosym);
				}
				pgsci($atrcolor); #set yellow color
				foreach my $key (keys %graph4atr){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph4atr{$key}, $atrsym);
				}
				#now graph mutlidef orfs for atonly
				pgsci($gcrcolor); #set yellow color
				foreach my $key (keys %graph2gcr){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph4gcr{$key}, $gcrsym);
				}
				#now graph mutlidef orfs for atonly for gc only can do a one loop because no multiorfs
				pgsci($gcocolor); #set yellow color
				foreach my $key (keys %graph4gco){ 
				 	
				#	pgpoint(#, x, y, symbol);
					pgpoint(1, $key, $graph4gco{$key}, $gcosym);
				}
				pgend();
				`mv temp.gif $outdir$runname.$morfrun.TOTAL.Graph4.gif`;
				if(-e "$runname.off.TOTAL.Graph4.gif"){
					`mv $runname.off.TOTAL.Graph1.gif $outdir$runname.TOTAL.Graph1.gif`;
					`mv $runname.off.TOTAL.Graph2.gif $outdir$runname.TOTAL.Graph2.gif`;
					`mv $runname.off.TOTAL.Graph3.gif $outdir$runname.TOTAL.Graph3.gif`;
					`mv $runname.off.TOTAL.Graph4.gif $outdir$runname.TOTAL.Graph4.gif`;
				}
				$graphymax = 0;
				$graph2ymax = 0;
				#and now that graphs are complete clear variables so no data overlap or funny looking graphs
			        (%graph1ato,%graph1atr,%graph1gcr,%graph1gco) = ();
			        (%graph2ato,%graph2atr,%graph2gcr,%graph2gco) = ();
			        (%graph3ato,%graph3atr,%graph3gcr,%graph3gco) = ();
			        (%graph4ato,%graph4atr,%graph4gcr,%graph4gco) = ();
				#for codons with multiple definitions, need to store definition, codon # and actual data value
				#so, key will be codon # cuz thats whats needed for graph and data will be value
			        (%graph1atomultidef, %graph2atomultidef,%graph3atomultidef,%graph4atomultidef) = ();
			        (%graph1atrmultidef, %graph2atrmultidef,%graph3atrmultidef,%graph4atrmultidef) = ();
			        (%graph1gcrmultidef, %graph2gcrmultidef,%graph3gcrmultidef,%graph4gcrmultidef) = ();
			        (%graph1gcomultidef, %graph2gcomultidef,%graph3gcomultidef,%graph4gcomultidef) = ();
		} #end of check for if graphing variable
		
}







sub translate(){
	print "Starting translation...\n";
	#need to setup way to take in both arrarys which were went when the function was called
	#so since I do not know how to do it properly and you send two arrarys will do this
	my @funcargs = @_;
	my $argtotal = @funcargs;
	my @seqlist = ();
	my @seqdata = ();
	
	for(my $importary = 0; $importary < $argtotal; $importary++){
		
		if( $importary < ($argtotal/2)){
			push @seqlist, $funcargs[$importary];
		}
		else{
			push @seqdata, $funcargs[$importary];
		}
	}
	if(!($fileoutputchoice eq "indvidfil")){
		if($morfrun eq "off"){
			open(FILE, ">$outdir$runname.sequencesALL.translated.txt")
		}
		else{
			open(FILE, ">$outdir$runname.$morfrun.sequencesALL.translated.txt")
		}
		print FILE "$appname\tVersion: $version\n$author\nSix Frame Translated DNA->AA Sequence\n\n";
	}
	for(my $lcv =0; $lcv < @seqlist; $lcv++){
		my $max = @seqlist;
		print " Translating "; 
		print  $lcv + 1 ;
		print  " / $max\n";
		if($fileoutputchoice eq "indvidfil"){
			open(FILE, ">$outdir$runname.$seqlist[$lcv].translated.txt");
			print FILE "$appname\tVersion: $version\n$author\nSix Frame Translated DNA->AA Sequence\n\n";
		}
	
		
				
				
		my %codonhash = ( 
				
				"TTA", "L","TAT", "Y","TTT", "F","AAT", "N","CTA", "L","ACT", "T","TAC", "Y","TCT", "S","AAG", "K","TTC", "F","ACA", 
				"T","TTG", "L","AAC", "N","ATG", "M","TCA", "S","ATC", "I","AGC", "S","CTG", "L","TGC", "C","TCC", "S","AGG", "R","GAG", 
				"E","GTG", "V","TGG", "W","ACC", "T","ACG", "T","GTC", "V","TCG", "S","GGG", "G","GGC", "G","CGG", "R","GCG", "A","TAA", 
				"*","ATA", "I","AAA", "K","ATT", "I","TAG", "*","AGT", "S","GTA", "V","AGA", "R","CTT", "L","GAA", "E","TGT", "C","CAA", 
				"Q","GTT", "V","CAT", "H","TGA", "*","GAT", "D","GCT", "A","CAG", "Q","GCA", "A","GGA", "G","CCT", "P","CTC", "L","CAC", 
				"H","CCA", "P","GGT", "G","CGT", "R","GAC", "D","CGA", "R","CCC", "P","GCC", "A","CCG", "P","CGC", "R"
				
				
				);
				
			
		my $baseseq = $seqdata[$lcv];
		#print "$baseseq\n";
		print FILE "\n---$seqlist[$lcv]---\n";
		my @frame1seq = split(//, $baseseq);
		#changing code, so that sequence two is directly based off of sequence one
		#this is to help with the errors of stop codons in frame 1 that shouldn't be there
		#makes code ridiclious long but will again have to do
		print "\tTranslating Frame 1\n";
		dotranslation(1, @frame1seq);
		shift(@frame1seq);
		print "\tTranslating Frame 2\n";
		dotranslation(2, @frame1seq);
		shift(@frame1seq);
		print "\tTranslating Frame 3\n";
		dotranslation(3, @frame1seq);
		print "\tReversing string...\n";
		my $reverse = reverse($baseseq);
		my @chars = split(//, $reverse);
		my $complimentoferverse = "";
		print "\tRewriting reversed string for complement strand...\n";
		foreach(@chars){
			if($_ eq "A"){
				$complimentoferverse = $complimentoferverse . "T";
			}
			elsif($_ eq "T"){
				$complimentoferverse = $complimentoferverse . "A";
			}
			elsif($_ eq "G"){
				$complimentoferverse = $complimentoferverse . "C";
			}
			elsif($_ eq "C"){
				$complimentoferverse = $complimentoferverse . "G";
			}
			else{
				#this is for characters that are not tag or c
				$complimentoferverse = $complimentoferverse . $_;
			}
			
		}

		my @frame4seq = split(//, $complimentoferverse);
		print "\tTranslating Frame 4\n";
		dotranslation(4, @frame4seq );
		shift(@frame4seq);
		print "\tTranslating Frame 5\n";
		dotranslation(5, @frame4seq);
		shift(@frame4seq);
		print "\tTranslating Frame 6\n";
		dotranslation(6, @frame4seq);
		
		sub dotranslation(){
			my ($framenum, @seq) = @_;
			print FILE "\nFrame $framenum:\n\n";
			my $count = 0;
			my $code = "";
			foreach(@seq){
				$count++;
				$code = $code . $_;
				if($count == 3){
					my $codonmatch = 0; #use as a loop control variable to match translation
					my $codonfound = 0; #use to check for improper entries in dna code
					if(exists($codonhash{$code})){
						
						print FILE "$codonhash{$code}";
						$codonfound = 1;
						$codonmatch++;
					}
					if($codonfound == 0){
						print "Unknown codon $code\n";
						print FILE "X";
					}
				$code = "";
				$count = 0;	
				}	
			}
			#end of translation for this frame
			print FILE "\n";			
		}
		
	}
	close FILE;

}



	






sub outputallsequencelist(){
	print "In outputall sequence code....$outdir , $runname \n";
#	sleep(10);
	print "Outputting sequences into files...\n";
	###################
	#need to setup way to take in both arrarys which were went when the function was called
	#so since I do not know how to do it properly and you send two arrarys will do this
	my @funcargs = @_;
	my $argtotal = @funcargs;
	my @seqlist = ();
	my @seqdata = ();
	
	for(my $importary = 0; $importary < $argtotal; $importary++){
		
		if( $importary < ($argtotal/2)){
			push @seqlist, $funcargs[$importary];
		}
		else{
			push @seqdata, $funcargs[$importary];
		}
	}
	
	#then its ok not using a local fasta list
	if(!($fileoutputchoice eq "indvidfil")){
		if($morfrun eq "off"){
			open(FILE, ">$outdir$runname.sequencesALL.fasta.txt")
		}
		else{
			open(FILE, ">$outdir$runname.$morfrun.sequencesALL.fasta.txt")
		}
		print FILE "$appname\tVersion: $version\n$author\nFasta Sequence DNA Output ALL\n\n";
	}
	if($fastalist == 1){ #we are using a local fasta list so
			for(my $loop = 0; $loop < @seqlist; $loop++){
				my $max = @seqlist;
				print "Outputting sequence $loop out of $max...\n";
				if($fileoutputchoice eq "indvidfil"){
					open(FILE, ">$outdir$runname.$seqlist[$loop].fastasequence.txt");
				}
				print FILE "\n>$seqlist[$loop]\n$seqdata[$loop]\n";
		
			} #end of for loop outputting all sequences
	}
	else {#not using a fasta list so
		for(my $loop =0; $loop < @seqlist; $loop++){
		
			#my $dsn = "DBI:mysql:duaxlab:mysql.dhcp";
			#my $username = "habegger";
			#my $password = "howdy-pilgrom";
			#my $dbh = DBI->connect($dsn, $username, $password) or errorwarning("Could not connect to Lukas' database", "ERROR");
			#my $sth = $dbh->prepare("SELECT name,sp_name FROM proteininfo, species WHERE anum=\"$seqlist[$loop]\" and proteininfo.sid=species.sid");
			#$sth->execute();
			#my $anum_row = $sth->fetchrow_hashref();
			my $sequenceinfoa = "";
			my $sequenceinfob = "";
			#print "Luka's Database: $sequenceinfoa $sequenceinfob\n";
			
			if(!($sequenceinfoa eq "") && !($sequenceinfob eq "")){
				my $max = @seqlist;
				print "Outputting sequence ";
				print  $loop+1;
				print " out of $max...\n";
				if($fileoutputchoice eq "indvidfil"){#
					open(FILE, ">$outdir$runname.$seqlist[$loop].fastasequence.txt");
				}
				print FILE ">[$seqlist[$loop]] $sequenceinfoa $sequenceinfob\n$seqdata[$loop]\n\n";
				#print ">[$seqlist[$loop]] $sequenceinfoa $sequenceinfob\n$seqdata[$loop]\n";
				
		
		
			}
			else{
				#information wasn't in lukas' database so lets look it up
				#errorwarning("Could not find information in Lukas's database for $seqlist[$loop]", "ERROR"); 
				my $max = @seqlist;
				print "Outputting sequence ";
				print  $loop+1;
				print " out of $max...\n";
				if($fileoutputchoice eq "indvidfil"){
					open(FILE, ">$runname.$seqlist[$loop].fastasequence.txt");
				}
				#get fasta line
				my $fastaentry = get "http://us.expasy.org/cgi-bin/get-sprot-fasta?$seqlist[$loop]";
				my @fastalines = split(/html>/, $fastaentry);
				my @fastalinesa = split(/\n/, $fastalines[0]);
				my @fastasections = split(/|/, $fastalinesa[0]);
				print FILE ">[$seqlist[$loop]] ";
				for(11..@fastasections){
					print FILE "$fastasections[$_]";
				}
				print FILE "\n$seqdata[$loop]\n"; #lines are already included
			
			} 
	
	}
	
	} #end of check for if using fasta list, what was happening was for each sequence in list was outputing whole list	
}

#sub calculatenumrows(){
#	my @arr = ([], []);
#	@arr = @_;
#	for (my $i = 0; $i < @arr; $i++) {
#   	 	#print "There are ", scalar @{$arr[$i]}, " columns in row $i\n";
#	}
#	return $arr;#
#
#}


sub procpdbid(){
	my $id = shift();
	my @returnar = ();
	my $hsspfile = "";
	if(-e "$id.hssp"){
		print "File $id.hssp exists already skipping download, remove it for a clean download.\n";
		$hsspfile = `cat $id.hssp`;
	}
	else{
		print "Please wait while downloading HSSP file $id this may take a while...";
		#these links are very troublesome for some reason use if only needed
		#$hsspfile = get "http://srs.embl-heidelberg.de:8000/srs5bin/cgi-bin/wgetz?-e+[HSSP-ID:'$id']";
		$hsspfile = get "http://srs.ebi.ac.uk/srs6bin/cgi-bin/wgetz?-id+4Flds1DaOiR+-e+[hssp-ID:$id]";
		#$hsspfile = get 'ftp://ftp.cmbi.kun.nl/pub/molbio/data/hssp/$id.hssp';
		print "$hsspfile\n";
		print "\nAccessing.. http://www.infobiogen.fr/db/hssp/$id.hssp...";
		#$hsspfile = get "http://www.infobiogen.fr/db/hssp/$id.hssp";
		print "done\n";
#		use LWP::UserAgent;
#		my $ua = LWP::UserAgent->new;
#		my $URL = 'ftp://ftp.unit.no/pub/rfc/rfc-index.txt';
#		my $expected_length;
#		my $bytes_received = 0;
#		my $res = $ua->request(HTTP::Request->new(GET => "http://www.infobiogen.fr/db/hssp/$id.hssp"),
# 			     sub {
# 				 my($chunk, $res) = @_;
# 				 $bytes_received += length($chunk);
# 				 unless (defined $expected_length) {
# 				    $expected_length = $res->content_length || 0;
# 				 }
# 				 if ($expected_length) {
#				  	print `clear`;
#					printappinfo();
#					
#					print "\nAccessing.. http://www.infobiogen.fr/db/hssp/$id.hssp...";
# 				      printf "%d%% - " ,100 * $bytes_received / $expected_length;
#				       print  "$bytes_received bytes received\n";
# 				 }
# 				#

 				 # XXX Should really do something with the chunk itself
 				#$hsspfile = $hsspfile . $chunk;
# 			     });
#		print $res->status_line, "\n";
#		print $res->content if $res->is_success;
		
		#errorwarning("HSSP FILE WAS NOT DOWNLOADED CORRECTLY!!!!", "ERROR") unless defined $hsspfile;
		open(FILE, ">hsspfile.txt");
		print FILE "$hsspfile\n";

		my @hsspblocks = split(/##/,$hsspfile);                           #Parse HSSP output
		my @hssplines = split(/\n/,$hsspblocks[1]);
		
		shift(@hssplines);				    #Remove the two header
		shift(@hssplines);
		print "Phrasing HSSP Data...";
		#this is for hssp without html, just plain txt hssp
		foreach(@hssplines){
		
	
			my @spacemarks = split(/\s+/, $_);
			#foreach(@spacemarks){
			#	print "$counter -> $_\n";
			#print FILE "$counter -> $_\n";
			#$counter++;
			
			#sometimes its 14 sometimes its 15,check to see which one
			my @chars = split(//, $spacemarks[14]);
			my $len = @chars;
			if($len >4){
				push @returnar, $spacemarks[14];
			}
			else{
				push @returnar, $spacemarks[15];
			}
		}
		
	
	


		#save this its for hssp downloaded that contains html links in it
		#while (@hssplines)			     #Loop on each individual line of HSSP output
			#{
		#	my @linefrags = split(/>/,shift(@hssplines));	  #Parsing each line to find Accession number
		#	my @linefrags2 = split(/ /,&space(pop(@linefrags)));
		#			   
		#	#there are now two different types of accseion numbers
		#	#those with the P##### and the XXX##### so different lengths
		#	#have to address this issue...done
		#	#print "$linefrags2[10]\n";
		#	push @returnar, $linefrags2[10];
		#	
		#	
	}
	print "done\n";
	return @returnar;


}



sub checkarraryforduplicates(){
	my @redudant = @_;
	my $num = @redudant;
	my @nonreduant = ();
	print "Checking for duplicate entries...\n";
	foreach(@redudant){
		my $addtolist = 1;
		my $checkagainst = $_;
		foreach(@nonreduant){
			if($checkagainst =~ $_){
				$addtolist = 0;
			}
		}
		if($addtolist =~ 1){
			push @nonreduant, $checkagainst;
		}
	}
	my $nonrnum = @nonreduant;
	print "Original had $num and non duplicate list has $nonrnum entries\n";
	return @nonreduant;

}





sub downloadaccnumseq(){
	my $accnum = shift();
	my @returnvalue  = ();
	
	#my $dsn = "DBI:mysql:duaxlab:mysql.dhcp";
	#my $username = "habegger";
	#my $password = "howdy-pilgrom";
	#my $dbh = DBI->connect($dsn, $username, $password) or errorwarning("Could not connect to Lukas' database", "ERROR");
	#my $sth = $dbh->prepare("SELECT seq FROM dna WHERE anum=\"$accnum\"");
	#$sth->execute();
	#my $anum_row = $sth->fetchrow_hashref();
	#my $dnastring = $anum_row->{'seq'};

#	if(!($dnastring eq "")){
#		push @returnvalue, $accnum;
#		push @returnvalue, $dnastring;
#		return  @returnvalue;
#	}
	#else{   #did not find it in Lukas' database so get it from the web
		#errorwarning("Sequence $accnum was not proccessed or found in Lukas' database", "ERROR");
		print "Finding link for $accnum sequence data...";
		#my $rawhtml = get "http://us.expasy.org/cgi-bin/get-entries?disp=1&AC=$accnum";
		my $rawhtml = get "http://us.expasy.org/uniprot/$accnum";
		if($rawhtml =~ "No entries have been found"){
			#check for cross linked references using this link
			print "crosslinked reference was found...";
			$rawhtml = get "http://us.expasy.org/cgi-bin/get-entries?disp=1&DR=$accnum";
		}
		#if for some reason refernces are crosslinked from original
		if($rawhtml =~ "Swiss-Prot and TrEMBL entries with specified accession number"){
			print "crosslinked reference was found...";
			$rawhtml = get "http://us.expasy.org/cgi-bin/niceprot.pl$accnum";
		}
		print "done\n";	
		print "Getting sequence file for $accnum this could take some time...";
		my @lines = split(/\n/,$rawhtml);
		my $found = 1;
		my @linebits = ();
		my @linefrags = ();
		my $codonstart = 1;
		foreach (@lines)
		{
			if (/CoDingSequence/ && $found)
			{
				@linefrags = split(/href/,$_);
				$found = 0;
			}
		#used for shifting on where actual proccessing of sequence should start
			
		}
		foreach (@linefrags)
		{
			if (/CoDingSequence/)
			{
				@linebits = split(/"/,$_);
			}
		}
		if (@linebits)
		{
			my $seqfile = get $linebits[1];
			my @seqhtmlbits = split(/SQ   Sequence/, $seqfile);
			print "done\n";
			#figure out if needs to be shifted
			my @firstlines = split(/\n/, $seqhtmlbits[0]);
			foreach(@firstlines){
				if(/codon_start/){
				
			
					my @getstart = split(/=/, $_);
					$codonstart = $getstart[1];
					print "Codon proccessing starts with nuc #: $codonstart\n";
		
				}
			}
			#clean up the sequence output
			my @trueseq = split(/\/\//, $seqhtmlbits[1]);
			my @trueseqb = split(/\;/, $trueseq[0]);
			my $trueseqb = pop @trueseqb;
			
			my @chars = split(//, $trueseqb);
			my @a2z = ('a'..'z');
			#now get rid of the rest of the junk, numbers on the side etc.
			#and make capitalized
			my $dnastring = "";
			foreach(@chars){
				if (!($_ =~ /\d/))
							{
								if($_ =~ /\w/)
									{
									my $big = uc($_);
									$dnastring = $dnastring . $big;
									}
							}
				
				#my $sequencechar = $_;
			#		foreach(@a2z){ #check to see if it is any character
					
					#this adds support for funny sequences
					#some other character part of sequence
					#added to support characters that are in the dna sequence but not atg or c
			#		if ($sequencechar eq $_){
		#				my $big = uc($sequencechar);
			#			$dnastring = $dnastring . $big;
			#		}
			#			}		
				
			}  
			
			#before returing sequence check to see if it needs to be shifted before proccessing
			if($codonstart == 1){  #does not need to be shifted     
				push @returnvalue, $accnum;
					push @returnvalue, $dnastring;
				return  @returnvalue;
			}
			else{
				my @sequencechars = split(//, $dnastring);
				for(my $lcv = 1; $lcv < $codonstart; $lcv++){
					shift(@sequencechars);
				}
				$dnastring = join( "", @sequencechars);
				push @returnvalue, $accnum;
				push @returnvalue, $dnastring;
				print "$returnvalue[0] - $returnvalue[1]\n";
				return  @returnvalue;
			}
		#}
		#else
		#{
			
			#try old method before outputting warning
			
		#	errorwarning("Couldn't find the sequence file $accnum online", "ERROR");
		#}
	}

}






sub determineput(){

	print "The $appname allows for many different input formats\n";
	print "These formats include accesion numbers both in the X##### format\n";
	print "and the XXX##### format, PDB ID's and local lists.\n";
	print "\n\n";
	print "--Input Menu--\n";
	print "1) Accesion Number\n";
	print "2) PDB ID\n";
	print "3) Local List\n";
	print "\nPlease select an input type\n>";
	my $choice = <STDIN>;
	chomp($choice);
	if($choice == 1 ){return 1;}
	elsif($choice == 2){return 2;}
	elsif($choice == 3){return 3;}
	else{
		printappinfo();
		errorwarning("Invalid choice selection!  Please try again.", "Warning");
		sleep(1);
		print `clear`;
		determineput();
	}


}

sub catchctrlc(){

	
	errorwarning("An Attempt to Exit was detected!", "Warning");
	print "Would you really like to quit (Y or N)?\n>";
	my $choice = <STDIN>;
	chomp($choice);
	if($choice eq "Y"){
		open (ERRLOG, ">$outdir$runname.errors.log");
		print ERRLOG "$appname - $version\t\tWritten By: $author\n";
		print ERRLOG "Session Variables:\n\tCodon Analysis in dir ";
		print ERRLOG  `pwd`;
		print ERRLOG "Runname: $runname\tRun Date: ";
		print ERRLOG `date`;
		print ERRLOG "Mode: $atgcmode\tColumn Sort: $columnsort-$columnsortupdown Swap Mode: $swapifbigger\tMORF Run: n/a  Graph: $graphyon\n\n";
		print ERRLOG "Application was quit before finished...\n";
		
		foreach(@errors){
			print ERRLOG "$_\n";
			
		}
		exit;
	}

}


sub errorwarning(){
	my $msg = shift();
	my $type = shift();
	print "\n\n";
	&printappinfo();
	print "$type:\n";
	print "$msg\n";
	push @errors, $msg;
}  



sub printappinfo(){
	print "********************************************\n";
	print "*                                          *\n";
	print "*$appname                        *\n";
	print "*By: $author    \t\t\t   *\n";
	print "*Version: $version    \t\t\t   *\n";
	print "*                                          *\n";
	print "*                                          *\n";
	print "********************************************\n";
}


#Jay's old utility function need to work on some other things
sub space    
{
	#utility function.  Removes multiple spaces form a string, for purposes of future splitting on / /.  
        #There must be a better way to do this.
        
        my @charsin = split(//,shift());
	my $chars = "";
	my $space = 1;
	while (@charsin)
	{
		my $char = shift(@charsin);
		if ($char eq " ")
		{
			$chars .= " " if (!$space);
			$space = 1;
		}
		else
		{
			$chars .= $char;
			$space = 0;
		}
	}
	return $chars;
}

`rm frame*`;
`rm grand*`;
